/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayOffsetMethodsReferenceContributor
extends PsiReferenceContributor {
    private static final String ARRAY_ACCESS_FQN = "\\ArrayAccess";
    public static final String OFFSET_SET_METHOD_NAME = "offsetSet";
    public static final String OFFSET_GET_METHOD_NAME = "offsetGet";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            PhpArrayOffsetMethodsReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(ArrayAccessExpression.class), (PsiReferenceProvider)new PhpArrayOffsetMethodsReferenceProvider());
    }

    @Nullable
    private static TextRange computeRange(PsiElement element, IElementType childTokenToProvideTextRange) {
        ASTNode node = element.getNode();
        ASTNode child = node.findChildByType(childTokenToProvideTextRange);
        return child != null ? child.getPsi().getTextRangeInParent() : null;
    }

    @NotNull
    private static String getOffsetMethodName(@NotNull ArrayAccessExpression expression) {
        if (expression == null) {
            PhpArrayOffsetMethodsReferenceContributor.$$$reportNull$$$0(1);
        }
        boolean assignmentVariable = expression.getParent() instanceof AssignmentExpression && ((AssignmentExpression)expression.getParent()).getVariable() == expression;
        return assignmentVariable ? OFFSET_SET_METHOD_NAME : OFFSET_GET_METHOD_NAME;
    }

    @NotNull
    public static Collection<ResolveResult> resolveElements(@NotNull ArrayAccessExpression expression) {
        PhpTypedElement value;
        if (expression == null) {
            PhpArrayOffsetMethodsReferenceContributor.$$$reportNull$$$0(2);
        }
        if ((value = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getValue(), PhpTypedElement.class)) == null) {
            List<ResolveResult> list = Collections.emptyList();
            if (list == null) {
                PhpArrayOffsetMethodsReferenceContributor.$$$reportNull$$$0(3);
            }
            return list;
        }
        PhpIndex index = PhpIndex.getInstance(value.getProject());
        String offsetMethodName = PhpArrayOffsetMethodsReferenceContributor.getOffsetMethodName(expression);
        Collection collection = PhpArrayOffsetMethodsReferenceContributor.getTypes(value).stream().filter(PhpLangUtil::isFqn).flatMap(type -> index.getAnyByFQN((String)type).stream()).map(aClass -> PhpArrayOffsetMethodsReferenceContributor.findArrayAccessOffsetMethod(aClass, offsetMethodName)).filter(Objects::nonNull).map(PsiElementResolveResult::new).collect(Collectors.toSet());
        if (collection == null) {
            PhpArrayOffsetMethodsReferenceContributor.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    public static Method findArrayAccessOffsetMethod(PhpClass aClass, String offsetMethodName) {
        Method offsetMethod = aClass.findMethodByName(offsetMethodName);
        if (offsetMethod == null) {
            return null;
        }
        PhpClass methodContainingClass = offsetMethod.getContainingClass();
        if (methodContainingClass == null) {
            return null;
        }
        return PhpArrayOffsetMethodsReferenceContributor.isImplementsArrayAccess(methodContainingClass) ? offsetMethod : null;
    }

    public static boolean isImplementsArrayAccess(@Nullable PhpClass aClass) {
        if (aClass == null) {
            return false;
        }
        Ref implementsArrayAccess = new Ref((Object)false);
        PhpClassHierarchyUtils.processSupers(aClass, true, true, (Processor<? super PhpClass>)((Processor)curClass -> {
            implementsArrayAccess.set((Object)PhpLangUtil.equalsClassNames(curClass.getFQN(), ARRAY_ACCESS_FQN));
            return (Boolean)implementsArrayAccess.get() == false;
        }));
        return (Boolean)implementsArrayAccess.get();
    }

    private static Set<String> getTypes(PhpTypedElement value) {
        if (value instanceof ArrayAccessExpression) {
            return (Set)StreamEx.of((Object[])value.getReferences()).map(PsiReference::resolve).select(Method.class).flatMap(method -> method.getGlobalType().getTypes().stream()).collect(Collectors.toSet());
        }
        return value.getGlobalType().getTypes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpArrayOffsetMethodsReferenceContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpArrayOffsetMethodsReferenceContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetMethodName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveElements";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class PhpArrayOffsetMethodsReferenceProvider
    extends PsiReferenceProvider {
        private PhpArrayOffsetMethodsReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                PhpArrayOffsetMethodsReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpArrayOffsetMethodsReferenceProvider.$$$reportNull$$$0(1);
            }
            SmartList references = new SmartList();
            ContainerUtil.addIfNotNull((Collection)references, (Object)((Object)PhpArrayOffsetMethodsReferenceProvider.getArrayOffsetMethodReferenceOnToken(element, PhpTokenTypes.chLBRACKET)));
            ContainerUtil.addIfNotNull((Collection)references, (Object)((Object)PhpArrayOffsetMethodsReferenceProvider.getArrayOffsetMethodReferenceOnToken(element, PhpTokenTypes.chRBRACKET)));
            PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                PhpArrayOffsetMethodsReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static PhpArrayOffsetMethodReference getArrayOffsetMethodReferenceOnToken(@NotNull PsiElement element, IElementType tokenType) {
            TextRange closeBracketRange;
            if (element == null) {
                PhpArrayOffsetMethodsReferenceProvider.$$$reportNull$$$0(3);
            }
            return (closeBracketRange = PhpArrayOffsetMethodsReferenceContributor.computeRange(element, tokenType)) != null ? new PhpArrayOffsetMethodReference((ArrayAccessExpression)element, closeBracketRange) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpArrayOffsetMethodsReferenceContributor$PhpArrayOffsetMethodsReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpArrayOffsetMethodsReferenceContributor$PhpArrayOffsetMethodsReferenceProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getArrayOffsetMethodReferenceOnToken";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PhpArrayOffsetMethodReference
    extends PsiPolyVariantReferenceBase<ArrayAccessExpression> {
        @NotNull
        private final TextRange myRange;

        private PhpArrayOffsetMethodReference(@NotNull ArrayAccessExpression psiElement, @NotNull TextRange range) {
            if (psiElement == null) {
                PhpArrayOffsetMethodReference.$$$reportNull$$$0(0);
            }
            if (range == null) {
                PhpArrayOffsetMethodReference.$$$reportNull$$$0(1);
            }
            super((PsiElement)psiElement);
            this.myRange = range;
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            ResolveResult[] resolveResultArray = PhpArrayOffsetMethodsReferenceContributor.resolveElements((ArrayAccessExpression)this.myElement).toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                PhpArrayOffsetMethodReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                PhpArrayOffsetMethodReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpArrayOffsetMethodsReferenceContributor$PhpArrayOffsetMethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpArrayOffsetMethodsReferenceContributor$PhpArrayOffsetMethodReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

