/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCallbackFunctionUtil {
    private static final Set<String> functionCallback = new HashSet<String>();
    private static final Set<String> classCallback = new HashSet<String>();
    private static final Set<String> existsClassCallbacks = new HashSet<String>();
    private static final Set<String> existsCallbacks = new HashSet<String>();
    private static final String VARIABLE_CALLBACK = "compact";
    private static final String METHOD_CALLBACK = "method_exists";
    private static final String FIELD_CALLBACK = "property_exists";
    private static final String FUNCTION_EXISTS = "function_exists";
    private static final String IS_CALLABLE = "is_callable";
    public static final String CLASS_ALIAS = "class_alias";
    public static final Condition<PsiElement> FUNCTION_ARGUMENT;
    public static final Condition<PsiElement> ARRAY_VALUE;

    public static boolean isExistsCallbackFunction(@NotNull String name) {
        if (name == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(0);
        }
        return existsCallbacks.contains(name) || existsClassCallbacks.contains(name);
    }

    public static boolean isClassCallbackFunction(@NotNull FunctionReference function, int selectedIndex) {
        String name;
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(1);
        }
        return classCallback.contains(name = function.getName()) && (selectedIndex != 1 || !CLASS_ALIAS.equals(name)) || selectedIndex == 0 && (METHOD_CALLBACK.equals(name) || FIELD_CALLBACK.equals(name));
    }

    public static boolean isMethodCallbackFunction(@NotNull FunctionReference function, int selectedIndex) {
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(2);
        }
        return METHOD_CALLBACK.equals(function.getName()) && selectedIndex == 1;
    }

    public static boolean isVariableCallbackFunction(@NotNull FunctionReference function) {
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(3);
        }
        return VARIABLE_CALLBACK.equals(function.getName());
    }

    public static boolean isFieldCallbackFunction(@NotNull FunctionReference function, int selectedIndex) {
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(4);
        }
        return FIELD_CALLBACK.equals(function.getName()) && selectedIndex == 1;
    }

    public static boolean isFunctionCallbackFunction(@NotNull FunctionReference function, int selectedIndex) {
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(5);
        }
        return PhpCallbackFunctionUtil.isCallableParameter(function, selectedIndex);
    }

    public static boolean isCallableParameter(@NotNull ParameterListOwner parametersOwner, int selectedIndex) {
        if (parametersOwner == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(6);
        }
        if (selectedIndex < 0) {
            return false;
        }
        String name = parametersOwner.getName();
        if (parametersOwner instanceof FunctionReference && (StringUtil.isEmpty((String)name) || PhpCallbackFunctionUtil.isStandardFunctionCallbackFunction(name))) {
            return true;
        }
        for (Function function : PhpWorkaroundUtil.resolveTargetFunctions((PsiElement)parametersOwner)) {
            Parameter parameter = function.getParameter(selectedIndex);
            if (parameter == null) continue;
            return PhpCallbackFunctionUtil.isCallable(parameter.getGlobalType());
        }
        return false;
    }

    public static boolean isStandardFunctionCallbackFunction(@NotNull String name) {
        if (name == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(7);
        }
        return functionCallback.contains(name);
    }

    public static boolean isCallable(@NotNull PhpType phpType) {
        if (phpType == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(8);
        }
        Set<String> types = phpType.getTypes();
        for (String type : types) {
            if (!PhpType.isCallableType(type)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PhpType getClassReferenceType(@Nullable PsiElement element) {
        CharSequence name;
        if (element instanceof ClassConstantReference && (PhpLangUtil.equalsConstantNames(name = ((ClassConstantReference)element).getNameCS(), "class") || StringUtil.isEmpty((CharSequence)name) && PhpPsiUtil.getChildOfType(element, PhpTokenTypes.kwCLASS) != null)) {
            element = ((ClassConstantReference)element).getClassReference();
        }
        return element instanceof PhpExpression ? ((PhpExpression)element).getGlobalType() : null;
    }

    @Nullable
    public static PsiElement getArrayValueContent(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        StringLiteralExpression innerStringElement = (StringLiteralExpression)PhpPsiUtil.getChildByCondition(element, StringLiteralExpression.INSTANCEOF);
        return innerStringElement == null ? PhpPsiUtil.getChildByCondition(element, PhpExpression.INSTANCEOF) : innerStringElement;
    }

    @Nullable
    public static String getCallbackString(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(9);
        }
        return (name = PhpCodeInsightUtil.toString(element)) == null ? null : StringUtil.replace((String)name, (String)"\\\\", (String)"\\");
    }

    @Nullable
    public static PhpCallbackInfoHolder createCallback(@NotNull PsiElement callback) {
        if (callback == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(10);
        }
        return PhpCallbackFunctionUtil.createCallback(callback, null);
    }

    @Nullable
    public static PhpCallbackInfoHolder createCallback(@NotNull PsiElement callback, @Nullable PsiElement original) {
        if (callback == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(11);
        }
        if (callback instanceof ArrayCreationExpression) {
            PsiElement secondValue;
            PsiElement callbackElement;
            PsiElement firstValue = PhpPsiUtil.getChildOfType(callback, PhpElementTypes.ARRAY_VALUE);
            PsiElement classElement = PhpCallbackFunctionUtil.getArrayValueContent(firstValue);
            if (classElement != null && (callbackElement = PhpCallbackFunctionUtil.getArrayValueContent(secondValue = PhpPsiUtil.getChildOfType(callback, PhpElementTypes.ARRAY_VALUE, firstValue))) != null && (original == null || original == classElement || original == callbackElement)) {
                return new PhpMemberCallbackInfoHolder(classElement, callbackElement);
            }
        } else if (callback instanceof StringLiteralExpression) {
            return new PhpCallbackInfoHolder(callback);
        }
        return null;
    }

    @Nullable
    public static PhpStaticCallback createStaticCallback(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(12);
        }
        return PhpCallbackFunctionUtil.createStaticCallback(expression.getContents());
    }

    @Nullable
    public static PhpStaticCallback createStaticCallback(String content) {
        String[] parts = content.split("::");
        if (parts.length != 2) {
            return null;
        }
        return new PhpStaticCallback(StringUtil.replace((String)parts[0], (String)"\\\\", (String)"\\"), parts[1]);
    }

    static {
        functionCallback.add(FUNCTION_EXISTS);
        functionCallback.add("unregister_tick_function");
        existsClassCallbacks.add("class_exists");
        existsClassCallbacks.add("interface_exists");
        existsClassCallbacks.add("trait_exists");
        classCallback.add("__autoload");
        classCallback.add(CLASS_ALIAS);
        classCallback.add("get_class_methods");
        classCallback.add("get_class_vars");
        classCallback.add("get_parent_class");
        classCallback.add("is_a");
        classCallback.add("is_subclass_of");
        classCallback.addAll(existsClassCallbacks);
        existsCallbacks.add(METHOD_CALLBACK);
        existsCallbacks.add(FIELD_CALLBACK);
        existsCallbacks.add(FUNCTION_EXISTS);
        existsCallbacks.add(IS_CALLABLE);
        FUNCTION_ARGUMENT = use -> use.getParent() instanceof ParameterList;
        ARRAY_VALUE = use -> PhpPsiUtil.isOfType(use.getParent(), PhpElementTypes.ARRAY_VALUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersOwner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isExistsCallbackFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassCallbackFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodCallbackFunction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVariableCallbackFunction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldCallbackFunction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionCallbackFunction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallableParameter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isStandardFunctionCallbackFunction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallbackString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createCallback";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createStaticCallback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpCallbackInfoHolder {
        private final PsiElement myCallbackElement;

        public PhpCallbackInfoHolder(@NotNull PsiElement element) {
            if (element == null) {
                PhpCallbackInfoHolder.$$$reportNull$$$0(0);
            }
            this.myCallbackElement = element;
        }

        public PsiElement getCallbackElement() {
            return this.myCallbackElement;
        }

        @NotNull
        public String getCallbackText() {
            String string = StringUtil.notNullize((String)PhpCallbackFunctionUtil.getCallbackString(this.myCallbackElement));
            if (string == null) {
                PhpCallbackInfoHolder.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil$PhpCallbackInfoHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil$PhpCallbackInfoHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallbackText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpMemberCallbackInfoHolder
    extends PhpCallbackInfoHolder {
        private final PsiElement myClassElement;

        public PhpMemberCallbackInfoHolder(@NotNull PsiElement clazzElement, @NotNull PsiElement callback) {
            if (clazzElement == null) {
                PhpMemberCallbackInfoHolder.$$$reportNull$$$0(0);
            }
            if (callback == null) {
                PhpMemberCallbackInfoHolder.$$$reportNull$$$0(1);
            }
            super(callback);
            this.myClassElement = clazzElement;
        }

        public PsiElement getClassElement() {
            return this.myClassElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clazzElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callback";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil$PhpMemberCallbackInfoHolder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpStaticCallback {
        @NotNull
        public final String myClassName;
        @NotNull
        public final String myMethodName;

        PhpStaticCallback(@NotNull String className, @NotNull String methodName) {
            if (className == null) {
                PhpStaticCallback.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                PhpStaticCallback.$$$reportNull$$$0(1);
            }
            this.myClassName = className;
            this.myMethodName = methodName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil$PhpStaticCallback";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

