/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.intentions.generators.PhpConstructorGenerator;
import com.jetbrains.php.lang.intentions.generators.PhpInvalidTemplateException;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCodeUtil {
    public static final String PHP_OVERRIDDEN_METHOD_BODY = "PHP Overridden Method Body";
    public static final String PHP_IMPLEMENTED_METHOD_BODY = "PHP Implemented Method Body";
    public static final String FUNCTION_KEYWORD = "function";
    public static final String DEFAULT_GETTER_PREFIX = "get";
    public static final String DEFAULT_SETTER_PREFIX = "set";
    public static final String CALL_METHOD_NAME = "__call";
    public static final String NULL_CONST_NAME = "null";
    public static final String TRUE_CONST_NAME = "true";
    public static final String FALSE_CONST_NAME = "false";
    private static final Logger LOG = Logger.getInstance(PhpCodeUtil.class);
    public static final String MIXED_TYPE_HINT = "mixed";
    public static final String BOOL_TYPE_HINT = "bool";

    private PhpCodeUtil() {
    }

    public static String createOverridingMethodText(PhpClass targetClass, Method method, PhpDocCreationOption docCreationOption, boolean addOverride) {
        return PhpCodeUtil.createOverridingMethodText(targetClass, method, null, docCreationOption, addOverride);
    }

    @NotNull
    public static String createOverridingMethodText(PhpClass targetClass, Method method, @Nullable String defaultBody, PhpDocCreationOption docCreationOption, boolean addOverride) {
        return PhpCodeUtil.createOverridingMethodText(targetClass, method, defaultBody, docCreationOption, null, addOverride);
    }

    public static String createOverridingMethodTextWithoutTypeDeclarations(Method method, @Nullable String defaultBody, PhpDocCreationOption docCreationOption, boolean addOverride) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)PhpCodeUtil.getCommentText(method, docCreationOption)));
        sb.append(PhpCodeUtil.getAttributeTextForOverride(method, addOverride));
        PhpCodeUtil.appendModifiersExceptAbstract(method, sb);
        sb.append("function ");
        sb.append(method.getName());
        sb.append("(").append(PhpCodeUtil.getParametersTextWithoutTypeDeclarations(method)).append(")");
        PhpCodeUtil.appendMethodBody(method, defaultBody, sb);
        return sb.toString();
    }

    @NotNull
    public static String createOverridingMethodText(PhpClass targetClass, Method method, @Nullable String defaultBody, PhpDocCreationOption docCreationOption, @Nullable PhpDocComment docComment, boolean isOverride) {
        String constructorText;
        if (method.getMethodType(false) == Method.MethodType.CONSTRUCTOR && (constructorText = PhpCodeUtil.createOverridingConstructorText(targetClass, method, docCreationOption, isOverride)) != null) {
            String string = constructorText;
            if (string == null) {
                PhpCodeUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)PhpCodeUtil.getCommentText(method, docCreationOption)));
        sb.append(PhpCodeUtil.getAttributeTextForOverride(method, isOverride));
        PhpCodeUtil.appendMethodSignature(method, targetClass, docComment, sb);
        PhpCodeUtil.appendMethodBody(method, defaultBody, sb);
        String string = sb.toString();
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void appendMethodSignature(Method method, PhpClass targetClass, @Nullable PhpDocComment docComment, StringBuilder sb) {
        PhpCodeUtil.appendModifiersExceptAbstract(method, sb);
        sb.append("function ");
        sb.append(method.getName());
        sb.append("(").append(PhpCodeUtil.getParametersText(method, docComment)).append(")");
        PhpScopeHolder scopeHolder = PhpPsiUtil.getParentOfClass((PsiElement)targetClass, false, PhpScopeHolder.class);
        String returnTypeText = PhpCodeUtil.getReturnTypeText(method, scopeHolder);
        if (docComment == null) {
            if (PhpHierarchyChecksInspection.hasTentativeReturnTypeAttribute(method) && !PhpLanguageLevel.current((Project)method.getProject()).isAtLeast(PhpLanguageLevel.PHP810)) {
                return;
            }
            if (!StringUtil.isEmpty((String)returnTypeText)) {
                sb.append(" : ");
                sb.append(PhpCodeUtil.getOverriddenReturnTypeText(returnTypeText, method.getContainingClass(), targetClass));
            }
        }
    }

    @Nullable
    private static String getReturnTypeText(Method method, PhpScopeHolder scopeHolder) {
        if (method instanceof PhpDocMethod) {
            PhpType methodType = method.getType();
            if (!PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(method.getProject())) {
                methodType = methodType.filterMixed();
            }
            return PhpCodeUtil.getRelativizedType(scopeHolder, methodType.toString());
        }
        PhpReturnType typeDeclaration = (PhpReturnType)method.getTypeDeclaration();
        return typeDeclaration != null ? typeDeclaration.getText() : null;
    }

    private static String getParametersText(@Nullable Function function, @Nullable PhpDocComment docComment) {
        ParameterList parameterList = (ParameterList)PhpPsiUtil.getChildByCondition(function, ParameterList.INSTANCEOF);
        if (parameterList == null) {
            return "";
        }
        if (docComment != null) {
            return parameterList.getText();
        }
        String parametersText = StreamEx.of((Object[])function.getParameters()).map(PhpCodeUtil::paramToString).joining((CharSequence)",");
        return PhpFunctionCodeGenerator.useTrailingCommaInParametersList(function) ? parametersText + "," : parametersText;
    }

    @NotNull
    private static String getParametersTextWithoutTypeDeclarations(@Nullable Function function) {
        ParameterList parameterList = (ParameterList)PhpPsiUtil.getChildByCondition(function, ParameterList.INSTANCEOF);
        if (parameterList == null) {
            return "";
        }
        StringJoiner parametersText = new StringJoiner(",");
        for (PsiElement parameter : parameterList.getParameters()) {
            if (parameter instanceof Parameter) {
                parametersText.add("$" + ((Parameter)parameter).getName());
                continue;
            }
            parametersText.add(parameter.getText());
        }
        String string = PhpFunctionCodeGenerator.useTrailingCommaInParametersList(function) ? parametersText.add(",").toString() : parametersText.toString();
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String paramToString(@NotNull PsiElement parameter) {
        if (parameter == null) {
            PhpCodeUtil.$$$reportNull$$$0(3);
        }
        if (parameter instanceof Parameter) {
            return PhpCodeUtil.paramToString((Parameter)parameter);
        }
        throw new IllegalArgumentException("Please use #paramToString for Parameter type version");
    }

    @NotNull
    public static String paramToString(@NotNull Parameter parameter) {
        if (parameter == null) {
            PhpCodeUtil.$$$reportNull$$$0(4);
        }
        PhpType declaredType = parameter.getDeclaredType().global(parameter.getProject());
        boolean variadic = parameter.isVariadic();
        if (!declaredType.isEmpty()) {
            boolean nullable = declaredType.unpluralize().getTypes().stream().anyMatch(PhpType::isNull);
            PhpType filteredType = declaredType.filterNull().filterUnknown();
            if (!PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(parameter.getProject())) {
                filteredType = filteredType.filterMixed();
            }
            PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(parameter);
            List types = ContainerUtil.mapNotNull(filteredType.getTypes(), type -> PhpCodeUtil.convertPluralTypesToParameterTypeHints(type, variadic));
            types = ContainerUtil.map((Collection)types, type -> PhpCodeUtil.getRelativizedType(scope, type));
            return PhpCodeUtil.createParameterText(parameter, PhpCodeUtil.getTypeHintString(parameter.getProject(), true, (Collection<String>)types), variadic, nullable);
        }
        return PhpCodeUtil.createParameterText(parameter, null, variadic, false);
    }

    @NotNull
    private static String getRelativizedType(@Nullable PhpPsiElement scope, @NotNull String type) {
        if (type == null) {
            PhpCodeUtil.$$$reportNull$$$0(5);
        }
        String string = scope != null && PhpLangUtil.isFqn(type) ? PhpCodeInsightUtil.createQualifiedName(scope, type) : type;
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String createParameterText(@NotNull Parameter parameter, @Nullable String type, boolean variadic, boolean nullable) {
        boolean isUnionType;
        if (parameter == null) {
            PhpCodeUtil.$$$reportNull$$$0(7);
        }
        StringBuilder result = new StringBuilder();
        result.append(PhpCodeUtil.getAttributeTextForOverride(parameter));
        boolean bl = isUnionType = type != null && type.contains("|") && PhpLanguageFeature.UNION_TYPES.isSupported(parameter.getProject());
        if (nullable && !isUnionType && PhpLanguageFeature.NULLABLES.isSupported(parameter.getProject())) {
            if (StringUtil.isEmpty((String)type)) {
                result.append(NULL_CONST_NAME);
            } else {
                result.append("?");
            }
        }
        boolean isVariadicAllowed = PhpLanguageFeature.VARIADIC_FUNCTIONS.isSupported(parameter.getProject());
        String string = type = variadic && !isVariadicAllowed ? PhpType.ARRAY.toString() : type;
        if (type != null) {
            result.append(type);
            if (isUnionType && nullable) {
                result.append("|null");
            }
            result.append(" ");
        }
        if (parameter.isPassByRef()) {
            result.append("&");
        }
        if (variadic && isVariadicAllowed) {
            result.append("...");
        }
        result.append("$").append(parameter.getName());
        PsiElement defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            result.append(" = ");
            result.append(defaultValue.getText());
        }
        String string2 = result.toString();
        if (string2 == null) {
            PhpCodeUtil.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    private static String getAttributeTextForOverride(@NotNull PsiElement element) {
        if (element == null) {
            PhpCodeUtil.$$$reportNull$$$0(9);
        }
        if (!PhpLanguageFeature.ATTRIBUTES.isSupported(element.getProject())) {
            return "";
        }
        String string = PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)((Condition)PhpAttributesList.class::isInstance)).stream().map(PhpCodeUtil::getTextWithoutInternalAttributes).collect(Collectors.joining(" "));
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getAttributeTextForOverride(@NotNull Method element, boolean addOverride) {
        if (element == null) {
            PhpCodeUtil.$$$reportNull$$$0(11);
        }
        String attributeText = PhpCodeUtil.getAttributeTextForOverride(element);
        if (!(!PhpLanguageFeature.ATTRIBUTE_OVERRIDE.isSupported(element.getProject()) || PhpLangUtil.isMagicMethod(element.getName()) || element.getContainingClass() != null && element.getContainingClass().isTrait())) {
            PhpAttributesList attributesList = PhpPsiElementFactory.createAttributesList(element.getProject(), "\\Override");
            attributeText = addOverride ? String.join((CharSequence)" ", attributeText, PhpCodeUtil.getTextWithoutInternalAttributes(attributesList)) : attributeText;
        }
        String string = attributeText;
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static String getTextWithoutInternalAttributes(PhpAttributesList attributesList) {
        @NotNull Collection attributes = attributesList.getAttributes();
        if (!ContainerUtil.exists((Iterable)attributes, PhpDocUtil::isInternalAtribute)) {
            return attributesList.getText();
        }
        @NotNull List notInternalAttributes = ContainerUtil.filter((Collection)attributes, attribute -> !PhpDocUtil.isInternalAtribute(attribute));
        return !notInternalAttributes.isEmpty() ? "#[" + StringUtil.join((Collection)notInternalAttributes, PsiElement::getText, (String)", ") + "]" : "";
    }

    @Nullable
    private static String convertPluralTypesToParameterTypeHints(@NotNull String typeString, boolean variadic) {
        if (typeString == null) {
            PhpCodeUtil.$$$reportNull$$$0(13);
        }
        if (PhpType.isPluralType(typeString)) {
            if (variadic) {
                String unpluralized = StringUtil.trimEnd((String)typeString, (String)"[]");
                return unpluralized.equals("\\null") ? null : unpluralized;
            }
            return PhpType.ARRAY.toString();
        }
        return !variadic ? typeString : null;
    }

    @NotNull
    private static String getOverriddenReturnTypeText(@NotNull String returnType, @Nullable PhpClass containingClass, @NotNull PhpClass targetClass) {
        PhpPsiElement scope;
        if (returnType == null) {
            PhpCodeUtil.$$$reportNull$$$0(14);
        }
        if (targetClass == null) {
            PhpCodeUtil.$$$reportNull$$$0(15);
        }
        if (containingClass != null && (scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)targetClass)) != null) {
            String superFQN;
            if ("self".equals(returnType)) {
                String string = PhpCodeInsightUtil.createQualifiedName(scope, containingClass.getFQN());
                if (string == null) {
                    PhpCodeUtil.$$$reportNull$$$0(16);
                }
                return string;
            }
            if ("parent".equals(returnType) && (superFQN = containingClass.getSuperFQN()) != null && !containingClass.getSuperClasses().isEmpty()) {
                String string = PhpCodeInsightUtil.createQualifiedName(scope, superFQN);
                if (string == null) {
                    PhpCodeUtil.$$$reportNull$$$0(17);
                }
                return string;
            }
        }
        String string = returnType;
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static void appendModifiersExceptAbstract(Method method, StringBuilder sb) {
        PsiElement modifier;
        Object modifierList = PhpPsiUtil.getChildByCondition(method, PhpModifierList.INSTANCEOF);
        PsiElement psiElement = modifier = modifierList != null ? modifierList.getFirstChild() : null;
        while (modifier != null) {
            IElementType elementType = modifier.getNode().getElementType();
            if (PhpFormatterUtil.isModifier(elementType) && elementType != PhpTokenTypes.kwABSTRACT) {
                sb.append(modifier.getText());
                sb.append(" ");
            }
            modifier = PhpPsiUtil.getNextSiblingIgnoreWhitespace(modifier, true);
        }
    }

    private static void appendMethodBody(Method method, @Nullable String defaultBody, StringBuilder sb) {
        sb.append("{");
        PhpClass containingClass = method.getContainingClass();
        if (!(method instanceof PhpDocMethod) && PhpPsiUtil.getChildOfType((PsiElement)method, PhpElementTypes.ANY_GROUP_STATEMENT) == null) {
            sb.append("\n ").append(PhpCodeUtil.getOverridingMethodBody(method, true, defaultBody));
        } else if (containingClass == null || !containingClass.isTrait()) {
            if (!(method.isAbstract() || containingClass != null && "\\___PHPSTORM_HELPERS\\object".equals(containingClass.getFQN()))) {
                sb.append("\n ").append(PhpCodeUtil.getOverridingMethodBody(method, false, defaultBody));
            } else {
                sb.append("\n ").append(PhpCodeUtil.getOverridingMethodBody(method, true, defaultBody));
            }
        }
        sb.append("\n}");
    }

    @Nullable
    private static String createOverridingConstructorText(@NotNull PhpClass targetClass, Method method, PhpDocCreationOption docOption, boolean addOverride) {
        if (targetClass == null) {
            PhpCodeUtil.$$$reportNull$$$0(19);
        }
        try {
            Pair<PhpDocComment, Method> result = new PhpConstructorGenerator(targetClass).withParameters(Arrays.asList(method.getParameters())).createConstructor();
            if (result != null) {
                StringBuilder sb = new StringBuilder();
                if (PhpDocCreationOption.DEFAULT.equals((Object)docOption)) {
                    if (result.first != null) {
                        sb.append(((PhpDocComment)result.first).getText()).append('\n');
                    }
                } else {
                    String constructorComment = PhpCodeUtil.getCommentText(method, docOption);
                    if (constructorComment != null) {
                        sb.append(constructorComment).append('\n');
                    }
                }
                sb.append(PhpCodeUtil.getAttributeTextForOverride(method, addOverride));
                sb.append(((Method)result.second).getText());
                return sb.toString();
            }
        }
        catch (PhpInvalidTemplateException e) {
            LOG.error("Invalid constructor template");
        }
        return null;
    }

    @Nullable
    private static String getCommentText(@NotNull Method method, PhpDocCreationOption option) {
        if (method == null) {
            PhpCodeUtil.$$$reportNull$$$0(20);
        }
        PhpDocComment comment = method.getDocComment();
        switch (option) {
            case NONE: {
                return null;
            }
            case INHERIT: {
                if (comment == null) break;
                return "/**\n* @inheritDoc\n*/";
            }
            case COPY_IF_ABSTRACT: {
                if (!method.isAbstract()) break;
            }
            case COPY_ALWAYS: {
                if (comment == null) break;
                return comment.getText().replaceAll("\\n.*@abstract.*\\n", "\n");
            }
            case DEFAULT: {
                if (!method.isValid() || (comment = PhpDocCommentGenerator.constructDocComment(method.getProject(), (PsiElement)method, false)) == null) break;
                return comment.getText();
            }
        }
        return null;
    }

    private static String getOverridingMethodBody(Method method, boolean isImplementing, @Nullable String defaultBody) {
        if (defaultBody != null) {
            return defaultBody;
        }
        return PhpCodeUtil.getCodeTemplate(isImplementing ? PHP_IMPLEMENTED_METHOD_BODY : PHP_OVERRIDDEN_METHOD_BODY, PhpCodeUtil.getOverridingMethodAttributes(method), method.getProject());
    }

    private static Properties getOverridingMethodAttributes(Method method) {
        Properties attributes = new Properties();
        StringBuilder paramList = new StringBuilder();
        Parameter[] params = method.getParameters();
        for (int i = 0; i < params.length; ++i) {
            paramList.append("$").append(params[i].getName());
            if (i >= params.length - 1) continue;
            paramList.append(',');
        }
        attributes.setProperty("NAME", method.getName());
        attributes.setProperty("PARAM_LIST", paramList.toString());
        attributes.setProperty("RETURN", PhpCodeUtil.containsElement(method, PhpElementTypes.RETURN) ? "return" : "");
        return attributes;
    }

    private static boolean containsElement(PsiElement parent, IElementType eType) {
        for (PsiElement currChild = parent.getFirstChild(); currChild != null; currChild = currChild.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(currChild, eType) && !PhpCodeUtil.containsElement(currChild, eType)) continue;
            return true;
        }
        return false;
    }

    public static boolean belongsTo(PsiElement element, PsiElement parent) {
        PsiElement currParent = element;
        while ((currParent = currParent.getParent()) != null) {
            if (currParent != parent) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Method createMethodFromTemplate(PhpClass phpClass, Project p, String template) {
        return PhpCodeUtil.createMethodFromTemplate(p, phpClass.isInterface(), template);
    }

    @Nullable
    public static Method createMethodFromTemplate(Project p, boolean isInterface, String template) {
        String classKeyword = isInterface ? "interface" : "class";
        String classTemplate = classKeyword + " c { " + template + "}";
        return PhpPsiElementFactory.createFromText(p, Method.class, classTemplate);
    }

    @Nullable
    public static PhpClass createClassFromMethodTemplate(PhpClass phpClass, Project p, String template) {
        String classKeyword = phpClass.isInterface() ? "interface" : "class";
        String classTemplate = classKeyword + " c { " + template + "}";
        return PhpPsiElementFactory.createFromText(p, PhpClass.class, classTemplate);
    }

    public static String camelCaps(String str) {
        StringBuilder strBuf = new StringBuilder();
        boolean capitalize = true;
        for (char c : str.toCharArray()) {
            if (c == '_') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                strBuf.append(StringUtil.toUpperCase((String)String.valueOf(c)));
                capitalize = false;
                continue;
            }
            strBuf.append(c);
        }
        return strBuf.toString();
    }

    public static String getCodeTemplate(String templateName, @Nullable Properties attributes, Project project) {
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate(templateName);
        if (attributes == null) {
            return fileTemplate.getText();
        }
        try {
            return fileTemplate.getText(attributes);
        }
        catch (IOException e) {
            return fileTemplate.getText();
        }
    }

    @NotNull
    public static String getTypeHint(@NotNull Field field, @Nullable PhpPsiElement scopeForUseOperator) {
        String typeHint;
        PhpType declaredType;
        PhpType type;
        if (field == null) {
            PhpCodeUtil.$$$reportNull$$$0(21);
        }
        PhpType phpType = type = (declaredType = field.getDeclaredType()).isEmpty() ? field.getType() : declaredType;
        if (PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned(type.toString())) {
            type = new PhpType().add("self");
        }
        if ((typeHint = PhpDocUtil.getTypePresentation(field.getProject(), type, scopeForUseOperator)).isEmpty()) {
            typeHint = MIXED_TYPE_HINT;
        }
        String string = typeHint;
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    public static String getVarDocComment(PsiElement target, Project project, @NotNull String typeTag) {
        if (typeTag == null) {
            PhpCodeUtil.$$$reportNull$$$0(23);
        }
        if (target == null || target.getNode() == null) {
            return null;
        }
        StringBuilder commentBuf = new StringBuilder();
        commentBuf.append(typeTag);
        if (PhpPsiUtil.isOfType(target, PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS)) {
            Field field = (Field)PsiTreeUtil.getChildOfType((PsiElement)target, Field.class);
            if (field == null) {
                return null;
            }
            PhpType type = PhpDocCommentGenerator.globalPreserving$This(field.getType(), field);
            PhpTypeDeclaration typeDeclaration = field.getTypeDeclaration();
            String fieldType = PhpDocUtil.getTypePresentation(project, type, PhpCodeInsightUtil.findScopeForUseOperator(field), typeDeclaration);
            if (!fieldType.isEmpty()) {
                commentBuf.append(' ').append(fieldType);
            }
        } else {
            Statement expr;
            if (target instanceof GroupStatement) {
                expr = (Statement)PsiTreeUtil.getChildOfType((PsiElement)target, Statement.class);
                if (expr == null) {
                    return null;
                }
            } else if (target instanceof Statement) {
                expr = (Statement)target;
            } else {
                return null;
            }
            if (expr instanceof ForeachStatement) {
                List<PsiElement> declarations = PhpPsiUtil.getChildren((PsiElement)expr, (Condition<? super PsiElement>)((Condition)element -> element instanceof Variable && ((Variable)element).isDeclaration()));
                if (!declarations.isEmpty()) {
                    if (declarations.size() == 1) {
                        PsiReference ref;
                        PsiElement variable = declarations.get(0);
                        if (variable == null || (ref = variable.getReference()) == null) {
                            return null;
                        }
                        commentBuf.append("  ").append(ref.getCanonicalText());
                    } else {
                        boolean isFirst = true;
                        commentBuf.insert(0, "\n* ");
                        for (PsiElement variable : declarations) {
                            PsiReference ref;
                            if (!isFirst) {
                                commentBuf.append("\n* ");
                                commentBuf.append(typeTag);
                            }
                            if (variable == null || (ref = variable.getReference()) == null) {
                                return null;
                            }
                            commentBuf.append("  ").append(ref.getCanonicalText());
                            isFirst = false;
                        }
                    }
                }
            } else {
                PsiReference ref;
                PhpPsiElement assignment = expr.getFirstPsiChild();
                if (assignment == null || !PhpPsiUtil.isOfType((PsiElement)assignment, PhpElementTypes.ASSIGNMENT_EXPRESSION)) {
                    return null;
                }
                PhpPsiElement variable = ((AssignmentExpression)assignment).getVariable();
                if (variable == null || (ref = variable.getReference()) == null) {
                    return null;
                }
                commentBuf.append("  ").append(ref.getCanonicalText());
            }
        }
        return commentBuf.toString();
    }

    public static void openRelatedFile(Project project, PsiElement element) {
        if (!element.isValid() || IntentionPreviewUtils.isPreviewElement((PsiElement)element)) {
            return;
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        assert (file != null);
        OpenFileAction.openFile((String)file.getPath(), (Project)project);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (!ApplicationManager.getApplication().isUnitTestMode()) assert (editor != null);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(element.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    public static boolean isImplemented(@Nullable PhpClass phpClass, @NotNull Method target) {
        if (target == null) {
            PhpCodeUtil.$$$reportNull$$$0(24);
        }
        if (phpClass == null || phpClass.isInterface() || PhpLangUtil.isObject(phpClass)) {
            return false;
        }
        Method method = phpClass.findMethodByName(target.getName());
        return method != null && !method.isAbstract();
    }

    @Nullable
    public static String getTypeHintString(@NotNull Project project, boolean allowMultipleTypes, Collection<String> typeHints) {
        if (project == null) {
            PhpCodeUtil.$$$reportNull$$$0(25);
        }
        return PhpCodeUtil.getTypeHintString(PhpLanguageLevel.current((Project)project), allowMultipleTypes, typeHints);
    }

    @Nullable
    public static String getTypeHintString(@NotNull PhpLanguageLevel languageLevel, boolean allowMultipleTypes, Collection<String> typeHints) {
        if (languageLevel == null) {
            PhpCodeUtil.$$$reportNull$$$0(26);
        }
        if (!languageLevel.hasFeature(PhpLanguageFeature.INTERSECTION_TYPES) && ContainerUtil.exists(typeHints, PhpType::isIntersectionType)) {
            return null;
        }
        if (allowMultipleTypes) {
            if (typeHints.size() > 1 && languageLevel.hasFeature(PhpLanguageFeature.UNION_TYPES)) {
                return typeHints.stream().map(s -> PhpType.isIntersectionType(s) ? "(" + s + ")" : s).collect(Collectors.joining("|"));
            }
            return (String)ContainerUtil.getFirstItem(typeHints);
        }
        return (String)ContainerUtil.getOnlyItem(typeHints);
    }

    public static String getPropertyHookText(String fieldName, PhpPropertyHook.PhpPropertyHookType hookType) {
        return hookType.keyWord + "{" + hookType.defaultBody.formatted(fieldName) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 7, 9, 11, 13, 14, 15, 19, 20, 21, 23, 24, 25, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpCodeUtil";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeTag";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverridingMethodText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersTextWithoutTypeDeclarations";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpCodeUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativizedType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterText";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeTextForOverride";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenReturnTypeText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "paramToString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRelativizedType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createParameterText";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeTextForOverride";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertPluralTypesToParameterTypeHints";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenReturnTypeText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createOverridingConstructorText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCommentText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getVarDocComment";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isImplemented";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHintString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 7, 9, 11, 13, 14, 15, 19, 20, 21, 23, 24, 25, 26 -> new IllegalArgumentException(string);
        };
    }
}

