/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.LexerEditorHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIndexPatternBuilder
implements IndexPatternBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            PhpIndexPatternBuilder.$$$reportNull$$$0(0);
        }
        if (file.getFileType() != PhpFileType.INSTANCE) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = file.getViewProvider().getVirtualFile();
        }
        try {
            LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
            EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file.getProject(), virtualFile);
            LexerEditorHighlighterLexer lexerEditorHighlighterLexer = new LexerEditorHighlighterLexer(highlighter, false);
            return lexerEditorHighlighterLexer;
        }
        finally {
            LayeredLexer.ourDisableLayersFlag.set(Boolean.FALSE);
        }
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            PhpIndexPatternBuilder.$$$reportNull$$$0(1);
        }
        if (file.getFileType() != PhpFileType.INSTANCE) {
            return null;
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(file.getViewProvider().getBaseLanguage());
        return definition != null ? definition.getCommentTokens() : TokenSet.EMPTY;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        return PhpIndexPatternBuilder.doGetCommentDelta(tokenType);
    }

    public int getCommentStartDelta(@NotNull IElementType tokenType, @NotNull CharSequence tokenText) {
        if (tokenType == null) {
            PhpIndexPatternBuilder.$$$reportNull$$$0(2);
        }
        if (tokenText == null) {
            PhpIndexPatternBuilder.$$$reportNull$$$0(3);
        }
        if (tokenType == PhpTokenTypes.LINE_COMMENT) {
            return StringUtil.startsWith((CharSequence)tokenText, (CharSequence)"#") ? 1 : 2;
        }
        return this.getCommentStartDelta(tokenType);
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return PhpIndexPatternBuilder.doGetCommentDelta(tokenType);
    }

    public static int doGetCommentDelta(IElementType tokenType) {
        if (tokenType == PhpTokenTypes.C_STYLE_COMMENT) {
            return 2;
        }
        if (tokenType == PhpDocElementTypes.DOC_COMMENT) {
            return 3;
        }
        return 0;
    }

    @NotNull
    public String getCharsAllowedInContinuationPrefix(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            PhpIndexPatternBuilder.$$$reportNull$$$0(4);
        }
        return tokenType == PhpTokenTypes.C_STYLE_COMMENT || tokenType == PhpDocElementTypes.DOC_COMMENT ? "*" : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/PhpIndexPatternBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentTokenSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentStartDelta";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharsAllowedInContinuationPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

