/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IntPair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.documentation.PhpDocSource;
import com.jetbrains.php.lang.documentation.PhpDocumentationProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PhpParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<ParameterListOwner, PsiElementResolveResult, PhpPsiElement>,
DumbAware {
    private String text;
    private static final String DOC_TEXT_PLACEHOLDER = "#doc#";
    public static final Key<PhpType> PARAM_TYPE_FROM_GIST = Key.create((String)"PhpParameterTypeFromGist");

    public ParameterListOwner findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        PhpPsiElement classReference;
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(0);
        }
        ParameterListOwner place = PhpParameterInfoHandler.findAnchorForParameterInfo((ParameterInfoContext)context);
        Object[] variants = ResolveResult.EMPTY_ARRAY;
        if (place instanceof PsiPolyVariantReference) {
            variants = ((PsiPolyVariantReference)place).multiResolve(true);
        } else if ((place instanceof NewExpression || place instanceof PhpAttribute) && (classReference = place.getFirstPsiChild()) instanceof ClassReference) {
            variants = ((ClassReference)classReference).multiResolve(true);
        }
        context.setItemsToShow(variants);
        return place;
    }

    @Nullable
    public static ParameterListOwner findAnchorForParameterInfo(@NotNull ParameterInfoContext context) {
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(1);
        }
        return PhpParameterInfoHandler.findAnchorElement(context.getOffset(), context.getFile());
    }

    public ParameterListOwner findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(2);
        }
        return PhpParameterInfoHandler.findAnchorForParameterInfo((ParameterInfoContext)context);
    }

    public PhpPsiElement @NotNull [] getActualParameters(@NotNull ParameterListOwner o) {
        if (o == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(3);
        }
        PsiElement[] parameters = o.getParameters();
        PhpPsiElement[] phpPsiElementArray = (PhpPsiElement[])Arrays.copyOf(parameters, parameters.length, PhpPsiElement[].class);
        if (phpPsiElementArray == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(4);
        }
        return phpPsiElementArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = PhpTokenTypes.opCOMMA;
        if (iElementType == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(5);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = PhpTokenTypes.chRPAREN;
        if (iElementType == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(6);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{PhpPsiElement.class});
        if (hashSet == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{Statement.class});
        if (hashSet == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public Class<ParameterListOwner> getArgumentListClass() {
        return ParameterListOwner.class;
    }

    private static boolean isEmbraced(@Nullable PhpPsiElement element, int offset) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        ASTNode lbrace = node.findChildByType(PhpTokenTypes.chLPAREN);
        ASTNode rbrace = node.findChildByType(PhpTokenTypes.chRPAREN);
        if (lbrace != null && rbrace != null) {
            return lbrace.getStartOffset() < offset && rbrace.getStartOffset() >= offset;
        }
        if (lbrace != null) {
            return lbrace.getStartOffset() <= offset;
        }
        return false;
    }

    @Nullable
    private static ParameterListOwner findAnchorElement(int offset, PsiFile file) {
        if (offset <= 0) {
            return null;
        }
        if (file instanceof PhpFile) {
            ParameterListOwner parametersOwner;
            CharSequence chars = file.getViewProvider().getContents();
            if (offset > chars.length()) {
                offset = chars.length();
            }
            if ((offset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t\n\r") + 1) <= 0) {
                return null;
            }
            if (chars.charAt(offset - 1) == ',') {
                --offset;
            }
            if ((parametersOwner = (ParameterListOwner)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, ParameterListOwner.class, (boolean)false)) == null) {
                return null;
            }
            if (PhpParameterInfoHandler.isEmbraced(parametersOwner, offset)) {
                return parametersOwner;
            }
            ParameterListOwner outerParameterListOwner = (ParameterListOwner)PhpPsiUtil.getParentByCondition((PsiElement)parametersOwner, (Condition<? super PsiElement>)((Condition)o -> o instanceof ParameterListOwner && PhpPsiUtil.getChildOfType(o, PhpTokenTypes.chLPAREN) != null));
            if (PhpParameterInfoHandler.isEmbraced(outerParameterListOwner, offset)) {
                return outerParameterListOwner;
            }
        }
        return null;
    }

    public void showParameterInfo(@NotNull ParameterListOwner place, @NotNull CreateParameterInfoContext context) {
        if (place == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(10);
        }
        context.showHint((PsiElement)place, place.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public void updateParameterInfo(@NotNull ParameterListOwner place, @NotNull UpdateParameterInfoContext context) {
        PsiElement contextParameterOwner;
        if (place == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if ((contextParameterOwner = context.getParameterOwner()) == null) {
            context.setParameterOwner((PsiElement)place);
        } else if (!(contextParameterOwner instanceof PhpPsiElement)) {
            context.removeHint();
            return;
        }
        IElementType delimiter = this.getActualParameterDelimiterType();
        int currIndex = PhpParameterInfoHandler.getCurrentParameterIndex(place, PhpParameterInfoHandler.getCurrentOffset(context), delimiter);
        context.setCurrentParameter(currIndex);
        Object[] objects = context.getObjectsToView();
        for (int i = 0; i < objects.length; ++i) {
            PsiElementResolveResult resolveResult = (PsiElementResolveResult)objects[i];
            PsiNamedElement namedElement = (PsiNamedElement)resolveResult.getElement();
            if (namedElement instanceof Function) {
                Function function = (Function)namedElement;
                int index = PhpParameterInfoHandler.getCurrentParameterIndexForPotentiallyNamedArgument(place, function, PhpParameterInfoHandler.getCurrentOffset(context), delimiter);
                context.setCurrentParameter(index);
                for (Parameter parameter : function.getParameters()) {
                    parameter.putUserData(PARAM_TYPE_FROM_GIST, parameter.getGlobalType());
                }
            }
            if (namedElement.isValid()) continue;
            context.setUIComponentEnabled(i, false);
        }
    }

    public static int getCurrentOffset(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(13);
        }
        int offset = context.getOffset();
        return CharArrayUtil.shiftForward((CharSequence)context.getEditor().getDocument().getText(), (int)offset, (String)" \t\n");
    }

    private static int getCurrentParameterIndexForPotentiallyNamedArgument(PhpPsiElement place, Function function, int offset, IElementType delimiterType) {
        ParameterList list = PhpParameterInfoHandler.getParameterList(place);
        if (list == null) {
            return ParameterInfoUtils.getCurrentParameterIndex((ASTNode)place.getNode(), (int)offset, (IElementType)delimiterType);
        }
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)list.getNode(), (int)offset, (IElementType)delimiterType);
        PsiElement parameterFromFunctionCall = list.getParameter(index);
        if (parameterFromFunctionCall == null) {
            return index;
        }
        PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(parameterFromFunctionCall);
        if (nameIdentifier == null) {
            return index;
        }
        int i = 0;
        for (Parameter parameter : function.getParameters()) {
            if (parameter != null && parameter.getName().equals(nameIdentifier.getText())) {
                return i;
            }
            ++i;
        }
        return index;
    }

    private static ParameterList getParameterList(PhpPsiElement place) {
        if (place instanceof ClassReference) {
            place = (PhpPsiElement)place.getParent();
        }
        if (place instanceof FunctionReference || place instanceof NewExpression || place instanceof PhpAttribute) {
            return ((ParameterListOwner)place).getParameterList();
        }
        return null;
    }

    public static int getCurrentParameterIndex(PhpPsiElement place, int offset, IElementType delimiterType) {
        ParameterList list = PhpParameterInfoHandler.getParameterList(place);
        if (list != null) {
            return ParameterInfoUtils.getCurrentParameterIndex((ASTNode)list.getNode(), (int)offset, (IElementType)delimiterType);
        }
        return ParameterInfoUtils.getCurrentParameterIndex((ASTNode)place.getNode(), (int)offset, (IElementType)delimiterType);
    }

    public void updateUI(PsiElementResolveResult resolveResult, @NotNull ParameterInfoUIContext context) {
        Method constructor;
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(14);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        Object element = (PsiNamedElement)resolveResult.getElement();
        if (!element.isValid()) {
            context.setUIComponentEnabled(false);
            return;
        }
        StringBuilder buffer = new StringBuilder();
        IntPair highlightRange = new IntPair(-1, -1);
        if (element instanceof PhpClass && (constructor = ((PhpClass)element).getConstructor()) != null) {
            element = constructor;
        }
        if (element instanceof Function) {
            int currentParameter;
            Function function = (Function)element;
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                buffer.append(element.getName());
                buffer.append("(");
            }
            if ((currentParameter = context.getCurrentParameterIndex()) < 0) {
                currentParameter = 0;
            }
            Parameter[] parameters = function.getParameters();
            highlightRange = PhpParameterInfoHandler.appendParameterInfo(context, buffer, highlightRange, currentParameter, Arrays.asList(parameters), PhpParameterInfoHandler::getPresentation);
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                buffer.append(")");
                PhpType returnType = function.getType();
                if (!returnType.isEmpty()) {
                    PhpParameterInfoHandler.formatType(buffer, function);
                }
            }
            if (currentParameter < parameters.length) {
                PhpParameterInfoHandler.appendPhpDoc(buffer, PhpDocumentationProvider.getDocSourceFor(parameters[currentParameter], (PsiElement)element), context);
            }
        } else if (element instanceof PhpClass) {
            buffer.append("no parameters");
        } else if (element instanceof Variable) {
            // empty if block
        }
        this.text = buffer.toString();
        context.setupUIComponentPresentation(this.text, highlightRange.first, highlightRange.second, false, false, false, context.getDefaultParameterColor());
    }

    public static <T> IntPair appendParameterInfo(@NotNull ParameterInfoUIContext context, StringBuilder buffer, IntPair highlightRange, int currentParameter, List<T> parameters, java.util.function.Function<T, String> presentation) {
        int numParams;
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(15);
        }
        if ((numParams = parameters.size()) > 0) {
            for (int j = 0; j < numParams; ++j) {
                boolean highlight;
                T param = parameters.get(j);
                boolean bl = highlight = context.isUIComponentEnabled() && (j == currentParameter || j == numParams - 1 && param instanceof Parameter && ((Parameter)param).isVariadic() && currentParameter >= numParams);
                if (highlight) {
                    highlightRange = new IntPair(buffer.length(), highlightRange.second);
                }
                buffer.append(presentation.apply(param));
                if (highlight) {
                    highlightRange = new IntPair(highlightRange.first, buffer.length());
                }
                if (j >= numParams - 1) continue;
                buffer.append(", ");
            }
        } else {
            buffer.append("no parameters");
        }
        return highlightRange;
    }

    @NotNull
    private static String getPresentation(Parameter param) {
        String string = PhpPresentationUtil.getParameterPresentation(param, PhpPresentationUtil.getParameterTypesStrings(param));
        if (string == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static void appendPhpDoc(@NotNull StringBuilder buffer, @Nullable PhpDocSource source, @NotNull ParameterInfoUIContext context) {
        String str;
        if (buffer == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(18);
        }
        if (context instanceof ParameterInfoUIContextEx && source != null && StringUtil.isNotEmpty((String)(str = StringUtil.trimLog((String)source.getDescription(), (int)200)))) {
            Object docString = str.startsWith("<p>") ? str : "<p>" + str;
            ((ParameterInfoUIContextEx)context).setEscapeFunction(arg_0 -> PhpParameterInfoHandler.lambda$appendPhpDoc$1((String)docString, arg_0));
            assert (buffer.indexOf(DOC_TEXT_PLACEHOLDER) < 0) : buffer.toString();
            buffer.append(DOC_TEXT_PLACEHOLDER);
        }
    }

    private static void formatType(@NotNull StringBuilder builder2, @NotNull PhpNamedElement e) {
        if (builder2 == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(19);
        }
        if (e == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(20);
        }
        if (DumbService.getInstance((Project)e.getProject()).isDumb()) {
            return;
        }
        PhpType phpType = e.getGlobalType();
        if (!phpType.isEmpty()) {
            builder2.append(": ");
            builder2.append(phpType.toStringRelativized("\\"));
        }
    }

    @TestOnly
    public String getText() {
        return this.text;
    }

    private static /* synthetic */ String lambda$appendPhpDoc$1(String docString, String s) {
        return StringUtil.replace((String)s, (String)DOC_TEXT_PLACEHOLDER, (String)docString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpParameterInfoHandler";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpParameterInfoHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findAnchorForParameterInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentOffset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendPhpDoc";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 16 -> new IllegalStateException(string);
        };
    }
}

