/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.CommentsReferenceContributor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.PhpStaticMethodCallbackReference;
import com.jetbrains.php.lang.PhpStaticMethodClassCallbackReference;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.intentions.strings.converters.PhpSprintfStringRepresentationConverter;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            PhpReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PhpLanguage.INSTANCE)).withElementType(PhpElementTypes.STRING), (PsiReferenceProvider)new CallbackReferenceProvider(true), 0.0);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PhpDocPsiElement.class).andNot((ElementPattern)PlatformPatterns.psiElement(PhpDocRef.class)), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = element.getReferences();
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/PhpReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/PhpReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }, -100.0);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement((IElementType)PhpDocTokenTypes.DOC_URL), CommentsReferenceContributor.COMMENTS_REFERENCE_PROVIDER_TYPE.getProvider());
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class), (PsiReferenceProvider)new MyPhpWebReferenceInStringProvider(), 0.0);
    }

    public static PhpCallbackReferenceBase.PhpClassMemberCallbackReference getCallbackRefFromArray(@Nullable ArrayCreationExpression array) {
        if (array == null) {
            return null;
        }
        List elements = ContainerUtil.map((Iterable)ArrayCreationExpressionImpl.children(array).limit(3), PhpPsiElement::getFirstPsiChild);
        if (elements.size() == 2) {
            PhpTypedElement classRef = (PhpTypedElement)ObjectUtils.tryCast(elements.get(0), PhpTypedElement.class);
            PsiElement methodName = (PsiElement)elements.get(1);
            if (classRef == null || !(methodName instanceof StringLiteralExpression)) {
                return null;
            }
            PhpCallbackReferenceBase.PhpClassMemberCallbackReference callbackReference = new PhpCallbackReferenceBase.PhpClassMemberCallbackReference((PsiElement)classRef, methodName, true);
            if (PhpReferenceContributor.isArrayBasedFunctionCall(array)) {
                return callbackReference;
            }
            PhpType classRefType = classRef.getGlobalType();
            boolean hasNonScalarType = classRefType.getTypes().stream().anyMatch(t -> !PhpType.isNotExtendablePrimitiveType(t));
            if ((PhpType.STRING.equals(classRefType) || hasNonScalarType) && callbackReference.multiResolve(false).length > 0) {
                return callbackReference;
            }
        }
        return null;
    }

    public static int findParameterIndex(@NotNull PsiElement parameter) {
        PsiElement parameterList;
        if (parameter == null) {
            PhpReferenceContributor.$$$reportNull$$$0(1);
        }
        if ((parameterList = parameter.getParent()) != null) {
            PsiElement[] children = parameterList.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (parameter != children[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isReturnedAsCallable(@NotNull PsiElement element) {
        PhpReturn phpReturn;
        if (element == null) {
            PhpReferenceContributor.$$$reportNull$$$0(2);
        }
        if ((phpReturn = (PhpReturn)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize(element.getParent()), PhpReturn.class)) == null) {
            return false;
        }
        Function function = (Function)ObjectUtils.tryCast((Object)PhpPsiUtil.getScopeHolder((PsiElement)phpReturn), Function.class);
        if (function == null || function.getTypeDeclaration() == null) {
            return false;
        }
        return PhpCallbackFunctionUtil.isCallable(((PhpReturnType)function.getTypeDeclaration()).getGlobalType());
    }

    @Nullable
    public static PsiElement findImmediateParentParameter(@NotNull PsiElement element) {
        PsiElement parameter;
        if (element == null) {
            PhpReferenceContributor.$$$reportNull$$$0(3);
        }
        for (parameter = element; parameter != null && PhpReferenceContributor.isStringOrInArray(parameter) && !(parameter.getParent() instanceof ParameterList); parameter = parameter.getParent()) {
        }
        if (parameter == null) {
            return null;
        }
        PsiElement parent = parameter.getParent();
        if (parent instanceof ParameterList) {
            return parameter;
        }
        if (parent instanceof AssignmentExpression && parent.getParent() instanceof ParameterList) {
            return parent;
        }
        return null;
    }

    private static boolean isStringOrInArray(@NotNull PsiElement element) {
        if (element == null) {
            PhpReferenceContributor.$$$reportNull$$$0(4);
        }
        if (element instanceof StringLiteralExpression) {
            return true;
        }
        return PhpPsiUtil.isOfType(element, PhpElementTypes.ARRAY_VALUE) || element instanceof ArrayCreationExpression || element instanceof ArrayHashElement;
    }

    private static boolean isArrayBasedFunctionCall(ArrayCreationExpression array) {
        return array != null && array.getParent() instanceof FunctionReference && ((FunctionReference)array.getParent()).getFirstPsiChild() == array;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/PhpReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findParameterIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isReturnedAsCallable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findImmediateParentParameter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringOrInArray";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CallbackReferenceProvider
    extends PsiReferenceProvider {
        private static final int MAX_CLASS_CALLBACK_LENGTH = 200;
        private final boolean myIsExtended;

        CallbackReferenceProvider(boolean isExtended) {
            this.myIsExtended = isExtended;
        }

        private Collection<PsiReference> getCallbackReferences(ParameterListOwner parameterListOwner, @Nullable PsiElement parameter, @NotNull PsiElement element, @Nullable PsiElement referenceHost) {
            int parameterIndex;
            ArrayCreationExpression array;
            PhpCallbackReferenceBase.PhpClassMemberCallbackReference callbackReference;
            if (element == null) {
                CallbackReferenceProvider.$$$reportNull$$$0(0);
            }
            FunctionReference functionRef = (FunctionReference)ObjectUtils.tryCast((Object)parameterListOwner, FunctionReference.class);
            if (element instanceof StringLiteralExpression && (callbackReference = PhpReferenceContributor.getCallbackRefFromArray(array = (ArrayCreationExpression)PhpPsiUtil.getParentByCondition(element, ArrayCreationExpression.INSTANCEOF, Statement.INSTANCEOF))) != null && callbackReference.getElement() == element) {
                return Collections.singletonList(callbackReference);
            }
            int n = parameterIndex = parameter != null ? PhpReferenceContributor.findParameterIndex(parameter) : -1;
            if (functionRef != null) {
                if (parameterIndex < 0) {
                    return Collections.emptyList();
                }
                if (referenceHost != null) {
                    if (PhpCallbackFunctionUtil.isClassCallbackFunction(functionRef, parameterIndex)) {
                        return Collections.singletonList(PhpCallbackReferenceBase.createClassReference(referenceHost, true));
                    }
                    boolean isMethod = PhpCallbackFunctionUtil.isMethodCallbackFunction(functionRef, parameterIndex);
                    if (isMethod || PhpCallbackFunctionUtil.isFieldCallbackFunction(functionRef, parameterIndex)) {
                        PsiElement[] parameters = parameter.getParent().getChildren();
                        return parameters.length < 2 ? Collections.emptyList() : Collections.singletonList(PhpCallbackReferenceBase.createMemberReference(parameters[0], referenceHost, isMethod));
                    }
                }
            }
            if (PhpReferenceContributor.isReturnedAsCallable(element) || parameterListOwner != null && PhpCallbackFunctionUtil.isCallableParameter(parameterListOwner, parameterIndex)) {
                StringLiteralExpression expression;
                PhpCallbackFunctionUtil.PhpStaticCallback staticCallback;
                if (referenceHost instanceof StringLiteralExpression && (staticCallback = PhpCallbackFunctionUtil.createStaticCallback(expression = (StringLiteralExpression)referenceHost)) != null) {
                    PhpStaticMethodClassCallbackReference classReference = new PhpStaticMethodClassCallbackReference(expression, staticCallback.myClassName);
                    PhpStaticMethodCallbackReference methodCallReference = new PhpStaticMethodCallbackReference(expression, staticCallback);
                    return Arrays.asList(new PsiReference[]{classReference, methodCallReference});
                }
                PsiElement callbackElement = referenceHost == element || referenceHost == null ? (PsiElement)ObjectUtils.chooseNotNull((Object)parameter, (Object)element) : referenceHost;
                PhpCallbackFunctionUtil.PhpCallbackInfoHolder callback = PhpCallbackFunctionUtil.createCallback(callbackElement, referenceHost);
                if (callback instanceof PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder) {
                    PsiElement classRef = ((PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder)callback).getClassElement();
                    if (callback.getCallbackElement() == referenceHost) {
                        return Collections.singletonList(PhpCallbackReferenceBase.createMemberReference(classRef, callback.getCallbackElement(), true));
                    }
                    return Collections.singletonList(PhpCallbackReferenceBase.createClassReference(classRef, true));
                }
                if (callback != null) {
                    return Collections.singletonList(PhpCallbackReferenceBase.createFunctionReference(callback.getCallbackElement()));
                }
            }
            if (this.myIsExtended && referenceHost instanceof StringLiteralExpression) {
                PhpCallbackReferenceBase classCallbackRef;
                String callbackString;
                StringLiteralExpression classRef = (StringLiteralExpression)referenceHost;
                if (!(referenceHost.getTextLength() >= 200 || classRef.isHeredoc() || !classRef.isSingleQuote() || functionRef != null && parameterIndex == 1 && "class_alias".equals(functionRef.getName()) || (callbackString = PhpCallbackFunctionUtil.getCallbackString(referenceHost)) == null || !callbackString.contains("\\") && !callbackString.contains("_") || (classCallbackRef = PhpCallbackReferenceBase.createClassReference(element, false)) == null)) {
                    return Collections.singletonList(classCallbackRef);
                }
            }
            return Collections.emptyList();
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PhpAccessVariableInstruction variableInstruction;
            Collection<PsiReference> references;
            if (element == null) {
                CallbackReferenceProvider.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CallbackReferenceProvider.$$$reportNull$$$0(2);
            }
            if (!(references = this.doGetReferences(element, element)).isEmpty()) {
                PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    CallbackReferenceProvider.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getValue() == element && (variableInstruction = PhpControlFlowUtil.getAccessInstruction(((AssignmentExpression)parent).getVariable(), PhpAccessVariableInstruction.class)) != null) {
                PsiReference[] psiReferenceArray = this.collectReferencesFromSuccessors(variableInstruction, element);
                if (psiReferenceArray == null) {
                    CallbackReferenceProvider.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                CallbackReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private PsiReference[] collectReferencesFromSuccessors(final PhpAccessVariableInstruction variableInstruction, final @NotNull PsiElement referenceHost) {
            if (referenceHost == null) {
                CallbackReferenceProvider.$$$reportNull$$$0(6);
            }
            final TreeSet<PsiReference> res = new TreeSet<PsiReference>(Comparator.comparing(r -> r.getClass().getName(), String.CASE_INSENSITIVE_ORDER));
            PhpControlFlowUtil.processSuccessors(variableInstruction, false, new PhpInstructionProcessor(){

                @Override
                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableInstruction.getVariableName())) {
                        if (instruction.getAccess() instanceof PhpAccessInstruction.ReadOrReadRefAccess || instruction.getAccess().isRead()) {
                            res.addAll(this.doGetReferences((PsiElement)instruction.getAnchor(), referenceHost));
                            return true;
                        }
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }

                @Override
                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    PhpCallbackFunctionUtil.PhpCallbackInfoHolder callback;
                    FunctionReference functionReference = instruction.getFunctionReference();
                    Variable variable = (Variable)ObjectUtils.tryCast((Object)functionReference.getFirstPsiChild(), Variable.class);
                    if (variable != null && PhpLangUtil.equalsVariableNames(variable.getName(), variableInstruction.getVariableName()) && (callback = PhpCallbackFunctionUtil.createCallback(referenceHost, referenceHost)) != null) {
                        res.add(PhpCallbackReferenceBase.createFunctionReference(callback.getCallbackElement()));
                    }
                    return super.processPhpCallInstruction(instruction);
                }
            });
            return res.toArray(PsiReference.EMPTY_ARRAY);
        }

        private Collection<PsiReference> doGetReferences(@NotNull PsiElement element, @NotNull PsiElement referenceHost) {
            if (element == null) {
                CallbackReferenceProvider.$$$reportNull$$$0(7);
            }
            if (referenceHost == null) {
                CallbackReferenceProvider.$$$reportNull$$$0(8);
            }
            ParameterListOwner parameterListOwner = (ParameterListOwner)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)e -> CallbackReferenceProvider.isFunctionTarget(e)), Statement.INSTANCEOF);
            FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)parameterListOwner, FunctionReference.class);
            PsiElement selectedParameter = PhpReferenceContributor.findImmediateParentParameter(element);
            if (functionReference != null && selectedParameter != null && PhpCallbackFunctionUtil.isVariableCallbackFunction(functionReference)) {
                PhpCallbackReferenceBase ref = PhpCallbackReferenceBase.createVariableReference((PsiElement)PhpPsiUtil.getParentOfClass(element, false, StringLiteralExpression.class));
                return ContainerUtil.createMaybeSingletonSet((Object)((Object)ref));
            }
            return this.getCallbackReferences(parameterListOwner, selectedParameter, element, referenceHost);
        }

        private static boolean isFunctionTarget(PsiElement e) {
            return e instanceof FunctionReference || e instanceof NewExpression || e instanceof PhpAttribute;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpReferenceContributor$CallbackReferenceProvider";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpReferenceContributor$CallbackReferenceProvider";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCallbackReferences";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectReferencesFromSuccessors";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "doGetReferences";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyPhpWebReferenceInStringProvider
    extends PsiReferenceProvider {
        private MyPhpWebReferenceInStringProvider() {
        }

        public boolean acceptsTarget(@NotNull PsiElement target) {
            if (target == null) {
                MyPhpWebReferenceInStringProvider.$$$reportNull$$$0(0);
            }
            return false;
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiElement parent;
            if (element == null) {
                MyPhpWebReferenceInStringProvider.$$$reportNull$$$0(1);
            }
            if (context == null) {
                MyPhpWebReferenceInStringProvider.$$$reportNull$$$0(2);
            }
            if (!((parent = element.getParent()) instanceof ConcatenationExpression) && element.textContains(':') && PhpSprintfStringRepresentationConverter.INSTANCE.getTargetElement(element) == null && PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations(element)) {
                PsiReference[] psiReferenceArray = MyPhpWebReferenceInStringProvider.collectWebReferences(element, ((StringLiteralExpression)element).getContents());
                if (psiReferenceArray == null) {
                    MyPhpWebReferenceInStringProvider.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                MyPhpWebReferenceInStringProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static PsiReference[] collectWebReferences(@NotNull PsiElement element, String unescapedContent) {
            int l;
            if (element == null) {
                MyPhpWebReferenceInStringProvider.$$$reportNull$$$0(5);
            }
            int valueStartOffset = ((StringLiteralExpression)element).getValueRange().getStartOffset();
            ArrayList<WebReference> references = new ArrayList<WebReference>();
            int r = 0;
            while ((l = MyPhpWebReferenceInStringProvider.firstNonWhitespaceSymbol(r, unescapedContent)) < unescapedContent.length()) {
                r = MyPhpWebReferenceInStringProvider.lastNonWhitespaceSymbol(l, unescapedContent) + 1;
                String url = unescapedContent.substring(l, r);
                if (!GlobalPathReferenceProvider.isWebReferenceUrl((String)url) || VfsUtil.toUri((String)url) == null) continue;
                references.add(new WebReference(element, TextRange.create((int)l, (int)r).shiftRight(valueStartOffset), url));
            }
            return references.toArray(PsiReference.EMPTY_ARRAY);
        }

        private static int lastNonWhitespaceSymbol(int i, String content) {
            while (i < content.length() - 1 && !StringUtil.isWhiteSpace((char)content.charAt(i + 1))) {
                ++i;
            }
            return i;
        }

        private static int firstNonWhitespaceSymbol(int i, String content) {
            while (i < content.length() && StringUtil.isWhiteSpace((char)content.charAt(i))) {
                ++i;
            }
            return i;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpReferenceContributor$MyPhpWebReferenceInStringProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpReferenceContributor$MyPhpWebReferenceInStringProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptsTarget";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectWebReferences";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

