/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.php.codeInsight.regexp.PhpRegexpParserDefinition;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.editor.BasicPhpTypedHandler;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpTypedHandler
extends BasicPhpTypedHandler {
    protected void showMemberLookUp(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            PhpTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(1);
        }
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, f -> {
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = f.findElementAt(offset - 1);
            return lastElement != null && lastElement.getParent() instanceof ParameterList && PhpPsiUtil.getPrevSiblingByCondition(lastElement, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.IDENTIFIER))) != null;
        });
    }

    protected boolean isOpenTagStringInsideXmlTag(char c, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(3);
        }
        return c == '?' && offset > 0 && editor.getDocument().getCharsSequence().charAt(offset - 1) == '<' && PhpTypedHandler.insideXmlTag(file, offset);
    }

    protected void tryToMoveSemicolon(PsiFile file, Editor editor) {
        if (PhpSmartKeysConfiguration.getInstance().isAutoInsertSemicolonAfterFunctionCall()) {
            PhpTypedHandler.tryMoveCaretAfterFunctionCallRParen(file, editor);
        }
    }

    protected boolean isAutoInsertFullPhpOpenTag() {
        return PhpSmartKeysConfiguration.getInstance().isAutoInsertFullPhpOpenTag();
    }

    protected boolean isInsertClosingHtmlTagInPhpDoc() {
        PhpSmartKeysConfiguration configuration = PhpSmartKeysConfiguration.getInstance();
        return configuration.isInsertClosingHtmlTagInPhpDoc();
    }

    protected boolean isSingleHtmlTag(@NotNull String tagName) {
        if (tagName == null) {
            PhpTypedHandler.$$$reportNull$$$0(4);
        }
        return HtmlUtil.isSingleHtmlTag((String)tagName, (boolean)false);
    }

    protected void showCompletion(Editor editor) {
        PhpCompletionUtil.showCompletion(editor);
    }

    protected TypedHandlerDelegate.Result tryToAddOneLineDocComment(Editor editor, int offset, PsiFile file, Project project) {
        if (offset > 4 && "/** ".equals(editor.getDocument().getCharsSequence().subSequence(offset - 4, offset).toString())) {
            String typeTag;
            PhpDocComment docComment;
            PhpPsiElement target;
            String varDoc;
            PhpDocComment comment = (PhpDocComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PhpDocComment.class, (boolean)false);
            if (comment != null && PhpTypedHandler.isCompleteDocComment((PsiElement)comment)) {
                return TypedHandlerDelegate.Result.STOP;
            }
            PsiComment cStyleComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiComment.class, (boolean)false);
            if (cStyleComment == null || cStyleComment.getTokenType() != PhpTokenTypes.C_STYLE_COMMENT) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" */");
                editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, false);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
            if ((varDoc = PhpCodeUtil.getVarDocComment((PsiElement)(target = (docComment = (PhpDocComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset = editor.getCaretModel().getOffset()), PhpDocComment.class, (boolean)false)) != null ? docComment.getNextPsiSibling() : null), project, typeTag = "@var")) != null) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)varDoc);
                int additionalOffset = typeTag.length() + 1;
                if (target instanceof ForeachStatement && varDoc.startsWith("\n")) {
                    additionalOffset = 8;
                }
                if (target instanceof Statement) {
                    editor.getCaretModel().moveToOffset(offset + additionalOffset);
                } else {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" ");
                }
                if (target instanceof ForeachStatement) {
                    PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
                    psiDocumentManager.commitDocument(editor.getDocument());
                    if (offset < target.getTextOffset()) {
                        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, offset, target.getTextOffset());
                    }
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    protected boolean isDocComment(PsiElement element) {
        return element instanceof PhpDocComment;
    }

    private static void tryMoveCaretAfterFunctionCallRParen(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(6);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        HighlighterIterator it = editor.getHighlighter().createIterator(caretOffset);
        int afterLastParenOffset = -1;
        while (!it.atEnd() && !PhpTypedHandler.isAtLineEnd(it)) {
            if (it.getTokenType() == PhpTokenTypes.chRPAREN) {
                afterLastParenOffset = it.getEnd();
            } else if (it.getTokenType() != PhpTokenTypes.WHITE_SPACE) {
                return;
            }
            it.advance();
        }
        if (afterLastParenOffset >= 0 && afterLastParenOffset >= caretOffset) {
            int endOffset;
            PsiElement element = file.findElementAt(caretOffset);
            Statement statement = PhpPsiUtil.getParentOfClass(element, Statement.class);
            FunctionReference functionCall = (FunctionReference)PhpPsiUtil.getParentByCondition(element, FunctionReference.INSTANCEOF, Statement.INSTANCEOF);
            Function anonymousFunction = (Function)PhpPsiUtil.getParentByCondition(element, Function.INSTANCEOF, Statement.INSTANCEOF);
            if (!PhpPsiUtil.isOfType((PsiElement)statement, PhpElementTypes.STATEMENT) || functionCall == null || anonymousFunction != null) {
                return;
            }
            if (PsiTreeUtil.getDeepestLast((PsiElement)statement) instanceof PsiErrorElement && ((endOffset = statement.getTextRange().getEndOffset()) == afterLastParenOffset || endOffset == it.getStart())) {
                editor.getCaretModel().moveToOffset(endOffset);
            }
        }
    }

    private static boolean isAtLineEnd(@NotNull HighlighterIterator it) {
        if (it == null) {
            PhpTypedHandler.$$$reportNull$$$0(7);
        }
        if (it.getTokenType() == PhpTokenTypes.WHITE_SPACE) {
            CharSequence tokenText = it.getDocument().getImmutableCharSequence().subSequence(it.getStart(), it.getEnd());
            return CharArrayUtil.containLineBreaks((CharSequence)tokenText);
        }
        return false;
    }

    private static boolean redundantCharAfterOpenTag(@NotNull Editor editor, char c, @Nullable PsiFile file) {
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(8);
        }
        if (c == 'p' || c == 'h') {
            return PhpTypedHandler.findFullPhpTagAtOffset(file, editor.getCaretModel().getOffset()) != null;
        }
        return false;
    }

    @Nullable
    public static PsiElement findFullPhpTagAtOffset(@Nullable PsiFile file, int offset) {
        if (offset > 0 && file != null) {
            PsiElement openTagAt = file.findElementAt(offset - 1);
            return PhpPsiUtil.isOfType(openTagAt, PhpTokenTypes.PHP_OPENING_TAG) && openTagAt.getTextLength() == 5 ? openTagAt : null;
        }
        return null;
    }

    public boolean isImmediatePaintingEnabled(@NotNull Editor editor, char c, @NotNull DataContext context) {
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PhpTypedHandler.$$$reportNull$$$0(10);
        }
        return !PhpTypedHandler.redundantCharAfterOpenTag(editor, c, (PsiFile)context.getData(CommonDataKeys.PSI_FILE));
    }

    protected boolean isGroupStatement(@Nullable PsiElement parent) {
        return parent instanceof GroupStatement;
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            PhpTypedHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(12);
        }
        if (psiFile == null) {
            PhpTypedHandler.$$$reportNull$$$0(13);
        }
        if (!(psiFile instanceof PhpFile || c == '\\' && psiFile.getFileElementType() == PhpRegexpParserDefinition.PHP_REGEXP_FILE_TYPE)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(14);
            }
            return result;
        }
        if (c == '$' || c == '\\') {
            PhpCompletionUtil.showCompletion(editor);
        } else if (c == '>') {
            int offset = editor.getCaretModel().getOffset();
            CharSequence text = editor.getDocument().getCharsSequence();
            if (offset >= 1 && text.charAt(offset - 1) == '-' || offset >= 2 && text.charAt(offset - 2) == '-') {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == ':') {
            int offset = editor.getCaretModel().getOffset();
            if (offset >= 1 && editor.getDocument().getCharsSequence().charAt(offset - 1) == ':') {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == ' ') {
            int offset = editor.getCaretModel().getOffset();
            if (offset > 3 && "new".equals(editor.getDocument().getCharsSequence().subSequence(offset - 3, offset).toString()) && !Character.isJavaIdentifierStart(editor.getDocument().getCharsSequence().charAt(offset - 4))) {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == '(') {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        if (PhpTypedHandler.scheduleCompletionForVersionCompareOperatorStart(c, project, editor, psiFile)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(16);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            PhpTypedHandler.$$$reportNull$$$0(17);
        }
        return result;
    }

    private static boolean scheduleCompletionForVersionCompareOperatorStart(char c, Project project, Editor editor, PsiFile file) {
        char openQuote;
        int offset;
        if (!(c != '!' && c != '<' && c != '>' && c != '=' || (offset = editor.getCaretModel().getOffset()) <= 1 || (openQuote = editor.getDocument().getCharsSequence().charAt(offset - 1)) != '\"' && openQuote != '\'')) {
            PsiElement stringLiteral;
            PsiElement leaf = file.findElementAt(offset - 1);
            PsiElement psiElement = stringLiteral = leaf != null ? leaf.getParent() : null;
            if (stringLiteral instanceof StringLiteralExpression) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, f -> PhpTypedHandler.isOperatorArgumentOfVersionCompareCall(offset, f));
                return true;
            }
        }
        return false;
    }

    private static boolean isOperatorArgumentOfVersionCompareCall(int offset, PsiFile f) {
        PsiElement functionCall;
        PsiElement stringLiteral;
        PsiElement leaf = f.findElementAt(offset - 1);
        PsiElement psiElement = stringLiteral = leaf != null ? leaf.getParent() : null;
        return stringLiteral instanceof StringLiteralExpression && stringLiteral.getParent() instanceof ParameterList && (functionCall = stringLiteral.getParent().getParent()) instanceof FunctionReference && PhpLangUtil.equalsFunctionNames(((FunctionReference)functionCall).getName(), "version_compare") && ((FunctionReference)functionCall).getParameter(2) == stringLiteral;
    }

    private static boolean insideXmlTag(@NotNull PsiFile file, int offset) {
        PsiElement elementAt;
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(18);
        }
        return (elementAt = file.getViewProvider().findElementAt(offset, (Language)HTMLLanguage.INSTANCE)) != null && PhpPsiUtil.getParentOfClass(elementAt, XmlTag.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpTypedHandler";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showMemberLookUp";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOpenTagStringInsideXmlTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSingleHtmlTag";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryMoveCaretAfterFunctionCallRParen";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineEnd";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "redundantCharAfterOpenTag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isImmediatePaintingEnabled";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insideXmlTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

