/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitMockBuilderTP;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitMockMethodReferenceContributor
extends PsiReferenceContributor {
    public static final String MOCK_OBJECT = "\\PHPUnit\\Framework\\MockObject\\MockObject";
    private static final PhpType STUB_OBJECT = PhpType.from("\\PHPUnit\\Framework\\MockObject\\Stub", "\\PHPUnit\\Framework\\MockObject\\MockObject");
    public static final PhpType MOCK_OBJECT_BUILDER = PhpType.from("\\PHPUnit\\Framework\\MockObject\\MockBuilder");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            PhpUnitMockMethodReferenceContributor.$$$reportNull$$$0(0);
        }
        PhpUnitMockMethodReferenceProvider provider = new PhpUnitMockMethodReferenceProvider();
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(MethodReference.class)), (PsiReferenceProvider)provider);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.ARRAY_VALUE).withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement(MethodReference.class))), (PsiReferenceProvider)provider);
    }

    @Nullable
    public static PhpUnitMockedMethodReference getTargetMockType(@NotNull MethodReference methodReference, @Nullable PsiElement element) {
        PhpType localClassReferenceType;
        PhpExpression classReference;
        if (methodReference == null) {
            PhpUnitMockMethodReferenceContributor.$$$reportNull$$$0(1);
        }
        Project project = methodReference.getProject();
        if (PhpLangUtil.equalsMethodNames(methodReference.getName(), "method")) {
            PhpType type;
            PhpExpression classReference2 = methodReference.getClassReference();
            if (classReference2 != null && PhpUnitMockMethodReferenceContributor.isConvertibleToMockObject(type = PhpUnitMockMethodReferenceContributor.getClassReferenceMockType(classReference2), PhpIndex.getInstance(project))) {
                return new PhpUnitMockedMethodReference(type, classReference2, (PsiElement)ObjectUtils.notNull((Object)element, (Object)methodReference));
            }
        } else if ((PhpLangUtil.equalsMethodNames(methodReference.getName(), "setMethods") || PhpLangUtil.equalsMethodNames(methodReference.getName(), "onlyMethods") || PhpLangUtil.equalsMethodNames(methodReference.getName(), "addMethods")) && (classReference = methodReference.getClassReference()) != null && PhpUnitMockMethodReferenceContributor.isMockBuilder(project, localClassReferenceType = PhpType.from(new PsiElement[]{classReference}))) {
            PhpType type = localClassReferenceType.map(s -> PhpUnitMockBuilderTP.isBuilderType(s) ? s.substring(s.lastIndexOf(46) + 1) : null);
            return new PhpUnitMockedMethodInBuilderReference(type, classReference, (PsiElement)ObjectUtils.notNull((Object)element, (Object)methodReference));
        }
        return null;
    }

    public static boolean isMockBuilder(Project project, PhpType localClassReferenceType) {
        PhpType global = localClassReferenceType.global(project).filterUnknown().filter(PhpType.MIXED);
        return !global.isEmpty() && MOCK_OBJECT_BUILDER.isConvertibleFrom(project, global);
    }

    private static PhpType getClassReferenceMockType(@NotNull PhpExpression classReference) {
        if (classReference == null) {
            PhpUnitMockMethodReferenceContributor.$$$reportNull$$$0(2);
        }
        return PhpType.from(new PsiElement[]{classReference}).map(PhpUnitMockMethodReferenceContributor::unwrapExpectsCall).global(classReference.getProject()).filterUnknown().filter(PhpType.MIXED);
    }

    @NotNull
    private static String unwrapExpectsCall(String s) {
        String string = PhpTypeSignatureKey.METHOD.isSigned(s) && s.endsWith(".expects") ? s.substring(2, s.lastIndexOf(46)) : s;
        if (string == null) {
            PhpUnitMockMethodReferenceContributor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isConvertibleToMockObject(PhpType type, PhpIndex index) {
        return !type.isEmpty() && STUB_OBJECT.isConvertibleFrom(type, index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapExpectsCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTargetMockType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassReferenceMockType";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class PhpUnitMockMethodReferenceProvider
    extends PhpMockMethodReferenceProvider<PhpUnitMockedMethodReference> {
        @Override
        @Nullable
        protected PhpUnitMockedMethodReference getTargetMockReference(@NotNull MethodReference reference, @NotNull StringLiteralExpression methodName) {
            if (reference == null) {
                PhpUnitMockMethodReferenceProvider.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                PhpUnitMockMethodReferenceProvider.$$$reportNull$$$0(1);
            }
            return PhpUnitMockMethodReferenceContributor.getTargetMockType(reference, (PsiElement)methodName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor$PhpUnitMockMethodReferenceProvider";
            objectArray[2] = "getTargetMockReference";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpUnitMockedMethodReference
    extends PhpMockedMethodReference {
        private PhpUnitMockedMethodReference(PhpType classReferenceType, PhpExpression classReference, @NotNull PsiElement methodNameRef) {
            if (methodNameRef == null) {
                PhpUnitMockedMethodReference.$$$reportNull$$$0(0);
            }
            super(methodNameRef, classReferenceType, classReference);
        }

        @Override
        @NotNull
        protected PhpType getMockedType(PhpType type) {
            PhpIndex index = PhpIndex.getInstance(this.myElement.getProject());
            PhpType phpType = type.getTypesIntersections().stream().flatMap(Collection::stream).distinct().filter(fqn -> !PhpUnitMockMethodReferenceContributor.isConvertibleToMockObject(PhpType.from(fqn), index)).map(xva$0 -> PhpType.from(xva$0)).reduce(new PhpType(), PhpType::add);
            if (phpType == null) {
                PhpUnitMockedMethodReference.$$$reportNull$$$0(1);
            }
            return phpType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor$PhpUnitMockedMethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor$PhpUnitMockedMethodReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMockedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpUnitMockedMethodInBuilderReference
    extends PhpUnitMockedMethodReference {
        private PhpUnitMockedMethodInBuilderReference(PhpType classReferenceType, PhpExpression classReference, @NotNull PsiElement methodNameRef) {
            if (methodNameRef == null) {
                PhpUnitMockedMethodInBuilderReference.$$$reportNull$$$0(0);
            }
            super(classReferenceType, classReference, methodNameRef);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNameRef", "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor$PhpUnitMockedMethodInBuilderReference", "<init>"));
        }
    }

    public static abstract class PhpMockedMethodReference
    extends PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase {
        protected final PhpType myClassReferenceType;
        private final PhpExpression myClassReference;

        public PhpMockedMethodReference(@NotNull PsiElement memberRef, PhpType classReferenceType, PhpExpression classReference) {
            if (memberRef == null) {
                PhpMockedMethodReference.$$$reportNull$$$0(0);
            }
            super(memberRef, true);
            this.myClassReferenceType = classReferenceType;
            this.myClassReference = classReference;
        }

        @Override
        @NotNull
        public Collection<PhpClass> resolveClassReference() {
            PhpIndex index = PhpIndex.getInstance(this.myElement.getProject());
            Collection collection = this.getMockedType(this.myClassReferenceType).types().flatMap(fqn -> index.getAnyByFQN((String)fqn).stream()).collect(Collectors.toSet());
            if (collection == null) {
                PhpMockedMethodReference.$$$reportNull$$$0(1);
            }
            return collection;
        }

        protected abstract PhpType getMockedType(PhpType var1);

        public PhpExpression getClassReference() {
            return this.myClassReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor$PhpMockedMethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor$PhpMockedMethodReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveClassReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class PhpMockMethodReferenceProvider<T extends PhpMockedMethodReference>
    extends PsiReferenceProvider {
        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            T ref;
            if (element == null) {
                PhpMockMethodReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpMockMethodReferenceProvider.$$$reportNull$$$0(1);
            }
            if (element instanceof StringLiteralExpression && (ref = this.getMockReference((StringLiteralExpression)element)) != null) {
                PsiReference[] psiReferenceArray = new PsiReference[]{ref};
                if (psiReferenceArray == null) {
                    PhpMockMethodReferenceProvider.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                PhpMockMethodReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        @Nullable
        public T getMockReference(StringLiteralExpression string) {
            MethodReference methodReference = PhpPsiUtil.getParentOfClass((PsiElement)string, MethodReference.class);
            return methodReference != null ? (T)this.getTargetMockReference(methodReference, string) : null;
        }

        @Nullable
        protected abstract T getTargetMockReference(@NotNull MethodReference var1, @NotNull StringLiteralExpression var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor$PhpMockMethodReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpUnitMockMethodReferenceContributor$PhpMockMethodReferenceProvider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

