/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class PhpGotoSuperMethodHandler
implements LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement at;
        PhpNamedElement phpNamedElement;
        if (project == null) {
            PhpGotoSuperMethodHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpGotoSuperMethodHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpGotoSuperMethodHandler.$$$reportNull$$$0(2);
        }
        if ((phpNamedElement = PhpPsiUtil.getParentOfClass(at = file.findElementAt(editor.getCaretModel().getOffset()), PhpNamedElement.class)) == null) {
            return;
        }
        ArrayList<PhpClass> results = new ArrayList<PhpClass>(1);
        if (DumbService.getInstance((Project)project).isDumb()) {
            String message = PhpBundle.message("navigation.goto.super.method.is.not.available", new Object[0]);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (editor.getComponent().getRootPane() == null) {
                    Messages.showMessageDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    HintManager.getInstance().showErrorHint(editor, message);
                }
            });
            return;
        }
        if (phpNamedElement instanceof Method) {
            PhpClassHierarchyUtils.processSuperMethods((Method)phpNamedElement, (method, subClass, baseClass) -> {
                results.add((PhpClass)((Object)method));
                return true;
            });
        } else if (phpNamedElement instanceof PhpClass) {
            results.addAll(PhpClassHierarchyUtils.getImmediateParents((PhpClass)phpNamedElement));
        }
        if (results.size() == 1) {
            ((PhpNamedElement)results.get(0)).navigate(true);
        } else if (results.size() > 0) {
            NavigationUtil.getPsiElementPopup((PsiElement[])PsiUtilCore.toPsiElementArray(results), (String)(results.get(0) instanceof Method ? PhpBundle.message("choose.super.method", new Object[0]) : PhpBundle.message("choose.super.class.or.interface", new Object[0]))).showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/lang/actions/PhpGotoSuperMethodHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

