/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.google.common.base.Predicates;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandService;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Range;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpKeywordsCompletionContributor;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAdjustMemberAccessFix;
import com.jetbrains.php.lang.annotator.PhpChangeFieldTypeToMatchDefaultValueFix;
import com.jetbrains.php.lang.annotator.PhpChangeParameterTypeToMatchDefaultValueFix;
import com.jetbrains.php.lang.annotator.PhpChangeReturnTypeAnnotatorFix;
import com.jetbrains.php.lang.annotator.PhpChangeTypeQuickFix;
import com.jetbrains.php.lang.annotator.PhpChangeTypeToMatchDefaultValueFix;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.annotator.PhpDumbAwareAnnotatorVisitor;
import com.jetbrains.php.lang.annotator.PhpGroupIntersectionTypesQuickFix;
import com.jetbrains.php.lang.annotator.PhpMakeClassNonFinalQuickFix;
import com.jetbrains.php.lang.annotator.PhpMakeReturnTypeNullableFix;
import com.jetbrains.php.lang.annotator.PhpReplaceFirstClassCallableInNewExpressionQuickFix;
import com.jetbrains.php.lang.annotator.PhpReplaceFirstClassCallableWithArrowFunQuickFix;
import com.jetbrains.php.lang.annotator.PhpReplaceNullSafeInFirstClassCallableQuickFix;
import com.jetbrains.php.lang.annotator.PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction;
import com.jetbrains.php.lang.annotator.PhpReplaceWithBitAndQuickFix;
import com.jetbrains.php.lang.annotator.PhpReplaceWithDnfTypeDeclarationQuickFix;
import com.jetbrains.php.lang.annotator.PhpReplaceWithElementQuickFix;
import com.jetbrains.php.lang.annotator.PhpReplaceWithUnionTypeQuickFix;
import com.jetbrains.php.lang.annotator.PhpUnwrapClassReferenceGroupQuickFix;
import com.jetbrains.php.lang.annotator.PhpUnwrapClassReferenceQuickFix;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.inspections.PhpAccessingStaticMembersOnTraitInspection;
import com.jetbrains.php.lang.inspections.PhpClassCanBeReadonlyInspection;
import com.jetbrains.php.lang.inspections.PhpElementIsNotAvailableInCurrentPhpVersionInspection;
import com.jetbrains.php.lang.inspections.PhpInconsistentReturnPointsInspection;
import com.jetbrains.php.lang.inspections.PhpMockeryInvalidMockingMethodInspection;
import com.jetbrains.php.lang.inspections.PhpUnusedFieldDefaultValueInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUncoveredEnumCasesInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpExchangeExtendsImplementsQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpSwitchLanguageLevelQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpIncompatibleReturnTypeInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.inspections.type.PhpUpdateTypeDeclarationQuickFix;
import com.jetbrains.php.lang.intentions.PhpClassCanBeConvertedToEnumIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.PhpTypeCodeFragment;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclarationOwner;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import com.jetbrains.php.lang.psi.elements.impl.MultiassignmentExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpBackedEnumTypeImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpBaseMemberReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassConstantsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpDefineImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldsDefaultValueMatcherIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpParametersDefaultValueMatchersIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.mockery.PhpMockeryTypeInferenceUtil;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.extractMethod.PhpParametersFolder;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldHandler;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantProcessor;
import com.jetbrains.php.util.PhpFlexibleHeredocHelper;
import com.jetbrains.php.util.PhpStringUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PhpAnnotatorVisitor
extends PhpElementVisitor {
    private static final TokenSet ASSIGNABLE_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpElementTypes.ASSIGNABLE, TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.ARRAY_CREATION_EXPRESSION})});
    @NotNull
    private static final PhpType ITERATOR_TRAVERSABLE_TYPE = new PhpType().add("\\Traversable").add("\\Iterator");
    @NotNull
    private static final TokenSet CONSTANTS = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.CONSTANT_REF, PhpElementTypes.NEW_EXPRESSION});
    @NotNull
    private static final TokenSet ALLOWED_ENUM_CASES_EXPRESSIONS = TokenSet.andNot((TokenSet)PhpCodeValidationUtil.CONSTANT_SCALAR_EXPRESSIONS, (TokenSet)CONSTANTS);
    private static final java.util.function.Function<PhpExpression, PhpType> NAIVE_THIS_TYPE_PROVIDER = c -> (PhpType)CachedValuesManager.getCachedValue((PsiElement)c, () -> {
        PhpType t = PhpTypeInfo.getTypeFromAST((PsiElement)c, new PhpTypeAnalyserVisitor(){

            @Override
            public Collection<? extends PhpTypeProvider4> getTypeProviders(@NotNull PsiElement psi) {
                if (psi == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$1", "getTypeProviders"));
            }
        }).global(c.getProject());
        return CachedValueProvider.Result.create((Object)t, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    });
    private static final java.util.function.Function<PhpExpression, PhpType> NAIVE_PEST_TYPE_PROVIDER = c -> (PhpType)CachedValuesManager.getCachedValue((PsiElement)c, () -> {
        PhpType t = PhpTypeInfo.getTypeFromAST((PsiElement)c, new PhpTypeAnalyserVisitor(){

            @Override
            @NotNull
            public PhpType getTypeFromAST(@NotNull PsiElement psi) {
                if (psi == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new PhpType();
            }

            @Override
            public Collection<? extends PhpTypeProvider4> getTypeProviders(@NotNull PsiElement psi) {
                if (psi == null) {
                    2.$$$reportNull$$$0(1);
                }
                return super.getTypeProviders(psi).stream().filter(typeProvider -> typeProvider.getKey() == '\u0226').collect(Collectors.toSet());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "psi";
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTypeFromAST";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTypeProviders";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).global(c.getProject());
        return CachedValueProvider.Result.create((Object)t, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    });
    @NotNull
    private static final Condition<PsiElement> NOT_ALLOWED_STATEMENT = Conditions.or(ControlStatement.INSTANCEOF, Try.class::isInstance);
    private final AnnotationHolder holder;
    private static final boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private static final PhpType GENERATOR_TYPE = new PhpType().add("\\Generator");
    private static final PhpType PROBABLY_GENERATOR_TYPE = new PhpType().add("\\Iterator").add("\\Traversable").add("\\iterable");
    private static final TokenSet UNSUPPORTED_OPERATORS_FOR_ARRAYS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opMINUS, PhpTokenTypes.opMUL, PhpTokenTypes.opDIV});

    public PhpAnnotatorVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    public static boolean isAssignable(PsiElement element) {
        if (element instanceof FieldReference && PhpPsiUtil.classConstantReferenceViaVariable((FieldReference)element)) {
            return false;
        }
        return PhpPsiUtil.isOfType(element, ASSIGNABLE_TOKENS);
    }

    @Override
    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        boolean multiAssignmentVariable;
        super.visitPhpArrayCreationExpression(expression);
        MultiassignmentExpression parent = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)expression, false, MultiassignmentExpression.INSTANCEOF, Statement.INSTANCEOF);
        boolean bl = multiAssignmentVariable = parent != null && PsiTreeUtil.isAncestor((PsiElement)parent.getFirstPsiChild(), (PsiElement)expression, (boolean)false);
        if (PhpLanguageFeature.SPREAD_OPERATOR_IN_ARRAY.isSupported(expression.getProject())) {
            for (PhpPsiElement child : ArrayCreationExpressionImpl.children(expression)) {
                this.checkPossibleUnpackedArgument(child, multiAssignmentVariable);
            }
            PhpAnnotatorVisitor.reportIncompleteSpreadOperators((PsiElement)expression, this.holder);
        }
    }

    private void checkPossibleUnpackedArgument(PhpPsiElement child, boolean multiAssignmentVariable) {
        if (child instanceof ArrayHashElement) {
            PhpPsiElement value;
            PhpPsiElement key = ((ArrayHashElement)child).getKey();
            if (key != null && ArrayCreationExpressionImpl.isUnpackedArrayArgument(key.getParent())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, key.getParent(), PhpBundle.message("it.s.not.possible.to.unpack.array.key", new Object[0]), new CommonIntentionAction[0]);
            }
            if ((value = ((ArrayHashElement)child).getValue()) != null && ArrayCreationExpressionImpl.isUnpackedArrayArgument(value.getParent())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, value.getParent(), PhpBundle.message("it.s.not.possible.to.unpack.array.value.with.associated.key", new Object[0]), new CommonIntentionAction[0]);
            }
        } else if (ArrayCreationExpressionImpl.isUnpackedArrayArgument((PsiElement)child)) {
            if (multiAssignmentVariable) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)child, PhpBundle.message("spread.operators.in.arrays.are.not.supported.for.multiassignments.variables", new Object[0]), new CommonIntentionAction[0]);
            } else if (PhpPsiUtil.isOfType(child.getFirstChild().getNextSibling(), PhpTokenTypes.opBIT_AND)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)child, PhpBundle.message("it.s.not.possible.to.unpack.array.argument.by.reference", new Object[0]), new CommonIntentionAction[0]);
            }
        }
    }

    @Override
    public void visitPhpUnaryExpression(UnaryExpression expr) {
        PhpType phpType;
        IElementType elementType;
        super.visitPhpUnaryExpression(expr);
        ASTNode node = expr.getNode();
        PhpPsiElement value = expr.getValue();
        if (node != null && (elementType = node.getElementType()) == PhpElementTypes.CLONE_EXPRESSION && value instanceof PhpTypedElement && !(phpType = ((PhpTypedElement)value).getGlobalType()).isAmbiguous()) {
            if (!PhpAnnotatorVisitor.methodCloneCanBeCalled(expr, phpType)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)value, PhpBundle.message("call.to.method.clone.from.invalid.context", new Object[0]), new CommonIntentionAction[0]);
            } else if (PhpAnnotatorVisitor.isEnum(value.getProject(), phpType)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expr, PhpBundle.message("enums.may.not.be.cloned", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithElementQuickFix((PsiElement)expr, (PsiElement)value)});
            }
        }
    }

    public static boolean isEnum(@NotNull Project project, PhpType type) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        return PhpAnnotatorVisitor.allResolvedTypesSatisfyCondition(project, type, (Condition<? super PhpClass>)((Condition)PhpClass::isEnum));
    }

    public static boolean isReadonlyClass(@NotNull Project project, PhpType type, @NotNull PsiElement position) {
        PhpClass target;
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if (position == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if (PhpAnnotatorVisitor.allResolvedTypesSatisfyCondition(project, type, (Condition<? super PhpClass>)((Condition)PhpClass::isReadonly))) {
            return true;
        }
        String fqn = (String)ContainerUtil.getOnlyItem(type.getTypes());
        return PhpType.isAnonymousClass(fqn) && (target = PhpCompletionContributor.findAnonymousClass(position, fqn)) != null && target.isReadonly();
    }

    private static boolean allResolvedTypesSatisfyCondition(@NotNull Project project, PhpType type, Condition<? super PhpClass> condition) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        PhpIndex index = PhpIndex.getInstance(project);
        for (String t : type.getTypes()) {
            Collection<PhpClass> classes = index.getAnyByFQN(t);
            if (!classes.isEmpty() && ContainerUtil.and(classes, condition)) continue;
            return false;
        }
        return !type.isAmbiguous();
    }

    private static boolean methodCloneCanBeCalled(UnaryExpression expr, PhpType phpType) {
        for (String type : phpType.getTypes()) {
            if (PhpType.isNull(type) || PhpType.isMixedType(type) || PhpType.isCallableType(type)) {
                return true;
            }
            if ((PhpType.isPrimitiveType(type) || PhpType.isPluralType(type)) && !PhpType.isObject(StringUtil.toLowerCase((String)type))) continue;
            Collection<PhpClass> classes = PhpIndex.getInstance(expr.getProject()).getClassesByFQN(type);
            if (classes.isEmpty()) {
                return true;
            }
            for (PhpClass clazz : classes) {
                PhpModifier.Access access;
                Method clone = clazz.findMethodByName("__clone");
                PhpModifier.Access access2 = access = clone == null ? null : clone.getAccess();
                if (clone == null || access == PhpModifier.Access.PUBLIC) {
                    return true;
                }
                PhpClass callerClass = PhpPsiUtil.getParentOfClass((PsiElement)expr, false, PhpClass.class);
                String caller = callerClass == null ? null : callerClass.getFQN();
                if (caller == null || !PhpLangUtil.equalsClassNames(caller, type) && (access != PhpModifier.Access.PROTECTED || !PhpType.findSuper(type, caller, PhpIndex.getInstance(expr.getProject())))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitPhpBinaryExpression(BinaryExpression expression) {
        super.visitPhpBinaryExpression(expression);
        this.checkOperatorsArraySupport(expression);
        this.checkBitShiftByNegativeNumber(expression);
    }

    private void checkBitShiftByNegativeNumber(@NotNull BinaryExpression expression) {
        if (expression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if (!PhpLanguageLevel.current((Project)expression.getProject()).isAtLeast(PhpLanguageLevel.PHP700)) {
            return;
        }
        if (!PhpTokenTypes.tsSHIFT_OPS.contains(expression.getOperationType())) {
            return;
        }
        PhpTypedElement rightOperand = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getRightOperand(), PhpTypedElement.class);
        if (rightOperand == null) {
            return;
        }
        if (PhpAnnotatorVisitor.isAlwaysNegativeNumber(PhpType.global(new PsiElement[]{rightOperand}))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("bit.shift.by.negative.number", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    public static boolean isAlwaysNegativeNumber(PhpType type) {
        Range<Integer> bounds = PhpType.getIntRangeBounds((String)ContainerUtil.getOnlyItem(type.getTypesWithParametrisedParts()));
        return bounds != null && (Integer)bounds.getFrom() < 0 && (Integer)bounds.getTo() < 0;
    }

    private void checkOperatorsArraySupport(@NotNull BinaryExpression expression) {
        if (expression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        Project project = expression.getProject();
        PsiElement operation = expression.getOperation();
        boolean level800plus = PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP800);
        if (!level800plus && PhpPsiUtil.isOfType(operation, UNSUPPORTED_OPERATORS_FOR_ARRAYS) && StreamEx.of((Object[])new PsiElement[]{expression.getLeftOperand(), expression.getRightOperand()}).map(PhpAnnotatorVisitor::getType).anyMatch(PhpType::isArray)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("arrays.are.not.supported.as.operands.for.0", operation.getText()), new CommonIntentionAction[0]);
        }
    }

    @Nullable
    private static PhpType getType(@Nullable PsiElement operand) {
        return operand instanceof PhpTypedElement ? ((PhpTypedElement)operand).getGlobalType() : null;
    }

    @Override
    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        this.visitPhpAssignmentExpression(expression);
    }

    static void checkSameArrayStyle(AnnotationHolder holder, PhpPsiElement expression) {
        for (PhpPsiElement child : MultiassignmentExpressionImpl.getChildren((PsiElement)expression)) {
            PsiElement firstChild = child.getFirstChild();
            if (PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.kwLIST)) {
                if (expression instanceof ArrayCreationExpression) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)child, PhpBundle.message("cannot.mix.and.list", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithArrayQuickFix((PsiElement)child)});
                    continue;
                }
                if (!(firstChild instanceof ArrayCreationExpression)) continue;
                PhpAnnotatorVisitor.checkSameArrayStyle(holder, (PhpPsiElement)firstChild);
                continue;
            }
            if (!(firstChild instanceof ArrayCreationExpression)) continue;
            if (!(expression instanceof ArrayCreationExpression)) {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, firstChild, PhpBundle.message("cannot.mix.and.list", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithListQuickFix(firstChild)});
                continue;
            }
            PhpAnnotatorVisitor.checkSameArrayStyle(holder, (PhpPsiElement)firstChild);
        }
    }

    @NotNull
    public static Collection<PhpPsiElement> getKeyedEntries(List<? extends PhpPsiElement> variables) {
        List list = ContainerUtil.filter(variables, v -> v.getParent().getParent() instanceof ArrayHashElement);
        if (list == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public void visitPhpVariable(Variable variable) {
        super.visitPhpVariable(variable);
        if (PhpLangUtil.equalsVariableNames("this", variable.getName())) {
            Function f = PhpPsiUtil.getParentOfClass((PsiElement)variable, Function.class);
            boolean level710plus = PhpProjectConfigurationFacade.getInstance(variable.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP710);
            if (f instanceof Method && ((Method)f).isStatic() || !(f instanceof Method) && f != null && !f.isClosure() && level710plus) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, variable.getNameNode(), PhpBundle.message("using.this.when.not.in.object.context", new Object[0]));
            }
        } else if (PhpLangUtil.equalsVariableNames("GLOBALS", variable.getName()) && PhpLanguageLevel.current((Project)variable.getProject()).isAtLeast(PhpLanguageLevel.PHP810) && !PhpPsiUtil.isOfType(variable.getParent(), PhpElementTypes.tsARRAY_EXPRESSIONS) && (PhpAnnotatorVisitor.isReadByRef(variable) || variable.isWriteAccess(true))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, variable.getNameNode(), PhpBundle.message("globals.can.only.be.modified.using.the.globals.name.value.syntax", new Object[0]));
        }
    }

    private static boolean isReadByRef(Variable variable) {
        PsiElement prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)variable, true);
        return PhpPsiUtil.isOfType(prevSibling, PhpTokenTypes.opBIT_AND) || PhpPsiUtil.isOfType(prevSibling, PhpTokenTypes.opASGN) && prevSibling.textContains('&');
    }

    @Override
    public void visitPhpCallableMethod(PhpCallableMethod reference) {
        super.visitPhpCallableMethod(reference);
        this.reportNullSafeOperatorsInFirstClassCallableSyntax(reference);
        PsiElement resolvedElement = reference.resolve();
        this.highlightMethodReference(reference, resolvedElement);
        this.reportAbstractMethodCalls(reference, reference.getClassReference(), resolvedElement);
        this.checkAccessModifiers(reference);
    }

    private void reportNullSafeOperatorsInFirstClassCallableSyntax(@NotNull PhpCallableMethod reference) {
        PsiElement nullSafeOperator;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        if ((nullSafeOperator = PhpAnnotatorVisitor.getNullSafeOperator((PhpBaseMemberReference)((Object)reference))) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nullSafeOperator, PhpBundle.message("cannot.combine.nullsafe.operator.with.closure.creation", new Object[0]), new CommonIntentionAction[]{new PhpReplaceNullSafeInFirstClassCallableQuickFix(nullSafeOperator), new PhpReplaceFirstClassCallableWithArrowFunQuickFix(reference)});
        }
    }

    @Nullable
    static PsiElement getNullSafeOperator(@NotNull PhpBaseMemberReference memberReference) {
        if (memberReference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(8);
        }
        PhpBaseMemberReference nextReference = memberReference;
        while (nextReference != null) {
            PhpExpression classReference = nextReference.getClassReference();
            PsiElement sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)classReference, true);
            if (PhpPsiUtil.isOfType(sibling, PhpTokenTypes.opQUEST)) {
                return sibling;
            }
            nextReference = (PhpBaseMemberReference)ObjectUtils.tryCast((Object)classReference, PhpBaseMemberReference.class);
        }
        return null;
    }

    @Override
    public void visitPhpFunctionCall(FunctionReference reference) {
        PhpType type;
        Set<String> types;
        PhpPsiElement name;
        super.visitPhpFunctionCall(reference);
        if (!(!StringUtil.isEmpty((String)reference.getName()) || !((name = reference.getFirstPsiChild()) instanceof Variable) || (types = (type = ((Variable)name).getGlobalType()).filterUnknown().getTypes()).isEmpty() || types.contains("\\mixed") || types.contains("\\string") || types.contains("\\callable") || types.contains("\\array") || ContainerUtil.exists(types, PhpType::isPluralType) || reference.multiResolve(false).length != 0)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)name, PhpBundle.message("function.name.must.be.callable.a.string.closure.or.class.implementing.invoke.currently.0", type.toStringResolved()), new CommonIntentionAction[0]);
        }
        this.checkCallParamList(reference);
    }

    @Override
    public void visitPhpParameterList(ParameterList list) {
        super.visitPhpParameterList(list);
        ParameterListOwner owner = (ParameterListOwner)ObjectUtils.tryCast((Object)list.getParent(), ParameterListOwner.class);
        if (owner == null) {
            return;
        }
        if (!PhpLanguageFeature.NAMED_ARGUMENTS.isSupported(list.getProject())) {
            return;
        }
        this.checkNamedArguments(list, owner);
    }

    static void reportIncompleteSpreadOperators(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(10);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement next;
            if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.opVARIADIC) || (next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true)) instanceof PhpExpression || next instanceof PsiErrorElement) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(holder, child, PhpBundle.message("expected.expression.after.spread.operator", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private void checkNamedArguments(ParameterList list, ParameterListOwner owner) {
        List<PsiElement> parameters = Arrays.asList(list.getParameters());
        int firstNamedIdentifier = ContainerUtil.indexOf(parameters, p -> ParameterListImpl.getNameIdentifier(p) != null);
        if (firstNamedIdentifier >= 0) {
            this.checkPositionalArgumentsAfterNamed(parameters, firstNamedIdentifier);
            Collection<Function> resolvedFunctions = PhpAnnotatorVisitor.resolveFunctions(owner);
            this.checkDuplicateNamesNamedArguments(parameters, resolvedFunctions);
            Collection functionParameters = resolvedFunctions.stream().flatMap(f -> Arrays.stream(f.getParameters())).collect(Collectors.toSet());
            Collection overriddenMethodParameters = resolvedFunctions.stream().flatMap(f -> f instanceof Method && !(f instanceof PhpDocMethod) ? PhpAnnotatorVisitor.overridingMethods((Method)f) : Stream.of(f)).flatMap(f -> Arrays.stream(f.getParameters())).filter(p -> !functionParameters.contains(p)).collect(Collectors.toSet());
            if (!(resolvedFunctions.isEmpty() || ContainerUtil.exists((Iterable)functionParameters, Parameter::isVariadic) || ContainerUtil.exists((Iterable)overriddenMethodParameters, Parameter::isVariadic))) {
                this.checkUnresolvedNamedArguments(parameters, functionParameters, overriddenMethodParameters);
            }
        }
    }

    private static Stream<Method> overridingMethods(Method method) {
        final ArrayList methods = new ArrayList();
        PhpClassHierarchyUtils.processOverridingMethods(method, (PhpClassHierarchyUtils.TypedHierarchyMemberProcessor<? super Method>)new PhpClassHierarchyUtils.TypedHierarchyMemberProcessor<Method>(){

            @Override
            public boolean process(Method member, PhpClass subClass, PhpClass baseClass) {
                if (!subClass.isTrait()) {
                    methods.add(member);
                }
                return true;
            }
        });
        return methods.stream();
    }

    public static Collection<Function> resolveFunctions(@Nullable ParameterListOwner owner) {
        PhpReference referenceToResolve = PhpAnnotatorVisitor.getReferenceToResolve(owner);
        if (referenceToResolve == null) {
            return Collections.emptyList();
        }
        return (Collection)StreamEx.of((Object[])referenceToResolve.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).collect(Collectors.toSet());
    }

    @Nullable
    public static PhpReference getReferenceToResolve(@Nullable ParameterListOwner owner) {
        if (owner instanceof PhpAttribute) {
            return ((PhpAttribute)owner).getClassReference();
        }
        if (owner instanceof NewExpression) {
            return ((NewExpression)owner).getClassReference();
        }
        return (PhpReference)ObjectUtils.tryCast((Object)owner, PhpReference.class);
    }

    private void checkUnresolvedNamedArguments(Collection<? extends PsiElement> arguments, Collection<? extends Parameter> resolvedFunctionParameters, Collection<? extends Parameter> overrridenMethodparameters) {
        Collection<String> parametersNames = PhpAnnotatorVisitor.getParametersNames(resolvedFunctionParameters);
        Collection<String> overriddenParametersNames = PhpAnnotatorVisitor.getParametersNames(overrridenMethodparameters);
        for (PsiElement psiElement : arguments) {
            String name;
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(psiElement);
            if (nameIdentifier == null || parametersNames.contains(name = nameIdentifier.getText()) || overriddenParametersNames.contains(name)) continue;
            this.createErrorOnNamedArgument(nameIdentifier, PhpBundle.message("unknown.named.parameter", name));
        }
    }

    @NotNull
    private static Collection<String> getParametersNames(Collection<? extends Parameter> resolvedFunctionParameters) {
        Collection collection = resolvedFunctionParameters.stream().map(Parameter::getName).collect(Collectors.toCollection(() -> CollectionFactory.createCaseInsensitiveStringSet()));
        if (collection == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(11);
        }
        return collection;
    }

    private void checkDuplicateNamesNamedArguments(List<PsiElement> arguments, Collection<Function> resolvedFunctions) {
        HashSet<String> alreadyMappedParameterNames = new HashSet<String>();
        for (int i = 0; i < arguments.size(); ++i) {
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(arguments.get(i));
            String nameOfMappedParam = PhpAnnotatorVisitor.getNameOfMappedParam(resolvedFunctions, arguments, nameIdentifier, i);
            if (nameOfMappedParam == null || alreadyMappedParameterNames.add(nameOfMappedParam) || nameIdentifier == null) continue;
            String message = PhpBundle.message("named.parameter.overwrites.previous.argument", new Object[0]);
            this.createErrorOnNamedArgument(nameIdentifier, message);
        }
    }

    @Nullable
    private static String getNameOfMappedParam(Collection<? extends Function> resolvedFunctions, List<PsiElement> arguments, PsiElement nameIdentifier, int i) {
        Set mappedParameters = resolvedFunctions.stream().map(f -> PhpParamsInspection.getMappedParam(arguments, Arrays.asList(f.getParameters()), i)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (resolvedFunctions.isEmpty() || ContainerUtil.exists(mappedParameters, Parameter::isVariadic)) {
            return nameIdentifier != null ? nameIdentifier.getText() : null;
        }
        return (String)ContainerUtil.getOnlyItem((Collection)ContainerUtil.map2Set(mappedParameters, Parameter::getName));
    }

    @Nullable
    public static String getNameOfMappedParam(List<? extends PsiElement> arguments, List<? extends Parameter> functionParameters, int i) {
        return PhpAnnotatorVisitor.getNameOfMappedParam(functionParameters, ParameterListImpl.getNameIdentifier(arguments.get(i)), i);
    }

    @Nullable
    private static String getNameOfMappedParam(List<? extends Parameter> functionParameters, PsiElement nameIdentifier, int i) {
        return nameIdentifier != null ? nameIdentifier.getText() : (i < functionParameters.size() ? functionParameters.get(i).getName() : null);
    }

    private void createErrorOnNamedArgument(PsiElement nameIdentifier, @Nls String message) {
        TextRange range = PhpAnnotatorVisitor.getRangeWithColon(nameIdentifier);
        this.holder.newAnnotation(HighlightSeverity.ERROR, message).range(range).enforcedTextAttributes(PhpAnnotatorVisitor.getInvalidNamedArgumentTextAttributes()).create();
    }

    @NotNull
    public static TextRange getRangeWithColon(PsiElement nameIdentifier) {
        PsiElement colon = PhpPsiUtil.getNextSiblingIgnoreWhitespace(nameIdentifier, true);
        if (colon == null) {
            TextRange textRange = nameIdentifier.getTextRange();
            if (textRange == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(12);
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)nameIdentifier.getTextRange().getStartOffset(), (int)colon.getTextRange().getEndOffset());
        if (textRange == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(13);
        }
        return textRange;
    }

    private static TextAttributes getInvalidNamedArgumentTextAttributes() {
        EditorColorsScheme theme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        TextAttributes namedArgument = theme.getAttributes(PhpHighlightingData.NAMED_ARGUMENT);
        TextAttributes error = theme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES);
        return TextAttributes.merge((TextAttributes)namedArgument, (TextAttributes)error);
    }

    private void checkPositionalArgumentsAfterNamed(List<? extends PsiElement> parameters, int firstNamedIdentifier) {
        for (int i = firstNamedIdentifier + 1; i < parameters.size(); ++i) {
            if (ParameterListImpl.getNameIdentifier(parameters.get(i)) != null) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameters.get(i), PhpBundle.message("cannot.use.positional.argument.after.named.argument", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private void checkCallParamList(FunctionReference reference) {
        List<PsiElement> callParams = Arrays.asList(reference.getParameters());
        int lastUnpacked = Integer.MAX_VALUE;
        for (int i = 0; i < callParams.size(); ++i) {
            PsiElement callArgument = callParams.get(i);
            if (PhpPsiUtil.isArgumentUnpacking(callArgument)) {
                lastUnpacked = i;
            }
            if (lastUnpacked >= i) continue;
            @Nls String message = PhpBundle.message("cannot.use.positional.argument.after.argument.unpacking", new Object[0]);
            if (ParameterListImpl.getNameIdentifier(callArgument) != null) {
                if (PhpLanguageLevel.current((Project)callArgument.getProject()).isAtLeast(PhpLanguageLevel.PHP810)) continue;
                message = PhpBundle.message("cannot.use.positional.argument.after.argument.unpacking.named.argument.81", new Object[0]);
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, callArgument, message, new CommonIntentionAction[0]);
        }
        Collection<Function> resolveFunctions = PhpAnnotatorVisitor.resolveFunctions(reference);
        PsiFile containingFile = reference.getContainingFile();
        if (containingFile instanceof PhpFile && !resolveFunctions.isEmpty() && ContainerUtil.all(resolveFunctions, f -> PhpAnnotatorVisitor.hasOptionalArgumentWithIncompatibleDefaultType((PhpFile)containingFile, f, callParams))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("function.has.parameter.with.incompatible.default.value.type", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private static boolean hasOptionalArgumentWithIncompatibleDefaultType(PhpFile containingFile, Function f, List<PsiElement> arguments) {
        List<Parameter> declParams = Arrays.asList(f.getParameters());
        Set resolvedParams = IntStream.range(0, arguments.size()).mapToObj(i -> PhpParamsInspection.getMappedParam(arguments, declParams, i)).filter(Objects::nonNull).collect(Collectors.toSet());
        Project project = f.getProject();
        return declParams.stream().filter(p -> !((ParameterImpl)p).isComputableCompileTimeDefaultValue()).filter(p -> !resolvedParams.contains(p)).anyMatch(p -> !PhpAnnotatorVisitor.isDefaultParameterValueCompatibleInCallSiteContainingFile(containingFile, project, p));
    }

    private static boolean isDefaultParameterValueCompatibleInCallSiteContainingFile(PhpFile containingFile, Project project, Parameter p) {
        return PhpAnnotatorVisitor.isDefaultValueCompatibleWithParameterType(project, p.getDeclaredType().global(project), ((ParameterImpl)p).getDefaultValueType().global(project), PhpCodeInsightUtil.isStrictTypes(containingFile), false);
    }

    @Override
    public void visitPhpClassConstantReference(ClassConstantReference reference) {
        super.visitPhpClassConstantReference(reference);
        this.checkAccessModifiers(reference);
        this.checkStaticClassConstantFetchArgument(reference);
        ProblemDescriptor descriptor = PhpAccessingStaticMembersOnTraitInspection.createProblemDescriptor(reference, (containingClass, name) -> containingClass.findFieldByName((CharSequence)name, true), true);
        if (descriptor != null) {
            ModCommandAction[] fixes = descriptor.getFixes() == null ? ModCommandAction.EMPTY_ARRAY : (ModCommandAction[])ContainerUtil.map2Array((Object[])descriptor.getFixes(), ModCommandAction.class, qf -> ModCommandService.getInstance().unwrap((LocalQuickFix)qf));
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, descriptor.getStartElement(), descriptor.getDescriptionTemplate(), (CommonIntentionAction[])fixes);
        }
    }

    private void checkStaticClassConstantFetchArgument(ClassConstantReference reference) {
        Object lookUpExpression;
        PsiElement lastChild = reference.getLastChild();
        if (PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.chRBRACE) && (lookUpExpression = PhpPsiUtil.getChildByCondition((PsiElement)reference, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpExpression && !(e instanceof ClassReference)))) != null && !PhpAnnotatorVisitor.mayBeStringType(lookUpExpression)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, lookUpExpression, PhpBundle.message("class.constant.reference.fetch.with.non.string.type", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private static boolean mayBeStringType(@Nullable PsiElement element) {
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.STRING)) {
            return true;
        }
        if (element instanceof PhpTypedElement) {
            PhpTypedElement typedElement = (PhpTypedElement)element;
            PhpType globalType = typedElement.getGlobalType();
            return globalType.isAmbiguous() || PhpType.intersects(globalType, PhpType.STRING);
        }
        return false;
    }

    @Override
    public void visitPhpFieldReference(FieldReference reference) {
        PhpExpression classReference;
        Collection<Field> resolvedFields;
        List unambiguousFields;
        super.visitPhpFieldReference(reference);
        this.checkAccessModifiers(reference);
        this.checkClassNameLiteral(reference);
        PsiElement target = reference.resolve();
        ASTNode nameNode = reference.getNameNode();
        if (nameNode != null) {
            if (target instanceof PhpDocPsiElement) {
                this.highlightInfo(reference.getNameNode(), PhpHighlightingData.MAGIC_MEMBER_ACCESS);
            } else {
                PsiElement parent = nameNode.getPsi().getParent();
                if (!(parent instanceof Variable && VariableImpl.isVariableVariable((Variable)parent) || FieldReferenceImpl.isClassNameLiteral(reference) || reference.getReferenceType().isStatic())) {
                    this.highlightInfo(nameNode, PhpAnnotatorVisitor.getInstanceFieldHighlightingData((Field)ObjectUtils.tryCast((Object)target, Field.class)));
                }
            }
        }
        Field resolvedTarget = (unambiguousFields = (List)((Optional)StreamEx.of(resolvedFields = reference.multiResolveStrict(Field.class)).groupRuns((f, s) -> f.getContainingClass() == s.getContainingClass()).collect(MoreCollectors.onlyOne())).orElse(null)) != null ? (Field)ContainerUtil.find((Iterable)unambiguousFields, f -> f instanceof PhpDocProperty) : null;
        this.checkDocPropertyAccess(reference, resolvedTarget);
        if (VariableImpl.isLocalWriteAccess((PsiElement)reference) && (classReference = reference.getClassReference()) != null) {
            PhpType globalType = classReference.getGlobalType();
            if (PhpAnnotatorVisitor.isEnum(classReference.getProject(), globalType)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("enum.properties.are.immutable", new Object[0]), new CommonIntentionAction[0]);
            }
            if (ContainerUtil.all(resolvedFields, f -> f instanceof PhpClassImpl.MyRenamableFakePsiElement) && PhpAnnotatorVisitor.isReadonlyClass(classReference.getProject(), globalType, (PsiElement)reference)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("cannot.declare.dynamic.properties.in.readonly.class", new Object[0]));
            }
        }
    }

    private void checkDocPropertyAccess(FieldReference reference, PsiElement target) {
        if (target instanceof PhpDocProperty && target.getParent() instanceof PhpDocTag) {
            PsiElement parent = reference.getParent();
            CharSequence nameCS = ((PhpDocTag)target.getParent()).getNameCS();
            if (nameCS.equals("@property-read")) {
                if (parent instanceof ArrayAccessExpression && parent.getParent() instanceof AssignmentExpression && ((AssignmentExpression)parent.getParent()).getVariable() == reference.getParent() || parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getVariable() == reference || parent instanceof UnaryExpression && PhpTokenTypes.tsUNARY_POSTFIX_OPS.contains(PsiUtilCore.getElementType((PsiElement)((UnaryExpression)parent).getOperation()))) {
                    if (PhpAnnotatorVisitor.isFieldAccessLocal(reference)) {
                        return;
                    }
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("property.read", new Object[0]), new CommonIntentionAction[0]);
                }
            } else if (nameCS.equals("@property-write") && (!(parent instanceof AssignmentExpression) || ((AssignmentExpression)parent).getVariable() != reference || parent instanceof SelfAssignmentExpression)) {
                if (PhpAnnotatorVisitor.isFieldAccessLocal(reference)) {
                    return;
                }
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("property.write", new Object[0]), new CommonIntentionAction[0]);
            }
        }
    }

    private void checkClassNameLiteral(@NotNull FieldReference reference) {
        PhpType type;
        PhpExpression classReference;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(14);
        }
        if (FieldReferenceImpl.isClassNameLiteral(reference) && (classReference = reference.getClassReference()) != null && !(type = classReference.getGlobalType()).isEmpty() && !PhpType.MIXED.equals(type) && !PhpType.isSubType(PhpType.OBJECT, type) && !PhpType.intersects(PhpType.CALLABLE, type) && type.filterPrimitives().isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("cannot.use.class.on.primitive.type", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private static boolean isFieldAccessLocal(FieldReference reference) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return false;
        }
        if (classReference instanceof Variable && "this".contentEquals(((Variable)classReference).getNameCS())) {
            return true;
        }
        PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)reference, true, PhpClass.class);
        if (containingClass == null) {
            return false;
        }
        PhpType type = classReference.getType();
        String containingClassFQN = containingClass.getFQN();
        return !type.isAmbiguous() && ContainerUtil.all(type.getTypes(), t -> PhpAnnotatorVisitor.isReferencedToCurrentClass(t, containingClassFQN));
    }

    private static boolean isReferencedToCurrentClass(String type, @NotNull @NlsSafe String classFQN) {
        if (classFQN == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(15);
        }
        return PhpLangUtil.equalsClassNames(type, classFQN) || PhpLangUtil.equalsClassNames(type, PhpTypeSignatureKey.SELF_CLASS.sign(classFQN));
    }

    @Override
    public void visitPhpMethodReference(MethodReference reference) {
        super.visitPhpMethodReference(reference);
        PsiElement resolvedElement = reference.resolve();
        this.highlightMethodReference(reference, resolvedElement);
        PhpExpression classReference = reference.getClassReference();
        if (PhpLangUtil.equalsFunctionNames("__clone", reference.getNameCS()) && classReference != null && !(reference.getParent() instanceof PhpTraitUseRule) && !PhpLangUtil.equalsClassNames("parent", classReference.getName())) {
            ASTNode nameNode = reference.getNameNode();
            if (nameNode == null) {
                return;
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("an.object.s.clone.method.cannot.be.called.directly", new Object[0]));
            return;
        }
        this.reportAbstractMethodCalls(reference, classReference, resolvedElement);
        this.checkAccessModifiers(reference);
        this.checkCallParamList(reference);
    }

    private void reportAbstractMethodCalls(PhpReference reference, PhpExpression classReference, PsiElement resolvedElement) {
        if (!(classReference instanceof ClassReference) || reference.getParent() instanceof PhpTraitUseRule) {
            return;
        }
        Method containingMethod = (Method)PhpPsiUtil.getParentByCondition((PsiElement)reference, Method.INSTANCEOF, PhpNamespace.INSTANCEOF);
        List results = ContainerUtil.map((Object[])reference.multiResolve(false), ResolveResult::getElement);
        if (!results.isEmpty() && ContainerUtil.and((Iterable)results, r -> PhpAnnotatorVisitor.isAvailableForCallAbstractMethodInsideHierarchy((ClassReference)classReference, r, containingMethod))) {
            PhpClass resolvedMethodContainingClass;
            PhpClass phpClass = resolvedMethodContainingClass = resolvedElement instanceof Method ? ((Method)resolvedElement).getContainingClass() : null;
            if (resolvedMethodContainingClass != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("cannot.call.abstract.method.0.1", resolvedMethodContainingClass.getName(), ((Method)resolvedElement).getName()), new CommonIntentionAction[0]);
            }
        }
    }

    private void highlightMethodReference(@NotNull PhpReference reference, @Nullable PsiElement resolvedElement) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(16);
        }
        if (resolvedElement instanceof PhpDocPsiElement) {
            this.highlightInfo(reference.getNameNode(), PhpHighlightingData.MAGIC_MEMBER_ACCESS);
        } else {
            PhpBaseMemberReference baseMemberReference = (PhpBaseMemberReference)ObjectUtils.tryCast((Object)reference, PhpBaseMemberReference.class);
            boolean isStatic = baseMemberReference != null && baseMemberReference.isStatic();
            this.highlightInfo(reference.getNameNode(), isStatic ? PhpHighlightingData.STATIC_METHOD_CALL : PhpAnnotatorVisitor.getInstanceMethodHighlightingData((Method)ObjectUtils.tryCast((Object)resolvedElement, Method.class)));
        }
    }

    private static boolean isAvailableForCallAbstractMethodInsideHierarchy(ClassReference classReference, PsiElement r, Method containingMethod) {
        if (r instanceof Method && ((Method)r).isAbstract()) {
            PhpClass containingClass = ((Method)r).getContainingClass();
            if (containingClass != null) {
                PhpClass referenceContainingClass;
                if (containingClass.isTrait()) {
                    return false;
                }
                if (PhpLangUtil.isClassNameSpecial(classReference.getName()) && containingMethod != null && !containingMethod.isStatic() && PhpClassHierarchyUtils.isSuperClass(containingClass, referenceContainingClass = containingMethod.getContainingClass(), false, false) && referenceContainingClass.isAbstract()) {
                    return false;
                }
            }
            return PhpAnnotatorVisitor.isInsideClassHierarchyWithoutMixins(classReference, (Method)r);
        }
        return false;
    }

    private static boolean isInsideClassHierarchyWithoutMixins(ClassReference classReference, Method method) {
        Ref res = new Ref((Object)false);
        for (PhpClass phpClass : classReference.multiResolveStrict(PhpClass.class)) {
            if (((Boolean)res.get()).booleanValue()) break;
            PhpClassHierarchyUtils.processMethods(phpClass, phpClass, (member, subClass, baseClass) -> {
                if (member == method) {
                    res.set((Object)true);
                    return false;
                }
                return true;
            }, false, false);
        }
        return (Boolean)res.get();
    }

    private static TextAttributesKey getInstanceMethodHighlightingData(@Nullable Method method) {
        PhpModifier.Access access = method != null ? method.getAccess() : PhpModifier.Access.PUBLIC;
        return switch (access) {
            default -> throw new IncompatibleClassChangeError();
            case PhpModifier.Access.PROTECTED -> PhpHighlightingData.PROTECTED_INSTANCE_METHOD_CALL;
            case PhpModifier.Access.PRIVATE -> PhpHighlightingData.PRIVATE_INSTANCE_METHOD_CALL;
            case PhpModifier.Access.PUBLIC -> PhpHighlightingData.INSTANCE_METHOD_CALL;
        };
    }

    private void checkAccessModifiers(PhpReference reference) {
        if (reference instanceof PhpBaseMemberReference) {
            this.checkAccessModifiers((PhpBaseMemberReference)reference);
        }
    }

    @NotNull
    private static PhpResolvedElementAccessDescriptor resolveAccess(@NotNull PhpBaseMemberReference reference, PhpClassMember resolvedMember) {
        PhpModifier.Access access;
        Collection<PhpClass> current;
        PhpExpression classReference;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(17);
        }
        if ((classReference = reference.getClassReference()) == null) {
            PhpResolvedElementAccessDescriptor phpResolvedElementAccessDescriptor = PhpResolvedElementAccessDescriptor.PUBLIC;
            if (phpResolvedElementAccessDescriptor == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(18);
            }
            return phpResolvedElementAccessDescriptor;
        }
        PhpClass declaringClass = resolvedMember.getContainingClass();
        PhpModifier.Access accessibleInContextAccess = PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess(reference, declaringClass, current = PhpAnnotatorVisitor.resolveCurrentScope(reference, access = resolvedMember.getModifier().getAccess()));
        if (accessibleInContextAccess.isWeakerThan(access)) {
            boolean hasMagic;
            String magicName = reference instanceof MethodReference || reference instanceof PhpCallableMethod ? (reference.isStatic() ? "__callStatic" : "__call") : (reference instanceof FieldReference ? (((FieldReference)((Object)reference)).isWriteAccess() ? "__set" : "__get") : null);
            boolean bl = hasMagic = declaringClass != null && PhpCodeInsightUtil.hasMagicMethod(declaringClass.getType(), PhpIndex.getInstance(resolvedMember.getProject()), magicName);
            if (!hasMagic && !current.isEmpty()) {
                hasMagic = ContainerUtil.exists(current, c -> PhpAnnotatorVisitor.hasMagic(reference, (PsiElement)resolvedMember, classReference, c, magicName));
            }
            if (PhpLangUtil.isThisReference((PsiElement)classReference) && !PhpAnnotatorVisitor.foundInNativeInferredType(reference, (PsiElement)resolvedMember)) {
                PhpResolvedElementAccessDescriptor phpResolvedElementAccessDescriptor = PhpResolvedElementAccessDescriptor.PUBLIC;
                if (phpResolvedElementAccessDescriptor == null) {
                    PhpAnnotatorVisitor.$$$reportNull$$$0(19);
                }
                return phpResolvedElementAccessDescriptor;
            }
            if (!MemberReferenceImpl.mayHaveDynamicClassFQN(reference) && PhpAnnotatorVisitor.foundInPestInferredType(reference, (PsiElement)resolvedMember)) {
                PhpResolvedElementAccessDescriptor phpResolvedElementAccessDescriptor = PhpResolvedElementAccessDescriptor.PUBLIC;
                if (phpResolvedElementAccessDescriptor == null) {
                    PhpAnnotatorVisitor.$$$reportNull$$$0(20);
                }
                return phpResolvedElementAccessDescriptor;
            }
            return new PhpResolvedElementAccessDescriptor(access, accessibleInContextAccess, hasMagic ? magicName : null);
        }
        PhpResolvedElementAccessDescriptor phpResolvedElementAccessDescriptor = PhpResolvedElementAccessDescriptor.PUBLIC;
        if (phpResolvedElementAccessDescriptor == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(21);
        }
        return phpResolvedElementAccessDescriptor;
    }

    private void checkAccessModifiers(@NotNull PhpBaseMemberReference reference) {
        ASTNode nameNode;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(22);
        }
        if ((nameNode = reference.getNameNode()) == null || nameNode.getTextLength() == 0) {
            return;
        }
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return;
        }
        Collection resolvedMembers = reference.multiResolveStrict(PhpClassMember.class);
        PhpResolvedElementAccessDescriptor resolvedAccess = resolvedMembers.stream().map(e -> PhpAnnotatorVisitor.resolveAccess(reference, e)).max(Comparator.comparingInt(e -> e.myResolvedElementAccess.getLevel())).orElse(null);
        if (resolvedAccess != null && !resolvedAccess.myResolvedElementAccess.isPublic()) {
            if (resolvedAccess.myResolvedClassMagicMethodName != null) {
                this.holder.newAnnotation(HighlightSeverity.WEAK_WARNING, PhpBundle.message("member.has.0.access.but.class.has.magic.method.1", new Object[]{resolvedAccess.myResolvedElementAccess, resolvedAccess.myResolvedClassMagicMethodName})).range(nameNode).create();
            } else if (!PhpAnnotatorVisitor.isMockeryReferenceWithAllowProtectedCall(reference, resolvedMembers, resolvedAccess)) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, PhpBundle.message("member.has.0.access", new Object[]{resolvedAccess.myResolvedElementAccess})).range(nameNode).withFix((IntentionAction)new PhpAdjustMemberAccessFix(reference, resolvedAccess.myAccessibleInContextAccess)).create();
            }
        }
    }

    private static boolean isMockeryReferenceWithAllowProtectedCall(@NotNull PhpBaseMemberReference reference, Collection<? extends PhpClassMember> resolvedMembers, PhpResolvedElementAccessDescriptor resolvedAccess) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(23);
        }
        return reference instanceof MethodReference && resolvedAccess.myResolvedElementAccess.isProtected() && ContainerUtil.exists(resolvedMembers, m -> !PhpMockeryTypeInferenceUtil.isMockeryNamespace(m.getFQN())) && PhpMockeryInvalidMockingMethodInspection.isInitialisedLocallyWithAllowingProtectedCall(reference, (Ref<Boolean>)new Ref((Object)false), false);
    }

    private static boolean foundInNativeInferredType(PhpBaseMemberReference reference, PsiElement resolvedElement) {
        return reference.resolveGlobal(NAIVE_THIS_TYPE_PROVIDER).contains(resolvedElement);
    }

    private static boolean foundInPestInferredType(PhpBaseMemberReference reference, PsiElement resolvedElement) {
        return reference.resolveGlobal(NAIVE_PEST_TYPE_PROVIDER).contains(resolvedElement);
    }

    private static boolean hasMagic(PhpBaseMemberReference reference, PsiElement resolvedElement, PhpExpression classReference, PhpClass current, String magicName) {
        String classReferenceName = classReference.getName();
        if (PhpLangUtil.isThisReference(classReferenceName) || PhpLangUtil.equalsClassNames(classReferenceName, current.getNameCS())) {
            Method currentMethod = PhpPsiUtil.getParentOfClass((PsiElement)reference, Method.class);
            return (currentMethod == null || !PhpLangUtil.equalsMethodNames(magicName, currentMethod.getNameCS())) && PhpCodeInsightUtil.hasMagicMethod(current.getType(), PhpIndex.getInstance(resolvedElement.getProject()), magicName);
        }
        return false;
    }

    @NotNull
    public static Collection<PhpClass> resolveCurrentScope(PhpReference reference, PhpModifier.Access access) {
        PhpClass current;
        Function parentFunction = PhpPsiUtil.getParentOfClass((PsiElement)reference, Function.class);
        if (parentFunction != null && parentFunction.isClosure()) {
            PhpIndex index = PhpIndex.getInstance(reference.getProject());
            Set classes = PhpAnnotatorVisitor.getClosureBoundType(parentFunction, true).global(reference.getProject()).filterPrimitives().getTypes().stream().flatMap(s -> index.getAnyByFQN((String)s).stream()).collect(Collectors.toSet());
            List closureBoundClasses = (List)PhpReferenceImpl.extendedResolve2(reference, classes);
            if (!closureBoundClasses.isEmpty()) {
                List list = closureBoundClasses;
                if (list == null) {
                    PhpAnnotatorVisitor.$$$reportNull$$$0(24);
                }
                return list;
            }
        }
        if ((current = PhpClassImpl.getContainingClass((PsiElement)reference)) == null && access != PhpModifier.Access.PUBLIC) {
            current = PhpAnnotatorVisitor.resolveThis((PsiElement)reference);
        }
        Collection<Object> collection = current != null ? Collections.singleton(current) : Collections.emptyList();
        if (collection == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @NotNull
    public static PhpType getClosureBoundType(Function function, boolean searchForScope) {
        PsiElement expression = function.getParent();
        if (PhpPsiUtil.isOfType(expression, PhpElementTypes.CLOSURE)) {
            PsiElement parent = PhpParametersFolder.getParentSkipParentheses(expression);
            PhpType inlineClosureReboundScope = PhpAnnotatorVisitor.getClosureReboundScope(expression, expression, searchForScope);
            if (!inlineClosureReboundScope.isEmpty()) {
                PhpType phpType = inlineClosureReboundScope;
                if (phpType == null) {
                    PhpAnnotatorVisitor.$$$reportNull$$$0(26);
                }
                return phpType;
            }
            if (parent instanceof AssignmentExpression) {
                PhpPsiElement variable = ((AssignmentExpression)parent).getVariable();
                if (((AssignmentExpression)parent).getValue() == expression && variable instanceof Variable) {
                    return PhpAnnotatorVisitor.getClosureBoundClassesFromVariableUsage((Variable)variable, searchForScope);
                }
            }
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(27);
        }
        return phpType;
    }

    @NotNull
    private static PhpType getClosureBoundClassesFromVariableUsage(final Variable variable, final boolean searchForScope) {
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(28);
            }
            return phpType;
        }
        final CharSequence variableName = instruction.getVariableName();
        final PhpType res = new PhpType();
        PhpControlFlowUtil.processSuccessors(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (!PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    return true;
                }
                if (instruction.getAccess().isWrite()) {
                    return false;
                }
                res.add(PhpAnnotatorVisitor.getClosureReboundScope((PsiElement)instruction.getAnchor(), (PsiElement)variable, searchForScope));
                return super.processAccessVariableInstruction(instruction);
            }
        });
        PhpType phpType = res;
        if (phpType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(29);
        }
        return phpType;
    }

    private static PhpType getClosureReboundScope(PsiElement anchor, PsiElement variable, boolean searchForScope) {
        PsiElement parent = PhpParametersFolder.getParentSkipParentheses(anchor);
        if (parent instanceof ParameterList) {
            return PhpAnnotatorVisitor.getReboundScopeType(PhpPsiUtil.getParentOfClass(parent, MethodReference.class), variable, searchForScope);
        }
        if (parent instanceof MethodReference && PhpPsiUtil.unparenthesize((PsiElement)((MethodReference)parent).getClassReference()) == anchor) {
            return PhpAnnotatorVisitor.getReboundScopeType((MethodReference)parent, variable, searchForScope);
        }
        return PhpType.EMPTY;
    }

    @Nullable
    private static PsiElement getReboundArgument(MethodReference methodReference, @Nullable PsiElement originalClassReference, boolean searchForScope) {
        if (PhpLangUtil.equalsMethodNames("bind", methodReference.getName()) || PhpLangUtil.equalsMethodNames("bindTo", methodReference.getName())) {
            PhpExpression classReference = methodReference.getClassReference();
            if (classReference instanceof ClassReference && methodReference.isStatic() && PhpLangUtil.equalsClassNames("\\Closure", ((ClassReference)classReference).getFQN())) {
                return methodReference.getParameter(searchForScope ? 2 : 1);
            }
            if (originalClassReference != null && PhpPsiUtil.areElementsEquivalent(PhpPsiUtil.unparenthesize(originalClassReference), PhpPsiUtil.unparenthesize((PsiElement)classReference))) {
                return methodReference.getParameter(searchForScope ? 1 : 0);
            }
        }
        return null;
    }

    @NotNull
    private static PhpType getReboundScopeType(@Nullable MethodReference methodReference, @Nullable PsiElement originalClassReference, boolean searchForScope) {
        PsiElement parameter;
        PsiElement psiElement = parameter = methodReference != null ? PhpAnnotatorVisitor.getReboundArgument(methodReference, originalClassReference, searchForScope) : null;
        if (parameter == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(30);
            }
            return phpType;
        }
        String inferredStaticClassName = PhpTypeConditionDFAnalyzer.inferClassName(parameter);
        if (inferredStaticClassName != null) {
            PhpType phpType = new PhpType().add(inferredStaticClassName);
            if (phpType == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(31);
            }
            return phpType;
        }
        if (parameter instanceof PhpTypedElement) {
            PhpType phpType = ((PhpTypedElement)parameter).getType();
            if (phpType == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(32);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(33);
        }
        return phpType;
    }

    @NotNull
    public static PhpModifier.Access getStrictestAccessibleInContextReferenceAccess(@NotNull PhpReference reference, @Nullable PhpClass declaringClass, @NotNull Collection<? extends PhpClass> currentClasses) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(34);
        }
        if (currentClasses == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(35);
        }
        PhpModifier.Access access = currentClasses.stream().map(c -> PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess(declaringClass, c, reference.getName())).min(Comparator.comparingInt(PhpModifier.Access::getLevel)).orElse(PhpModifier.Access.PUBLIC);
        if (access == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(36);
        }
        return access;
    }

    @NotNull
    private static PhpModifier.Access getStrictestAccessibleInContextReferenceAccess(@Nullable PhpClass declaringClass, @Nullable PhpClass current, @Nullable String methodName) {
        if (current == null) {
            PhpModifier.Access access = PhpModifier.Access.PUBLIC;
            if (access == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(37);
            }
            return access;
        }
        if (declaringClass == null || PhpClassHierarchyUtils.classesEqual(current, declaringClass)) {
            PhpModifier.Access access = PhpModifier.Access.PRIVATE;
            if (access == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(38);
            }
            return access;
        }
        if (!current.isTrait() && !declaringClass.isTrait()) {
            PhpModifier.Access access = PhpAnnotatorVisitor.protectedAccessAccessibleInContext(declaringClass, current, methodName) ? PhpModifier.Access.PROTECTED : PhpModifier.Access.PUBLIC;
            if (access == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(39);
            }
            return access;
        }
        if (!current.isTrait() && !PhpClassHierarchyUtils.isMyTrait(current, declaringClass, null) || !declaringClass.isTrait() && !PhpClassHierarchyUtils.isMyTrait(declaringClass, current, null)) {
            PhpModifier.Access access = PhpModifier.Access.PROTECTED;
            if (access == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(40);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PRIVATE;
        if (access == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(41);
        }
        return access;
    }

    private static boolean protectedAccessAccessibleInContext(@NotNull PhpClass declaringClass, @NotNull PhpClass current, @Nullable String methodName) {
        boolean commonSuper;
        if (declaringClass == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(42);
        }
        if (current == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(43);
        }
        if (commonSuper = PhpAnnotatorVisitor.hasCommonSuper(declaringClass, current, methodName)) {
            return true;
        }
        if (current.isTrait() && !declaringClass.isTrait()) {
            Collection<PhpClass> usages = PhpIndex.getInstance(declaringClass.getProject()).getTraitUsages(current);
            return ContainerUtil.exists(usages, usage -> PhpClassHierarchyUtils.isSuperClass(declaringClass, usage, true));
        }
        return false;
    }

    private static boolean hasCommonSuper(@NotNull PhpClass declaringClass, @NotNull PhpClass current, @Nullable String methodName) {
        if (declaringClass == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(44);
        }
        if (current == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(45);
        }
        boolean[] commonSuper = new boolean[]{false};
        HashSet superClasses = new HashSet();
        PhpClassHierarchyUtils.processSuperClasses(current, true, true, (Processor<? super PhpClass>)((Processor)aClass -> {
            if (PhpLangUtil.equalsClassNames("\\___PHPSTORM_HELPERS\\object", aClass.getFQN())) {
                return true;
            }
            if (PhpClassHierarchyUtils.classesEqual(declaringClass, aClass)) {
                commonSuper[0] = true;
            }
            superClasses.add(aClass);
            return !commonSuper[0];
        }));
        if (commonSuper[0]) {
            return true;
        }
        PhpClassHierarchyUtils.processSuperClasses(declaringClass, true, true, (Processor<? super PhpClass>)((Processor)aClass -> {
            if (PhpLangUtil.equalsClassNames("\\___PHPSTORM_HELPERS\\object", aClass.getFQN())) {
                return true;
            }
            if (PhpClassHierarchyUtils.classesEqual(current, aClass) || superClasses.contains(aClass) && aClass.findOwnMethodByName(methodName) != null) {
                commonSuper[0] = true;
            }
            return !commonSuper[0];
        }));
        return commonSuper[0];
    }

    @Nullable
    public static PhpClass resolveThis(@NotNull PsiElement position) {
        PhpDocType typeRef;
        PhpNamedElement aThis;
        if (position == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(46);
        }
        if ((aThis = (PhpNamedElement)ContainerUtil.getFirstItem(VariableImpl.collectDeclarations(position, false, "this"))) instanceof PhpDocVariable && (typeRef = (PhpDocType)PhpPsiUtil.getChildByCondition(aThis.getParent(), PhpDocType.INSTANCEOF)) != null) {
            return (PhpClass)typeRef.resolve();
        }
        return null;
    }

    public static boolean canBeUsedAsLexicalVariable(@NotNull Variable variable) {
        String variableName;
        if (variable == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(47);
        }
        return !"this".equals(variableName = variable.getName()) && !PhpLangUtil.isSuperGlobal(variableName);
    }

    @Override
    public void visitPhpUse(PhpUse expression) {
        PsiElement resolvedElement;
        super.visitPhpUse(expression);
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)expression, PhpClass.INSTANCEOF, Function.INSTANCEOF);
        PhpReference reference = expression.getTargetReference();
        if (reference != null && containingClass != null && expression.isTraitImport() && (resolvedElement = reference.resolve()) instanceof PhpClass) {
            PhpClass resolvedClass = (PhpClass)resolvedElement;
            boolean isTrait = resolvedClass.isTrait();
            if (!isTrait) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNode(), PhpBundle.message("trait.expected.class.found", new Object[0]));
            }
            if (containingClass.isInterface()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNode(), PhpBundle.message("cannot.use.traits.inside.of.interfaces", new Object[0]));
            } else if (containingClass.isEnum()) {
                if (PhpAnnotatorVisitor.hasNonConstantProperty(resolvedClass)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNode(), PhpBundle.message("enums.may.not.include.properties", new Object[0]));
                } else {
                    Collection<String> forbiddenMethodNames = PhpAnnotatorVisitor.findForbiddenMethodNames(resolvedClass);
                    if (!forbiddenMethodNames.isEmpty()) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNode(), PhpBundle.message("enum.may.not.include.0", StringUtil.join(new HashSet<String>(forbiddenMethodNames), (String)", ")));
                    }
                }
            }
        }
    }

    private static boolean hasNonConstantProperty(PhpClass aClass) {
        Ref res = new Ref((Object)false);
        PhpClassHierarchyUtils.processFields(aClass, aClass, (member, subClass, baseClass) -> {
            if (!member.isConstant()) {
                res.set((Object)true);
                return false;
            }
            return true;
        }, false, false);
        return (Boolean)res.get();
    }

    @Override
    public void visitPhpClass(final PhpClass clazz) {
        Collection<PhpClass> superClasses;
        PhpClass superClass;
        PhpClassImpl phpClass;
        super.visitPhpClass(clazz);
        ASTNode nameNode = clazz.getNameNode();
        final boolean anInterface = clazz.isInterface();
        if (clazz.isEnum()) {
            this.checkBackedEnumConsistency(clazz);
            for (Method method : clazz.getOwnMethods()) {
                if (method instanceof PhpDocMethod || !PhpAnnotatorVisitor.isOverriddenFromEnumImplicitInterface(method)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, method.getNameNode(), PhpBundle.message("cannot.redeclare.methods.from.enum.implicit.interfaces", new Object[0]));
            }
            if (PhpType.findSuper("\\Serializable", clazz.getFQN(), PhpIndex.getInstance(clazz.getProject()))) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)clazz.getImplementsList(), PhpBundle.message("enums.may.not.implement.the.serializable.interface", new Object[0]), new CommonIntentionAction[0]);
            }
            if (!clazz.getBackedEnumType().isEmpty()) {
                this.checkBackedEnumUniqueValues(clazz.getEnumCases());
            }
        }
        if (!clazz.getBackedEnumType().isEmpty() && PhpClassCanBeConvertedToEnumIntention.canBeReplacedWithEnum(clazz) && clazz.getOwnFields().length == 0 && (phpClass = (PhpClassImpl)ObjectUtils.tryCast((Object)clazz, PhpClassImpl.class)) != null) {
            PhpBackedEnumTypeImpl typeDeclaration = phpClass.getTypeDeclaration();
            PsiElement identifier = clazz.getNameIdentifier();
            if (typeDeclaration != null && identifier != null) {
                PhpClassCanBeConvertedToEnumIntention intentionAction = new PhpClassCanBeConvertedToEnumIntention();
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)typeDeclaration, PhpBundle.message("classes.can.not.have.backed.type", new Object[0]), new CommonIntentionAction[]{intentionAction});
            }
        }
        if (clazz.isReadonly() && PhpLanguageFeature.PROPERTY_HOOKS.isSupported(clazz.getProject())) {
            boolean containsHookedProperties = ContainerUtil.exists((Object[])clazz.getOwnFields(), Field::hasPropertyHooksContainer);
            PsiElement readonlyKw = FieldImpl.getReadonlyKeyword((PsiElement)clazz);
            if (containsHookedProperties && readonlyKw != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, readonlyKw, PhpBundle.message("php.annotator.hooked.properties.cannot.be.readonly", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(readonlyKw)});
            }
        }
        if ((superClass = (PhpClass)ContainerUtil.getFirstItem(superClasses = clazz.getSuperClasses())) != null) {
            this.checkSuperClassModifiers(clazz, superClasses, (Condition<? super PhpClass>)((Condition)PhpClass::isFinal), PhpBundle.message("inspection.message.class.may.inherit.from.final.class", new Object[0]), (CommonIntentionAction)(!superClass.isEnum() ? new PhpMakeClassNonFinalQuickFix(superClass) : null));
            String name = superClass.getName();
            if (clazz.isReadonly()) {
                this.checkSuperClassModifiers(clazz, superClasses, (Condition<? super PhpClass>)Conditions.not(PhpClass::isReadonly), PhpBundle.message("inspection.message.readonly.class.cannot.extend.non.readonly.class", name), (CommonIntentionAction)new PhpDeleteElementQuickFix(FieldImpl.getReadonlyKeyword((PsiElement)clazz)));
            } else {
                boolean canMakeClassReadonly = (!clazz.isAnonymous() || PhpLanguageFeature.ANONYMOUS_READONLY_CLASSES.isSupported(clazz.getProject())) && clazz.getOwnFields(false).length == 0 && ContainerUtil.all(PhpClassHierarchyUtils.getDirectSubclasses(clazz), PhpClass::isReadonly);
                this.checkSuperClassModifiers(clazz, superClasses, (Condition<? super PhpClass>)((Condition)PhpClass::isReadonly), PhpBundle.message("inspection.message.non.readonly.class.cannot.extend.readonly.class", name), (CommonIntentionAction)(canMakeClassReadonly ? new PhpClassCanBeReadonlyInspection.PhpMakeClassReadonlyQuickFix(clazz) : null));
            }
        }
        ExtendsList extendsList = clazz.getExtendsList();
        List<ClassReference> referenceElements = extendsList.getReferenceElements();
        HashSet extendedClasses = new HashSet();
        for (ClassReference it : referenceElements) {
            String itFQN = it.getFQN();
            if (PhpLangUtil.isPhpReservedClassName(it.getName()) && it.getImmediateNamespaceName().isEmpty()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, PhpBundle.message("annotator.reserved.class.name", it.getName()), new CommonIntentionAction[0]);
            } else if (PhpLangUtil.equalsClassNames(clazz.getFQN(), itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("0.should.not.extend.itself", anInterface ? "Interface" : "Class"), new CommonIntentionAction[0]);
            }
            PsiElement element = it.resolve();
            if (element instanceof PhpClass && ((PhpClass)element).isTrait() && !clazz.isTrait()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("class.cannot.extend.from.trait", new Object[0]), new CommonIntentionAction[0]);
            }
            if (!anInterface) continue;
            if (extendedClasses.contains(itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, PhpBundle.message("interface.cannot.extend.previously.extended.interface", new Object[0]), new CommonIntentionAction[0]);
            }
            PhpAnnotatorVisitor.addAllSuperInterfaces(it, extendedClasses);
        }
        this.checkClassRefsOfAppropriateType(clazz, anInterface, referenceElements);
        if (clazz.isTrait() && !referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("a.trait.cannot.extend.a.class", new Object[0]), new CommonIntentionAction[0]);
        }
        if (extendsList.getFirstChild() != null) {
            if (clazz.isEnum()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("enum.may.not.include.extend", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix((PsiElement)extendsList)});
            }
            if (referenceElements.isEmpty()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("empty.extends.list", new Object[0]), new CommonIntentionAction[0]);
            }
        }
        ImplementsList implementsList = clazz.getImplementsList();
        referenceElements = implementsList.getReferenceElements();
        HashSet implementedInterfaces = new HashSet();
        for (ClassReference it : referenceElements) {
            String itFQN = it.getFQN();
            if (PhpLangUtil.equalsClassNames(clazz.getFQN(), itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, PhpBundle.message("class.should.not.implement.itself", new Object[0]), new CommonIntentionAction[0]);
            }
            if (PhpClassImpl.isImplicitEnumFQN(itFQN)) {
                @Nls String message = clazz.isEnum() ? PhpBundle.message("cannot.implement.interface.0.directly", PhpLangUtil.toShortName(itFQN)) : PhpBundle.message("cannot.implement.interface.0", PhpLangUtil.toShortName(itFQN));
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, message, new CommonIntentionAction[0]);
            }
            if (implementedInterfaces.contains(itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, PhpBundle.message("class.cannot.implement.previously.implemented.interface", new Object[0]), new CommonIntentionAction[0]);
            }
            PhpAnnotatorVisitor.addAllSuperInterfaces(it, implementedInterfaces);
        }
        this.checkEnumInterracesIndirectImplementation(clazz, nameNode);
        this.checkClassRefsOfAppropriateType(clazz, true, referenceElements);
        if (clazz.isTrait() && !referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, PhpBundle.message("a.trait.cannot.implement.an.interface", new Object[0]), new CommonIntentionAction[0]);
        }
        if (implementsList.getFirstChild() != null && referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, PhpBundle.message("empty.implements.list", new Object[0]), new CommonIntentionAction[0]);
        }
        this.markDuplicateMethods(clazz, false);
        this.markDuplicateFields(clazz, false);
        final HashMap<String, Pair<Field, PhpModifier>> classConstants = new HashMap<String, Pair<Field, PhpModifier>>();
        PhpClassHierarchyUtils.processFields(clazz, clazz, new PhpClassHierarchyUtils.HierarchyFieldProcessor(){
            final Map<String, Field> myStaticSet = new HashMap<String, Field>();
            final Map<String, Field> myNonStaticSet = new HashMap<String, Field>();
            final Map<String, Pair<Field, Pair<PhpModifier.Access, PhpModifier.Access>>> myFieldMap = new HashMap<String, Pair<Field, Pair<PhpModifier.Access, PhpModifier.Access>>>();
            final Set<Field> myVisitedFields = new HashSet<Field>();

            @Override
            public boolean process(Field field, PhpClass subClass, PhpClass baseClass) {
                if (field instanceof PhpDocProperty) {
                    return false;
                }
                if (field instanceof PhpClassImpl.MyRenamableFakePsiElement) {
                    return true;
                }
                String fieldName = field.getName();
                PhpModifier modifier = field.getModifier();
                PhpModifier.Access superAccess = modifier.getAccess();
                PhpModifier.Access superSetAccess = modifier.getSetAccess();
                if (field.isConstant()) {
                    if (PhpElementIsNotAvailableInCurrentPhpVersionInspection.notAvailableByRemovedTag(field) || PhpElementIsNotAvailableInCurrentPhpVersionInspection.notAvailableBySinceTag(field)) {
                        return true;
                    }
                    ASTNode nameNode = clazz.getNameNode();
                    if (classConstants.containsKey(fieldName)) {
                        PhpModifier.Access childAccess;
                        Field f = (Field)((Pair)classConstants.get((Object)fieldName)).first;
                        PhpClass containingClass = f.getContainingClass();
                        boolean isRedeclaration = containingClass == clazz;
                        boolean isDirectRedeclaration = ArrayUtil.contains((Object)subClass, (Object[])clazz.getImplementedInterfaces());
                        if (isRedeclaration) {
                            nameNode = f.getNameNode();
                        }
                        if (!5.haveSameFQNs(subClass, containingClass)) {
                            PhpClass fieldContainingClass = field.getContainingClass();
                            if (modifier.isFinal() && (fieldContainingClass == null || !fieldContainingClass.isTrait())) {
                                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("cannot.override.final.constant", fieldName, subClass.getName()));
                            } else if (!PhpLanguageFeature.FINAL_CLASS_CONSTANTS.isSupported(clazz.getProject()) && (anInterface || subClass.isInterface()) && (isDirectRedeclaration || 5.isInheritanceChainOfInterfaces(subClass, clazz))) {
                                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("cannot.inherit.previously.inherited.or.override.constant.0.from.interface.1", fieldName, subClass.getName()));
                            }
                        }
                        if (superAccess.isWeakerThan(childAccess = ((PhpModifier)((Pair)classConstants.get((Object)fieldName)).second).getAccess()) && this.myVisitedFields.add(f)) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("access.level.to.0.1.must.be.2.as.in.class.3.or.weaker2", new Object[]{clazz.getName(), fieldName, superAccess, subClass.getName()}));
                        }
                        if (subClass.isTrait() || baseClass.isTrait()) {
                            this.checkFieldsCompatibility(field, subClass, baseClass, fieldName, nameNode, f);
                        }
                    } else {
                        classConstants.put(fieldName, Pair.create((Object)field, (Object)modifier));
                    }
                } else {
                    ASTNode nameNode = null;
                    if (this.myFieldMap.containsKey(fieldName)) {
                        Field f = (Field)this.myFieldMap.get((Object)fieldName).first;
                        if (f != null && f.getContainingClass() == clazz) {
                            nameNode = f.getNameNode();
                        }
                        PhpModifier.Access childAccess = (PhpModifier.Access)((Object)((Pair)this.myFieldMap.get((Object)fieldName).second).first);
                        PhpModifier.Access childSetAccess = (PhpModifier.Access)((Object)((Pair)this.myFieldMap.get((Object)fieldName).second).second);
                        if (superAccess.isWeakerThan(childAccess) && nameNode != null && nameNode.getPsi() != null) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode.getPsi(), PhpBundle.message("access.level.to.0.1.must.be.2.as.in.class.3.or.weaker", new Object[]{clazz.getName(), fieldName, superAccess, subClass.getName()}), new CommonIntentionAction[]{new PhpAdjustMemberAccessFix(f, superAccess)});
                            return false;
                        }
                        if (PhpLanguageFeature.ASYMMETRIC_VISIBILITY.isSupported(subClass.getProject()) && nameNode != null && nameNode.getPsi() != null) {
                            if (childSetAccess != null && superSetAccess == null && !5.isAccessCompatible(field, f, superAccess, childSetAccess)) {
                                PsiElement getModifier = FieldImpl.getVisibilityPsi(f);
                                PsiElement setModifier = PhpModifierListImpl.getSetOperationModifierPsiElement(f);
                                if (getModifier == null) {
                                    PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode.getPsi(), PhpBundle.message("php.annotator.set.access.level.must.be.omitted", baseClass.getName(), fieldName, subClass.getName()), new CommonIntentionAction[0]);
                                } else if (setModifier != null) {
                                    PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode.getPsi(), PhpBundle.message("php.annotator.set.access.level.must.be.omitted", baseClass.getName(), fieldName, subClass.getName()), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(setModifier)});
                                }
                            } else if (superSetAccess != null && superSetAccess.isPrivate()) {
                                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("inspection.message.cannot.override.final.property.1", subClass.getName(), fieldName));
                            } else if (superSetAccess != null && childSetAccess != null && superSetAccess.isWeakerThan(childSetAccess)) {
                                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode.getPsi(), PhpBundle.message("set.access.level.to.0.1.must.be.2.as.in.class.3.or.weaker", new Object[]{clazz.getName(), fieldName, superSetAccess, subClass.getName()}), new CommonIntentionAction[]{new PhpAdjustMemberAccessFix(f, superSetAccess, true)});
                            }
                        }
                        if (subClass.isTrait() && !baseClass.isTrait()) {
                            this.checkFieldsCompatibility(field, subClass, baseClass, fieldName, nameNode, f);
                        }
                    } else {
                        this.myFieldMap.put(fieldName, (Pair<Field, Pair<PhpModifier.Access, PhpModifier.Access>>)Pair.create((Object)field, (Object)Pair.create((Object)((Object)superAccess), (Object)((Object)superSetAccess))));
                    }
                    if (this.myStaticSet.containsKey(fieldName)) {
                        containingClass = this.myStaticSet.get(fieldName).getContainingClass();
                        if (!(5.haveSameFQNs(subClass, containingClass) || modifier.isStatic() || modifier.isPrivate())) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("cannot.redeclare.non.static.0.1.as.static.2.3", subClass.getName(), fieldName, clazz.getName(), fieldName));
                            return false;
                        }
                    } else if (this.myNonStaticSet.containsKey(fieldName)) {
                        containingClass = this.myNonStaticSet.get(fieldName).getContainingClass();
                        if (!5.haveSameFQNs(subClass, containingClass) && modifier.isStatic() && !modifier.isPrivate()) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("cannot.redeclare.static.0.1.as.non.static.2.3", subClass.getName(), fieldName, clazz.getName(), fieldName));
                            return false;
                        }
                    } else if (modifier.isStatic()) {
                        this.myStaticSet.put(fieldName, field);
                    } else {
                        this.myNonStaticSet.put(fieldName, field);
                    }
                }
                return true;
            }

            private static boolean isAccessCompatible(Field superField, Field field, PhpModifier.Access superAccess, PhpModifier.Access childSetAccess) {
                if (!superAccess.isWeakerThan(childSetAccess)) {
                    return true;
                }
                if (!superField.isAbstract() && !superField.isVirtualProperty()) {
                    return false;
                }
                return superField.hasPropertyHooksContainer() && ContainerUtil.find(superField.getPropertyHooksList(), PhpPropertyHook.IS_SET_HOOK) == null;
            }

            private void checkFieldsCompatibility(Field field, PhpClass subClass, PhpClass baseClass, String fieldName, ASTNode nameNode, Field f) {
                if (!PhpAnnotatorVisitor.fieldsAreCompatible(field, f) && ArrayUtil.contains((String)subClass.getFQN(), (String[])baseClass.getTraitNames()) && this.myVisitedFields.add(f)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("0.and.1.define.the.same.property.2", baseClass.getName(), subClass.getName(), fieldName));
                }
            }

            private static boolean isInheritanceChainOfInterfaces(PhpClass subClass, PhpClass clazz2) {
                LinkedList implementedInterfaces = new LinkedList();
                HashSet<PhpClass> visited = new HashSet<PhpClass>();
                ContainerUtil.addAll(implementedInterfaces, (Object[])clazz2.getImplementedInterfaces());
                while (!implementedInterfaces.isEmpty()) {
                    PhpClass implementedInterface = (PhpClass)implementedInterfaces.poll();
                    if (!visited.add(implementedInterface)) continue;
                    if (implementedInterface == subClass) {
                        return true;
                    }
                    ContainerUtil.addAll(implementedInterfaces, (Object[])implementedInterface.getImplementedInterfaces());
                }
                return false;
            }

            private static boolean haveSameFQNs(PhpClass subClass, PhpClass containingClass) {
                return containingClass != null && PhpLangUtil.equalsClassNames(subClass.getFQN(), containingClass.getFQN());
            }
        }, false, false);
        if (clazz.hasTraitUses()) {
            PhpAnnotatorVisitor.checkTraitMethodsConflictsWithAppliedMethods(clazz, this.holder);
        }
        this.checkDuplicatedCasesNames(clazz, PhpAnnotatorVisitor.fieldNamesToContainingClasses(classConstants));
    }

    private void checkSuperClassModifiers(@NotNull PhpClass clazz, @NotNull Collection<? extends PhpClass> superClasses, @NotNull Condition<? super PhpClass> condition, @NotNull @Nls String message, @Nullable CommonIntentionAction fix) {
        if (clazz == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(48);
        }
        if (superClasses == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(49);
        }
        if (condition == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(50);
        }
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(51);
        }
        if (!superClasses.isEmpty() && ContainerUtil.all(superClasses, condition)) {
            ASTNode nameNode;
            ASTNode aSTNode = nameNode = clazz.isAnonymous() ? clazz.getNode().findChildByType(PhpTokenTypes.kwCLASS) : clazz.getNameNode();
            if (nameNode != null && nameNode.getTextLength() != 0) {
                AnnotationBuilder annotation = this.holder.newAnnotation(HighlightSeverity.ERROR, message).range(nameNode);
                if (superClasses.size() == 1 && fix != null) {
                    annotation.withFix(fix.asIntention()).create();
                } else {
                    annotation.create();
                }
            }
        }
    }

    private void checkBackedEnumUniqueValues(Collection<? extends PhpEnumCase> cases) {
        for (PhpEnumCase phpEnumCase : cases) {
            for (PhpEnumCase phpEnumCase2 : cases) {
                if (phpEnumCase == phpEnumCase2) continue;
                PhpExpression fExpression = phpEnumCase.getExpression();
                PhpExpression sExpression = phpEnumCase2.getExpression();
                PhpEnumCase.PhpDefaultValueDescriptor fDescriptor = phpEnumCase.getDefaultValueDescriptor();
                PhpEnumCase.PhpDefaultValueDescriptor sDescriptor = phpEnumCase2.getDefaultValueDescriptor();
                if (fExpression == null || sExpression == null || fDescriptor == null || sDescriptor == null || fDescriptor.match((PsiElement)sExpression) != PhpEnumCase.MatchResult.MATCHES && sDescriptor.match((PsiElement)fExpression) != PhpEnumCase.MatchResult.MATCHES && !PhpPsiUtil.areElementsEquivalent((PsiElement)fExpression, (PsiElement)sExpression)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)fExpression, PhpBundle.message("duplicate.value.in.enum.for.cases.0.and.1", phpEnumCase.getName(), phpEnumCase2.getName()), new CommonIntentionAction[]{new PhpNavigateToElementQuickFix((PsiElement)sExpression, PhpBundle.message("quickfix.navigate.to.duplicate.case.value", new Object[0]))});
            }
        }
    }

    private static Map<String, PhpClass> fieldNamesToContainingClasses(Map<String, Pair<Field, PhpModifier>> constants) {
        return EntryStream.of(constants).mapValues(p -> ((Field)p.first).getContainingClass()).filterValues(Objects::nonNull).toMap();
    }

    @NotNull
    private static Collection<String> findForbiddenMethodNames(PhpClass e) {
        Collection collection = e.getMethods().stream().map(PhpNamedElement::getName).filter(PhpAnnotatorVisitor::isForbiddenEnumMethodName).collect(Collectors.toSet());
        if (collection == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(52);
        }
        return collection;
    }

    private void checkEnumInterracesIndirectImplementation(PhpClass clazz, ASTNode nameNode) {
        PhpIndex index = PhpIndex.getInstance(clazz.getProject());
        if (clazz.isEnum()) {
            PhpType backedEnumType = clazz.getBackedEnumType();
            if (backedEnumType.isEmpty() && PhpType.findSuper("\\BackedEnum", clazz.getFQN(), index)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("non.backed.enum.cannot.implement.interface.backedenum", new Object[0]));
            }
        } else if (!clazz.isInterface()) {
            if (PhpType.findSuper("\\BackedEnum", clazz.getFQN(), index)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("non.enum.class.cannot.implement.interface", "BackedEnum"));
            } else if (PhpType.findSuper("\\UnitEnum", clazz.getFQN(), index)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("non.enum.class.cannot.implement.interface", "UnitEnum"));
            }
        }
    }

    private static boolean isOverriddenFromEnumImplicitInterface(Method method) {
        Ref overriddenFromEnumInterface = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperMethods(method, (member, subClass, baseClass) -> {
            PhpClass aClass = member.getContainingClass();
            if (aClass != null && ("\\UnitEnum".equals(aClass.getFQN()) || "\\BackedEnum".equals(aClass.getFQN()))) {
                overriddenFromEnumInterface.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)overriddenFromEnumInterface.get();
    }

    private void checkBackedEnumConsistency(PhpClass clazz) {
        PhpType type = clazz.getBackedEnumType();
        for (PhpEnumCase aCase : clazz.getEnumCases()) {
            ModCommandAction[] modCommandActionArray;
            ModCommandAction[] fixes;
            PhpExpression expression = aCase.getExpression();
            PhpType expressionType = new PhpType().add((PsiElement)expression).global(clazz.getProject());
            if (!type.isEmpty()) {
                ModCommandAction[] modCommandActionArray2;
                PhpBackedEnumTypeImpl backedDeclaration;
                if (expression == null) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)aCase, PhpBundle.message("all.cases.of.backed.enum.must.have.a.value", new Object[0]), new CommonIntentionAction[]{new PhpDeleteEnumBackedTypeQuickFix(clazz)});
                    continue;
                }
                if (expressionType.equals(type)) continue;
                PhpBackedEnumTypeImpl phpBackedEnumTypeImpl = backedDeclaration = clazz instanceof PhpClassImpl ? ((PhpClassImpl)clazz).getTypeDeclaration() : null;
                if (backedDeclaration != null && PhpAnnotatorVisitor.isExpressionTypeIsSuitableForBackedEnum(expressionType)) {
                    ModCommandAction[] modCommandActionArray3 = new ModCommandAction[1];
                    modCommandActionArray2 = modCommandActionArray3;
                    modCommandActionArray3[0] = new PhpUpdateTypeDeclarationQuickFix(backedDeclaration, expressionType);
                } else {
                    modCommandActionArray2 = ModCommandAction.EMPTY_ARRAY;
                }
                fixes = modCommandActionArray2;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("enum.case.type.0.does.not.match.enum.backing.type.1", expressionType, type), (CommonIntentionAction[])fixes);
                continue;
            }
            if (expression == null) continue;
            PhpDeleteCaseInitExpressionQuickFix deleteCaseInitQuickFix = new PhpDeleteCaseInitExpressionQuickFix(aCase);
            if (PhpAnnotatorVisitor.isExpressionTypeIsSuitableForBackedEnum(expressionType)) {
                ModCommandAction[] modCommandActionArray4 = new ModCommandAction[2];
                modCommandActionArray4[0] = deleteCaseInitQuickFix;
                modCommandActionArray = modCommandActionArray4;
                modCommandActionArray4[1] = new PhpAddEnumBackedTypeQuickFix(clazz, expressionType);
            } else {
                ModCommandAction[] modCommandActionArray5 = new ModCommandAction[1];
                modCommandActionArray = modCommandActionArray5;
                modCommandActionArray5[0] = deleteCaseInitQuickFix;
            }
            fixes = modCommandActionArray;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("case.of.non.backed.enum.must.not.have.a.value", new Object[0]), (CommonIntentionAction[])fixes);
        }
    }

    private static boolean isExpressionTypeIsSuitableForBackedEnum(PhpType expressionType) {
        return expressionType.equals(PhpType.STRING) || expressionType.equals(PhpType.INT);
    }

    private static boolean fieldsAreCompatible(@Nullable Field field, @Nullable Field another) {
        if (field == null || another == null) {
            return true;
        }
        if (!field.getModifier().getAccess().equals((Object)another.getModifier().getAccess())) {
            return false;
        }
        if (field.getModifier().isFinal() != another.getModifier().isFinal()) {
            return false;
        }
        Collection<PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> matchers = PhpFieldsDefaultValueMatcherIndex.getDefaultValueMatcher(field);
        PsiElement defaultValue = another.getDefaultValue();
        return matchers.isEmpty() || defaultValue == null || ContainerUtil.exists(matchers, m -> m.matches(defaultValue));
    }

    private void markDuplicateFields(final PhpClass clazz, final boolean docProperties) {
        final HashSet constantNames = new HashSet();
        PhpClassHierarchyUtils.processFields(clazz, clazz, new PhpClassHierarchyUtils.HierarchyFieldProcessor(){
            final Set<String> propNames = new HashSet<String>();
            final Set<String> fieldNames = new HashSet<String>();

            @Override
            public boolean process(Field field, PhpClass subClass, PhpClass baseClass) {
                if (field instanceof PhpClassImpl.MyRenamableFakePsiElement) {
                    return true;
                }
                Set<String> names = field.isConstant() ? constantNames : (PhpPsiUtil.getParentOfClass(field, true, PhpDocComment.class) != null ? this.propNames : this.fieldNames);
                String name = field.getName();
                if (!StringUtil.isEmpty((String)name) && !names.add(name) && docProperties == field instanceof PhpDocProperty) {
                    PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, field.getNameIdentifier(), PhpBundle.message("0.with.same.name.already.defined.in.this.class", field.isConstant() ? PhpBundle.message("constant", new Object[0]) : PhpBundle.message("field1", new Object[0])), new CommonIntentionAction[0]);
                }
                if (!(docProperties || !subClass.isInterface() || field instanceof PhpDocProperty || field.isConstant() || field.hasPropertyHooksContainer())) {
                    if (PhpLanguageLevel.current((Project)field.getProject()).isAtLeast(PhpLanguageLevel.PHP840)) {
                        PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, field, PhpBundle.message("php.annotator.interfaces.may.only.include.hooked.properties", new Object[0]), new CommonIntentionAction[]{new PhpAddPropertyHooksQuickFix(field)});
                    } else {
                        PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, field, PhpBundle.message("interfaces.may.not.include.member.variables", new Object[0]), new CommonIntentionAction[]{PhpAnnotatorVisitor.getFix(field, clazz)});
                    }
                }
                return true;
            }
        }, true, false);
    }

    private void checkDuplicatedCasesNames(PhpClass clazz, Map<String, PhpClass> constantNames) {
        HashSet<String> casesName = new HashSet<String>();
        for (PhpEnumCase aCase : clazz.getEnumCases()) {
            PsiElement nameIdentifier = aCase.getNameIdentifier();
            if (nameIdentifier == null) continue;
            String caseName = aCase.getName();
            if (constantNames.containsKey(caseName)) {
                PhpClass containingClass = constantNames.get(caseName);
                String message = clazz == containingClass ? PhpBundle.message("0.with.same.name.already.defined.in.this.class", PhpBundle.message("constant", new Object[0])) : PhpBundle.message("cannot.inherit.previously.inherited.or.override.constant.0.from.interface.1", caseName, containingClass.getName());
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameIdentifier, message, new CommonIntentionAction[0]);
                continue;
            }
            if (casesName.add(caseName)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameIdentifier, PhpBundle.message("0.with.same.name.already.defined.in.this.class", PhpBundle.message("enum.case", new Object[0])), new CommonIntentionAction[0]);
        }
    }

    @NotNull
    private static ModCommandAction getFix(Field field, PhpClass clazz) {
        return field.getDefaultValue() != null && clazz.findFieldByName(field.getName(), true) == null ? new PhpReplaceWithConstantQuickFix(field) : new PhpDeleteFieldQuickFix(field);
    }

    private static void checkTraitMethodsConflictsWithAppliedMethods(@NotNull PhpClass phpClass, AnnotationHolder holder) {
        if (phpClass == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(53);
        }
        PhpIndex index = PhpIndex.getInstance(phpClass.getProject());
        Set<String> traitMethodsExcludedFromConflicts = PhpAnnotatorVisitor.getTraitsExcludedFromConflicts(phpClass, index, new HashSet());
        Map usedMethodsFromTraits = CollectionFactory.createCaseInsensitiveStringMap();
        List<PhpUseList> useListElements = PhpPsiUtil.getChildren((PsiElement)phpClass, PhpUseList.INSTANCEOF);
        Collection ownMethodNames = Arrays.stream(phpClass.getOwnMethods()).map(PhpNamedElement::getName).collect(PhpStringUtil.toCaseInsensitiveSet());
        for (PhpUseList useList : useListElements) {
            for (PhpUse declaration : useList.getDeclarations()) {
                String traitFqn = PhpAnnotatorVisitor.getTargetReferenceFqn(declaration);
                if (traitFqn == null) continue;
                index.getTraitsByFQN(traitFqn).stream().flatMap(trait -> PhpAnnotatorVisitor.getMethods(trait, new HashSet(), new HashSet<String>())).filter(traitMethod -> PhpAnnotatorVisitor.canConflict(traitMethod) && !ownMethodNames.contains(traitMethod.getName())).distinct().forEach(traitMethod -> PhpAnnotatorVisitor.checkTraitMethodDoestConflictWithExisting(holder, usedMethodsFromTraits, (PsiElement)declaration, traitMethodsExcludedFromConflicts, traitMethod.getName(), PhpAnnotatorVisitor.getConflictingTraitFqn(traitMethod, traitFqn)));
            }
            for (PhpTraitUseRule rule : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)useList, PhpTraitUseRule.class)) {
                PhpClass containingClass;
                Method original;
                String alias = rule.getAlias();
                if (alias == null || rule.isInsteadOf() || ownMethodNames.contains(alias) || !PhpAnnotatorVisitor.canConflict(original = rule.getOriginal()) || (containingClass = original.getContainingClass()) == null) continue;
                PhpAnnotatorVisitor.checkTraitMethodDoestConflictWithExisting(holder, usedMethodsFromTraits, (PsiElement)rule, Collections.emptySet(), alias, containingClass.getFQN());
            }
        }
    }

    @NotNull
    private static Set<String> getTraitsExcludedFromConflicts(@NotNull PhpClass phpClass, PhpIndex index, Collection<? super PhpClass> visited) {
        if (phpClass == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(54);
        }
        if (!visited.add(phpClass)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(55);
            }
            return set;
        }
        Set res = CollectionFactory.createCaseInsensitiveStringSet();
        Set<String> exclusions = PhpClassHierarchyUtils.getTraitUseRulesConflictResolutions(phpClass.traitUseRules().toList()).keySet();
        if (PhpLanguageLevel.current((Project)phpClass.getProject()).isAtLeast(PhpLanguageLevel.PHP730)) {
            exclusions = exclusions.stream().map(s -> PhpTypeSignatureKey.METHOD.sign(PhpTypeSignatureKey.CLASS.sign((CharSequence)s))).flatMap(s -> index.getBySignature((String)s).stream()).map(PhpNamedElement::getFQN).collect(Collectors.toSet());
        }
        res.addAll(exclusions);
        for (PhpClass trait : phpClass.getTraits()) {
            res.addAll(PhpAnnotatorVisitor.getTraitsExcludedFromConflicts(trait, index, visited));
        }
        Set set = res;
        if (set == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(56);
        }
        return set;
    }

    @NotNull
    private static String getConflictingTraitFqn(@NotNull Method traitMethod, @NotNull String originalTraitFqn) {
        PhpClass containingClass;
        if (traitMethod == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(57);
        }
        if (originalTraitFqn == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(58);
        }
        if (PhpProjectConfigurationFacade.getInstance(traitMethod.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP730) && (containingClass = traitMethod.getContainingClass()) != null) {
            String string = containingClass.getFQN();
            if (string == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(59);
            }
            return string;
        }
        String string = originalTraitFqn;
        if (string == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(60);
        }
        return string;
    }

    private static Stream<Method> getMethods(@NotNull PhpClass trait, Set<? super PhpClass> visited, Collection<String> alreadyImplementedNames) {
        if (trait == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(61);
        }
        List methods = ContainerUtil.filter((Object[])trait.getOwnMethods(), e -> !alreadyImplementedNames.contains(e.getName().toLowerCase(Locale.ROOT)));
        StreamEx result = StreamEx.of((Collection)methods);
        Collection<String> alreadyImplementedNamesWithCurrent = PhpAnnotatorVisitor.unionMethodsNames(alreadyImplementedNames, methods);
        Set<String> conflictResolutions = PhpClassHierarchyUtils.getTraitUseRulesConflictResolutions(trait.traitUseRules().toList()).keySet();
        for (PhpClass usedTrait : trait.getTraits()) {
            if (!visited.add(usedTrait)) continue;
            result = (StreamEx)result.append(PhpAnnotatorVisitor.getMethods(usedTrait, visited, alreadyImplementedNamesWithCurrent));
        }
        return result.filter(m -> !conflictResolutions.contains(m.getFQN()));
    }

    @NotNull
    private static @Unmodifiable Collection<String> unionMethodsNames(Collection<String> names, List<? extends Method> methods) {
        Set set = ContainerUtil.union(names, (Collection)ContainerUtil.map2Set(methods, method -> method.getName().toLowerCase(Locale.ROOT)));
        if (set == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(62);
        }
        return set;
    }

    private static boolean canConflict(@Nullable Method traitMethod) {
        return traitMethod != null && !(traitMethod instanceof PhpDocMethod) && !traitMethod.isAbstract();
    }

    @Nullable
    private static String getTargetReferenceFqn(@NotNull PhpUse declaration) {
        PhpReference reference;
        if (declaration == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(63);
        }
        return (reference = declaration.getTargetReference()) != null ? reference.getFQN() : null;
    }

    private static void checkTraitMethodDoestConflictWithExisting(AnnotationHolder holder, Map<String, String> usedMethodsFromTraits, PsiElement elementToRegisterError, Collection<String> traitMethodsExcludedFromConflicts, String methodName, String traitFqn) {
        String conflictTraitFqn;
        if (usedMethodsFromTraits.containsKey(methodName) && !PhpLangUtil.equalsClassNames(conflictTraitFqn = usedMethodsFromTraits.get(methodName), traitFqn) && !traitMethodsExcludedFromConflicts.contains(conflictTraitFqn + "." + methodName) && !traitMethodsExcludedFromConflicts.contains(traitFqn + "." + methodName)) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, elementToRegisterError, PhpBundle.message("trait.method.0.will.not.be.applied.because.it.collides.with.1", methodName, PhpLangUtil.toShortName(conflictTraitFqn)), new CommonIntentionAction[0]);
        }
        usedMethodsFromTraits.put(methodName, traitFqn);
    }

    private static void addAllSuperInterfaces(@NotNull ClassReference reference, @NotNull Set<? super String> interfaces) {
        PsiElement phpClass;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(64);
        }
        if (interfaces == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(65);
        }
        if ((phpClass = reference.resolve()) instanceof PhpClass && !interfaces.contains(((PhpClass)phpClass).getFQN())) {
            PhpClassHierarchyUtils.processSuperInterfaces((PhpClass)phpClass, true, true, (Processor<? super PhpClass>)((Processor)superInterface -> {
                interfaces.add(superInterface.getFQN());
                return true;
            }));
        }
    }

    public static void createErrorAnnotation(AnnotationHolder holder, @Nullable ASTNode node, @Nls @NotNull String message) {
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(66);
        }
        if (node != null && node.getTextLength() != 0) {
            holder.newAnnotation(HighlightSeverity.ERROR, message).range(node).create();
        }
    }

    public static void createErrorAnnotation(AnnotationHolder holder, @Nullable TextRange e, @Nls @NotNull String message, CommonIntentionAction ... fixes) {
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(67);
        }
        if (fixes == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(68);
        }
        if (e != null && e.getLength() != 0) {
            AnnotationBuilder builder2 = holder.newAnnotation(HighlightSeverity.ERROR, message).range(e);
            for (CommonIntentionAction fix : fixes) {
                builder2 = builder2.withFix(fix.asIntention());
            }
            builder2.create();
        }
    }

    public static void createErrorAnnotation(AnnotationHolder holder, @NotNull PsiElement e, @Nls @NotNull String message, CommonIntentionAction ... fixes) {
        if (e == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(69);
        }
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(70);
        }
        if (fixes == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(71);
        }
        PhpAnnotatorVisitor.createErrorAnnotation(holder, e.getTextRange(), message, fixes);
    }

    @Override
    public void visitPhpReturn(PhpReturn returnStatement) {
        Function method = PhpPsiUtil.getParentOfClass((PsiElement)returnStatement, Function.class);
        if (method instanceof Method && "getIterator".equals(method.getName())) {
            PhpTypedElement returnArgument;
            PhpClass containingClass = ((Method)method).getContainingClass();
            PhpIndex index = PhpIndex.getInstance(returnStatement.getProject());
            if (containingClass != null && PhpType.findSuper("\\IteratorAggregate", containingClass.getFQN(), index) && (returnArgument = (PhpTypedElement)ObjectUtils.tryCast((Object)returnStatement.getArgument(), PhpTypedElement.class)) != null) {
                PhpType returnArgumentType = returnArgument.getType();
                if (!ITERATOR_TRAVERSABLE_TYPE.isConvertibleFromGlobal(returnStatement.getProject(), returnArgumentType) && !returnArgumentType.global(returnArgument.getProject()).equals(PhpType.NULL)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnArgument, PhpBundle.message("returned.by.iterator.aggregate.should.be.traversable", new Object[0]), new CommonIntentionAction[0]);
                }
            }
        }
        if (method != null) {
            this.checkReturnStatementNullability(method, returnStatement, (PhpReturnType)method.getTypeDeclaration());
            this.checkNoReturnArgumentForVoidFunction(method, returnStatement);
        }
    }

    private void checkNoReturnArgumentForVoidFunction(@NotNull Function function, @NotNull PhpReturn returnStatement) {
        PsiElement returnArgument;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(72);
        }
        if (returnStatement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(73);
        }
        if ((returnArgument = returnStatement.getArgument()) == null) {
            return;
        }
        if (!PhpIncompatibleReturnTypeInspection.isVoidDeclaredType(function)) {
            return;
        }
        ArrayList<PhpDeleteElementQuickFix> fixes = new ArrayList<PhpDeleteElementQuickFix>();
        fixes.add(new PhpDeleteElementQuickFix(returnArgument, PhpBundle.message("quickfix.delete.return.argument", new Object[0])));
        ContainerUtil.addIfNotNull(fixes, (Object)PhpAnnotatorVisitor.getChangeReturnTypeFix(function, returnArgument));
        if (function instanceof PhpPropertyHook) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, returnArgument, PhpBundle.message("php.annotator.void.function.must.not.return.value", new Object[0]), new CommonIntentionAction[0]);
        } else {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, returnArgument, PhpBundle.message("php.annotator.void.function.must.not.return.value", new Object[0]), (CommonIntentionAction[])fixes.toArray(ModCommandAction.EMPTY_ARRAY));
        }
    }

    @Nullable
    private static ModCommandAction getChangeReturnTypeFix(@NotNull Function function, @Nullable PsiElement returnArgument) {
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(74);
        }
        if (returnArgument == null) {
            return null;
        }
        PhpType returnArgumentType = ((PhpTypedElement)returnArgument).getType().global(function.getProject()).filterUnknown();
        PhpType typeWithoutNull = returnArgumentType.filterNull();
        if (!PhpType.VOID.equals(returnArgumentType) && (typeWithoutNull.size() == 1 || typeWithoutNull.size() > 1 && PhpLanguageFeature.UNION_TYPES.isSupported(function.getProject()))) {
            return new PhpChangeReturnTypeAnnotatorFix(function, returnArgumentType);
        }
        return null;
    }

    private void checkReturnStatementNullability(@NotNull Function function, @NotNull PhpReturn returnStatement, @Nullable PhpReturnType returnTypeElement) {
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(75);
        }
        if (returnStatement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(76);
        }
        if (returnTypeElement == null) {
            return;
        }
        PhpType returnType = returnTypeElement.getGlobalType();
        if (PhpType.intersects(returnType, PhpType.VOID) || returnType.isNullable() || returnType.equals(PhpType.MIXED)) {
            return;
        }
        if (PhpType.intersects(returnType, GENERATOR_TYPE)) {
            return;
        }
        if (PhpType.intersects(returnType, PROBABLY_GENERATOR_TYPE)) {
            return;
        }
        boolean nullablesSupported = PhpLanguageFeature.NULLABLES.isSupported(function.getProject());
        boolean hasNonNullableSuperMethods = PhpAnnotatorVisitor.hasNonNullableSuperMethods(function);
        for (PsiElement returnArgument : PhpIncompatibleReturnTypeInspection.collectArgumentsContributingToReturnType(returnStatement.getArgument())) {
            boolean isNull = PhpLangUtil.isNull(returnArgument);
            if (isNull && nullablesSupported && !hasNonNullableSuperMethods) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, returnArgument, PhpBundle.message("php.annotator.return.type.non.nullable.null.returned", new Object[0]), new CommonIntentionAction[]{new PhpMakeReturnTypeNullableFix(returnArgument)});
                continue;
            }
            if (!isNull) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, returnArgument, PhpBundle.message("php.annotator.return.type.non.nullable.null.returned", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private static boolean hasNonNullableSuperMethods(@NotNull Function function) {
        Method method;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(77);
        }
        if ((method = (Method)ObjectUtils.tryCast((Object)function, Method.class)) == null) {
            return false;
        }
        return !PhpClassHierarchyUtils.processSuperMethods(method, (superMethod, subClass, baseClass) -> baseClass.isTrait() || superMethod.getDeclaredType().isEmpty() || superMethod.getDeclaredType().isNullable());
    }

    @Override
    public void visitPhpFunction(Function function) {
        super.visitPhpFunction(function);
        if (PhpAnnotatorVisitor.hasYield(function)) {
            this.checkCorrectReturnGeneratorType(function);
        }
        this.checkParametersRedefinition(function);
        PhpReturnType returnTypeElement = (PhpReturnType)function.getTypeDeclaration();
        if (returnTypeElement != null) {
            if (FunctionImpl.isShortArrowFunction(function)) {
                this.checkArrowFunctionReturnType(function, returnTypeElement);
            }
            for (ClassReference classReference : returnTypeElement.getClassReferences()) {
                this.checkInvalidClassName(classReference);
            }
        }
        this.checkVoidFunctionReturnByRef(function, returnTypeElement);
    }

    @Override
    public void visitPhpExit(PhpExit exitExpression) {
        ASTNode kw = exitExpression.getNode().findChildByType(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwEXIT, PhpTokenTypes.kwDIE}));
        if (kw == null) {
            return;
        }
        this.highlightInfo(kw, PhpHighlightingData.KEYWORD);
    }

    private void checkVoidFunctionReturnByRef(Function function, PhpReturnType returnTypeElement) {
        PhpLanguageLevel languageLevel = PhpLanguageLevel.current((Project)function.getProject());
        if (function instanceof FunctionImpl && returnTypeElement != null && languageLevel.isAtLeast(PhpLanguageLevel.PHP810) || function instanceof PhpPropertyHook && PhpPropertyHook.IS_SET_HOOK.value((Object)function) && languageLevel.isAtLeast(PhpLanguageLevel.PHP840)) {
            PsiElement returnByRef = function.getReturnByReferenceTokenFromAST();
            if ((returnTypeElement != null && returnTypeElement.getType().equals(PhpType.VOID) || function instanceof PhpPropertyHook) && returnByRef != null) {
                this.holder.newAnnotation(HighlightSeverity.WARNING, PhpBundle.message("inspection.message.returning.by.reference.from.void.function.deprecated", new Object[0])).range(returnByRef).withFix((CommonIntentionAction)new PhpDeleteElementQuickFix(returnByRef)).create();
            }
        }
    }

    private void checkArrowFunctionReturnType(@NotNull Function function, @NotNull PhpReturnType returnTypeElement) {
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(78);
        }
        if (returnTypeElement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(79);
        }
        if (returnTypeElement.getType().global(function.getProject()).equals(PhpType.VOID)) {
            PhpExpression returnArgument = (PhpExpression)ObjectUtils.tryCast((Object)FunctionImpl.getShortArrowFunctionArgument(function), PhpExpression.class);
            ArrayList<PhpDeleteElementQuickFix> fixes = new ArrayList<PhpDeleteElementQuickFix>();
            ContainerUtil.addIfNotNull(fixes, (Object)PhpAnnotatorVisitor.getChangeReturnTypeFix(function, (PsiElement)returnArgument));
            fixes.add(new PhpDeleteElementQuickFix((PsiElement)returnTypeElement, PhpBundle.message("delete.void.return.type", new Object[0]), PhpTokenTypes.opCOLON));
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnTypeElement, PhpBundle.message("short.arrow.function.cannot.return.void", new Object[0]), fixes.toArray(CommonIntentionAction.EMPTY_ARRAY));
        }
    }

    private static boolean hasYield(Function function) {
        final Ref hasYield = Ref.create((Object)Boolean.FALSE);
        PhpControlFlowUtil.processFlow(function.getControlFlow(), new PhpInstructionProcessor(){

            @Override
            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                hasYield.set((Object)Boolean.TRUE);
                return false;
            }
        });
        return (Boolean)hasYield.get();
    }

    @Override
    public void visitPhpMethod(Method method) {
        super.visitPhpMethod(method);
        if (!(method instanceof PhpDocMethod) && PhpAnnotatorVisitor.hasYield(method)) {
            this.checkCorrectReturnGeneratorType(method);
        }
        ASTNode nameNode = method.getNameNode();
        PhpReturnType returnType = (PhpReturnType)method.getTypeDeclaration();
        CharSequence name = method.getNameCS();
        if (nameNode != null && returnType != null) {
            boolean isConstructorOrDestructor;
            boolean bl = isConstructorOrDestructor = PhpLangUtil.equalsMethodNames("__construct", name) || PhpLangUtil.equalsMethodNames("__destruct", name);
            if (isConstructorOrDestructor || PhpLangUtil.equalsMethodNames("__clone", name) && !PhpLanguageLevel.current((Project)method.getProject()).isAtLeast(PhpLanguageLevel.PHP800)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, PhpBundle.message("return.type.declaration.is.not.allowed", new Object[0]), new CommonIntentionAction[0]);
            }
        }
        if (method instanceof MethodImpl && PhpLanguageLevel.current((Project)method.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && method.getAccess().isPrivate()) {
            PsiElement finalKeyword;
            ASTNode kwFinalNode = ((MethodImpl)method).getModifierList().getNode().findChildByType(PhpTokenTypes.kwFINAL);
            PsiElement psiElement = finalKeyword = kwFinalNode != null ? kwFinalNode.getPsi() : null;
            if (finalKeyword != null && method.getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, finalKeyword, PhpBundle.message("private.methods.cannot.be.final", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(finalKeyword)});
            }
        }
        if (returnType != null) {
            for (ClassReference classReference : returnType.getClassReferences()) {
                this.checkInvalidClassName(classReference);
            }
        }
        this.checkParametersRedefinition(method);
        this.checkVoidFunctionReturnByRef(method, returnType);
    }

    static boolean isForbiddenEnumMethodName(CharSequence name) {
        return PhpLangUtil.equalsMethodNames("__construct", name) || PhpLangUtil.equalsMethodNames("__destruct", name) || PhpAnnotatorVisitor.isForbiddenMagicMethodNameForEnum(name);
    }

    public static boolean isForbiddenMagicMethodNameForEnum(CharSequence name) {
        return PhpLangUtil.isMagicMethod(name) && !"__callStatic".contentEquals(name) && !"__call".contentEquals(name) && !"__invoke".contentEquals(name);
    }

    private void checkParametersRedefinition(@NotNull Function function) {
        Parameter[] parameters;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(80);
        }
        if (PhpProjectConfigurationFacade.getInstance(function.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP700) && (parameters = function.getParameters()).length > 1) {
            if (parameters.length == 2 && parameters[0].getName().equals(parameters[1].getName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameters[1], PhpBundle.message("redefinition.of.parameters.is.not.allowed", new Object[0]), new CommonIntentionAction[0]);
            } else {
                HashSet duplicates = new HashSet();
                Arrays.stream(parameters).filter(parameter -> !duplicates.add(parameter.getName())).forEach(parameter -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter, PhpBundle.message("redefinition.of.parameters.is.not.allowed", new Object[0]), new CommonIntentionAction[0]));
            }
        }
    }

    @Override
    public void visitPhpField(Field field) {
        PhpPropertyHook setHook;
        PsiElement defaultValue;
        super.visitPhpField(field);
        PhpClass aClass = field.getContainingClass();
        assert (aClass != null);
        if (field.isConstant() && (defaultValue = field.getDefaultValue()) != null && PhpAnnotatorVisitor.expressionHasReferenceToConstant(field, defaultValue)) {
            boolean hasOverridingConst;
            boolean bl = hasOverridingConst = !PhpClassHierarchyUtils.processOverridingMembers(field, PhpClassHierarchyUtils.FALSE_PROCESSOR);
            if (!hasOverridingConst) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("cannot.declare.self.referencing.constant", new Object[0]), new CommonIntentionAction[0]);
            }
        }
        if ((defaultValue = field.getDefaultValue()) != null) {
            if (field.isConstant()) {
                if (!PhpCodeValidationUtil.isAllowedAsConstantValue(defaultValue) || !PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(defaultValue)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("annotation.expression.is.not.allowed.as.class.constant.value", new Object[0]), new CommonIntentionAction[0]);
                }
                if (PhpLanguageFeature.TYPED_CLASS_CONSTANTS.isSupported(field.getProject())) {
                    this.checkTypedPropertyDefaultValue(field, defaultValue);
                }
            } else {
                if (field.isReadonly()) {
                    ModCommandAction[] modCommandActionArray;
                    if (!PhpClassImpl.getConstructorAssignmentsPerField(aClass).containsKey((Object)field.getName())) {
                        ModCommandAction[] modCommandActionArray2 = new ModCommandAction[1];
                        modCommandActionArray = modCommandActionArray2;
                        modCommandActionArray2[0] = new PhpInitializePropertyInConstructorQuickFix(defaultValue);
                    } else {
                        modCommandActionArray = ModCommandAction.EMPTY_ARRAY;
                    }
                    ModCommandAction[] quickFixes = modCommandActionArray;
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("readonly.property.cannot.have.default.value", new Object[0]), (CommonIntentionAction[])quickFixes);
                } else if (!(PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(defaultValue) || field instanceof PhpPromotedFieldParameterImpl && !PhpAnnotatorVisitor.isAllowedAsParameterDefaultValue(defaultValue))) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("expression.is.not.allowed.as.field.default.value", new Object[0]), new CommonIntentionAction[0]);
                }
                if (PhpLanguageFeature.PROPERTY_HOOKS.isSupported(field.getProject()) && field.isVirtualProperty()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("php.annotator.cannot.specify.default.value.for.virtual.hooked.property", new Object[0]), new CommonIntentionAction[]{new PhpDumbAwareAnnotatorVisitor.PhpRemoveDefaultValueQuickFix(field)});
                    return;
                }
                if (PhpLanguageFeature.TYPED_PROPERTIES.isSupported(field.getProject()) && !(field instanceof PhpPromotedFieldParameterImpl)) {
                    this.checkTypedPropertyDefaultValue(field, defaultValue);
                }
            }
        }
        if (PhpLanguageFeature.PROPERTY_HOOKS.isSupported(field.getProject()) && (setHook = (PhpPropertyHook)ContainerUtil.find(field.getPropertyHooksList(), PhpPropertyHook.IS_SET_HOOK)) != null) {
            PhpType parameterType;
            Parameter singleParameter = (Parameter)ContainerUtil.getOnlyItem(Arrays.stream(setHook.getParameters()).toList());
            if (singleParameter == null) {
                return;
            }
            PhpType fieldType = field.getDeclaredType();
            if (!PhpAnnotatorVisitor.areParameterHookTypeAndFieldTypeCompatible(fieldType, parameterType = singleParameter.getDeclaredType(), field.getProject())) {
                PhpTypeDeclaration paramTypeDeclaration = singleParameter.getTypeDeclaration();
                List<PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix> quickFixes = paramTypeDeclaration != null && fieldType.isEmpty() ? List.of(new PhpDeleteElementQuickFix((PsiElement)paramTypeDeclaration), new PhpChangeFieldTypeToMatchDefaultValueFix(field, singleParameter, fieldType, parameterType)) : List.of(new PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix(singleParameter, fieldType, parameterType));
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, singleParameter, PhpBundle.message("php.annotator.set.hook.type.parameter.must.compatible.property.type", new Object[0]), quickFixes.toArray(CommonIntentionAction.EMPTY_ARRAY));
            }
        }
    }

    public static boolean areParameterHookTypeAndFieldTypeCompatible(PhpType fieldType, PhpType parameterType, Project project) {
        if (fieldType.isEmpty() != parameterType.isEmpty()) {
            return false;
        }
        PhpType fieldPrimitiveType = fieldType.filterOut(it -> !PhpType.isNotExtendablePrimitiveType(it));
        PhpType parameterPrimitiveType = parameterType.filterOut(it -> !PhpType.isNotExtendablePrimitiveType(it));
        if (!parameterPrimitiveType.getTypes().containsAll(fieldPrimitiveType.getTypes())) {
            return false;
        }
        PhpType fieldNonPrimitiveType = fieldType.filterOut(PhpType::isNotExtendablePrimitiveType);
        PhpType parameterNonPrimitiveType = parameterType.filterOut(PhpType::isNotExtendablePrimitiveType);
        if (parameterNonPrimitiveType.isEmpty() && !fieldNonPrimitiveType.isEmpty()) {
            return false;
        }
        fieldNonPrimitiveType = PhpType.fromStrings(ContainerUtil.map(fieldNonPrimitiveType.getTypes(), PhpTypeSignatureKey.SELF_CLASS::unsign));
        return ContainerUtil.and(fieldNonPrimitiveType.getTypes(), it -> parameterNonPrimitiveType.isConvertibleFrom(PhpType.from(it), PhpIndex.getInstance(project)));
    }

    private static boolean expressionHasReferenceToConstant(@NotNull Field constant, @NotNull PsiElement expression) {
        if (constant == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(81);
        }
        if (expression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(82);
        }
        return SyntaxTraverser.psiTraverser((PsiElement)expression).filter(ClassConstantReference.class).filter(e -> PhpLangUtil.equalsClassNames(e.getName(), constant.getName())).filter(e -> e.resolve() == constant).isNotEmpty();
    }

    private void checkTypedPropertyDefaultValue(@NotNull Field field, @NotNull PsiElement defaultValue) {
        if (field == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(83);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(84);
        }
        if (!(defaultValue instanceof PhpTypedElement)) {
            return;
        }
        PhpType declaredType = field.getDeclaredType();
        if (declaredType.isEmpty() || declaredType.equals(PhpType.MIXED)) {
            return;
        }
        if (PhpAnnotatorVisitor.isPropertyDefaultValueTypeCompatible(field, declaredType, defaultValue)) {
            return;
        }
        PhpType defaultValueType = ((PhpTypedElement)defaultValue).getGlobalType();
        PhpType type = PhpAnnotatorVisitor.getCompatibleType(declaredType, defaultValueType);
        PhpAnnotatorVisitor.createIncompatibleDefaultValueAnnotation(this.holder, field, declaredType, defaultValue, PhpAnnotatorVisitor.getChangeFieldTypeFixes(field, defaultValue, declaredType, type));
    }

    private static CommonIntentionAction[] getChangeFieldTypeFixes(@NotNull Field field, @NotNull PsiElement defaultValue, @NotNull PhpType declaredType, @Nullable PhpType type) {
        if (field == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(85);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(86);
        }
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(87);
        }
        if (type == null || PhpAnnotatorVisitor.isInsideHierarchy(field) || declaredType.hasIntersectionType()) {
            return IntentionAction.EMPTY_ARRAY;
        }
        java.util.function.Function<PhpType, PhpChangeTypeToMatchDefaultValueFix> quickFixFactory = newType -> {
            if (field == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(144);
            }
            return new PhpChangeFieldTypeToMatchDefaultValueFix(field, defaultValue, declaredType, (PhpType)newType);
        };
        return PhpAnnotatorVisitor.getChangeTypeFixes(defaultValue, declaredType, type, quickFixFactory);
    }

    private static CommonIntentionAction[] getChangeParameterTypeFixes(@NotNull Parameter parameter, @NotNull PsiElement defaultValue, @NotNull PhpType declaredType, @Nullable PhpType type) {
        if (parameter == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(88);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(89);
        }
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(90);
        }
        if (type == null) {
            return IntentionAction.EMPTY_ARRAY;
        }
        Method method = PhpPsiUtil.getParentOfClass(parameter, Method.class);
        if (method != null && PhpAnnotatorVisitor.isInsideHierarchy(method) || declaredType.hasIntersectionType()) {
            return IntentionAction.EMPTY_ARRAY;
        }
        java.util.function.Function<PhpType, PhpChangeTypeToMatchDefaultValueFix> quickFixFactory = newType -> {
            if (defaultValue == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(143);
            }
            return new PhpChangeParameterTypeToMatchDefaultValueFix(defaultValue, declaredType, (PhpType)newType);
        };
        return PhpAnnotatorVisitor.getChangeTypeFixes(defaultValue, declaredType, type, quickFixFactory);
    }

    private static CommonIntentionAction[] getChangeTypeFixes(@NotNull PsiElement defaultValue, @NotNull PhpType declaredType, @NotNull PhpType type, @NotNull java.util.function.Function<? super PhpType, ? extends PhpChangeTypeToMatchDefaultValueFix> typeFixerFactory) {
        boolean atLeast82;
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(91);
        }
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(92);
        }
        if (type == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(93);
        }
        if (typeFixerFactory == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(94);
        }
        if (!(atLeast82 = PhpLanguageLevel.current((Project)defaultValue.getProject()).isAtLeast(PhpLanguageLevel.PHP820)) && type.getTypes().contains("\\true")) {
            type = type.filter(PhpType.TRUE).add(PhpType.BOOLEAN);
        }
        ArrayList<PhpChangeTypeToMatchDefaultValueFix> fixes = new ArrayList<PhpChangeTypeToMatchDefaultValueFix>();
        PhpChangeTypeToMatchDefaultValueFix changeFix = typeFixerFactory.apply(ParameterImpl.generaliseDefaultValueType(type));
        fixes.add(changeFix);
        if (PhpLanguageFeature.UNION_TYPES.isSupported(defaultValue.getProject())) {
            PhpType appendedType = new PhpType().add(declaredType).add(type);
            fixes.add((PhpChangeTypeToMatchDefaultValueFix)((CommonIntentionAction)typeFixerFactory.apply(appendedType)));
            if (appendedType.getTypes().contains("\\false") || atLeast82 && appendedType.getTypes().contains("\\true")) {
                fixes.add((PhpChangeTypeToMatchDefaultValueFix)((CommonIntentionAction)typeFixerFactory.apply(ParameterImpl.generaliseDefaultValueType(appendedType))));
            }
        }
        return fixes.toArray(CommonIntentionAction.EMPTY_ARRAY);
    }

    public static boolean isInsideHierarchy(@NotNull PhpClassMember classMember) {
        if (classMember == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(95);
        }
        if (classMember.getModifier().isPrivate()) {
            return false;
        }
        return !PhpClassHierarchyUtils.processOverridingMembers(classMember, PhpClassHierarchyUtils.FALSE_PROCESSOR) || !PhpClassHierarchyUtils.processSuperMembers(classMember, PhpClassHierarchyUtils.FALSE_PROCESSOR);
    }

    private static void createIncompatibleDefaultValueAnnotation(@NotNull AnnotationHolder holder, @NotNull Field field, @NotNull PhpType declaredType, @NotNull PsiElement defaultValue, CommonIntentionAction @NotNull [] fixes) {
        PhpType globalDeclaredType;
        PhpType typesThatCanHaveDefaultValue;
        if (holder == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(96);
        }
        if (field == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(97);
        }
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(98);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(99);
        }
        if (fixes == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(100);
        }
        if (!(typesThatCanHaveDefaultValue = (globalDeclaredType = declaredType.global(defaultValue.getProject())).filterOut((Predicate<String>)Predicates.not(PhpType::isPrimitiveType))).isEmpty()) {
            PhpType mustBeType = PhpType.intersects(typesThatCanHaveDefaultValue, PhpType.ITERABLE) ? typesThatCanHaveDefaultValue.filter(PhpType.ITERABLE).add(PhpType.ARRAY) : typesThatCanHaveDefaultValue;
            PhpAnnotatorVisitor.createErrorAnnotation(holder, defaultValue, PhpBundle.message("php.annotator.typed.property.type.mismatch", mustBeType), fixes);
        } else {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, defaultValue, PhpBundle.message("php.annotator.typed.property.illegal.value", field.isConstant() ? 1 : 0, globalDeclaredType), fixes);
        }
    }

    @Nullable
    private static PhpType getCompatibleType(@NotNull PhpType declaredType, @NotNull PhpType defaultValueType) {
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(101);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(102);
        }
        if (defaultValueType.size() != 1 || defaultValueType.isAmbiguous()) {
            return null;
        }
        if (PhpType.isArray(defaultValueType)) {
            return PhpType.ARRAY;
        }
        if (PhpType.NULL.equals(defaultValueType)) {
            return new PhpType().add(declaredType).add(PhpType.NULL);
        }
        return defaultValueType;
    }

    public static boolean isPropertyDefaultValueTypeCompatible(Field field, @NotNull PhpType fieldDeclaredType, @Nullable PsiElement defaultValue) {
        if (fieldDeclaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(103);
        }
        if (defaultValue == null) {
            return true;
        }
        fieldDeclaredType = fieldDeclaredType.global(field.getProject());
        if (PhpLangUtil.isNull(defaultValue) && !fieldDeclaredType.isNullable() && !PhpType.intersects(fieldDeclaredType, PhpType.MIXED)) {
            return false;
        }
        return PhpAnnotatorVisitor.isParameterDefaultValueCompatibleWithType(defaultValue, fieldDeclaredType, !(field instanceof PhpPromotedFieldParameterImpl));
    }

    @Contract(pure=true)
    public static boolean falseTrueAndBooleanNonCompatible(@NotNull PhpType fieldDeclaredType, @NotNull PhpType defaultValueType) {
        if (fieldDeclaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(104);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(105);
        }
        return (fieldDeclaredType.getTypes().contains("\\false") || fieldDeclaredType.getTypes().contains("\\true")) && defaultValueType.equals(PhpType.BOOLEAN);
    }

    public static TextAttributesKey getInstanceFieldHighlightingData(@Nullable Field field) {
        PhpModifier.Access access = field != null ? field.getModifier().getAccess() : PhpModifier.Access.PUBLIC;
        return switch (access) {
            default -> throw new IncompatibleClassChangeError();
            case PhpModifier.Access.PROTECTED -> PhpHighlightingData.PROTECTED_INSTANCE_FIELD;
            case PhpModifier.Access.PRIVATE -> PhpHighlightingData.PRIVATE_INSTANCE_FIELD;
            case PhpModifier.Access.PUBLIC -> PhpHighlightingData.INSTANCE_FIELD;
        };
    }

    @Override
    public void visitPhpConstant(Constant constant) {
        super.visitPhpConstant(constant);
        if (constant instanceof PhpDefineImpl) {
            PsiElement value;
            PsiElement[] parameters = ((PhpDefineImpl)constant).getParameters();
            if (parameters.length > 1 && !PhpAnnotatorVisitor.allowedDefineValue(value = parameters[1])) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, value, PhpBundle.message("constants.may.only.evaluate.to.scalar.values.arrays.or.resources", new Object[0]), new CommonIntentionAction[0]);
            }
        } else {
            PsiElement value;
            String constantName = constant.getName();
            if (PhpLangUtil.isBuiltInConstant(constantName)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)constant, PhpBundle.message("cannot.redeclare.constant.0", constantName), new CommonIntentionAction[0]);
            }
            if ((value = constant.getValue()) != null && !PhpCodeValidationUtil.isAllowedAsConstantValue(value)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, value, PhpBundle.message("expression.is.not.allowed.as.constant.value", new Object[0]), PhpAnnotatorVisitor.getFix(constant));
            }
            if (PhpAnnotatorVisitor.notAllowedConstantDeclarationPlace(constant)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)constant, PhpBundle.message("constants.defined.using.the.const.keyword.must.be.declared.at.the.top.level.scope", new Object[0]), PhpAnnotatorVisitor.getFix(constant));
            }
        }
    }

    private static CommonIntentionAction[] getFix(Constant constant) {
        CommonIntentionAction[] commonIntentionActionArray;
        PsiElement value = constant.getValue();
        if (value != null && PhpAnnotatorVisitor.allowedDefineValue(value)) {
            CommonIntentionAction[] commonIntentionActionArray2 = new CommonIntentionAction[1];
            commonIntentionActionArray = commonIntentionActionArray2;
            commonIntentionActionArray2[0] = new PhpReplaceWithDefineQuickFix(constant);
        } else {
            commonIntentionActionArray = CommonIntentionAction.EMPTY_ARRAY;
        }
        return commonIntentionActionArray;
    }

    private static boolean allowedDefineValue(PsiElement value) {
        if (PhpLanguageLevel.current((Project)value.getProject()).isAtLeast(PhpLanguageLevel.PHP810)) {
            return true;
        }
        if (value instanceof NewExpression && !(((NewExpression)value).getFirstPsiChild() instanceof PhpClass)) {
            return true;
        }
        PhpIndex index = PhpIndex.getInstance(value.getProject());
        PhpType type = new PhpType().add(value).global(value.getProject());
        return type.isEmpty() || ContainerUtil.exists(type.getTypes(), t -> PhpAnnotatorVisitor.allowedDefineValueType(index, t));
    }

    private static boolean allowedDefineValueType(PhpIndex index, String t) {
        if (PhpType.isAnonymousClass(t)) {
            return false;
        }
        return PhpType.isNotExtendablePrimitiveType(t) || PhpType.isArray(t) || PhpType.isPluralPrimitiveType(t) || !PhpType.nonPrimitiveWithoutToString(t, index);
    }

    public static boolean notAllowedConstantDeclarationPlace(Constant constant) {
        PhpNamedElement namedElement = PhpPsiUtil.getParentOfClass((PsiElement)constant, true, PhpNamedElement.class);
        return namedElement != null && !(namedElement instanceof PhpNamespace) || PhpPsiUtil.getParentByCondition((PsiElement)constant, true, NOT_ALLOWED_STATEMENT) != null;
    }

    @Override
    public void visitPhpModifierList(PhpModifierList modifierList) {
        super.visitPhpModifierList(modifierList);
        PsiElement parent = modifierList.getParent();
        if (parent instanceof Method) {
            PhpAnnotatorVisitor.checkMemberModifiers((Method)parent, modifierList, this.holder);
        }
    }

    @Override
    public void visitPhpNewExpression(NewExpression expression) {
        ParameterList parameterList;
        Collection<? extends PhpNamedElement> elements;
        Collection classes;
        super.visitPhpNewExpression(expression);
        ClassReference classReference = expression.getClassReference();
        PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)expression, PhpClass.class);
        if (classReference != null && !PhpLangUtil.equalsClassNames("static", classReference.getName()) && !(classes = (Collection)StreamEx.of(elements = ClassReferenceImpl.resolveGlobal(classReference, classReference.getName(), classReference.getNamespaceName(), true)).select(PhpClass.class).collect(Collectors.toSet())).isEmpty() && classes.size() == elements.size()) {
            PhpClass clazz = (PhpClass)ContainerUtil.getFirstItem((Collection)classes);
            if (ContainerUtil.and((Iterable)classes, PhpClass::isInterface)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.interface", clazz.getName()), new CommonIntentionAction[0]);
            } else if (ContainerUtil.and((Iterable)classes, PhpClass::isTrait) && !PhpLangUtil.equalsClassNames("self", classReference.getName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.trait", clazz.getName()), new CommonIntentionAction[0]);
            } else if (ContainerUtil.and((Iterable)classes, PhpClass::isAbstract)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.abstract", clazz.getName()), new CommonIntentionAction[0]);
            } else if (ContainerUtil.and((Iterable)classes, PhpClass::isEnum)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.enum", clazz.getName()), new CommonIntentionAction[0]);
            }
            if (ContainerUtil.and((Iterable)classes, c -> PhpAnnotatorVisitor.inaccessibleConstructorExists(containingClass, c))) {
                PhpClass constructorClass;
                Method constructor = clazz.getConstructor();
                PhpClass phpClass = constructorClass = constructor != null ? constructor.getContainingClass() : null;
                if (constructorClass != null) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("call.to.0.1.construct.from.invalid.context", new Object[]{constructor.getAccess(), constructorClass.getName()}), new CommonIntentionAction[0]);
                }
            }
        }
        if (PhpAnnotatorVisitor.hasOnlyVariadicOperator(parameterList = expression.getParameterList())) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameterList.getFirstChild(), PhpBundle.message("cannot.create.closure.for.new.expression", new Object[0]), new CommonIntentionAction[]{new PhpReplaceFirstClassCallableInNewExpressionQuickFix(expression)});
        }
    }

    static boolean hasOnlyVariadicOperator(@Nullable PhpPsiElement elementsList) {
        if (elementsList == null) {
            return false;
        }
        return PhpPsiUtil.isOfType(elementsList.getFirstChild(), PhpTokenTypes.opVARIADIC) && PhpPsiUtil.getNextSiblingIgnoreWhitespace(elementsList.getFirstChild(), true) == null;
    }

    private static boolean inaccessibleConstructorExists(PhpClass containingClass, PhpClass clazz) {
        Method constructor = clazz.getConstructor();
        return constructor != null && !PhpAnnotatorVisitor.constructorAccessibleInContext(constructor, containingClass);
    }

    @Override
    public void visitPhpTraitUseRule(PhpTraitUseRule type) {
        PhpClass aClass;
        ClassReference originalTraitReference;
        MethodReference methodReference;
        super.visitPhpTraitUseRule(type);
        String alias = type.getAlias();
        if (alias != null && (methodReference = type.getOriginalReference()) != null && (originalTraitReference = (ClassReference)ObjectUtils.tryCast((Object)methodReference.getFirstPsiChild(), ClassReference.class)) != null && (aClass = (PhpClass)ObjectUtils.tryCast((Object)originalTraitReference.resolve(), PhpClass.class)) != null && aClass.findMethodByName(alias) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, type.getNameNode(), PhpBundle.message("trait.already.contains.method", aClass.getName(), alias));
        }
        if (type.isInsteadOf()) {
            MethodReference methodReference2;
            Collection<ClassReference> overrides = type.getOverrides();
            if (overrides.isEmpty()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)type, PhpBundle.message("target.trait.should.be.specified", new Object[0]), new CommonIntentionAction[0]);
            }
            if ((methodReference2 = type.getOriginalReference()) == null) {
                return;
            }
            this.checkRequiredTraitsArePresent(overrides, methodReference2);
            ClassReference originalTraitReference2 = (ClassReference)ObjectUtils.tryCast((Object)methodReference2.getFirstPsiChild(), ClassReference.class);
            if (originalTraitReference2 == null) {
                if (methodReference2.getTextLength() != 0) {
                    this.holder.newAnnotation(HighlightSeverity.ERROR, PhpBundle.message("inspection.message.absolute.method.reference.should.be.specified.for.insteadof.trait.use.rule", new Object[0])).range((PsiElement)methodReference2).withFix((CommonIntentionAction)new PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction(methodReference2)).create();
                }
                return;
            }
            PhpClass originalTrait = (PhpClass)ObjectUtils.tryCast((Object)originalTraitReference2.resolve(), PhpClass.class);
            if (originalTrait == null) {
                return;
            }
            for (ClassReference override : overrides) {
                if (!PhpClassHierarchyUtils.classesEqual((PhpClass)ObjectUtils.tryCast((Object)override.resolve(), PhpClass.class), originalTrait)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)override, PhpBundle.message("method.0.can.t.be.overridden.with.same.trait.1", methodReference2.getName(), originalTrait.getName()), new CommonIntentionAction[0]);
            }
        } else if (type.getAlias() != null) {
            MethodReference reference = type.getOriginalReference();
            if (reference == null || reference.getFirstPsiChild() instanceof ClassReference) {
                return;
            }
            List traitsNamesWithResolvedMethod = (List)StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Method.class).map(PhpClassMember::getContainingClass).nonNull().map(PhpNamedElement::getName).collect(Collectors.toList());
            String name = reference.getName();
            if (traitsNamesWithResolvedMethod.size() > 1) {
                CommonIntentionAction[] fixes = (CommonIntentionAction[])ContainerUtil.map2Array((Collection)traitsNamesWithResolvedMethod, CommonIntentionAction.class, traitName -> new PhpMakeReferenceAbsoluteQuickFix((String)traitName));
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("an.alias.was.defined.for.method.0.which.exists.in.1", name, StringUtil.join((Collection)traitsNamesWithResolvedMethod, (String)", ")), fixes);
            }
        }
    }

    public void checkRequiredTraitsArePresent(Collection<? extends ClassReference> overrides, MethodReference methodReference) {
        PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)methodReference, PhpClass.class);
        if (containingClass != null) {
            Set usedTraitNames = CollectionFactory.createCaseInsensitiveStringSet();
            ContainerUtil.addAll((Collection)usedTraitNames, (Object[])containingClass.getTraitNames());
            if (!usedTraitNames.isEmpty()) {
                for (ClassReference classReference : overrides) {
                    String fqn = classReference.getFQN();
                    if (fqn == null || usedTraitNames.contains(fqn)) continue;
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)classReference, PhpBundle.message("required.trait.0.wasn.t.added.to.1", PhpLangUtil.toShortName(fqn), PhpLangUtil.toShortName(containingClass.getFQN())), new CommonIntentionAction[]{new PhpAddTraitUseRuleQuickFix(fqn).asIntention()});
                }
            }
        }
    }

    public static boolean constructorAccessibleInContext(@NotNull Method constructor, @Nullable PhpClass contextClass) {
        if (constructor == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(106);
        }
        return !PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess(constructor.getContainingClass(), contextClass, constructor.getName()).isWeakerThan(constructor.getAccess());
    }

    @Override
    public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
        super.visitPhpThrowExpression(throwExpression);
        PhpExpression argument = throwExpression.getArgument();
        if (argument != null && !PhpAnnotatorVisitor.isCouldBeDerivedFromException(throwExpression.getProject(), argument)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)argument, PhpBundle.message("inspection.wrong.exception.type.problem.throw", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitPhpCatch(Catch phpCatch) {
        super.visitPhpCatch(phpCatch);
        Collection<ClassReference> exceptionTypes = phpCatch.getExceptionTypes();
        for (ClassReference exceptionType : exceptionTypes) {
            if (exceptionType == null || PhpAnnotatorVisitor.isCouldBeDerivedFromException(phpCatch.getProject(), exceptionType)) continue;
            this.holder.newAnnotation(HighlightSeverity.WARNING, PhpBundle.message("inspection.wrong.exception.type.problem.catch", new Object[0])).range((PsiElement)exceptionType).create();
        }
    }

    @Override
    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        Pair<TextRange, String> validationMessage;
        super.visitPhpStringLiteralExpression(expression);
        for (PhpPsiElement psiChild = expression.getFirstPsiChild(); psiChild != null; psiChild = psiChild.getNextPsiSibling()) {
            PhpPsiElement firstPsiChild = psiChild.getFirstPsiChild();
            IElementType type = psiChild.getFirstChild().getNode().getElementType();
            if (psiChild instanceof Variable && firstPsiChild == null || firstPsiChild != null && PhpAnnotatorVisitor.possiblePartOfStringInterpolation(firstPsiChild.getClass(), type)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)psiChild, PhpBundle.message("only.simple.expressions.are.allowed", new Object[0]), new CommonIntentionAction[0]);
        }
        if (expression.isHeredoc() && (validationMessage = PhpFlexibleHeredocHelper.validateHeredocIndentation(expression)) != null) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, (String)validationMessage.second).range(((TextRange)validationMessage.first).shiftRight(expression.getTextRange().getStartOffset())).create();
        }
        super.visitPhpStringLiteralExpression(expression);
    }

    public static boolean possiblePartOfStringInterpolation(Class<? extends PsiElement> element, IElementType firstElementType) {
        return Variable.class.isAssignableFrom(element) || ArrayAccessExpression.class.isAssignableFrom(element) || StringLiteralExpression.class.isAssignableFrom(element) || !PhpTokenTypes.DOLLAR_LBRACE.equals(firstElementType) && !((Object)PhpStubElementTypes.VARIABLE).equals(firstElementType) && (FieldReference.class.isAssignableFrom(element) || MethodReference.class.isAssignableFrom(element) || FunctionReference.class.isAssignableFrom(element));
    }

    public static boolean isCouldBeDerivedFromException(@NotNull Project project, @NotNull PhpTypedElement typedElement) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(107);
        }
        if (typedElement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(108);
        }
        PhpType t = typedElement.getType();
        PhpIndex phpIndex = PhpIndex.getInstance(project);
        if (!PhpType.THROWABLE.isConvertibleFromGlobal(project, t)) {
            for (String type : t.global(project).getTypes()) {
                if (PhpType.isPrimitiveType(type)) continue;
                if (phpIndex.getClassesByFQN(type).isEmpty()) {
                    return true;
                }
                if (phpIndex.getInterfacesByFQN(type).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void visitPhpParameter(Parameter parameter) {
        super.visitPhpParameter(parameter);
        Method method = PhpPsiUtil.getParentOfClass(parameter, Method.class);
        if (method instanceof PhpDocMethod) {
            return;
        }
        boolean parameterTypeIsIncompatible = false;
        PsiElement defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            if (parameter.isVariadic()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("variadic.parameter.cannot.have.a.default.value", new Object[0]), new CommonIntentionAction[0]);
            }
            if (!PhpAnnotatorVisitor.isAllowedAsParameterDefaultValue(defaultValue)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("expression.is.not.allowed.as.parameter.default.value", new Object[0]), new CommonIntentionAction[0]);
                parameterTypeIsIncompatible = true;
            } else if (!parameter.isVariadic() && defaultValue instanceof PhpTypedElement) {
                parameterTypeIsIncompatible = this.checkParameterTypeCompatibility(parameter, (PhpTypedElement)defaultValue);
            }
        }
        if (parameter.isVariadic() && parameter.getNextPsiSibling() != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter, PhpBundle.message("only.the.last.parameter.can.be.variadic", new Object[0]), new CommonIntentionAction[0]);
        }
        for (PsiElement child = parameter.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PhpTypeDeclaration)) continue;
            for (ClassReference classReference : ((PhpTypeDeclaration)child).getClassReferences()) {
                this.checkParameterClassReference(classReference);
            }
        }
        if ("this".equals(parameter.getName())) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter, PhpBundle.message("cannot.use.this.as.parameter", new Object[0]), new CommonIntentionAction[0]);
        }
        if (parameter.isPromotedField()) {
            Function parentFunction;
            if (((PhpPromotedFieldParameterImpl)parameter).isReadonly() && parameter.getTypeDeclaration() == null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter.getNameNode(), PhpBundle.message("readonly.property.must.have.type", new Object[0]));
            }
            if (((Field)((Object)parameter)).isPropertyWithAsymmetricVisibility() && parameter.getTypeDeclaration() == null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter.getNameNode(), PhpBundle.message("php.annotator.property.with.asymmetric.visibility.must.have.type", new Object[0]));
            }
            if (defaultValue != null && parameter.getTypeDeclaration() != null && !parameterTypeIsIncompatible) {
                this.checkTypedPropertyDefaultValue((PhpPromotedFieldParameterImpl)parameter, defaultValue);
            }
            if (!((parentFunction = PhpPsiUtil.getParentOfClass(parameter, Function.class)) instanceof Method) || ((Method)parentFunction).getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter, PhpBundle.message("cannot.declare.promoted.property.outside.a.constructor", new Object[0]), new CommonIntentionAction[0]);
            } else if (((Method)parentFunction).isAbstract()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter, PhpBundle.message("cannot.declare.promoted.property.in.an.abstract.constructor", new Object[0]), new CommonIntentionAction[0]);
            } else if (parameter.isVariadic()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter, PhpBundle.message("cannot.declare.variadic.promoted.property", new Object[0]), new CommonIntentionAction[0]);
            }
            PhpAnnotatorVisitor.checkReadonlyHookedProperty((Field)((Object)parameter), this.holder, parameter.getProject());
            this.checkPromotedPropertyModifiers(parameter);
        }
        this.highlightInfo(parameter.getNameNode(), PhpHighlightingData.PARAMETER);
    }

    private static boolean isAllowedAsParameterDefaultValue(PsiElement defaultValue) {
        return defaultValue instanceof ArrayCreationExpression || PhpCodeValidationUtil.isAllowedAsConstantValue(defaultValue);
    }

    private void checkPromotedPropertyModifiers(Parameter parameter) {
        int visibilityMod = 0;
        int visibilityWriteMod = 0;
        int readonlyMod = 0;
        Project project = parameter.getProject();
        for (PsiElement child = parameter.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.tsVARIABLE_MODIFIERS) && !PhpPsiUtil.isOfType(child, PhpTokenTypes.tsVISIBILITY_MODIFIERS)) {
                PhpDeleteElementQuickFix deleteElementQuickFix = new PhpDeleteElementQuickFix(child);
                CommonIntentionAction[] fixes = PhpPsiUtil.isOfType(child, PhpTokenTypes.kwVAR) ? new CommonIntentionAction[]{deleteElementQuickFix, new PhpReplaceWithPublicQuickFix(child)} : new CommonIntentionAction[]{deleteElementQuickFix};
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("only.visibility.modifiers.can.be.applied.to.promoted.property", new Object[0]), fixes);
            }
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.tsVISIBILITY_MODIFIERS)) {
                if (PhpLanguageFeature.ASYMMETRIC_VISIBILITY.isSupported(project) && PhpModifierListImpl.isSetOperationModifier(child)) {
                    PhpPromotedFieldParameterImpl promotedField = (PhpPromotedFieldParameterImpl)ObjectUtils.tryCast((Object)parameter, PhpPromotedFieldParameterImpl.class);
                    if (promotedField != null) {
                        PhpModifier modifier = promotedField.getModifier();
                        PhpModifier.Access setAccess = modifier.getSetAccess();
                        if (setAccess != null && setAccess.isWeakerThan(modifier.getAccess())) {
                            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("php.annotator.visibility.of.property.must.not.be.weaker.than.set.visibility", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(child)});
                        }
                        PhpAnnotatorVisitor.checkIfAsymmetricVisibilityPropertyIsVirtualAndReadOrWriteOnly(promotedField, child, this.holder);
                    }
                    ++visibilityWriteMod;
                } else {
                    ++visibilityMod;
                }
                if (visibilityMod > 1 || visibilityWriteMod > 1) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("multiple.modifiers.are.not.allowed", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(child)});
                }
            }
            if (!PhpAnnotatorVisitor.isReadonlyKeyword(project, child.getNode()) || ++readonlyMod <= 1) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("multiple.modifiers.are.not.allowed", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(child)});
        }
    }

    private boolean checkParameterTypeCompatibility(Parameter parameter, PhpTypedElement defaultValue) {
        PhpType parameterType = parameter.getDeclaredType().global(parameter.getProject());
        if (PhpAnnotatorVisitor.isParameterDefaultValueCompatibleWithType((PsiElement)defaultValue, parameterType, false)) {
            return false;
        }
        PhpType defaultValueType = defaultValue.getGlobalType();
        PhpType compatibleType = PhpAnnotatorVisitor.getCompatibleType(parameterType, defaultValueType);
        CommonIntentionAction[] fixes = PhpAnnotatorVisitor.getChangeParameterTypeFixes(parameter, (PsiElement)defaultValue, parameterType, compatibleType);
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)defaultValue, PhpBundle.message("argument.passed.must.be.of.the.type.0.1.given", parameterType, defaultValueType), fixes);
        return true;
    }

    public static boolean isParameterDefaultValueCompatibleWithType(PsiElement defaultValue, PhpType parameterType, boolean strict) {
        if (parameterType.isEmpty()) {
            return true;
        }
        PhpType defaultValueType = new PhpType().add(defaultValue).global(defaultValue.getProject());
        return PhpAnnotatorVisitor.isDefaultValueCompatibleWithParameterType(defaultValue.getProject(), parameterType, defaultValue, defaultValueType, strict);
    }

    public static boolean isDefaultValueCompatibleWithParameterType(@NotNull Project project, @NotNull PhpType parameterType, @NotNull PsiElement defaultValue, @NotNull PhpType defaultValueType, boolean strict) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(109);
        }
        if (parameterType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(110);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(111);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(112);
        }
        return PhpAnnotatorVisitor.isDefaultValueCompatibleWithParameterType(project, parameterType, defaultValueType, strict, PhpAnnotatorVisitor.isComputableCompileTimeDefaultValue(defaultValue));
    }

    public static boolean isDefaultValueCompatibleWithParameterType(@NotNull Project project, @NotNull PhpType parameterType, @NotNull PhpType defaultValueType, boolean strict, boolean isComputableCompileTimeDefaultValue) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(113);
        }
        if (parameterType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(114);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(115);
        }
        if (parameterType.isEmpty() || parameterType.equals(PhpType.MIXED)) {
            return true;
        }
        if (defaultValueType.isNullable()) {
            return !(parameterType.hasIntersectionType() && parameterType.size() == 1 || !isComputableCompileTimeDefaultValue && !parameterType.isNullable() && !PhpType.intersects(parameterType, defaultValueType) && !PhpType.intersects(PhpType.MIXED, parameterType));
        }
        if (PhpAnnotatorVisitor.falseTrueAndBooleanNonCompatible(parameterType, defaultValueType)) {
            return false;
        }
        return ContainerUtil.exists(parameterType.filterNull().getTypes(), t -> PhpAnnotatorVisitor.isCompatible(project, t, defaultValueType, strict, isComputableCompileTimeDefaultValue));
    }

    private void checkParameterClassReference(ClassReference classReference) {
        this.checkInvalidClassName(classReference);
        if (PhpAnnotatorVisitor.isStaticKeywordClassReference(classReference)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)classReference, PhpBundle.message("static.is.not.allowed.in.parameter.type.declaration", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitPhpTypeDeclaration(PhpTypeDeclaration typeDeclaration) {
        PhpType type;
        if (PhpLanguageFeature.INTERSECTION_AND_UNION_IN_SAME_TYPE.isSupported(typeDeclaration.getProject())) {
            this.checkCorrectIntersectionAndUnionGroupUsage(typeDeclaration);
        }
        if (typeDeclaration instanceof PhpBackedEnumTypeImpl && !(type = typeDeclaration.getGlobalType()).isEmpty() && !type.equals(PhpType.INT) && !type.equals(PhpType.STRING)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)typeDeclaration, PhpBundle.message("enum.backing.type.must.be.int.or.string", new Object[0]), new CommonIntentionAction[]{new PhpUpdateTypeDeclarationQuickFix(typeDeclaration, PhpType.STRING), new PhpUpdateTypeDeclarationQuickFix(typeDeclaration, PhpType.INT)});
        }
        boolean isUnionTypeSupported = PhpLanguageFeature.UNION_TYPES.isSupported(typeDeclaration.getProject());
        boolean isIntersectionTypeSupported = PhpLanguageFeature.INTERSECTION_TYPES.isSupported(typeDeclaration.getProject());
        boolean isIntersectionType = typeDeclaration.isIntersection();
        Collection<ClassReference> classReferences = typeDeclaration.getClassReferences();
        this.checkFalseAndTrueInSameType(typeDeclaration, classReferences);
        boolean haveNullReference = ContainerUtil.exists(classReferences, c -> PhpType.NULL.equals(c.resolveLocalType()));
        if (haveNullReference && classReferences.size() == 1 && typeDeclaration.isNullable()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, typeDeclaration.getFirstChild(), PhpBundle.message("null.cannot.be.marked.as.nullable", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(typeDeclaration.getFirstChild())});
        }
        for (ClassReference reference : classReferences) {
            boolean isVoid = PhpAnnotatorVisitor.isVoid(reference);
            if (isUnionTypeSupported && (isVoid && typeDeclaration instanceof PhpReturnType || reference.resolveLocalType().equals(PhpType.MIXED)) && classReferences.size() > 1) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("can.only.be.used.as.standalone.type", StringUtil.capitalize((String)reference.getText())), (CommonIntentionAction[])PhpAnnotatorVisitor.getFixesForIncorrectVoidUsages(typeDeclaration, reference));
            } else if (isVoid && !(typeDeclaration instanceof PhpReturnType) && PhpLanguageFeature.RETURN_VOID.isSupported(typeDeclaration.getProject())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("void.can.only.be.used.as.return.type", new Object[0]), (CommonIntentionAction[])PhpAnnotatorVisitor.getFixesForIncorrectVoidUsages(typeDeclaration, reference));
            } else if (PhpLanguageFeature.RETURN_NEVER.isSupported(typeDeclaration.getProject()) && reference.resolveLocalType().equals(PhpType.NEVER)) {
                if (classReferences.size() > 1) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("can.only.be.used.as.standalone.type", StringUtil.capitalize((String)reference.getText())), new CommonIntentionAction[0]);
                } else if (!(typeDeclaration instanceof PhpReturnType)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("never.can.only.be.used.as.return.type", new Object[0]), new CommonIntentionAction[0]);
                }
            }
            if (PhpAnnotatorVisitor.getPluralDimension(reference) > 0) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, PhpAnnotatorVisitor.getRangeUntilLastBracket(reference), PhpBundle.message("plural.types.are.not.allowed.in.real.types", new Object[0]), new CommonIntentionAction[]{new PhpRemoveBracketsFix(), new PhpUpdateTypeFix()});
            }
            if (!isIntersectionTypeSupported || !isIntersectionType || PhpAnnotatorVisitor.isTypeCanBePartOfIntersection(reference)) continue;
            ArrayList<PhpChangeTypeQuickFix> fixes = new ArrayList<PhpChangeTypeQuickFix>();
            if (reference.getType().isNullable() || !haveNullReference || classReferences.size() > 2) {
                fixes.add(new PhpChangeTypeQuickFix(reference, null));
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("type.0.cannot.be.part.of.an.intersection.type", reference.getText()), fixes.toArray(CommonIntentionAction.EMPTY_ARRAY));
        }
        if (isUnionTypeSupported) {
            if (classReferences.size() > 1) {
                if (isIntersectionType && PhpPsiUtil.getChildOfType((PsiElement)typeDeclaration, PhpTokenTypes.opBIT_OR) != null) {
                    IntentionAction[] intentionActionArray;
                    if (PhpLanguageFeature.INTERSECTION_AND_UNION_IN_SAME_TYPE.isSupported(typeDeclaration.getProject()) && PhpPsiUtil.getChildOfType((PsiElement)typeDeclaration, PhpElementTypes.CLASS_REFERENCES_GROUP) == null) {
                        CommonIntentionAction[] commonIntentionActionArray = new CommonIntentionAction[1];
                        intentionActionArray = commonIntentionActionArray;
                        commonIntentionActionArray[0] = new PhpGroupIntersectionTypesQuickFix(typeDeclaration);
                    } else {
                        intentionActionArray = IntentionAction.EMPTY_ARRAY;
                    }
                    IntentionAction[] fixes = intentionActionArray;
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)typeDeclaration, PhpBundle.message("cannot.mix.amp.and.pipe.in.type.declaration", new Object[0]), (CommonIntentionAction[])fixes);
                }
                this.checkDuplicateTypes(typeDeclaration);
                boolean nullReferenceExists = ((PhpTypeDeclarationImpl)typeDeclaration).findNullReference() != null;
                SyntaxTraverser.psiApi().children((Object)typeDeclaration).filter(e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opQUEST)).forEach(quest -> this.registerInvalidNullabilityNotationError((PsiElement)quest, nullReferenceExists, isIntersectionType));
            } else if (typeDeclaration.isNullable() && classReferences.size() == 1 && ((ClassReference)ContainerUtil.getFirstItem(classReferences)).resolveLocalType().equals(PhpType.MIXED)) {
                PsiElement quest2 = typeDeclaration.getFirstChild();
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, quest2, PhpBundle.message("union.types.mixed.cannot.be.nullable", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(quest2, PhpBundle.message("quick.fix.delete", "?"))});
            }
        }
    }

    private void checkCorrectIntersectionAndUnionGroupUsage(PhpTypeDeclaration declaration) {
        List<PsiElement> groups = PhpTypeDeclarationImpl.getClassReferenceGroups(declaration);
        if (groups.isEmpty()) {
            return;
        }
        if (groups.size() == 1 && PhpTypeDeclarationImpl.getDirectClassReferences((PsiElement)declaration).isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)declaration, PhpBundle.message("usage.of.intersection.types.grouping.is.allowed.only.as.part.of.union.type", new Object[0]), new CommonIntentionAction[]{new PhpUnwrapClassReferenceGroupQuickFix(declaration)});
        }
        if (declaration.isIntersection()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)declaration, PhpBundle.message("usage.of.intersection.types.grouping.is.allowed.only.as.part.of.union.type", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithUnionTypeQuickFix(declaration)});
        }
        this.checkPipeOperatorInsideGroups(declaration, groups);
    }

    private void checkPipeOperatorInsideGroups(PhpTypeDeclaration declaration, List<? extends PsiElement> groups) {
        for (PsiElement psiElement : groups) {
            Collection<ClassReference> classReferences = PhpTypeDeclarationImpl.getDirectClassReferences(psiElement);
            if (classReferences.size() == 1) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, psiElement, PhpBundle.message("only.intersection.type.can.be.used.for.grouping", new Object[0]), new CommonIntentionAction[]{new PhpUnwrapClassReferenceQuickFix(psiElement)});
                continue;
            }
            for (PsiElement pipe : PhpPsiUtil.getChildrenOfType(psiElement, PhpTokenTypes.opBIT_OR)) {
                String dnfForm = PhpAnnotatorVisitor.computeDnfForm(declaration);
                if (dnfForm != null) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)declaration, PhpBundle.message("only.intersection.type.can.be.used.for.grouping", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithDnfTypeDeclarationQuickFix(declaration, dnfForm)});
                    return;
                }
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, pipe, PhpBundle.message("only.intersection.type.can.be.used.for.grouping1", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithBitAndQuickFix(pipe)});
            }
        }
    }

    private static String computeDnfForm(PhpTypeDeclaration declaration) {
        ArrayList<String> types = new ArrayList<String>();
        for (Collection<PsiElement> elements : PhpAnnotatorVisitor.splitByUnionType(declaration)) {
            PsiElement onlyItem = (PsiElement)ContainerUtil.getOnlyItem(elements);
            if (PhpPsiUtil.isOfType(onlyItem, PhpElementTypes.CLASS_REFERENCES_GROUP)) {
                return null;
            }
            if (onlyItem != null) {
                types.add(onlyItem.getText());
                continue;
            }
            String dnfType = PhpAnnotatorVisitor.computeDnfTypeFromIntersectionWithGroup(elements);
            if (dnfType == null) {
                return null;
            }
            types.add(dnfType);
        }
        return !types.isEmpty() ? StringUtil.join(types, (String)"|") : null;
    }

    @Nullable
    private static String computeDnfTypeFromIntersectionWithGroup(Collection<? extends PsiElement> elements) {
        PsiElement onlyGroup = (PsiElement)ContainerUtil.getOnlyItem((Collection)ContainerUtil.filter(elements, e -> PhpPsiUtil.isOfType(e, PhpElementTypes.CLASS_REFERENCES_GROUP)));
        if (onlyGroup == null || PhpPsiUtil.getChildOfType(onlyGroup, PhpTokenTypes.opBIT_AND) != null) {
            return null;
        }
        String prefix = StringUtil.join((Collection)ContainerUtil.filter(elements, ClassReference.class::isInstance), PsiElement::getText, (String)"&");
        return PhpTypeDeclarationImpl.getDirectClassReferences(onlyGroup).stream().map(type -> "(" + prefix + "&" + type.getText() + ")").collect(Collectors.joining("|"));
    }

    public static Collection<Collection<PsiElement>> splitByUnionType(PhpTypeDeclaration declaration) {
        ArrayList<Collection<PsiElement>> res = new ArrayList<Collection<PsiElement>>();
        ArrayList<PsiElement> buffer = new ArrayList<PsiElement>();
        for (PsiElement child = declaration.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opBIT_OR)) {
                res.add(new ArrayList(buffer));
                buffer.clear();
                continue;
            }
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opBIT_AND)) continue;
            buffer.add(child);
        }
        if (!buffer.isEmpty()) {
            res.add(buffer);
        }
        return res;
    }

    private void checkFalseAndTrueInSameType(PhpTypeDeclaration typeDeclaration, Collection<? extends ClassReference> classReferences) {
        if (ContainerUtil.exists(classReferences, r -> r.resolveLocalType().equals(PhpType.FALSE)) && ContainerUtil.exists(classReferences, r -> r.resolveLocalType().equals(PhpType.TRUE))) {
            PhpType newType = typeDeclaration.getGlobalType().filter(PhpType.FALSE).filter(PhpType.TRUE).add(PhpType.BOOLEAN);
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)typeDeclaration, PhpBundle.message("type.contains.both.true.and.false.bool.should.be.used.instead", new Object[0]), new CommonIntentionAction[]{new PhpUpdateTypeDeclarationQuickFix(typeDeclaration, newType)});
        }
    }

    private static boolean isTypeCanBePartOfIntersection(@NotNull ClassReference reference) {
        String className;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(116);
        }
        if ("parent".equalsIgnoreCase(className = reference.getName()) || "self".equalsIgnoreCase(className) || "static".equalsIgnoreCase(className)) {
            return false;
        }
        PhpType localType = reference.resolveLocalType();
        PhpType standaloneTypes = PhpType.or(PhpType.MIXED, PhpType.or(PhpType.VOID, PhpType.NEVER));
        if (PhpType.intersects(standaloneTypes, localType)) {
            return true;
        }
        return !ContainerUtil.exists(localType.getTypes(), PhpType::isPrimitiveType);
    }

    private static int getPluralDimension(ClassReference reference) {
        ClassReference sibling = reference;
        int res = 0;
        while (PhpPsiUtil.isOfType((PsiElement)(sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)sibling, true)), PhpTokenTypes.chLBRACKET) && PhpPsiUtil.isOfType((PsiElement)(sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)sibling, true)), PhpTokenTypes.chRBRACKET)) {
            ++res;
        }
        return res;
    }

    @NotNull
    private static TextRange getRangeUntilLastBracket(@NotNull ClassReference reference) {
        PsiElement next;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(117);
        }
        ClassReference lastBracket = reference;
        while (PhpPsiUtil.isOfType(next = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)lastBracket, true), PhpTokenTypes.tsBRACKETS)) {
            lastBracket = next;
        }
        TextRange textRange = TextRange.create((int)reference.getTextRange().getStartOffset(), (int)lastBracket.getTextRange().getEndOffset());
        if (textRange == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(118);
        }
        return textRange;
    }

    private static ModCommandAction[] getFixesForIncorrectVoidUsages(PhpTypeDeclaration typeDeclaration, ClassReference reference) {
        ArrayList<PhpChangeTypeQuickFix> fixes = new ArrayList<PhpChangeTypeQuickFix>();
        PhpType type = typeDeclaration.getType();
        PhpType nonNullableType = type.filterNull();
        if (nonNullableType.size() > 1 && !PhpLanguageFeature.UNION_TYPES.isSupported(typeDeclaration.getProject())) {
            return ModCommandAction.EMPTY_ARRAY;
        }
        if (nonNullableType.equals(PhpType.or(PhpType.FALSE, PhpType.VOID)) || nonNullableType.equals(PhpType.or(PhpType.TRUE, PhpType.VOID))) {
            return ModCommandAction.EMPTY_ARRAY;
        }
        if (nonNullableType.size() > 1 || type.equals(PhpType.VOID) && !(typeDeclaration instanceof PhpReturnType)) {
            fixes.add(new PhpChangeTypeQuickFix(reference, null));
        }
        if (!type.isNullable() && !type.equals(PhpType.VOID)) {
            fixes.add(new PhpChangeTypeQuickFix(reference, PhpType.NULL.toString()));
        }
        return fixes.toArray(ModCommandAction.EMPTY_ARRAY);
    }

    private void checkDuplicateTypes(PhpTypeDeclaration typeDeclaration) {
        MultiMap groupedReferences = ContainerUtil.groupBy(typeDeclaration.getClassReferences(), PsiElement::getParent);
        for (Map.Entry e : groupedReferences.entrySet()) {
            this.checkDuplicateTypes((Collection)e.getValue());
        }
        List<PsiElement> groups = PhpTypeDeclarationImpl.getClassReferenceGroups(typeDeclaration);
        this.checkDuplicateTypes(groups);
        this.checkMoreRestrictiveTypes(groups, ContainerUtil.union(PhpTypeDeclarationImpl.getDirectClassReferences((PsiElement)typeDeclaration), groups));
    }

    private void checkMoreRestrictiveTypes(List<? extends PsiElement> groups, Collection<? extends PsiElement> allTypeDeclarationElements) {
        for (PsiElement psiElement : groups) {
            PhpType type = PhpAnnotatorVisitor.getIntersectionTypesFlatten(psiElement);
            for (PsiElement psiElement2 : allTypeDeclarationElements) {
                PhpType anotherType = PhpAnnotatorVisitor.getIntersectionTypesFlatten(psiElement2);
                if (anotherType.isEmpty() || type.getTypes().size() <= anotherType.getTypes().size() || !type.getTypes().containsAll(anotherType.getTypes())) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, psiElement, PhpBundle.message("type.0.is.redundant.as.it.is.more.restrictive.than.type.1", type.toStringResolved(), anotherType.toStringResolved()), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(psiElement, PhpTokenTypes.opBIT_OR)});
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static PhpType getIntersectionTypesFlatten(PsiElement group) {
        @NlsSafe List types = ContainerUtil.flatten(PhpTypeDeclarationImpl.getTypeDeclarationPartType(group).getTypesIntersections());
        PhpType phpType = PhpType.fromStrings(types);
        if (phpType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(119);
        }
        return phpType;
    }

    private void checkDuplicateTypes(Collection<? extends PsiElement> elements) {
        HashSet<PsiElement> processedReferences = new HashSet<PsiElement>();
        for (PsiElement psiElement : elements) {
            PsiElement duplicatedReference = (PsiElement)ContainerUtil.find(processedReferences, r -> PhpAnnotatorVisitor.isDuplicatedBy(r, reference));
            if (duplicatedReference != null) {
                processedReferences.remove(duplicatedReference);
                this.registerDuplicatedReference(psiElement, duplicatedReference);
                this.registerDuplicatedReference(duplicatedReference, psiElement);
                continue;
            }
            processedReferences.add(psiElement);
        }
    }

    private static boolean isDuplicatedBy(@NotNull PsiElement reference, @NotNull PsiElement possibleDuplicate) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(120);
        }
        if (possibleDuplicate == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(121);
        }
        PhpType referenceFQN = PhpTypeDeclarationImpl.getTypeDeclarationPartType(reference);
        PhpType possibleDuplicateFQN = PhpTypeDeclarationImpl.getTypeDeclarationPartType(possibleDuplicate);
        return PhpAnnotatorVisitor.coveredBy(reference.getProject(), referenceFQN, possibleDuplicateFQN) || PhpAnnotatorVisitor.coveredBy(reference.getProject(), possibleDuplicateFQN, referenceFQN);
    }

    private static boolean coveredBy(@NotNull Project project, PhpType referenceFQN, PhpType possibleDuplicateFQN) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(122);
        }
        if (ContainerUtil.exists(referenceFQN.getTypes(), PhpTypeSignatureKey.POLYMORPHIC_CLASS::isSigned)) {
            return PhpType.OBJECT.equals(possibleDuplicateFQN);
        }
        if (referenceFQN.equals(possibleDuplicateFQN)) {
            return true;
        }
        referenceFQN = referenceFQN.global(project);
        possibleDuplicateFQN = possibleDuplicateFQN.global(project);
        if (PhpType.BOOLEAN.equals(referenceFQN) && (PhpType.FALSE.equals(possibleDuplicateFQN) || PhpType.TRUE.equals(possibleDuplicateFQN))) {
            return true;
        }
        if (!referenceFQN.filterOut(PhpType::isPrimitiveType).isEmpty() && PhpType.OBJECT.equals(possibleDuplicateFQN)) {
            return true;
        }
        return PhpType.ITERABLE.equals(referenceFQN) && (PhpType.TRAVERSABLE.equals(possibleDuplicateFQN) || PhpType.ARRAY.equals(possibleDuplicateFQN));
    }

    private void registerDuplicatedReference(PsiElement reference, PsiElement duplicatedReference) {
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, reference, PhpBundle.message("is.duplicated.by.0", duplicatedReference.getText()), new CommonIntentionAction[]{new PhpRemoveUnionTypeReference(reference, duplicatedReference)});
    }

    private void registerInvalidNullabilityNotationError(PsiElement quest, boolean nullReferenceExists, boolean isIntersectionType) {
        CommonIntentionAction[] fixes = isIntersectionType ? CommonIntentionAction.EMPTY_ARRAY : PhpAnnotatorVisitor.getUnionTypeFixes(quest, nullReferenceExists);
        String message = isIntersectionType ? PhpBundle.message("intersection.types.and.the.nullable.type.notation.cannot.be.mixed", new Object[0]) : PhpBundle.message("union.types.and.the.nullable.type.notation.cannot.be.mixed", new Object[0]);
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, quest, message, fixes);
    }

    @NotNull
    private static @NotNull CommonIntentionAction @NotNull [] getUnionTypeFixes(PsiElement quest, boolean nullReferenceExists) {
        CommonIntentionAction[] commonIntentionActionArray;
        ModCommandAction deleteQuestionMark = new PhpDeleteElementQuickFix(quest, PhpBundle.message("quick.fix.delete", "?")).withPresentation(presentation -> presentation.withPriority(PriorityAction.Priority.LOW));
        if (nullReferenceExists) {
            CommonIntentionAction[] commonIntentionActionArray2 = new CommonIntentionAction[1];
            commonIntentionActionArray = commonIntentionActionArray2;
            commonIntentionActionArray2[0] = deleteQuestionMark;
        } else {
            CommonIntentionAction[] commonIntentionActionArray3 = new CommonIntentionAction[2];
            commonIntentionActionArray3[0] = deleteQuestionMark;
            commonIntentionActionArray = commonIntentionActionArray3;
            commonIntentionActionArray3[1] = new PhpReplaceNullableNotationWithNullAsPartOfUnionType(quest);
        }
        if (commonIntentionActionArray == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(123);
        }
        return commonIntentionActionArray;
    }

    private static boolean isVoid(@Nullable ClassReference classReference) {
        if (classReference == null) {
            return false;
        }
        return PhpType.VOID.equals(classReference.resolveLocalType());
    }

    @Override
    public void visitPhpReturnType(PhpReturnType returnType) {
        super.visitPhpReturnType(returnType);
        for (ClassReference classReference : returnType.getClassReferences()) {
            if (returnType.isNullable() && PhpAnnotatorVisitor.isVoid(classReference)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, PhpBundle.message("void.type.cannot.be.nullable", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(returnType.getFirstChild(), PhpBundle.message("make.non.nullable", new Object[0]))});
            }
            if (returnType.getContainingFile() instanceof PhpTypeCodeFragment || !PhpAnnotatorVisitor.isStaticKeywordClassReference(classReference) || PhpPsiUtil.getParentOfClass((PsiElement)returnType, PhpClass.class) != null) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, PhpBundle.message("cannot.use.static.as.function.return.type.declaration", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    public static boolean isStaticKeywordClassReference(ClassReference classReference) {
        return classReference != null && PhpPsiUtil.isOfType(classReference.getFirstChild(), PhpTokenTypes.kwSTATIC);
    }

    private static boolean isCompatible(@NotNull Project project, String parameterType, @NotNull PhpType defaultValueType, boolean strict, boolean isComputableCompileTimeDefaultValue) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(124);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(125);
        }
        if (!strict && !isComputableCompileTimeDefaultValue || !PhpType.isNotExtendablePrimitiveType(parameterType) && ContainerUtil.all(defaultValueType.getTypes(), t -> !PhpType.isPrimitiveType(t))) {
            if (("\\float".equals(parameterType) || "\\int".equals(parameterType)) && PhpType.intersects(PhpType.STRING, defaultValueType)) {
                return false;
            }
            return new PhpType().add(parameterType).isConvertibleFrom(defaultValueType, PhpIndex.getInstance(project));
        }
        return PhpAnnotatorVisitor.isCompatibleStrict(parameterType, defaultValueType);
    }

    public static boolean isComputableCompileTimeDefaultValue(@NotNull PsiElement defaultValue) {
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(126);
        }
        return ContainerUtil.all(PhpPsiUtil.findChildrenNonStrict(defaultValue, PhpExpression.class), PhpAnnotatorVisitor::isComputableCompileTime);
    }

    private static boolean isComputableCompileTime(@NotNull PsiElement defaultValue) {
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(127);
        }
        return (!(defaultValue instanceof ConstantReference) || PhpLangUtil.isTrue(defaultValue) || PhpLangUtil.isNull(defaultValue) || PhpLangUtil.isFalse(defaultValue)) && !(defaultValue instanceof ClassConstantReference) && !(defaultValue instanceof NewExpression);
    }

    private static boolean isCompatibleStrict(String parameterType, @NotNull PhpType defaultValueType) {
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(128);
        }
        if (PhpType.intersects(defaultValueType, PhpType.MIXED)) {
            return true;
        }
        boolean isFloat = "\\float".equals(parameterType);
        if ((PhpType.isArray(parameterType) || "\\iterable".equals(parameterType)) && ContainerUtil.exists(defaultValueType.getTypes(), t -> PhpType.isArray(t) || PhpType.isPluralType(t))) {
            return true;
        }
        return PhpType.intersects(isFloat ? PhpType.FLOAT_INT : new PhpType().add(parameterType), defaultValueType);
    }

    private void checkInvalidClassName(@Nullable ClassReference element) {
        String type;
        if (element != null && "\\".equals(element.getImmediateNamespaceName()) && PhpLangUtil.isPhpReservedClassName(PhpLangUtil.toName(type = element.getText()))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("annotator.invalid.class.name", type), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitPhpGoto(PhpGoto element) {
        super.visitPhpGoto(element);
        Finally finallyStatement = PhpPsiUtil.getParentOfClass((PsiElement)element, true, Finally.class);
        for (ResolveResult resolveResult : element.multiResolve(false)) {
            PsiElement targetLabel = resolveResult.getElement();
            Finally targetFinally = PhpPsiUtil.getParentOfClass(targetLabel, true, Finally.class);
            if (targetFinally != null && targetFinally != finallyStatement) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("jump.into.a.finally.block.is.disallowed", new Object[0]), new CommonIntentionAction[0]);
                continue;
            }
            if (finallyStatement == null) continue;
            PhpAnnotatorVisitor.checkJumpOutOfFinallyStatement(this.holder, finallyStatement, (PsiElement)element, targetLabel);
        }
    }

    static void checkJumpOutOfFinallyStatement(@NotNull AnnotationHolder holder, @Nullable Finally finallyStatement, @Nullable PsiElement jumpFrom, @Nullable PsiElement jumpTo) {
        if (holder == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(129);
        }
        if (jumpTo != null && finallyStatement != null && !PsiTreeUtil.isAncestor((PsiElement)finallyStatement, (PsiElement)jumpTo, (boolean)true)) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, jumpFrom, PhpBundle.message("annotator.jump.out.of.finally", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    static void checkMemberModifiers(@NotNull PhpClassMember member, @NotNull PhpModifierList modifierList, AnnotationHolder holder) {
        if (member == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(130);
        }
        if (modifierList == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(131);
        }
        nodes = modifierList.getNode().getChildren(null);
        staticMod = 0;
        visibilityMod = 0;
        visibilityWriteMod = 0;
        abstractnessMod = 0;
        finalityMod = 0;
        readonlyMod = 0;
        containingClass = member.getContainingClass();
        modifier = member.getModifier();
        isInterface = containingClass != null && containingClass.isInterface() != false;
        project = member.getProject();
        for (ASTNode node : nodes) {
            block45: {
                block48: {
                    block47: {
                        block46: {
                            block44: {
                                type = node.getElementType();
                                if (!PhpTokenTypes.tsVARIABLE_MODIFIERS.contains(type) && !PhpAnnotatorVisitor.isReadonlyKeyword(project, node)) continue;
                                v0 = isClassConstant = member instanceof Field != false && ((Field)member).isConstant() != false;
                                if (type != PhpTokenTypes.kwSTATIC) break block44;
                                ++staticMod;
                                if (member instanceof Field) {
                                    field = (Field)member;
                                    if (PhpLanguageFeature.PROPERTY_HOOKS.isSupported(project) && field.hasPropertyHooksContainer()) {
                                        PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.cannot.declare.hooks.for.static.property", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                                    }
                                }
                                if (isClassConstant) {
                                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("static.modifier.is.not.allowed.here", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                                }
                                if (containingClass != null && member instanceof Field && containingClass.isReadonly()) {
                                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("cannot.declare.static.properties.in.readonly.class", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(Objects.requireNonNull(FieldImpl.getReadonlyKeyword((PsiElement)containingClass)))});
                                }
                                if (member instanceof PhpPropertyHook) {
                                    PhpAnnotatorVisitor.registerModifierErrorOnPropertyHook(node.getPsi(), "static", holder);
                                }
                                break block45;
                            }
                            if (type != PhpTokenTypes.kwABSTRACT) break block46;
                            if (member instanceof Field) {
                                field = (Field)member;
                                if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP840)) {
                                    if (isInterface) {
                                        PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.property.in.interface.cannot.be.explicitly.abstract", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                                    } else if (!field.hasPropertyHooksContainer()) {
                                        PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.only.hooked.properties.may.be.declared.abstract", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi()), new PhpAddPropertyHooksQuickFix(field)});
                                    } else if (field.getModifier().isPrivate()) {
                                        PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.property.cannot.be.both.abstract.and.private", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                                    }
                                    hooksList = field.getPropertyHooksList();
                                    if (!hooksList.isEmpty() && ContainerUtil.all(hooksList, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkMemberModifiers$73(com.jetbrains.php.lang.psi.elements.PhpPropertyHook ), (Lcom/jetbrains/php/lang/psi/elements/PhpPropertyHook;)Z)())) {
                                        PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.abstract.property.must.specify.at.least.one.hook", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                                    }
                                } else {
                                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("fields.cannot.be.declared.abstract", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi()), new PhpSwitchLanguageLevelModCommandAction(project, PhpLanguageLevel.PHP840)});
                                }
                            } else if (finalityMod > 0 || isInterface || modifier.isPrivate() && (containingClass == null || !containingClass.isTrait())) {
                                PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("abstract.modifier.is.not.allowed.here", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                            } else if (member instanceof PhpPropertyHook) {
                                PhpAnnotatorVisitor.registerModifierErrorOnPropertyHook(node.getPsi(), "abstract", holder);
                            }
                            ++abstractnessMod;
                            break block45;
                        }
                        if (type != PhpTokenTypes.kwFINAL) break block47;
                        if (member instanceof Field && !((Field)member).isConstant()) {
                            if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP840)) {
                                if (isInterface) {
                                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.property.in.interface.cannot.be.final", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                                } else if (member.getModifier().isPrivate()) {
                                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.property.cannot.be.both.final.and.private", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                                }
                            } else {
                                PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("fields.cannot.be.declared.final", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi()), new PhpSwitchLanguageLevelModCommandAction(project, PhpLanguageLevel.PHP840)});
                            }
                        } else if ((abstractnessMod > 0 || isInterface) && !isClassConstant) {
                            PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("final.modifier.is.not.allowed.here", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                        } else if (isClassConstant && modifier.isPrivate() && PhpLanguageFeature.FINAL_CLASS_CONSTANTS.isSupported(project)) {
                            PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("private.constant.cannot.be.final", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                        } else if (member instanceof PhpPropertyHook && (hook = (PhpPropertyHook)member).getModifier().isPrivate()) {
                            PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.property.hook.cannot.be.both.final.and.private", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                        } else if (member instanceof PhpPropertyHook && (hook = (PhpPropertyHook)member).isAbstract()) {
                            PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.property.hook.cannot.be.both.abstract.and.final", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                        }
                        ++finalityMod;
                        break block45;
                    }
                    if (!PhpAnnotatorVisitor.isReadonlyKeyword(project, node)) break block48;
                    if (member instanceof Field) {
                        field = (Field)member;
                        if (PhpLanguageFeature.PROPERTY_HOOKS.isSupported(project) && field.hasPropertyHooksContainer()) {
                            message = PhpBundle.message("php.annotator.hooked.properties.cannot.be.readonly", new Object[0]);
                            PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), message, new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                        }
                    }
                    if (modifierList.hasStatic()) {
                        PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("static.property.cannot.be.readonly", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                    }
                    if (member instanceof PhpPropertyHook) {
                        PhpAnnotatorVisitor.registerModifierErrorOnPropertyHook(node.getPsi(), "readonly", holder);
                    }
                    ++readonlyMod;
                    break block45;
                }
                if (!PhpTokenTypes.tsVISIBILITY_MODIFIERS.contains(type)) break block45;
                if (isInterface && (PhpTokenTypes.kwPRIVATE == type || PhpTokenTypes.kwPROTECTED == type) && !PhpModifierListImpl.isSetOperationModifier(node)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("access.type.for.interface.member.must.be.omitted", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                }
                if (member instanceof PhpPropertyHook) {
                    PhpAnnotatorVisitor.registerModifierErrorOnPropertyHook(node.getPsi(), type.toString(), holder);
                }
                if (!PhpLanguageFeature.ASYMMETRIC_VISIBILITY.isSupported(project) || !(member instanceof Field)) ** GOTO lbl-1000
                field = (Field)member;
                if (PhpModifierListImpl.isSetOperationModifier(node)) {
                    setAccess = modifier.getSetAccess();
                    if (setAccess != null && setAccess.isWeakerThan(modifier.getAccess())) {
                        PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("php.annotator.visibility.of.property.must.not.be.weaker.than.set.visibility", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
                    }
                    PhpAnnotatorVisitor.checkIfAsymmetricVisibilityPropertyIsVirtualAndReadOrWriteOnly(field, node.getPsi(), holder);
                    ++visibilityWriteMod;
                } else lbl-1000:
                // 2 sources

                {
                    ++visibilityMod;
                }
            }
            if (staticMod <= 1 && abstractnessMod <= 1 && finalityMod <= 1 && visibilityMod <= 1 && readonlyMod <= 1 && visibilityWriteMod <= true) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("multiple.modifiers.are.not.allowed", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node.getPsi())});
        }
    }

    private static void checkReadonlyHookedProperty(@NotNull Field field, AnnotationHolder holder, Project project) {
        if (field == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(132);
        }
        if (PhpLanguageFeature.PROPERTY_HOOKS.isSupported(project) && field.hasPropertyHooksContainer()) {
            PsiElement readonlyKw = FieldImpl.getReadonlyKeyword(field);
            if (readonlyKw == null) {
                return;
            }
            String message = PhpBundle.message("php.annotator.hooked.properties.cannot.be.readonly", new Object[0]);
            PhpAnnotatorVisitor.createErrorAnnotation(holder, readonlyKw, message, new CommonIntentionAction[]{new PhpDeleteElementQuickFix(readonlyKw)});
        }
    }

    private static void checkIfAsymmetricVisibilityPropertyIsVirtualAndReadOrWriteOnly(Field field, PsiElement node, AnnotationHolder holder) {
        if (field.getModifier().getSetAccess() == null || !field.isVirtualProperty()) {
            return;
        }
        Ref hasSetHook = new Ref((Object)(ContainerUtil.find(field.getPropertyHooksList(), PhpPropertyHook.IS_SET_HOOK) != null ? 1 : 0));
        Ref hasGetHook = new Ref((Object)(ContainerUtil.find(field.getPropertyHooksList(), PhpPropertyHook.IS_GET_HOOK) != null ? 1 : 0));
        if (((Boolean)hasGetHook.get()).booleanValue() && ((Boolean)hasSetHook.get()).booleanValue()) {
            return;
        }
        PhpClassHierarchyUtils.processSuperFields(field, (superField, superClass, baseClass) -> {
            if (!((Boolean)hasSetHook.get()).booleanValue()) {
                hasSetHook.set((Object)(ContainerUtil.find(superField.getPropertyHooksList(), PhpPropertyHook.IS_SET_HOOK) != null ? 1 : 0));
            }
            if (!((Boolean)hasGetHook.get()).booleanValue()) {
                hasGetHook.set((Object)(ContainerUtil.find(superField.getPropertyHooksList(), PhpPropertyHook.IS_GET_HOOK) != null ? 1 : 0));
            }
            return (Boolean)hasSetHook.get() == false || (Boolean)hasGetHook.get() == false;
        });
        if (!((Boolean)hasSetHook.get()).booleanValue()) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, node, PhpBundle.message("php.annotator.read.only.virtual.property.must.not.specify.asymmetric.visibility", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node)});
        } else if (!((Boolean)hasGetHook.get()).booleanValue()) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, node, PhpBundle.message("php.annotator.write.only.virtual.property.must.not.specify.asymmetric.visibility", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(node)});
        }
    }

    private static void registerModifierErrorOnPropertyHook(PsiElement psi, String modifier, AnnotationHolder holder) {
        PhpAnnotatorVisitor.createErrorAnnotation(holder, psi, PhpBundle.message("php.annotator.cannot.use.the.0.modifier.on.a.property.hook", modifier), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(psi)});
    }

    public static boolean isReadonlyKeyword(@NotNull Project project, @NotNull ASTNode node) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(133);
        }
        if (node == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(134);
        }
        return PhpLanguageFeature.READONLY_PROPERTIES.isSupported(project) && FieldImpl.isReadonlyKeyword(node);
    }

    private void checkClassRefsOfAppropriateType(PhpClass clazz, boolean expectingInterfaces, @NotNull List<? extends ClassReference> referenceElements) {
        if (referenceElements == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(135);
        }
        for (ClassReference classReference : referenceElements) {
            PsiElement element = classReference.resolve();
            if (!(element instanceof PhpClass) || ((PhpClass)element).isInterface() == expectingInterfaces) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)classReference, PhpBundle.message(expectingInterfaces ? "php.annotator.expecting.interface" : "php.annotator.expecting.class", new Object[0]), new CommonIntentionAction[]{new PhpExchangeExtendsImplementsQuickFix(clazz, classReference)});
        }
    }

    private void checkCorrectReturnGeneratorType(@NotNull Function function) {
        PhpTypeDeclaration returnType;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(136);
        }
        if ((returnType = function.getTypeDeclaration()) == null || returnType.getTextLength() == 0) {
            return;
        }
        PhpType declaredType = function.getDeclaredType().global(function.getProject());
        if (PhpType.intersects(PhpInconsistentReturnPointsInspection.GENERATOR_TYPE, declaredType) || PhpInconsistentReturnPointsInspection.isProbablyGenerator(declaredType)) {
            return;
        }
        String type = declaredType.toStringRelativized(function.getNamespaceName());
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, PhpBundle.message("inspection.message.generators.may.only.declare.return.type.generator.iterator.or.traversable.or.iterable.permitted", type), new CommonIntentionAction[0]);
    }

    public static boolean allowedPlaceForStrictTypesDeclareStatement(PsiElement place) {
        PsiElement phpOpeningTag = place.getParent().getFirstChild();
        if (PhpAnnotatorVisitor.isShebang(phpOpeningTag)) {
            phpOpeningTag = phpOpeningTag.getNextSibling();
        }
        PsiElement declare = PhpPsiUtil.getNextSibling(phpOpeningTag, Conditions.not(Statement.INSTANCEOF));
        return PhpPsiUtil.isOfType(phpOpeningTag, PhpTokenTypes.PHP_OPENING_TAG) && place == declare;
    }

    @Override
    public void visitPhpElement(PhpPsiElement element) {
        if (element instanceof PhpDocComment) {
            PhpClass clazz = (PhpClass)ObjectUtils.tryCast((Object)((PhpDocComment)element).getOwner(), PhpClass.class);
            if (clazz == null) {
                return;
            }
            this.markDuplicateMethods(clazz, true);
            this.markDuplicateFields(clazz, true);
        }
    }

    private void markDuplicateMethods(PhpClass clazz, boolean docMethods) {
        HashSet dynamicMethodNames = new HashSet();
        HashSet staticMethodNames = new HashSet();
        HashMap dynamicDocMethodNames = new HashMap();
        HashMap staticDocMethodNames = new HashMap();
        PhpClassHierarchyUtils.processMethods(clazz, clazz, (method, subClass, baseClass) -> {
            String name = StringUtil.toLowerCase((String)method.getName());
            if (!StringUtil.isEmpty((String)name)) {
                Set alreadyProcessedMethodsToCheck;
                Set methods = method.isStatic() ? staticMethodNames : dynamicMethodNames;
                Map phpDocMethods = method.isStatic() ? staticDocMethodNames : dynamicDocMethodNames;
                Collection<String> alreadyProcessedDocMethodsToCheck = PhpAnnotatorVisitor.getAlreadyProcessedDocMethodsToCheck(method, docMethods, dynamicDocMethodNames, staticDocMethodNames);
                Set set = alreadyProcessedMethodsToCheck = docMethods && method instanceof PhpDocMethod ? ContainerUtil.union((Collection)methods, alreadyProcessedDocMethodsToCheck) : ContainerUtil.union((Collection)ContainerUtil.union((Set)staticMethodNames, (Set)dynamicMethodNames), alreadyProcessedDocMethodsToCheck);
                if (docMethods == method instanceof PhpDocMethod && alreadyProcessedMethodsToCheck.contains(name)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, method.getNameIdentifier(), PhpBundle.message("method.with.same.name.already.defined.in.this.class", new Object[0]), new CommonIntentionAction[0]);
                }
                if (docMethods && method instanceof PhpDocMethod) {
                    PhpDocMethod docMethod = (PhpDocMethod)method;
                    PhpDocTag tag = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)docMethod, PhpDocTag.INSTANCEOF, PhpDocComment.INSTANCEOF);
                    if (tag == null) {
                        return true;
                    }
                    phpDocMethods.computeIfAbsent(tag.getName(), k -> new HashSet());
                    ((Set)phpDocMethods.get(tag.getName())).add(name);
                } else {
                    methods.add(name);
                }
            }
            return true;
        }, true, false);
    }

    private static Collection<String> getAlreadyProcessedDocMethodsToCheck(@NotNull Method method, boolean docMethods, Map<String, Set<String>> dynamicDocMethods, Map<String, Set<String>> staticDocMethods) {
        if (method == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(137);
        }
        if (docMethods && method instanceof PhpDocMethod) {
            PhpDocTag tag = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)method, PhpDocTag.INSTANCEOF, PhpDocComment.INSTANCEOF);
            if (tag == null) {
                return Collections.emptyList();
            }
            if (method.isStatic()) {
                return staticDocMethods.getOrDefault(tag.getName(), Collections.emptySet());
            }
            return dynamicDocMethods.getOrDefault(tag.getName(), Collections.emptySet());
        }
        return ContainerUtil.union(staticDocMethods.values().stream().flatMap(StreamEx::of).toList(), dynamicDocMethods.values().stream().flatMap(StreamEx::of).toList());
    }

    public static boolean isShebang(@NotNull PsiElement element) {
        PsiFile htmlFile;
        PsiFile phpFile;
        if (element == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(138);
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.HTML) && (phpFile = element.getContainingFile()) != null && (htmlFile = phpFile.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE)) != null) {
            element = htmlFile.findElementAt(element.getTextOffset());
        }
        if (PhpPsiUtil.isOfType(element, XmlTokenType.XML_DATA_CHARACTERS) && element.getText().startsWith("#!")) {
            PsiElement next = element.getNextSibling();
            while (next instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(next, XmlTokenType.XML_DATA_CHARACTERS)) {
                String text;
                int lineBreak;
                if (next instanceof PsiWhiteSpace && (lineBreak = (text = next.getText()).indexOf(10)) != -1) {
                    if (lineBreak != text.length() - 1) break;
                    next = next.getNextSibling();
                    break;
                }
                next = next.getNextSibling();
            }
            if (next == null) {
                next = element.getParent().getNextSibling();
            }
            if (PhpPsiUtil.isOfType(next, PhpElementTypes.PHP_OUTER_TYPE)) {
                return true;
            }
        }
        return false;
    }

    private void highlightInfo(@Nullable ASTNode node, TextAttributesKey textAttributeKey) {
        if (node == null) {
            return;
        }
        @NlsSafe String name = textAttributeKey.getExternalName();
        (isUnitTestMode ? this.holder.newAnnotation(HighlightSeverity.INFORMATION, name) : this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(node.getTextRange()).textAttributes(textAttributeKey).create();
    }

    @Override
    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        super.visitPhpMatchExpression(matchExpression);
        this.checkMatchArgumentIsHandled(matchExpression);
    }

    @Override
    public void visitPhpEnumCase(PhpEnumCase enumCase) {
        PhpExpression enumCaseExpression = enumCase.getExpression();
        if (enumCaseExpression != null) {
            if (!PhpCodeValidationUtil.checkStaticAllowedExpression((PsiElement)enumCaseExpression, ALLOWED_ENUM_CASES_EXPRESSIONS)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)enumCaseExpression, PhpBundle.message("enum.case.value.must.be.constant", new Object[0]), new CommonIntentionAction[0]);
            } else {
                PhpType expressionType;
                if (!PhpLanguageLevel.current((Project)enumCase.getProject()).isAtLeast(PhpLanguageLevel.PHP820)) {
                    this.highlightEnumCaseReferences(enumCaseExpression);
                }
                if (!PhpAnnotatorVisitor.isExpressionTypeIsSuitableForBackedEnum(expressionType = enumCaseExpression.getGlobalType())) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)enumCaseExpression, PhpBundle.message("enum.backing.type.must.be.int.or.string.0.given", expressionType), new CommonIntentionAction[0]);
                }
            }
        }
        PhpSplitIdentifiersToEnumCasesQuickFix fix = new PhpSplitIdentifiersToEnumCasesQuickFix(enumCase);
        PhpAnnotatorVisitor.processRedundantEnumCaseNameIdentifiers(enumCase, identifier -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, identifier, PhpBundle.message("multiple.enum.identifiers.should.be.stated.in.different.cases", new Object[0]), new CommonIntentionAction[]{fix}));
    }

    private void highlightEnumCaseReferences(PhpExpression enumCaseExpression) {
        for (ClassConstantReference reference : PhpPsiUtil.findChildrenNonStrict((PsiElement)enumCaseExpression, ClassConstantReference.class)) {
            Collection<PhpClassMember> resolvedMembers = reference.multiResolveStrict(PhpClassMember.class);
            if (resolvedMembers.isEmpty()) continue;
            if (!ContainerUtil.all(resolvedMembers, PhpEnumCase.class::isInstance)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("enum.value.cannot.referer.to.enum.cases", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private static void processRedundantEnumCaseNameIdentifiers(PhpEnumCase enumCase, Consumer<? super PsiElement> consumer) {
        Object identifier = enumCase.getNameIdentifier();
        while (identifier != null && (identifier = PhpPsiUtil.getNextSiblingByCondition(identifier, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.IDENTIFIER)))) != null) {
            consumer.accept((PsiElement)identifier);
        }
    }

    private void checkMatchArgumentIsHandled(@NotNull PhpMatchExpression matchExpression) {
        PhpExpression argument;
        if (matchExpression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(139);
        }
        if ((argument = matchExpression.getArgument()) == null || matchExpression.getDefaultMatchArm() != null) {
            return;
        }
        Project project = matchExpression.getProject();
        PhpType argumentType = argument.getGlobalType();
        if (argumentType.isEmpty() || PhpType.intersects(argumentType, PhpType.MIXED) || argumentType.hasUnknown()) {
            return;
        }
        PhpType cumulativeConditionsType = new PhpType();
        for (PhpExpression condition : PhpMatchExpressionImpl.getAllConditions(matchExpression)) {
            cumulativeConditionsType.add(condition.getType());
        }
        if (!PhpStrictTypeCheckingInspection.isTypeCompatible(argumentType, cumulativeConditionsType.global(project))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)argument, PhpBundle.message("annotator.unhandled.match.argument", new Object[0]), new CommonIntentionAction[]{new PhpAddDefaultMatchArmQuickFix((PsiElement)argument)});
        }
    }

    @Override
    public void visitPhpAttribute(PhpAttribute attribute) {
        for (PsiElement parameter : attribute.getParameters()) {
            if (PhpCodeValidationUtil.isAllowedAsConstantValue(parameter) || PhpPsiUtil.isArgumentUnpacking(parameter)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter, PhpBundle.message("constant.expression.contains.invalid.operations", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitPhpGlobal(Global globalStatement) {
        Variable thisVariable;
        if (PhpProjectConfigurationFacade.getInstance(globalStatement.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP710) && (thisVariable = (Variable)ContainerUtil.find((Object[])globalStatement.getVariables(), variable -> "this".equalsIgnoreCase(variable.getName()))) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)thisVariable, PhpBundle.message("global.this.is.deprecated", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private static void removeBrackets(@NotNull ClassReference classReference) {
        PsiElement sibling;
        if (classReference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(140);
        }
        while (PhpPsiUtil.isOfType(sibling = classReference.getNextSibling(), PhpTokenTypes.tsBRACKETS)) {
            sibling.delete();
        }
    }

    private static void replaceMultiAssignmentElement(@NotNull Project project, @NotNull PsiElement element, PsiElement lParen, PsiElement rParen, String format) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(141);
        }
        if (element == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(142);
        }
        if (lParen == null || rParen == null) {
            return;
        }
        String elementsText = element.getText().substring(lParen.getTextRangeInParent().getEndOffset(), rParen.getTextRangeInParent().getStartOffset());
        String arrayText = String.format(format, elementsText);
        MultiassignmentExpression multiAssignment = PhpPsiElementFactory.createPhpPsiFromText(project, MultiassignmentExpression.class, String.format("list(%s) = $a;", arrayText));
        element.replace((PsiElement)multiAssignment.getFirstPsiChild());
    }

    private static /* synthetic */ boolean lambda$checkMemberModifiers$73(PhpPropertyHook it) {
        return !it.isAbstract();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 12, 13, 18, 19, 20, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 52, 55, 56, 59, 60, 62, 118, 119, 123 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: 
            case 5: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 62: 
            case 118: 
            case 119: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor";
                break;
            }
            case 7: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 34: 
            case 64: 
            case 116: 
            case 117: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReference";
                break;
            }
            case 9: 
            case 138: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 96: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQN";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentClasses";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringClass";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 51: 
            case 66: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traitMethod";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalTraitFqn";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 68: 
            case 71: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnTypeElement";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 83: 
            case 85: 
            case 97: 
            case 132: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 84: 
            case 86: 
            case 89: 
            case 91: 
            case 99: 
            case 111: 
            case 126: 
            case 127: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 87: 
            case 90: 
            case 92: 
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeFixerFactory";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 102: 
            case 105: 
            case 112: 
            case 115: 
            case 125: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueType";
                break;
            }
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldDeclaredType";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedElement";
                break;
            }
            case 110: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleDuplicate";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElements";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchExpression";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyedEntries";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeWithColon";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAccess";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCurrentScope";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosureBoundType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosureBoundClassesFromVariableUsage";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getReboundScopeType";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictestAccessibleInContextReferenceAccess";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "findForbiddenMethodNames";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitsExcludedFromConflicts";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictingTraitFqn";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "unionMethodsNames";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeUntilLastBracket";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersectionTypesFlatten";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionTypeFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnum";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReadonlyClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allResolvedTypesSatisfyCondition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkBitShiftByNegativeNumber";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkOperatorsArraySupport";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 62: 
            case 118: 
            case 119: 
            case 123: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportNullSafeOperatorsInFirstClassCallableSyntax";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNullSafeOperator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportIncompleteSpreadOperators";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkClassNameLiteral";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedToCurrentClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightMethodReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveAccess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessModifiers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isMockeryReferenceWithAllowProtectedCall";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getStrictestAccessibleInContextReferenceAccess";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "protectedAccessAccessibleInContext";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasCommonSuper";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveThis";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "canBeUsedAsLexicalVariable";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperClassModifiers";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkTraitMethodsConflictsWithAppliedMethods";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getTraitsExcludedFromConflicts";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getConflictingTraitFqn";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getTargetReferenceFqn";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addAllSuperInterfaces";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotation";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "checkNoReturnArgumentForVoidFunction";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getChangeReturnTypeFix";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnStatementNullability";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "hasNonNullableSuperMethods";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "checkArrowFunctionReturnType";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "checkParametersRedefinition";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "expressionHasReferenceToConstant";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "checkTypedPropertyDefaultValue";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getChangeFieldTypeFixes";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getChangeParameterTypeFixes";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getChangeTypeFixes";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isInsideHierarchy";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleDefaultValueAnnotation";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibleType";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyDefaultValueTypeCompatible";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "falseTrueAndBooleanNonCompatible";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "constructorAccessibleInContext";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isCouldBeDerivedFromException";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultValueCompatibleWithParameterType";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCanBePartOfIntersection";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getRangeUntilLastBracket";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicatedBy";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "coveredBy";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isComputableCompileTimeDefaultValue";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isComputableCompileTime";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleStrict";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "checkJumpOutOfFinallyStatement";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "checkMemberModifiers";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "checkReadonlyHookedProperty";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isReadonlyKeyword";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "checkClassRefsOfAppropriateType";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "checkCorrectReturnGeneratorType";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getAlreadyProcessedDocMethodsToCheck";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "isShebang";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "checkMatchArgumentIsHandled";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "removeBrackets";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "replaceMultiAssignmentElement";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChangeParameterTypeFixes$57";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChangeFieldTypeFixes$56";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 12, 13, 18, 19, 20, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 52, 55, 56, 59, 60, 62, 118, 119, 123 -> new IllegalStateException(string);
        };
    }

    private static class PhpReplaceWithArrayQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        protected PhpReplaceWithArrayQuickFix(@NotNull PsiElement listElement) {
            if (listElement == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(0);
            }
            super(listElement);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(3);
            }
            ASTNode node = element.getNode();
            ASTNode lParen = node.findChildByType(PhpTokenTypes.chLPAREN);
            ASTNode rParen = PhpPsiUtil.getLastChildByType(node, PhpTokenTypes.chRPAREN);
            if (lParen != null && rParen != null) {
                PhpAnnotatorVisitor.replaceMultiAssignmentElement(context.project(), element, lParen.getPsi(), rParen.getPsi(), "[%s]");
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.array", new Object[0]);
            if (string == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithArrayQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithArrayQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceWithListQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private PhpReplaceWithListQuickFix(@NotNull PsiElement array) {
            if (array == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(0);
            }
            super(array);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(3);
            }
            PhpAnnotatorVisitor.replaceMultiAssignmentElement(context.project(), element.getParent(), element.getFirstChild(), element.getLastChild(), "list(%s)");
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.list", new Object[0]);
            if (string == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithListQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithListQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpResolvedElementAccessDescriptor {
        static final PhpResolvedElementAccessDescriptor PUBLIC = new PhpResolvedElementAccessDescriptor(PhpModifier.Access.PUBLIC, PhpModifier.Access.PUBLIC, null);
        @NotNull
        private final PhpModifier.Access myResolvedElementAccess;
        @NotNull
        private final PhpModifier.Access myAccessibleInContextAccess;
        @Nullable
        private final String myResolvedClassMagicMethodName;

        private PhpResolvedElementAccessDescriptor(@NotNull PhpModifier.Access resolvedElementAccess, @NotNull PhpModifier.Access accessibleInContextAccess, @Nullable String resolvedClassMagicMethodName) {
            if (resolvedElementAccess == null) {
                PhpResolvedElementAccessDescriptor.$$$reportNull$$$0(0);
            }
            if (accessibleInContextAccess == null) {
                PhpResolvedElementAccessDescriptor.$$$reportNull$$$0(1);
            }
            this.myResolvedElementAccess = resolvedElementAccess;
            this.myAccessibleInContextAccess = accessibleInContextAccess;
            this.myResolvedClassMagicMethodName = resolvedClassMagicMethodName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolvedElementAccess";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessibleInContextAccess";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpResolvedElementAccessDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDeleteEnumBackedTypeQuickFix
    extends PsiUpdateModCommandAction<PhpClass> {
        private PhpDeleteEnumBackedTypeQuickFix(@NotNull PhpClass clazz) {
            if (clazz == null) {
                PhpDeleteEnumBackedTypeQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)clazz);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpClass element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpDeleteEnumBackedTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpDeleteEnumBackedTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpDeleteEnumBackedTypeQuickFix.$$$reportNull$$$0(3);
            }
            PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getChildByCondition((PsiElement)element, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
            PsiElement opColon = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)typeDeclaration, true);
            if (typeDeclaration != null && PhpPsiUtil.isOfType(opColon, PhpTokenTypes.opCOLON)) {
                element.deleteChildRange(opColon, (PsiElement)typeDeclaration);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.backed.type.from.containing.enum", new Object[0]);
            if (string == null) {
                PhpDeleteEnumBackedTypeQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteEnumBackedTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteEnumBackedTypeQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpDeleteCaseInitExpressionQuickFix
    extends PsiUpdateModCommandAction<PhpEnumCase> {
        private PhpDeleteCaseInitExpressionQuickFix(@NotNull PhpEnumCase aCase) {
            if (aCase == null) {
                PhpDeleteCaseInitExpressionQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)aCase);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpEnumCase element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpDeleteCaseInitExpressionQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpDeleteCaseInitExpressionQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpDeleteCaseInitExpressionQuickFix.$$$reportNull$$$0(3);
            }
            PhpExpression expression = element.getExpression();
            PsiElement opAsgn = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)expression, true);
            if (expression != null && PhpPsiUtil.isOfType(opAsgn, PhpTokenTypes.opASGN)) {
                element.deleteChildRange(opAsgn, (PsiElement)expression);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.delete.initializer", new Object[0]);
            if (string == null) {
                PhpDeleteCaseInitExpressionQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aCase";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteCaseInitExpressionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteCaseInitExpressionQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpAddEnumBackedTypeQuickFix
    extends PsiUpdateModCommandAction<PhpClass> {
        private final PhpType myBackedType;

        private PhpAddEnumBackedTypeQuickFix(@NotNull PhpClass phpClass, PhpType backedType) {
            if (phpClass == null) {
                PhpAddEnumBackedTypeQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)phpClass);
            this.myBackedType = backedType;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpClass element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddEnumBackedTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddEnumBackedTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddEnumBackedTypeQuickFix.$$$reportNull$$$0(3);
            }
            PhpAddEnumBackedTypeQuickFix.insertBackedType(context.project(), element, this.myBackedType);
        }

        public static void insertBackedType(Project project, PhpClass clazz, PhpType type) {
            PsiElement backedType;
            PsiElement nameIdentifier = clazz.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            PsiElement opColon = PhpPsiUtil.getNextSiblingIgnoreWhitespace(nameIdentifier, true);
            if (!PhpPsiUtil.isOfType(opColon, PhpTokenTypes.opCOLON)) {
                opColon = clazz.addAfter(PhpPsiElementFactory.createColon(project), nameIdentifier);
            }
            if ((backedType = PhpPsiUtil.getNextSiblingIgnoreWhitespace(opColon, true)) instanceof PhpTypeDeclaration) {
                return;
            }
            PhpTypeDeclaration backedTypeToInsert = PhpPsiElementFactory.createPhpPsiFromText(project, PhpTypeDeclaration.class, "<?php enum a : " + type.toString() + " {}");
            opColon.getParent().addAfter((PsiElement)backedTypeToInsert, opColon);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.to.containing.enum", this.myBackedType.toString());
            if (string == null) {
                PhpAddEnumBackedTypeQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddEnumBackedTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddEnumBackedTypeQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceWithConstantQuickFix
    extends PsiUpdateModCommandAction<Field> {
        private PhpReplaceWithConstantQuickFix(@NotNull Field field) {
            if (field == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)field);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Field startElement, @NotNull ModPsiUpdater updater) {
            PhpClassFieldsList originalList;
            PhpClassFieldsList list;
            Field field;
            PsiElement defaultValue;
            if (context == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(3);
            }
            if ((defaultValue = (field = (Field)ContainerUtil.getFirstItem((list = FieldImpl.copyListWithSingleField(startElement, originalList = (PhpClassFieldsList)startElement.getParent())).getFields())).getDefaultValue()) == null) {
                return;
            }
            String text = list.getText();
            String constantText = String.format("class a{%s const %s = %s;}", text.substring(0, field.getTextRangeInParent().getStartOffset()), field.getName(), defaultValue.getText());
            originalList.getParent().addBefore((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(context.project(), PhpClassConstantsListImpl.class, constantText), (PsiElement)originalList);
            PhpMoveClassMemberBase.removeFieldWithPhpDoc(startElement);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.class.constant", new Object[0]);
            if (string == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithConstantQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithConstantQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpDeleteFieldQuickFix
    extends PsiUpdateModCommandAction<Field> {
        private PhpDeleteFieldQuickFix(@NotNull Field field) {
            if (field == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)field);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Field field, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(1);
            }
            if (field == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(3);
            }
            PhpMoveClassMemberBase.removeFieldWithPhpDoc(field);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.delete.field", new Object[0]);
            if (string == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteFieldQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteFieldQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpInitializePropertyInConstructorQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        protected PhpInitializePropertyInConstructorQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                PhpInitializePropertyInConstructorQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement defaultValue, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpInitializePropertyInConstructorQuickFix.$$$reportNull$$$0(1);
            }
            if (defaultValue == null) {
                PhpInitializePropertyInConstructorQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpInitializePropertyInConstructorQuickFix.$$$reportNull$$$0(3);
            }
            Field field = PhpPsiUtil.getParentOfClass(defaultValue, Field.class);
            assert (field != null);
            PhpClass clazz = field.getContainingClass();
            assert (clazz != null);
            Method constructor = PhpIntroduceFieldHandler.getOrCreateConstructor(clazz);
            Statement initStatement = PhpIntroduceFieldHandler.getFieldInitialization(context.project(), field.getName(), false, defaultValue.getText());
            GroupStatement methodBlock = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)constructor, GroupStatement.class);
            assert (methodBlock != null);
            if (methodBlock.getChildren().length == 0) {
                methodBlock.addAfter((PsiElement)initStatement, methodBlock.getFirstChild());
            } else {
                methodBlock.addBefore((PsiElement)initStatement, methodBlock.getLastChild());
            }
            field.replace(PhpUnusedFieldDefaultValueInspection.PhpRemoveFieldDefaultValueQuickFix.createFieldWithoutDefaultValue(context.project(), field));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.initialize.property.in.constructor", new Object[0]);
            if (string == null) {
                PhpInitializePropertyInConstructorQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpInitializePropertyInConstructorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpInitializePropertyInConstructorQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix
    extends PsiUpdateModCommandAction<Parameter> {
        private final PhpType myTypeToAdd;
        private final String myNewParameterPresentation;

        protected PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix(@NotNull Parameter element, PhpType typeToAdd, PhpType type) {
            if (element == null) {
                PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.myTypeToAdd = typeToAdd.filterOut(it -> type.getTypes().contains(it));
            this.myNewParameterPresentation = type.add(this.myTypeToAdd).toString();
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Parameter element, @NotNull ModPsiUpdater updater) {
            PhpTypeDeclaration typeDeclaration;
            if (context == null) {
                PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix.$$$reportNull$$$0(3);
            }
            if ((typeDeclaration = element.getTypeDeclaration()) == null) {
                Parameter newParameter = PhpPsiElementFactory.createComplexParameter(element.getProject(), this.myTypeToAdd + " $" + element.getName());
                element.replace(newParameter);
            } else {
                PhpHierarchyChecksInspection.PhpAppendNonCompatibleClassReferencesToParameterQuickFix.appendNonCompatibleClassReferencesToParameter(element, this.myTypeToAdd);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.quick.fix.change.append.field.declared.type", this.myNewParameterPresentation);
            if (string == null) {
                PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAppendFieldDeclaredTypeToHookParameterTypeQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceWithDefineQuickFix
    extends PsiUpdateModCommandAction<Constant> {
        protected PhpReplaceWithDefineQuickFix(@NotNull Constant constDeclaration) {
            if (constDeclaration == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)constDeclaration);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Constant constant, @NotNull ModPsiUpdater updater) {
            PsiElement value;
            if (context == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(1);
            }
            if (constant == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(3);
            }
            if ((value = constant.getValue()) == null) {
                return;
            }
            String define = String.format("define(\"%s\", %s);", PhpLangUtil.toPresentableFQN(constant.getFQN()), value.getText());
            PsiElement parent = constant.getParent();
            parent.getParent().addBefore(PhpPsiElementFactory.createPhpPsiFromText(context.project(), PhpDefine.class, define).getParent(), parent);
            PhpMoveFileConstantProcessor.deleteOriginalConstantDeclaration(constant);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.define.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constDeclaration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithDefineQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithDefineQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpAddTraitUseRuleQuickFix
    extends PsiUpdateModCommandAction<PhpUseList> {
        private final String myTraitFQN;

        private PhpAddTraitUseRuleQuickFix(String traitFQN) {
            super(PhpUseList.class);
            this.myTraitFQN = traitFQN;
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PhpUseList element) {
            if (context == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(1);
            }
            return Presentation.of((String)PhpBundle.message("intention.name.add.trait.to.use.list", PhpLangUtil.toShortName(this.myTraitFQN)));
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.trait.to.use.list", new Object[0]);
            if (string == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpUseList useList, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(3);
            }
            if (useList == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(5);
            }
            Project project = context.project();
            PhpUse lastDeclaration = (PhpUse)ArrayUtil.getLastElement((Object[])useList.getDeclarations());
            PsiElement elementToAddAfter = lastDeclaration != null ? useList.addAfter(PhpPsiElementFactory.createComma(project), (PsiElement)lastDeclaration) : useList.getFirstChild();
            PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)useList);
            if (scope == null) {
                return;
            }
            String traitImportedName = PhpCodeInsightUtil.createQualifiedName(scope, this.myTraitFQN);
            PhpUse traitUseDeclaration = PhpPsiElementFactory.createPhpPsiFromText(project, PhpUse.class, "<?php class a { use " + traitImportedName + ";}");
            useList.addAfter((PsiElement)traitUseDeclaration, elementToAddAfter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddTraitUseRuleQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useList";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddTraitUseRuleQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceWithPublicQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        protected PhpReplaceWithPublicQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(3);
            }
            element.replace(PhpPsiUtil.getChildOfType((PsiElement)PhpPsiElementFactory.createModifierList(context.project(), PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC), PhpTokenTypes.kwPUBLIC));
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.public", new Object[0]);
            if (string == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithPublicQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithPublicQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    protected static class PhpRemoveBracketsFix
    extends PsiUpdateModCommandAction<PsiElement> {
        protected PhpRemoveBracketsFix() {
            super(PsiElement.class);
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.remove.brackets", new Object[0]);
            if (string == null) {
                PhpRemoveBracketsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement elementAt, @NotNull ModPsiUpdater updater) {
            PhpTypeDeclarationOwner typeDeclarationOwner;
            PhpTypeDeclaration typeDeclaration;
            if (context == null) {
                PhpRemoveBracketsFix.$$$reportNull$$$0(1);
            }
            if (elementAt == null) {
                PhpRemoveBracketsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveBracketsFix.$$$reportNull$$$0(3);
            }
            PhpTypeDeclaration phpTypeDeclaration = typeDeclaration = (typeDeclarationOwner = PhpPsiUtil.getParentOfClass(elementAt, PhpTypeDeclarationOwner.class)) != null ? (PhpTypeDeclaration)typeDeclarationOwner.getTypeDeclaration() : null;
            if (typeDeclaration == null) {
                return;
            }
            ClassReference reference = (ClassReference)ContainerUtil.find(typeDeclaration.getClassReferences(), r -> PhpAnnotatorVisitor.getRangeUntilLastBracket(r).containsOffset(context.offset()));
            if (reference == null) {
                return;
            }
            PhpAnnotatorVisitor.removeBrackets(reference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveBracketsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementAt";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveBracketsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpUpdateTypeFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private PhpUpdateTypeFix() {
            super(PsiElement.class);
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.replace.brackets.with.types", new Object[0]);
            if (string == null) {
                PhpUpdateTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement elementAt, @NotNull ModPsiUpdater updater) {
            PhpTypeDeclarationOwner typeDeclarationOwner;
            PhpTypeDeclaration typeDeclaration;
            if (context == null) {
                PhpUpdateTypeFix.$$$reportNull$$$0(1);
            }
            if (elementAt == null) {
                PhpUpdateTypeFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUpdateTypeFix.$$$reportNull$$$0(3);
            }
            PhpTypeDeclaration phpTypeDeclaration = typeDeclaration = (typeDeclarationOwner = PhpPsiUtil.getParentOfClass(elementAt, PhpTypeDeclarationOwner.class)) != null ? (PhpTypeDeclaration)typeDeclarationOwner.getTypeDeclaration() : null;
            assert (typeDeclaration != null);
            Object2IntOpenHashMap unpluralisedTypes = new Object2IntOpenHashMap();
            for (ClassReference reference : typeDeclaration.getClassReferences()) {
                int pluralDimension = PhpAnnotatorVisitor.getPluralDimension(reference);
                if (pluralDimension <= 0) continue;
                PhpAnnotatorVisitor.removeBrackets(reference);
                unpluralisedTypes.put((Object)reference.resolveLocalType().global(context.project()), pluralDimension);
            }
            PhpType[] newType = new PhpType[]{new PhpType().add(typeDeclaration.getGlobalType())};
            for (Object2IntMap.Entry entry : unpluralisedTypes.object2IntEntrySet()) {
                newType[0] = newType[0].filter((PhpType)entry.getKey()).add(((PhpType)entry.getKey()).pluralise(entry.getIntValue()));
            }
            typeDeclaration.update(newType[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpUpdateTypeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementAt";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpUpdateTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    static final class PhpRemoveUnionTypeReference
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        public boolean startInWriteAction() {
            return false;
        }

        private PhpRemoveUnionTypeReference(PsiElement reference, PsiElement duplicatedReference) {
            super(reference, duplicatedReference);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(3);
            }
            if (editor == null || startElement.textMatches(endElement) || ApplicationManager.getApplication().isUnitTestMode()) {
                WriteAction.run(() -> PhpRemoveUnionTypeReference.removeClassReference(startElement));
                return;
            }
            final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
            PsiTargetNavigator navigator = new PsiTargetNavigator(Arrays.asList(startElement, endElement)).presentationProvider(e -> TargetPresentation.builder((String)PhpBundle.message("php.remove.doc.tag.quick.fix.family.name", e.getText())).presentation()).builderConsumer(builder2 -> builder2.setResizable(false).setRequestFocus(true).setItemChosenCallback(e -> {
                PsiElement psi = e.dereference();
                if (psi == null) {
                    return;
                }
                CommandProcessor.getInstance().executeCommand(project, () -> WriteAction.run(() -> PhpRemoveUnionTypeReference.removeClassReference(psi)), psi.getText(), null);
            }).setItemSelectedCallback(e -> {
                if (e == null) {
                    return;
                }
                highlighter.dropHighlight();
                PsiElement element = e.dereference();
                if (element == null) {
                    return;
                }
                highlighter.highlight(element, Collections.singletonList(element));
            }));
            JBPopup popup = navigator.createPopup(project, PhpBundle.message("popup.title.select.reference.to.remove", new Object[0]));
            popup.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    highlighter.dropHighlight();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveUnionTypeReference$1", "onClosed"));
                }
            });
            popup.showInBestPositionFor(editor);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            if (project == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(5);
            }
            if (file == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(6);
            }
            PhpRemoveUnionTypeReference.doRemoveClassReference(PsiTreeUtil.findSameElementInCopy((PsiElement)this.getStartElement(), (PsiFile)file));
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        public static void removeClassReference(PsiElement element) {
            if (PhpQuickFixBase.ensureFileWritableInQuickFix(element.getProject(), element.getContainingFile().getVirtualFile())) {
                PhpRemoveUnionTypeReference.doRemoveClassReference(element);
            }
        }

        private static void doRemoveClassReference(PsiElement element) {
            PhpTypeDeclaration typeDeclaration = PhpPsiUtil.getParentOfClass(element, PhpTypeDeclaration.class);
            List<PsiElement> groups = PhpTypeDeclarationImpl.getClassReferenceGroups(typeDeclaration);
            PsiElement elementGroup = (PsiElement)ContainerUtil.find(groups, group -> PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)element, (boolean)true));
            IElementType delimiterType = StreamEx.of((Object[])new PsiElement[]{PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true), PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true)}).map(PsiUtilCore::getElementType).findFirst(e -> PhpTokenTypes.opBIT_AND.equals(e) || PhpTokenTypes.opBIT_OR.equals(e)).orElse(null);
            PhpCodeEditUtil.removeStatementWithDelivery(element, delimiterType);
            if (typeDeclaration == null) {
                return;
            }
            if (PhpTypeDeclarationImpl.getDirectClassReferences(elementGroup).size() == 1) {
                PhpUnwrapClassReferenceQuickFix.unwrapGroup(elementGroup);
            }
            if (PhpTypeDeclarationImpl.getClassReferenceGroups(typeDeclaration).size() == 1 && PhpTypeDeclarationImpl.getDirectClassReferences((PsiElement)typeDeclaration).isEmpty()) {
                PhpUnwrapClassReferenceGroupQuickFix.unwrapTypeDeclarationWithSingleGroup((PsiElement)typeDeclaration);
            }
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.remove.duplicated.type", new Object[0]);
            if (string == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(8);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.remove.duplicated.type", new Object[0]);
            if (string == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveUnionTypeReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveUnionTypeReference";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpReplaceNullableNotationWithNullAsPartOfUnionType
    extends PsiUpdateModCommandAction<PsiElement> {
        protected PhpReplaceNullableNotationWithNullAsPartOfUnionType(PsiElement quest) {
            super(quest);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpTypeDeclarationImpl typeDeclaration;
            if (context == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(2);
            }
            if ((typeDeclaration = (PhpTypeDeclarationImpl)ObjectUtils.tryCast((Object)element.getParent(), PhpTypeDeclarationImpl.class)) != null && typeDeclaration.findNullReference() == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.replaceNullableNotationWithNullReference(typeDeclaration, element);
            }
        }

        public static void replaceNullableNotationWithNullReference(@NotNull PhpTypeDeclarationImpl typeDeclaration, @NotNull PsiElement nullableNotation) {
            if (typeDeclaration == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(3);
            }
            if (nullableNotation == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(4);
            }
            typeDeclaration.addTypeReference("null");
            nullableNotation.delete();
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.replace.nullable.notation.with.null.as.part.union.type", new Object[0]);
            if (string == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeDeclaration";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullableNotation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceNullableNotationWithNullAsPartOfUnionType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceNullableNotationWithNullAsPartOfUnionType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceNullableNotationWithNullReference";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpAddPropertyHooksQuickFix
    extends PsiUpdateModCommandAction<Field> {
        protected PhpAddPropertyHooksQuickFix(@NotNull Field element) {
            if (element == null) {
                PhpAddPropertyHooksQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Field element, @NotNull ModPsiUpdater updater) {
            PsiElement propertyHooks;
            if (context == null) {
                PhpAddPropertyHooksQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddPropertyHooksQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddPropertyHooksQuickFix.$$$reportNull$$$0(3);
            }
            if ((propertyHooks = PhpPsiElementFactory.createPropertyHooks(element.getProject(), "get; set;")) == null) {
                return;
            }
            PsiElement semicolon = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true);
            if (PhpPsiUtil.isOfType(semicolon, PhpTokenTypes.opSEMICOLON)) {
                semicolon.delete();
            }
            element.addAfter(propertyHooks, element.getLastChild());
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.quick.fix.add.property.hooks", new Object[0]);
            if (string == null) {
                PhpAddPropertyHooksQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddPropertyHooksQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddPropertyHooksQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpSwitchLanguageLevelModCommandAction
    implements ModCommandAction {
        private final PhpLanguageLevel myLevel;
        private final Project myProject;

        protected PhpSwitchLanguageLevelModCommandAction(@NotNull Project project, @NotNull PhpLanguageLevel level) {
            if (project == null) {
                PhpSwitchLanguageLevelModCommandAction.$$$reportNull$$$0(0);
            }
            if (level == null) {
                PhpSwitchLanguageLevelModCommandAction.$$$reportNull$$$0(1);
            }
            this.myLevel = level;
            this.myProject = project;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpSwitchLanguageLevelQuickFix.getInstance(this.myLevel).getFamilyName();
            if (string == null) {
                PhpSwitchLanguageLevelModCommandAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public Presentation getPresentation(@NotNull ActionContext context) {
            if (context == null) {
                PhpSwitchLanguageLevelModCommandAction.$$$reportNull$$$0(3);
            }
            return Presentation.of((String)this.getFamilyName());
        }

        @NotNull
        public ModCommand perform(@NotNull ActionContext context) {
            if (context == null) {
                PhpSwitchLanguageLevelModCommandAction.$$$reportNull$$$0(4);
            }
            ApplicationManager.getApplication().invokeLater(() -> PhpProjectConfigurationFacade.getInstance(this.myProject).setLanguageLevel(this.myLevel));
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                PhpSwitchLanguageLevelModCommandAction.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull ActionContext context) {
            if (context == null) {
                PhpSwitchLanguageLevelModCommandAction.$$$reportNull$$$0(6);
            }
            IntentionPreviewInfo intentionPreviewInfo = ((PhpSwitchLanguageLevelQuickFix)PhpSwitchLanguageLevelQuickFix.getInstance(this.myLevel)).generatePreview();
            if (intentionPreviewInfo == null) {
                PhpSwitchLanguageLevelModCommandAction.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpSwitchLanguageLevelModCommandAction";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpSwitchLanguageLevelModCommandAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpSplitIdentifiersToEnumCasesQuickFix
    extends PsiUpdateModCommandAction<PhpEnumCase> {
        private PhpSplitIdentifiersToEnumCasesQuickFix(@NotNull PhpEnumCase enumCase) {
            if (enumCase == null) {
                PhpSplitIdentifiersToEnumCasesQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)enumCase);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpEnumCase enumCase, @NotNull ModPsiUpdater updater) {
            PhpClass containingClass;
            if (context == null) {
                PhpSplitIdentifiersToEnumCasesQuickFix.$$$reportNull$$$0(1);
            }
            if (enumCase == null) {
                PhpSplitIdentifiersToEnumCasesQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpSplitIdentifiersToEnumCasesQuickFix.$$$reportNull$$$0(3);
            }
            if ((containingClass = enumCase.getContainingClass()) == null) {
                return;
            }
            HashSet alreadyTakenEnumCases = new HashSet(ContainerUtil.map2Set(containingClass.getEnumCases(), PhpNamedElement::getName));
            ArrayList<PsiElement> identifiersToDelete = new ArrayList<PsiElement>();
            ArrayList<PhpEnumCase> enumCasesNamesToInsert = new ArrayList<PhpEnumCase>();
            PhpAnnotatorVisitor.processRedundantEnumCaseNameIdentifiers(enumCase, identifier -> {
                identifiersToDelete.add((PsiElement)identifier);
                if (alreadyTakenEnumCases.add(identifier.getText())) {
                    PsiElement defaultValue = PhpSplitIdentifiersToEnumCasesQuickFix.getNextDefaultValue(identifier);
                    PhpEnumCase enumCaseToInsert = PhpPsiElementFactory.createEnumCase(context.project(), identifier.getText(), defaultValue != null ? defaultValue.getText() : null);
                    enumCasesNamesToInsert.add(enumCaseToInsert);
                }
            });
            PhpSplitIdentifiersToEnumCasesQuickFix.insertNewCases((PsiElement)enumCase, containingClass, enumCasesNamesToInsert);
            PhpSplitIdentifiersToEnumCasesQuickFix.deleteRedundantIdentifiers((PsiElement)enumCase, identifiersToDelete);
        }

        @Nullable
        private static PsiElement getNextDefaultValue(PsiElement identifier) {
            PsiElement asgn = PhpPsiUtil.getNextSiblingIgnoreWhitespace(identifier, true);
            return PhpPsiUtil.isOfType(asgn, PhpTokenTypes.opASGN) ? (PsiElement)ObjectUtils.tryCast((Object)PhpPsiUtil.getNextSiblingIgnoreWhitespace(asgn, true), PhpExpression.class) : null;
        }

        private static void deleteRedundantIdentifiers(@NotNull PsiElement enumCase, List<PsiElement> identifiersToDelete) {
            if (enumCase == null) {
                PhpSplitIdentifiersToEnumCasesQuickFix.$$$reportNull$$$0(4);
            }
            if (!identifiersToDelete.isEmpty()) {
                PsiElement first = (PsiElement)ContainerUtil.getFirstItem(identifiersToDelete);
                PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(first, true);
                if (PhpPsiUtil.isOfType(prev, PhpTokenTypes.opCOMMA)) {
                    first = prev;
                }
                PsiElement last = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(enumCase.getLastChild(), true);
                enumCase.deleteChildRange(first, last);
            }
        }

        private static void insertNewCases(@NotNull PsiElement enumCase, PhpClass containingClass, Collection<PhpEnumCase> enumCasesToInsert) {
            if (enumCase == null) {
                PhpSplitIdentifiersToEnumCasesQuickFix.$$$reportNull$$$0(5);
            }
            PsiElement anchor = enumCase;
            for (PhpEnumCase caseToInsert : enumCasesToInsert) {
                anchor = containingClass.addAfter((PsiElement)caseToInsert, anchor);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.split.into.multiple.enum.cases", new Object[0]);
            if (string == null) {
                PhpSplitIdentifiersToEnumCasesQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumCase";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpSplitIdentifiersToEnumCasesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpSplitIdentifiersToEnumCasesQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRedundantIdentifiers";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insertNewCases";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpAddDefaultMatchArmQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        public PhpAddDefaultMatchArmQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(3);
            }
            PhpAddDefaultMatchArmQuickFix.doAddMatchArm(context.project(), startElement);
            PhpMatchExpression matchExpression = PhpPsiUtil.getParentOfClass(startElement, false, PhpMatchExpression.class);
            assert (matchExpression != null);
            PhpDefaultMatchArm defaultMatchArm = matchExpression.getDefaultMatchArm();
            assert (defaultMatchArm != null);
            PhpExpression body = defaultMatchArm.getBodyExpression();
            assert (body != null);
            updater.templateBuilder().field((PsiElement)body, body.getText());
        }

        private static void doAddMatchArm(@NotNull Project project, @NotNull PsiElement startElement) {
            if (project == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(5);
            }
            PhpMatchExpression matchExpression = PhpPsiUtil.getParentOfClass(startElement, PhpMatchExpression.class);
            assert (matchExpression != null && matchExpression.getDefaultMatchArm() == null);
            PhpMatchArm defaultArm = PhpPsiElementFactory.createMatchArm(project, "default", "throw new \\Exception('Unexpected match value')");
            PhpUncoveredEnumCasesInspection.PhpAddMissingEnumCasesQuickFix.appendMatchArm(project, matchExpression, (PsiElement)defaultArm);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.default.match.arm", new Object[0]);
            if (string == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddDefaultMatchArmQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddDefaultMatchArmQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doAddMatchArm";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpMakeReferenceAbsoluteQuickFix
    extends PsiUpdateModCommandAction<MethodReference> {
        private final String myTraitName;

        private PhpMakeReferenceAbsoluteQuickFix(String traitName) {
            super(MethodReference.class);
            this.myTraitName = traitName;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.append.absolute.trait", this.myTraitName);
            if (string == null) {
                PhpMakeReferenceAbsoluteQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull MethodReference reference, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpMakeReferenceAbsoluteQuickFix.$$$reportNull$$$0(1);
            }
            if (reference == null) {
                PhpMakeReferenceAbsoluteQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpMakeReferenceAbsoluteQuickFix.$$$reportNull$$$0(3);
            }
            reference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(context.project(), MethodReference.class, String.format("class a { use T1 {%s::%s}}", this.myTraitName, reference.getText())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpMakeReferenceAbsoluteQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpMakeReferenceAbsoluteQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    static class PhpChangeToSupportDirectiveQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private final String myDirectiveName;

        private PhpChangeToSupportDirectiveQuickFix(@NotNull PsiElement element, String name) {
            if (element == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myDirectiveName = name;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(3);
            }
            Project project = context.project();
            Declare declare = PhpPsiElementFactory.createPhpPsiFromText(project, Declare.class, String.format("declare(%s=1)", this.myDirectiveName));
            PsiElement name = (PsiElement)ContainerUtil.getFirstItem(DeclareImpl.getDirectivesNames(declare));
            if (name == null) {
                return;
            }
            element.replace(name);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myDirectiveName);
            if (string == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public static ModCommandAction[] getFixes(@NotNull PsiElement directiveName) {
            if (directiveName == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(5);
            }
            return (ModCommandAction[])ContainerUtil.map2Array(PhpKeywordsCompletionContributor.getSupportedDeclareDirectives(directiveName.getProject()), ModCommandAction.class, name -> new PhpChangeToSupportDirectiveQuickFix(directiveName, (String)name));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpChangeToSupportDirectiveQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directiveName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpChangeToSupportDirectiveQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFixes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

