/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeReturnTypeAnnotatorFix
extends PsiUpdateModCommandAction<Function> {
    @NotNull
    private final PhpType myNewType;
    private final String myNewTypePresentation;
    private final String myCurrentTypePresentation;

    public PhpChangeReturnTypeAnnotatorFix(@NotNull Function function, @NotNull PhpType newType) {
        if (function == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(0);
        }
        if (newType == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)function);
        Project project = function.getProject();
        @NotNull PhpType currentType = function.getDeclaredType();
        this.myNewType = newType;
        this.myNewTypePresentation = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, this.myNewType, function);
        this.myCurrentTypePresentation = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, currentType, function);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull Function function, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(2);
        }
        if (function == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(4);
        }
        PhpChangeReturnTypeQuickFix.changeReturnType(function, this.myNewType);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull Function element) {
        if (context == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(6);
        }
        return Presentation.of((String)PhpBundle.message("quickfix.strict.type.checking.change.return.type.name", this.myCurrentTypePresentation, this.myNewTypePresentation));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.return.type.family", new Object[0]);
        if (string == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpChangeReturnTypeAnnotatorFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpChangeReturnTypeAnnotatorFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

