/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.classAlias;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.classAlias.PhpClassAliasProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.parsing.expressions.StaticScalar;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpDefineImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassAliasProviderImpl
implements PhpClassAliasProvider {
    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public CharSequence getSearchString() {
        return "class_alias";
    }

    @Override
    public boolean isClassAliasDeclaration(@NotNull FunctionReference reference) {
        PsiElement[] parameters;
        int length;
        if (reference == null) {
            PhpClassAliasProviderImpl.$$$reportNull$$$0(0);
        }
        if ((length = (parameters = reference.getParameters()).length) != 2 && length != 3) {
            return false;
        }
        if (!"class_alias".equals(reference.getName())) {
            return false;
        }
        return PhpClassAliasProviderImpl.extractFqn(parameters[0]) != null && PhpClassAliasProviderImpl.extractFqn(parameters[1]) != null;
    }

    @Override
    @Nullable
    public String getAliasFqn(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpClassAliasProviderImpl.$$$reportNull$$$0(1);
        }
        PsiElement parameter = reference.getParameter(1);
        assert (parameter != null);
        return PhpClassAliasProviderImpl.extractFqn(parameter);
    }

    @Override
    @Nullable
    public String getOriginalFqn(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpClassAliasProviderImpl.$$$reportNull$$$0(2);
        }
        PsiElement parameter = reference.getParameter(0);
        assert (parameter != null);
        return PhpClassAliasProviderImpl.extractFqn(parameter);
    }

    @Nullable
    public static String extractFqn(@NotNull PsiElement parameter) {
        PhpExpression reference;
        ClassConstantReference constant;
        if (parameter == null) {
            PhpClassAliasProviderImpl.$$$reportNull$$$0(3);
        }
        if (parameter instanceof StringLiteralExpression) {
            PsiElement string = PhpPsiUtil.getChildOfType(parameter, StaticScalar.STRING_BODY);
            if (string != null) {
                String name = string.getText();
                name = StringUtil.unquoteString((String)name);
                name = StringUtil.trimStart((String)name, (String)"PS_UNRESERVE_PREFIX_");
                name = StringUtil.replace((String)name, (String)"\\\\", (String)"\\");
                name = PhpLangUtil.toFQN(name);
                return name;
            }
        } else if (parameter instanceof ClassConstantReference && "class".equalsIgnoreCase((constant = (ClassConstantReference)parameter).getName()) && (reference = constant.getClassReference()) instanceof ClassReference) {
            return ((ClassReference)reference).getFQN();
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode getNameNode(@NotNull FunctionReference reference) {
        List<PsiElement> operands;
        PsiElement lastOperand;
        PsiElement parameter;
        if (reference == null) {
            PhpClassAliasProviderImpl.$$$reportNull$$$0(4);
        }
        if ((parameter = reference.getParameter(1)) != null && (lastOperand = (PsiElement)ContainerUtil.getLastItem(operands = PhpDefineImpl.collectOperands(parameter))) != null) {
            return lastOperand.getNode().findChildByType(StaticScalar.STRING_BODY);
        }
        return null;
    }

    @Override
    public void setName(@NotNull ASTNode nameNode, @NotNull String newName, @NotNull Project project) {
        if (nameNode == null) {
            PhpClassAliasProviderImpl.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            PhpClassAliasProviderImpl.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PhpClassAliasProviderImpl.$$$reportNull$$$0(7);
        }
        char s = PhpPsiUtil.isOfType(nameNode, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE) ? (char)'\'' : '\"';
        PsiElement constantReference = PhpPsiElementFactory.createFromText(project, nameNode.getElementType(), s + newName + s);
        nameNode.getTreeParent().replaceChild(nameNode, constantReference.getNode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/classAlias/PhpClassAliasProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassAliasDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAliasFqn";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginalFqn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFqn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameNode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

