/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.php.lang.documentation.PhpClassDocSource;
import com.jetbrains.php.lang.documentation.PhpDefaultDocSource;
import com.jetbrains.php.lang.documentation.PhpDocSource;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassRefDocSource
extends PhpDefaultDocSource {
    private final ClassReference myClassRef;
    private PhpDocSource myDelegate;

    public PhpClassRefDocSource(ClassReference element, boolean isGenerationForRenderedDoc) {
        super(element, isGenerationForRenderedDoc);
        this.myClassRef = element;
        this.resolveDelegate();
    }

    private void resolveDelegate() {
        Collection<? extends PhpNamedElement> classes = this.myClassRef.resolveGlobal(false);
        if (classes.size() > 0) {
            Object resolved = classes.toArray()[0];
            if (resolved instanceof PhpClass) {
                this.myDelegate = new PhpClassDocSource((PhpClass)resolved, this.myIsGenerationForRenderedDoc);
                return;
            }
            if (resolved instanceof Method) {
                this.myDelegate = new PhpFunctionDocSource((Method)resolved, this.myIsGenerationForRenderedDoc);
                return;
            }
        }
        this.myDelegate = new PhpDefaultDocSource(this.myClassRef, this.myIsGenerationForRenderedDoc);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getTitle() {
        String string = this.myDelegate.getTitle();
        if (string == null) {
            PhpClassRefDocSource.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDelegate.getDescription();
        if (string == null) {
            PhpClassRefDocSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getParameters() {
        return this.myDelegate.getParameters();
    }

    @Override
    @Nullable
    public String getVar() {
        return this.myDelegate.getVar();
    }

    @Override
    public String getReturnType() {
        return this.myDelegate.getReturnType();
    }

    @Override
    public String getReturn() {
        return this.myDelegate.getReturn();
    }

    @Override
    public boolean isDeprecated() {
        return this.myDelegate.isDeprecated();
    }

    @Override
    public String getSince() {
        return this.myDelegate.getSince();
    }

    @Override
    public String getUses() {
        return this.myDelegate.getUses();
    }

    @Override
    public String getLinks() {
        return this.myDelegate.getLinks();
    }

    @Override
    public String getSeeItems() {
        return this.myDelegate.getSeeItems();
    }

    @Override
    public String getVersion() {
        return this.myDelegate.getVersion();
    }

    @Override
    public String getPackage() {
        return this.myDelegate.getPackage();
    }

    @Override
    public String getSubpackage() {
        return this.myDelegate.getSubpackage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/documentation/PhpClassRefDocSource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

