/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.PhpDocSource;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLinkTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDefaultDocSource
implements PhpDocSource {
    protected PhpPsiElement myElement;
    protected boolean myIsGenerationForRenderedDoc;
    @Nullable
    protected PhpDocComment myDocComment;

    public PhpDefaultDocSource(PhpPsiElement element, boolean isGenerationForRenderedDoc) {
        this.myElement = element;
        this.myIsGenerationForRenderedDoc = isGenerationForRenderedDoc;
    }

    public PhpDefaultDocSource(PhpPsiElement element, boolean isGenerationForRenderedDoc, @NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpDefaultDocSource.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        this.myIsGenerationForRenderedDoc = isGenerationForRenderedDoc;
        this.myDocComment = comment;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getTitle() {
        String title = this.myElement.getText();
        String string = title = title.replace("PsiDirectory:", "");
        if (string == null) {
            PhpDefaultDocSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        return this.myDocComment;
    }

    @Override
    public String getAuthor() {
        if (this.myDocComment == null) {
            return null;
        }
        PhpDocTag[] authors = this.myDocComment.getTagElementsByName("@author");
        if (authors.length == 0) {
            return null;
        }
        return Arrays.stream(authors).map(tag -> {
            Object element = PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)((Condition)c -> c instanceof PhpPsiElement));
            if (element == null) {
                return "";
            }
            StringBuilder builder2 = new StringBuilder();
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER)) {
                    builder2.append(child.getText());
                    builder2.append(" ");
                }
                if (!PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_MAIL)) continue;
                String mail = child.getText();
                builder2.append("<a href=\"mailto:").append(mail).append("\">");
                builder2.append(mail);
                builder2.append("</a>");
            }
            return builder2.toString();
        }).collect(Collectors.joining("<br>"));
    }

    @Override
    public String getVar() {
        if (this.myDocComment == null) {
            return null;
        }
        PhpDocCommentImpl phpDocComment = (PhpDocCommentImpl)ObjectUtils.tryCast((Object)this.myDocComment, PhpDocCommentImpl.class);
        if (phpDocComment == null) {
            return null;
        }
        Collection<PhpDocParamTag> vars = PhpDefaultDocSource.getVarTags(phpDocComment);
        if (vars.isEmpty()) {
            return null;
        }
        return vars.stream().map(var -> PhpFunctionDocSource.getParameterInfo(var, true, this.myIsGenerationForRenderedDoc)).collect(Collectors.joining("<br>"));
    }

    private static Collection<PhpDocParamTag> getVarTags(PhpDocCommentImpl comment) {
        return ContainerUtil.filter(comment.getDocTagByClass(PhpDocParamTag.class), tag -> {
            String name = tag.getName();
            return "@var".equals(name) || "@type".equals(name) || "@psalm-var".equals(name) || "@phpstan-var".equals(name);
        });
    }

    @Override
    public String getProperties() {
        return null;
    }

    @Override
    public String getDataProvider() {
        return null;
    }

    @Override
    public String getCovers() {
        return null;
    }

    @Override
    public String getCoversDefaultClass() {
        return null;
    }

    @Override
    public String getDepends() {
        return null;
    }

    @Override
    public String getMethods() {
        return null;
    }

    @Override
    public String getGenerics() {
        return null;
    }

    @Override
    public HtmlChunk.Element getContainerInfo() {
        return null;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = PhpDocUtil.getDescription(this.myDocComment, true);
        if (string == null) {
            PhpDefaultDocSource.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getParameters() {
        return null;
    }

    @Override
    public String getReturnType() {
        if (this.myElement instanceof PhpTypedElement) {
            PhpType type;
            StringBuilder buffer = new StringBuilder();
            if (!buffer.isEmpty()) {
                buffer.append(": ");
            }
            if (!(type = ((PhpTypedElement)this.myElement).getType()).isEmpty()) {
                buffer.append(DumbService.getInstance((Project)this.myElement.getProject()).isDumb() ? type.toString() : type.global(this.myElement.getProject()));
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    public String getReturn() {
        return null;
    }

    @Override
    public String getSince() {
        if (this.myDocComment == null) {
            return null;
        }
        PhpDocTag[] sinceTags = this.myDocComment.getTagElementsByName("@since");
        if (sinceTags.length == 0) {
            return null;
        }
        return PhpDocUtil.getTagValue(sinceTags[0], this.myIsGenerationForRenderedDoc);
    }

    @Override
    public String getUses() {
        return PhpNamedElementDocSource.getSeeItemsInternal(this.myDocComment, "@uses");
    }

    @Override
    public String getLinks() {
        if (this.myDocComment == null) {
            return null;
        }
        Object[] linkTags = this.myDocComment.getLinkTags();
        if (linkTags == null) {
            return null;
        }
        return ((HtmlChunk)((StreamEx)((StreamEx)StreamEx.of((Object[])linkTags).remove(PhpDocTagImpl::isInline)).map(linkTag -> {
            String url = linkTag.getURL();
            if (url == null) {
                return HtmlChunk.text((String)PhpDefaultDocSource.getTextWithoutTag(linkTag));
            }
            String value = linkTag.getTagValue();
            if (StringUtil.isEmpty((String)value)) {
                value = url;
            }
            return HtmlChunk.link((String)url, (String)value);
        }).remove(HtmlChunk::isEmpty)).collect(HtmlChunk.toFragment((HtmlChunk)HtmlChunk.br()))).toString();
    }

    @NlsSafe
    private static String getTextWithoutTag(@NotNull PhpDocLinkTag linkTag) {
        if (linkTag == null) {
            PhpDefaultDocSource.$$$reportNull$$$0(3);
        }
        return linkTag.getText().substring(linkTag.getFirstChild().getTextLength()).trim();
    }

    @Override
    public String getSeeItems() {
        return PhpNamedElementDocSource.getSeeItemsInternal(this.myDocComment, "@see");
    }

    @Override
    public String getVersion() {
        if (this.myDocComment == null) {
            return null;
        }
        PhpDocTag[] verTags = this.myDocComment.getTagElementsByName("@version");
        if (verTags.length == 0) {
            return null;
        }
        return PhpDocUtil.getTagValue(verTags[0], this.myIsGenerationForRenderedDoc);
    }

    @Override
    public String getPackage() {
        return null;
    }

    @Override
    public String getSubpackage() {
        return null;
    }

    @Override
    public String getThrows() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        if (this.myElement instanceof PhpDeprecationAttributeOwner && ((PhpDeprecationAttributeOwner)((Object)this.myElement)).getDeprecationInfo() != null) {
            return true;
        }
        PhpDocComment comment = this.getDocComment();
        return comment != null && PhpDocUtil.hasDocTagWithName(comment, "@deprecated");
    }

    @Override
    public String getDeprecationInfo() {
        PhpDocComment comment;
        if (this.myElement instanceof PhpDeprecationAttributeOwner) {
            String reason;
            PhpDeprecationAttributeOwner.PhpDeprecationInfo info = ((PhpDeprecationAttributeOwner)((Object)this.myElement)).getDeprecationInfo();
            String string = reason = info != null ? info.getReason() : null;
            if (StringUtil.isNotEmpty((String)reason)) {
                return reason;
            }
        }
        if ((comment = this.getDocComment()) == null) {
            return null;
        }
        PhpDocTag[] tags = comment.getTagElementsByName("@deprecated");
        if (tags.length == 0) {
            return "";
        }
        return PhpDocUtil.getTagValue(tags[0], this.myIsGenerationForRenderedDoc);
    }

    @Override
    public boolean isInternal() {
        PhpDocComment comment = this.getDocComment();
        return comment != null && PhpDocUtil.hasDocTagWithName(comment, "@internal");
    }

    @Override
    public String getInternalInfo() {
        PhpDocComment comment = this.getDocComment();
        if (comment == null) {
            return null;
        }
        PhpDocTag[] tags = comment.getTagElementsByName("@internal");
        if (tags.length == 0) {
            return "";
        }
        return tags[0].getTagValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpDefaultDocSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpDefaultDocSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithoutTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

