/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.documentation.PhpClassMemberDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import org.jetbrains.annotations.NotNull;

public class PhpDocMethodSource
extends PhpClassMemberDocSource {
    private final PhpDocMethod myMethod;
    private String myType;
    private String mySignature;
    private String myDescription;

    public PhpDocMethodSource(@NotNull PhpDocMethod method, boolean isGenerationForRenderedDoc) {
        if (method == null) {
            PhpDocMethodSource.$$$reportNull$$$0(0);
        }
        super(method, isGenerationForRenderedDoc);
        this.myMethod = method;
        this.processDocComment();
    }

    private void processDocComment() {
        PhpDocComment docComment = this.myMethod.getDocComment();
        if (docComment == null) {
            return;
        }
        String methodName = this.myMethod.getName();
        for (PsiElement child = docComment.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode childNode = child.getNode();
            if (childNode == null || childNode.getElementType() != PhpDocElementTypes.phpDocSpecialTag) continue;
            boolean matchFound = false;
            String retType = "";
            for (PsiElement methodTagChild = child.getFirstChild(); methodTagChild != null; methodTagChild = methodTagChild.getNextSibling()) {
                if (methodTagChild instanceof PhpDocMethod) {
                    PsiElement identifierElement = methodTagChild.getFirstChild();
                    if (identifierElement == null || !identifierElement.getText().equals(methodName)) continue;
                    this.mySignature = PhpDocUtil.extractDefinition((PhpDocMethod)methodTagChild, this.myIsGenerationForRenderedDoc);
                    matchFound = true;
                    continue;
                }
                ASTNode node = methodTagChild.getNode();
                if (node == null) continue;
                if (node.getElementType() == PhpDocTokenTypes.DOC_METHOD_DESCRIPTION) {
                    if (!matchFound) continue;
                    this.myDescription = methodTagChild.getText();
                    continue;
                }
                if (node.getElementType() != PhpDocElementTypes.phpDocMethodType) continue;
                PsiElement reference = node.getPsi().getFirstChild();
                if (reference instanceof ClassReference) {
                    StringBuilder builder2 = new StringBuilder();
                    PhpDocMethodSource.appendType(builder2, ((ClassReference)reference).getType(), this.myMethod.getContext(), this.myIsGenerationForRenderedDoc);
                    retType = builder2.toString();
                    continue;
                }
                retType = methodTagChild.getText();
            }
            if (!matchFound) continue;
            this.myType = retType;
        }
    }

    @Override
    @NotNull
    @NlsSafe
    public String getTitle() {
        String string = this.mySignature;
        if (string == null) {
            PhpDocMethodSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getReturnType() {
        return this.myType;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            PhpDocMethodSource.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpDocMethodSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpDocMethodSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

