/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamespaceDocSource
extends PhpNamedElementDocSource {
    private static String SEPARATOR = "\\";
    private final PhpNamespace myNamespace;

    public PhpNamespaceDocSource(PhpNamespace element, boolean isGenerationForRenderedDoc) {
        super(element, isGenerationForRenderedDoc);
        this.myNamespace = element;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getTitle() {
        StringBuilder titleBuf = new StringBuilder();
        for (PsiElement childElement = this.myNamespace.getFirstChild(); childElement != null && !(childElement instanceof GroupStatement) && !PhpPsiUtil.isOfType(childElement, PhpTokenTypes.opSEMICOLON); childElement = childElement.getNextSibling()) {
            if (PhpPsiUtil.isOfType(childElement, PhpTokenTypes.kwNAMESPACE)) {
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)titleBuf, (String)childElement.getText(), (TextAttributesKey)PhpHighlightingData.KEYWORD);
                continue;
            }
            titleBuf.append(childElement.getText());
        }
        String allNamespaceClasses = this.getAllNamespaceClasses();
        if (allNamespaceClasses != null) {
            titleBuf.append(allNamespaceClasses);
        }
        String string = titleBuf.toString().trim();
        if (string == null) {
            PhpNamespaceDocSource.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public String getAllNamespaceClasses() {
        if (DumbService.isDumb((Project)this.myNamespace.getProject())) {
            return null;
        }
        PhpIndexImpl index = (PhpIndexImpl)ObjectUtils.tryCast((Object)PhpIndex.getInstance(this.myNamespace.getProject()), PhpIndexImpl.class);
        if (index == null) {
            return null;
        }
        HtmlBuilder classes = new HtmlBuilder();
        ((StreamEx)((StreamEx)PhpNamespaceDocSource.getFqns(index, this.myNamespace.getFQN() + SEPARATOR).sorted()).flatMap(fqn -> StreamEx.of(index.getAnyByFQN((String)fqn))).map(clazz -> PhpNamedElementDocSource.getLinkWithIcon(clazz.getFQN(), PhpNamespaceDocSource.getIcon(clazz), "left", (PsiElement)clazz)).filter(Objects::nonNull)).forEach(info -> classes.append((HtmlChunk)info));
        if (classes.isEmpty()) {
            return null;
        }
        return HtmlChunk.div().style("margin-bottom:\"5px\"").children(new HtmlChunk[]{HtmlChunk.tag((String)"h3").style("margin-bottom:\"5px\"").addText(PhpBundle.message("php.quick.documentation.namespace.classes", new Object[0])), classes.toFragment()}).toString();
    }

    private static StreamEx<String> getFqns(@NotNull PhpIndexImpl index, String prefix) {
        if (index == null) {
            PhpNamespaceDocSource.$$$reportNull$$$0(1);
        }
        MyPrefixMatcher matcher = new MyPrefixMatcher(prefix);
        return StreamEx.of(index.getAllClassFqns(matcher)).append(index.getAllInterfacesFqns(matcher)).append(index.getAllTraitsFqns(matcher));
    }

    @NotNull
    public static String getIcon(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpNamespaceDocSource.$$$reportNull$$$0(2);
        }
        return clazz.isEnum() ? "AllIcons.Nodes.Enum" : (clazz.isTrait() ? "icons.PhpIcons.Trait" : (clazz.isInterface() ? "AllIcons.Nodes.Interface" : (clazz.isAbstract() ? "AllIcons.Nodes.AbstractClass" : "AllIcons.Nodes.Class")));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpNamespaceDocSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpNamespaceDocSource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFqns";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class MyPrefixMatcher
    extends PrefixMatcher {
        private MyPrefixMatcher(String prefix) {
            super(prefix);
        }

        public boolean prefixMatches(@NotNull String name) {
            String className;
            if (name == null) {
                MyPrefixMatcher.$$$reportNull$$$0(0);
            }
            if ((className = StringUtil.trimStart((String)name, (String)this.myPrefix)).length() == name.length()) {
                return false;
            }
            return !className.contains(SEPARATOR);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                MyPrefixMatcher.$$$reportNull$$$0(1);
            }
            return new MyPrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpNamespaceDocSource$MyPrefixMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixMatches";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cloneWithPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

