/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.documentation.PhpClassMemberDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPropertyDocSource
extends PhpClassMemberDocSource {
    PhpDocProperty myProperty;

    public PhpPropertyDocSource(PhpDocProperty element, boolean isGenerationForRenderedDoc) {
        super(element, isGenerationForRenderedDoc);
        this.myProperty = element;
    }

    @Override
    @NotNull
    public String getDescription() {
        PhpDocComment docComment = this.myProperty.getDocComment();
        if (docComment == null) {
            return "";
        }
        List<PhpDocPropertyTag> propertyTags = docComment.getPropertyTags();
        String propertyName = "$" + this.myProperty.getName();
        for (PhpDocTag phpDocTag : propertyTags) {
            if (!propertyName.equals(PhpPropertyDocSource.getPropertyName((PsiElement)phpDocTag))) continue;
            String string = PhpDocUtil.getTagValue(phpDocTag, this.myIsGenerationForRenderedDoc);
            if (string == null) {
                PhpPropertyDocSource.$$$reportNull$$$0(0);
            }
            return string;
        }
        return "";
    }

    @Nullable
    private static String getPropertyName(PsiElement propertyTag) {
        PsiElement docProperty = PhpPsiUtil.getChildOfType(propertyTag, PhpDocElementTypes.phpDocProperty);
        if (docProperty != null) {
            return docProperty.getText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/documentation/PhpPropertyDocSource", "getDescription"));
    }
}

