/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVarDocSource
extends PhpNamedElementDocSource {
    @NotNull
    private final Variable myOriginalVariable;

    public PhpVarDocSource(@NotNull PhpNamedElement element, @NotNull Variable originalElement, boolean isGenerationForRenderedDoc) {
        if (element == null) {
            PhpVarDocSource.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            PhpVarDocSource.$$$reportNull$$$0(1);
        }
        super(element, isGenerationForRenderedDoc);
        this.myOriginalVariable = originalElement;
    }

    @Nullable
    static Variable getVariable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpVarDocSource.$$$reportNull$$$0(2);
        }
        if (element instanceof Variable) {
            return (Variable)element;
        }
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.VARIABLE) && (parent = element.getParent()) instanceof Variable) {
            return (Variable)parent;
        }
        PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true);
        if (prev instanceof Variable) {
            return (Variable)prev;
        }
        return null;
    }

    @Override
    public String getReturnType() {
        PhpType resolved;
        Collection tags = this.myElement.getDocTags();
        if (tags.isEmpty()) {
            return this.getReturnType(this.myOriginalVariable);
        }
        PhpType original = this.myOriginalVariable.getGlobalType();
        if (!original.equals(resolved = this.myElement.getGlobalType())) {
            return this.getReturnType(this.myOriginalVariable);
        }
        StringBuilder builder2 = new StringBuilder();
        tags.forEach(tag -> {
            PhpVarDocSource.appendTypeFromDocTag(builder2, tag, this.myIsGenerationForRenderedDoc);
            builder2.append("|");
        });
        if (!builder2.isEmpty()) {
            builder2.setLength(builder2.length() - 1);
        }
        return QuickDocHighlightingHelper.wrapWithInlineCodeTag((StringBuilder)builder2).toString();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getTitle() {
        @NlsSafe StringBuilder buf = new StringBuilder();
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)("$" + this.myOriginalVariable.getName()), (TextAttributesKey)PhpHighlightingData.VAR);
        String string = buf.toString();
        if (string == null) {
            PhpVarDocSource.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpVarDocSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpVarDocSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

