/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.actions.InspectionElement;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.PhpDocLinkResolver;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocCommentStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocTagStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.intentions.PhpImportClassIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocUtil {
    @NlsSafe
    public static final String API_TAG = "@api";
    @NlsSafe
    public static final String AUTHOR_TAG = "@author";
    @NlsSafe
    public static final String CATEGORY_TAG = "@category";
    @NlsSafe
    public static final String COPYRIGHT_TAG = "@copyright";
    @NlsSafe
    public static final String DEPRECATED_TAG = "@deprecated";
    @NlsSafe
    public static final String EXAMPLE_TAG = "@example";
    @NlsSafe
    public static final String FILESOURCE_TAG = "@filesource";
    @NlsSafe
    public static final String GLOBAL_TAG = "@global";
    @NlsSafe
    public static final String IGNORE_TAG = "@ignore";
    @NlsSafe
    public static final String INTERNAL_TAG = "@internal";
    @NlsSafe
    public static final String LICENSE_TAG = "@license";
    @NlsSafe
    public static final String LINK_TAG = "@link";
    @NlsSafe
    public static final String METHOD_TAG = "@method";
    @NlsSafe
    public static final String PACKAGE_TAG = "@package";
    @NlsSafe
    public static final String PARAM_TAG = "@param";
    @NlsSafe
    public static final String PROPERTY_TAG = "@property";
    @NlsSafe
    public static final String PROPERTY_READ_TAG = "@property-read";
    @NlsSafe
    public static final String PROPERTY_WRITE_TAG = "@property-write";
    @NlsSafe
    public static final String RETURN_TAG = "@return";
    @NlsSafe
    public static final String SEE_TAG = "@see";
    @NlsSafe
    public static final String SINCE_TAG = "@since";
    @NlsSafe
    public static final String REMOVED_TAG = "@removed";
    @NlsSafe
    public static final String SUBPACKAGE_TAG = "@subpackage";
    @NlsSafe
    public static final String THROWS_TAG = "@throws";
    @NlsSafe
    public static final String TODO_TAG = "@todo";
    @NlsSafe
    public static final String USES_TAG = "@uses";
    @NlsSafe
    public static final String USED_BY_TAG = "used-by";
    @NlsSafe
    public static final String VAR_TAG = "@var";
    @NlsSafe
    public static final String VERSION_TAG = "@version";
    @NlsSafe
    public static final String INHERITDOC_TAG = "@inheritDoc";
    @NlsSafe
    public static final String MIXIN_TAG = "@mixin";
    @NlsSafe
    public static final String NOINSPECTION = "@noinspection";
    @NlsSafe
    public static final String TYPE_TAG = "@type";
    @NlsSafe
    public static final String FINAL_TAG = "@final";
    @NlsSafe
    public static final String CODE_TAG = "@code";
    public static final String[] ALL_TAGS = new String[]{"@api", "@author", "@category", "@copyright", "@deprecated", "@example", "@filesource", "@global", "@ignore", "@internal", "@license", "@link", "@method", "@package", "@param", "@property", "@property-read", "@property-write", "@return", "@see", "@since", "@subpackage", "@throws", "@todo", "@uses", "used-by", "@var", "@version", "@inheritDoc", "@mixin", "@final"};
    public static final Set<String> ALL_TAGS_SET = new HashSet<String>();
    public static final TokenSet ALLOWED_PHP_DOC_TOKENS;
    private static final Key<PhpPsiElementImpl.StubBuildCachedValue<Boolean>> NO_INSPECTION_TAG_STUB_BUILDING_KEY;
    private static final Key<PhpPsiElementImpl.StubBuildCachedValue<MultiMap<String, PhpDocTag>>> GET_TAGS_BY_NAME_STUB_BUILDING_KEY;

    private PhpDocUtil() {
    }

    public static String getTagValue(PhpDocTag tagElement, boolean isRenderedDocGeneration) {
        StringBuilder valueBuf = new StringBuilder();
        PsiElement lastChild = tagElement.getLastChild();
        if (lastChild != null && PhpPsiUtil.isOfType(lastChild, (IElementType)PhpDocElementTypes.phpDocTagValue)) {
            PhpDocUtil.appendDescription(valueBuf, lastChild, isRenderedDocGeneration);
        }
        PsiElement nextElement = tagElement.getNextSibling();
        while (nextElement != null && (nextElement = PhpDocCodeUtil.getNextSiblingAfterCodeSection(nextElement, valueBuf)) != null && PhpDocUtil.appendDescription(valueBuf, nextElement, isRenderedDocGeneration)) {
            nextElement = PhpDocUtil.getNextSiblingIgnoringInlineDocTagRBrace(nextElement);
        }
        return valueBuf.toString().trim();
    }

    public static String getTagValue(PhpDocTag tagElement) {
        return PhpDocUtil.getTagValue(tagElement, false);
    }

    private static PsiElement getNextSiblingIgnoringInlineDocTagRBrace(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement nextSibling = element.getNextSibling();
        if (!(element instanceof PhpDocTag)) {
            return nextSibling;
        }
        return PhpDocTagImpl.isInline((PhpDocTag)element) ? nextSibling.getNextSibling() : nextSibling;
    }

    @NotNull
    public static String getDescription(@Nullable PhpDocComment docComment) {
        return PhpDocUtil.getDescription(docComment, false);
    }

    @NotNull
    public static String getDescription(@Nullable PhpDocComment docComment, boolean isRenderedDocGeneration) {
        if (docComment == null) {
            return "";
        }
        StringBuilder descBuf = new StringBuilder();
        StringBuilder todoBuffer = new StringBuilder();
        List<TextRange> todoRanges = PhpDocUtil.getAllToDo(docComment);
        PsiElement child = docComment.getFirstChild();
        while (child != null && (child = PhpDocCodeUtil.getNextSiblingAfterCodeSection(child, descBuf)) != null && (PhpDocUtil.appendTodo(todoRanges, child, todoBuffer) || PhpDocUtil.appendDescription(descBuf, child, isRenderedDocGeneration))) {
            child = PhpDocUtil.getNextSiblingIgnoringInlineDocTagRBrace(child);
        }
        if (!todoBuffer.isEmpty()) {
            String description = StringsKt.trimIndent((String)descBuf.toString()).trim();
            descBuf.setLength(0);
            descBuf.append(description);
            if (!description.isEmpty()) {
                todoBuffer.append("<br>");
            }
            Object @NotNull [] lines = StringUtil.splitByLines((String)todoBuffer.toString());
            QuickDocHighlightingHelper.appendStyledFragment((StringBuilder)descBuf, (String)StringUtil.join((Object[])lines, line -> line.trim(), (String)"\n"), (TextAttributesKey)CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
        }
        @NlsSafe String string = descBuf.toString();
        String string2 = DocMarkdownToHtmlConverter.convert((Project)docComment.getProject(), (String)string, (Language)PhpLanguage.INSTANCE).replace("\u00a0", "&nbsp;");
        if (string2 == null) {
            PhpDocUtil.$$$reportNull$$$0(0);
        }
        return string2;
    }

    private static boolean appendDescription(StringBuilder buf, PsiElement element, boolean isRenderedDocGeneration) {
        ASTNode childNode = element.getNode();
        if (childNode == null) {
            return false;
        }
        IElementType currType = childNode.getElementType();
        if (currType == PhpDocTokenTypes.DOC_COMMENT_END || currType == PhpDocElementTypes.phpDocSpecialTag) {
            return false;
        }
        if (element instanceof PhpDocTag) {
            ASTNode prevNode;
            PsiElement prevChild = element.getPrevSibling();
            if (prevChild != null && (prevNode = prevChild.getNode()) != null) {
                if (prevNode.getElementType() != PhpDocTokenTypes.DOC_LBRACE) {
                    return false;
                }
                buf.deleteCharAt(buf.length() - 1);
                PhpDocUtil.appendInlineTag(buf, (PhpDocTag)element, isRenderedDocGeneration);
                return true;
            }
        } else {
            if (PhpPsiUtil.isOfType(childNode, PhpDocTokenTypes.DOC_URL)) {
                @NlsSafe String linkValue = childNode.getText();
                buf.append(HtmlChunk.link((String)linkValue, (String)linkValue));
                return true;
            }
            if (currType == PhpDocElementTypes.phpDocTagValue) {
                PsiElement valueChild = element.getFirstChild();
                while (valueChild != null) {
                    if ((valueChild = PhpDocCodeUtil.getNextSiblingAfterCodeSection(valueChild, buf)) == null) {
                        return true;
                    }
                    PsiElement next = valueChild.getNextSibling();
                    if (PhpPsiUtil.isOfType(valueChild, PhpDocTokenTypes.DOC_LBRACE) && next instanceof PhpDocTag && PhpDocTagImpl.isInline((PhpDocTag)next)) {
                        PhpDocUtil.appendInlineTag(buf, (PhpDocTag)next, isRenderedDocGeneration);
                        valueChild = PhpDocUtil.getNextSiblingIgnoringInlineDocTagRBrace(next);
                        continue;
                    }
                    buf.append(valueChild.getNode().getChars());
                    valueChild = valueChild.getNextSibling();
                }
                return true;
            }
        }
        if (currType != PhpDocTokenTypes.DOC_LEADING_ASTERISK && currType != PhpDocTokenTypes.DOC_COMMENT_START) {
            int lastEolPos;
            String elementText = element.getText();
            if (childNode.getPsi() instanceof PsiWhiteSpace && childNode.textContains('\n') && (lastEolPos = elementText.lastIndexOf(10)) >= 0) {
                elementText = elementText.substring(0, lastEolPos + 1);
            }
            buf.append(elementText);
        }
        return true;
    }

    private static void appendInlineTag(StringBuilder buf, PhpDocTag tagElement, boolean isRenderedDocGeneration) {
        ASTNode node = tagElement.getNode();
        if (node != null) {
            String tagName = null;
            StringBuilder textBuf = new StringBuilder();
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() == PhpDocTokenTypes.DOC_TAG_NAME) {
                    tagName = child.getText();
                    continue;
                }
                if (child.getElementType() == PhpDocElementTypes.phpDocRef) {
                    textBuf.append(child.getText());
                    textBuf.append(" ");
                    continue;
                }
                if (child.getElementType() != PhpDocElementTypes.phpDocTagValue) continue;
                for (ASTNode valueChild = child.getFirstChildNode(); valueChild != null; valueChild = valueChild.getTreeNext()) {
                    textBuf.append(valueChild.getText());
                }
            }
            if (tagName != null) {
                PhpDocUtil.appendInlineTag(buf, tagName, textBuf.toString(), tagElement, isRenderedDocGeneration);
                return;
            }
        }
        buf.append(PhpDocUtil.markAsError(tagElement.getText()));
    }

    private static void appendInlineTag(@NotNull StringBuilder outBuf, @NotNull String tagName, @NotNull @NlsSafe String tagValue, @NotNull PhpDocTag tag, boolean isRenderedDocGeneration) {
        if (outBuf == null) {
            PhpDocUtil.$$$reportNull$$$0(1);
        }
        if (tagName == null) {
            PhpDocUtil.$$$reportNull$$$0(2);
        }
        if (tagValue == null) {
            PhpDocUtil.$$$reportNull$$$0(3);
        }
        if (tag == null) {
            PhpDocUtil.$$$reportNull$$$0(4);
        }
        if (LINK_TAG.equals(tagName) || SEE_TAG.equals(tagName)) {
            String[] chunks = tagValue.split(" ");
            if (chunks.length > 0) {
                Object target;
                String linkValue = chunks[0].trim();
                String linkDesc = tagValue.replace(linkValue, "").trim();
                if (!linkValue.startsWith("http://") && !linkValue.startsWith("https://")) {
                    if (isRenderedDocGeneration && PhpDocUtil.unresolvedLink(linkValue, tag.getContext())) {
                        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)outBuf, (String)linkValue, (TextAttributesKey)PhpHighlightingData.DOC_IDENTIFIER);
                        return;
                    }
                    target = "psi_element://" + linkValue;
                } else {
                    target = linkValue;
                }
                outBuf.append(HtmlChunk.link((String)target, (String)(linkDesc.isEmpty() ? linkValue : linkDesc)));
            }
        } else if (INHERITDOC_TAG.equalsIgnoreCase(tagName)) {
            outBuf.append(tagName);
        } else if (CODE_TAG.equals(tagName)) {
            PhpDocCodeUtil.appendCodeSnippet(tagValue, outBuf, tag.getProject(), true);
        }
    }

    private static String markAsError(String text) {
        return "<u color='red'>" + text + "</u>";
    }

    public static String extractDefinition(PhpNamedElement psiElement, boolean isGenerationForRenderedDoc) {
        ASTNode node;
        boolean hasAttribute;
        StringBuilder buf = new StringBuilder();
        PsiElement child = psiElement.getFirstChild();
        if (psiElement instanceof PhpDocMethod && !isGenerationForRenderedDoc) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)METHOD_TAG, (TextAttributesKey)PhpHighlightingData.DOC_COMMENT);
            buf.append(HtmlChunk.nbsp());
        }
        boolean bl = hasAttribute = psiElement instanceof PhpAttributesOwner && !((PhpAttributesOwner)((Object)psiElement)).getAttributes().isEmpty();
        while (child != null && ((node = child.getNode()) == null || !PhpElementTypes.ANY_GROUP_STATEMENT.contains(node.getElementType()) && node.getElementType() != PhpTokenTypes.chLBRACE && node.getElementType() != PhpTokenTypes.opCOLON)) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.IDENTIFIER)) {
                String name = psiElement.getName();
                if (psiElement instanceof Function) {
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)name, (TextAttributesKey)PhpHighlightingData.FUNCTION);
                } else if (psiElement instanceof PhpClass) {
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)name, (TextAttributesKey)PhpHighlightingData.CLASS);
                }
            } else if (child instanceof ExtendsList || child instanceof ImplementsList) {
                List<ClassReference> elements;
                List<ClassReference> list = elements = child instanceof ExtendsList ? ((ExtendsList)child).getReferenceElements() : ((ImplementsList)child).getReferenceElements();
                if (!elements.isEmpty()) {
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)(child instanceof ExtendsList ? "extends " : "implements "), (TextAttributesKey)PhpHighlightingData.KEYWORD);
                    for (ClassReference element : elements) {
                        PhpNamedElementDocSource.appendLink(buf, element.getFQN(), true);
                        buf.append(", ");
                    }
                    buf.setLength(buf.length() - 2);
                }
            } else if (child instanceof ParameterList) {
                PsiElement[] parameters = ((ParameterList)child).getParameters();
                if (psiElement instanceof PhpDocMethod) {
                    for (PsiElement parameterListChild = child.getFirstChild(); parameterListChild != null; parameterListChild = parameterListChild.getNextSibling()) {
                        if (parameterListChild instanceof Parameter) {
                            PhpFunctionDocSource.appendParameterSignature((Parameter)parameterListChild, buf, true, isGenerationForRenderedDoc);
                            continue;
                        }
                        buf.append(PhpDocUtil.prepareText(parameterListChild.getText()));
                    }
                } else if (parameters.length > 0) {
                    buf.append("<br>");
                    for (PsiElement parameter : parameters) {
                        if (!(parameter instanceof Parameter)) continue;
                        buf.append(StringUtil.repeatSymbol((char)' ', (int)CodeStyle.getIndentSize((PsiFile)psiElement.getContainingFile())));
                        PhpFunctionDocSource.appendParameterSignature((Parameter)parameter, buf, false, isGenerationForRenderedDoc);
                        if (parameters[parameters.length - 1] == parameter) continue;
                        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)",", (TextAttributesKey)PhpHighlightingData.COMMA);
                        buf.append("<br>");
                    }
                    buf.append("<br>");
                }
            } else if (child instanceof PhpAttributesList) {
                StringBuilder attributes = new StringBuilder();
                PhpDocUtil.appendAttributeListDoc(attributes, (PhpAttributesList)child);
                if (!attributes.isEmpty()) {
                    attributes.append("<br>");
                    buf.append((CharSequence)attributes);
                }
            } else {
                if (child instanceof PsiWhiteSpace && PhpDocUtil.skipWhiteSpace(child)) {
                    child = child.getNextSibling();
                    continue;
                }
                if (!hasAttribute || !(child instanceof PhpDocComment)) {
                    String text = PhpDocUtil.prepareText(child.getText());
                    if (PhpPsiUtil.isOfType(child, PhpTokenTypes.tsKEYWORDS) || child instanceof PhpModifierList) {
                        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)text, (TextAttributesKey)PhpHighlightingData.KEYWORD);
                    } else if (PhpPsiUtil.isOfType(child, PhpTokenTypes.tsPARENTHESES)) {
                        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)text, (TextAttributesKey)PhpHighlightingData.PARENTHESES);
                    } else if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.opSEMICOLON)) {
                        buf.append(text);
                    }
                }
            }
            child = child.getNextSibling();
        }
        return buf.toString().trim();
    }

    public static boolean skipWhiteSpace(PsiElement child) {
        PsiElement next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true);
        PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(child, true);
        return next instanceof ParameterList || prev instanceof ParameterList || prev instanceof PhpAttributesList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void appendAttributeListDoc(StringBuilder buf, PhpAttributesList child) {
        @NotNull List attributes = ContainerUtil.filter((Collection)child.getAttributes(), attribute -> !PhpDocUtil.isInternalAtribute(attribute));
        if (!attributes.isEmpty()) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)"#[", (TextAttributesKey)PhpHighlightingData.ATTRIBUTE);
            for (PhpAttribute attribute2 : attributes) {
                String fqn = attribute2.getFQN();
                if (fqn == null) continue;
                PhpNamedElementDocSource.appendAttributeLink(buf, fqn, true);
                Object[] parameters = attribute2.getParameters();
                if (parameters.length > 0) {
                    buf.append("(");
                    buf.append(StringUtil.join((Object[])parameters, p -> PhpDocUtil.getDefaultValue(p), (String)", "));
                    buf.append(")");
                }
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)"] ", (TextAttributesKey)PhpHighlightingData.ATTRIBUTE);
        }
    }

    public static String getDefaultValue(@Nullable PsiElement element) {
        StringBuilder buf = new StringBuilder();
        if (element instanceof ParenthesizedExpression) {
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)element;
            return "(" + PhpDocUtil.getDefaultValue((PsiElement)parenthesizedExpression.extract()) + ")";
        }
        if (element == null) {
            return "";
        }
        if (!(element instanceof PhpExpression)) {
            return PhpDocUtil.getDefaultValue(element.getFirstChild());
        }
        if (element instanceof StringLiteralExpression) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)XmlStringUtil.escapeString((String)element.getText()), (TextAttributesKey)PhpHighlightingData.STRING);
        } else if (PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER)) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)element.getText(), (TextAttributesKey)PhpHighlightingData.NUMBER);
        } else if (element instanceof ArrayCreationExpression) {
            ArrayCreationExpression arrayCreation = (ArrayCreationExpression)element;
            PhpDocUtil.appendArrayCreation(arrayCreation, buf);
        } else if (element instanceof PhpReference) {
            PhpReference reference = (PhpReference)element;
            PhpDocUtil.appendReference(reference, buf);
        } else if (element instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)element;
            PhpDocUtil.appendBinaryExpression(binaryExpression, buf);
        } else {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)element.getText(), (TextAttributesKey)PhpHighlightingData.IDENTIFIER);
        }
        return buf.toString();
    }

    private static void appendReference(@NotNull PhpReference reference, @NotNull StringBuilder buf) {
        MemberReference memberReference;
        PhpExpression classRef;
        String refText;
        if (reference == null) {
            PhpDocUtil.$$$reportNull$$$0(5);
        }
        if (buf == null) {
            PhpDocUtil.$$$reportNull$$$0(6);
        }
        boolean enumValueRef = (refText = reference.getText()).contains("::") && refText.contains("->");
        StringBuilder builder2 = new StringBuilder();
        String classRefText = "";
        if (reference instanceof MemberReference && (classRef = (memberReference = (MemberReference)reference).getClassReference()) != null) {
            classRefText = classRef.getText();
            builder2.append(classRefText);
            builder2.append(memberReference.isStatic() ? "::" : "->");
        }
        String name = reference instanceof FieldReference && !enumValueRef ? "$" + reference.getName() : reference.getName();
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)builder2, (String)name, (TextAttributesKey)(PhpType.isPrimitiveType(refText) ? PhpHighlightingData.PRIMITIVE_TYPE_HINT : PhpHighlightingData.CONSTANT));
        PhpNamedElementDocSource.appendLink(buf, enumValueRef ? classRefText : refText, builder2.toString(), true);
    }

    private static void appendArrayCreation(@NotNull ArrayCreationExpression arrayCreation, @NotNull StringBuilder buf) {
        if (arrayCreation == null) {
            PhpDocUtil.$$$reportNull$$$0(7);
        }
        if (buf == null) {
            PhpDocUtil.$$$reportNull$$$0(8);
        }
        buf.append("[");
        for (PsiElement child : arrayCreation.getChildren()) {
            if (child instanceof ArrayHashElement) {
                ArrayHashElement hashElement = (ArrayHashElement)child;
                buf.append(PhpDocUtil.getDefaultValue((PsiElement)hashElement.getKey()));
                buf.append(" => ");
                buf.append(PhpDocUtil.getDefaultValue((PsiElement)hashElement.getValue()));
            } else {
                buf.append(PhpDocUtil.getDefaultValue(child));
            }
            buf.append(", ");
        }
        if (buf.length() >= 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append("]");
    }

    private static void appendBinaryExpression(@NotNull BinaryExpression binaryExpression, @NotNull StringBuilder buf) {
        if (binaryExpression == null) {
            PhpDocUtil.$$$reportNull$$$0(9);
        }
        if (buf == null) {
            PhpDocUtil.$$$reportNull$$$0(10);
        }
        buf.append(PhpDocUtil.getDefaultValue(binaryExpression.getLeftOperand()));
        PsiElement operation = binaryExpression.getOperation();
        if (operation != null) {
            buf.append(" ").append(XmlStringUtil.escapeString((String)operation.getText())).append(" ");
        }
        buf.append(PhpDocUtil.getDefaultValue(binaryExpression.getRightOperand()));
    }

    public static boolean isInternalAtribute(@NotNull PhpAttribute attribute) {
        if (attribute == null) {
            PhpDocUtil.$$$reportNull$$$0(11);
        }
        return PhpDocUtil.isInternalAttributeFQN(attribute.getFQN());
    }

    public static boolean isInternalAttributeFQN(@Nullable String fqn) {
        return StringUtil.startsWith((CharSequence)StringUtil.notNullize((String)fqn), (CharSequence)"\\JetBrains\\PhpStorm\\Internal\\");
    }

    public static String prepareText(String text) {
        String result = text.replace("<script", "&lt;script").replace("</script>", "&lt;/script&gt;").replaceAll("\n\\s*\n", "<br>").replaceAll("<([^a-zA-Z/]|$)", "&lt;$1");
        return result;
    }

    public static String convertFromMarkdown(@NotNull Project project, @NotNull @NlsSafe String text) {
        if (project == null) {
            PhpDocUtil.$$$reportNull$$$0(12);
        }
        if (text == null) {
            PhpDocUtil.$$$reportNull$$$0(13);
        }
        return StringUtil.trimStart((String)DocMarkdownToHtmlConverter.convert((Project)project, (String)text), (String)"<p>");
    }

    @Nullable
    public static String getParamName(@NotNull PhpDocTag docTag, @NotNull Function function) {
        Object nextElement;
        PsiElement tagName;
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(14);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(15);
        }
        if ((tagName = docTag.getFirstChild()) == null || !PARAM_TAG.equals(tagName.getText())) {
            return null;
        }
        for (nextElement = tagName; nextElement != null; nextElement = nextElement.getNextSibling()) {
            String paramName = PhpDocUtil.getParamName(nextElement);
            if (paramName == null) continue;
            return paramName;
        }
        nextElement = docTag.getNextPsiSibling();
        if (nextElement instanceof PsiWhiteSpace) {
            nextElement = nextElement.getNextSibling();
        }
        if (nextElement != null) {
            String candidateName = nextElement.getText();
            for (Parameter parameter : function.getParameters()) {
                if (!candidateName.equals(parameter.getName())) continue;
                return candidateName;
            }
        }
        return null;
    }

    @Nullable
    private static String getParamName(PsiElement element) {
        String text = element.getText();
        if (StringUtil.startsWithChar((CharSequence)text, (char)'$')) {
            text = text.substring(1);
        } else if (text.startsWith("&$")) {
            text = text.substring(2);
        } else if (text.startsWith("...$")) {
            text = text.substring(4);
        } else {
            return null;
        }
        int unlimitedPos = text.indexOf(",...");
        if (unlimitedPos > 0) {
            text = text.substring(0, unlimitedPos);
        }
        return text;
    }

    public static String @NotNull [] getRawParamTypeStrings(@NotNull PhpDocTag docTag, @NotNull Function function) {
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(16);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(17);
        }
        PsiElement tagName = docTag.getFirstChild();
        ArrayList<String> typeStrings = new ArrayList<String>();
        if (tagName != null && PARAM_TAG.equals(tagName.getText())) {
            String text;
            String paramName = PhpDocUtil.getParamName(docTag, function);
            PsiElement nextElement = tagName.getNextSibling();
            if (nextElement instanceof PsiWhiteSpace) {
                nextElement = nextElement.getNextSibling();
            }
            if (!(nextElement == null || StringUtil.startsWithChar((CharSequence)(text = nextElement.getText()), (char)'$') || text.startsWith("&$") || paramName != null && paramName.equals(text))) {
                typeStrings.add(text);
                boolean typeExpected = false;
                for (nextElement = nextElement.getNextSibling(); nextElement != null; nextElement = nextElement.getNextSibling()) {
                    IElementType currType = nextElement.getNode().getElementType();
                    if (currType == PhpDocTokenTypes.DOC_PIPE) {
                        typeExpected = true;
                        continue;
                    }
                    if (nextElement instanceof PsiWhiteSpace) continue;
                    if (!typeExpected) break;
                    typeStrings.add(nextElement.getText());
                    typeExpected = false;
                }
            }
        }
        if (typeStrings.isEmpty()) {
            typeStrings.add("mixed");
        }
        String[] stringArray = ArrayUtilRt.toStringArray(typeStrings);
        if (stringArray == null) {
            PhpDocUtil.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    public static PhpType getParamType(@NotNull PhpDocTag docTag, @NotNull Function function) {
        PhpType docType;
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(19);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(20);
        }
        if (docTag instanceof PhpDocParamTag && docTag.textContains('$') && !(docType = docTag.getGlobalType()).isEmpty()) {
            return docType;
        }
        String[] typeStrings = PhpDocUtil.getRawParamTypeStrings(docTag, function);
        PhpType paramType = new PhpType();
        for (String typeString : typeStrings) {
            paramType.add(PhpDocUtil.getTypeString(typeString, function));
        }
        return paramType;
    }

    public static String getTypeString(@NotNull String text, @NotNull PhpPsiElement element) {
        if (text == null) {
            PhpDocUtil.$$$reportNull$$$0(21);
        }
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(22);
        }
        String typeString = text;
        if ("$this".equals(text)) {
            return text;
        }
        if ("self".equals(text)) {
            return text;
        }
        if ("static".equals(text)) {
            return text;
        }
        if (PhpType.isPrimitiveType(typeString) || PhpType.isPluralPrimitiveType(typeString) || PhpType.isResourceOrNumberType(typeString)) {
            return StringUtil.startsWithChar((CharSequence)typeString, (char)'\\') ? typeString : "\\" + typeString;
        }
        typeString = PhpReferenceImpl.findNamespaceName(typeString, (PsiElement)element);
        return typeString;
    }

    @NotNull
    public static String getParamTagValue(PhpDocTag paramTag, Function function) {
        String prefixedString;
        PsiElement childElement = paramTag.getFirstChild();
        if (childElement == null || !PARAM_TAG.equals(childElement.getText())) {
            return "";
        }
        String afterString = PhpDocUtil.getParamName(paramTag, function);
        String string = prefixedString = afterString != null ? "$" + afterString : null;
        if (afterString == null) {
            String[] typeStrings = PhpDocUtil.getRawParamTypeStrings(paramTag, function);
            afterString = typeStrings[typeStrings.length - 1];
        }
        StringBuilder result = new StringBuilder();
        boolean isCollecting = false;
        while (childElement != null) {
            String elementText = childElement.getText();
            if (isCollecting) {
                result.append(elementText);
            }
            if (elementText.equals(afterString) || elementText.equals(prefixedString)) {
                isCollecting = true;
            }
            childElement = childElement.getNextSibling();
        }
        String string2 = result.toString().trim();
        if (string2 == null) {
            PhpDocUtil.$$$reportNull$$$0(23);
        }
        return string2;
    }

    public static boolean isSimpleTag(PsiElement element) {
        IElementType prevType;
        if (!(element instanceof PhpDocTag)) {
            return false;
        }
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if ((prevType = PsiUtilCore.getElementType((PsiElement)prev)) == PhpDocTokenTypes.DOC_LEADING_ASTERISK || prevType == PhpDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
            PsiElement child = element.getFirstChild();
            if (child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TAG_NAME)) {
                if (ALL_TAGS_SET.contains(child.getText())) {
                    return true;
                }
                if ((child = PhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true)) == null) {
                    return true;
                }
                IElementType childType = child.getNode().getElementType();
                if (childType == PhpDocElementTypes.phpDocType || childType == PhpDocElementTypes.phpDocVariable || childType == PhpDocElementTypes.phpDocRef) {
                    return true;
                }
                if (childType == PhpDocElementTypes.phpDocTagValue && ((child = child.getFirstChild()) == null || PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER) || PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TEXT))) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInsidePhpDocAttributeList(@NotNull PsiElement element) {
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(24);
        }
        for (PsiElement parent = element.getParent(); parent != null && !(parent instanceof PsiFile) && !(parent instanceof PhpDocComment); parent = parent.getParent()) {
            if (!PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocAttributeList)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDocVarType(@Nullable String tagName) {
        return VAR_TAG.equals(tagName) || GLOBAL_TAG.equals(tagName) || TYPE_TAG.equals(tagName);
    }

    @NotNull
    public static String getTypePresentation(@NotNull Project project, @NotNull PhpType phpType, @Nullable PhpPsiElement scope) {
        if (project == null) {
            PhpDocUtil.$$$reportNull$$$0(25);
        }
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(26);
        }
        return PhpDocUtil.getTypePresentation(project, phpType, scope, null);
    }

    @NotNull
    public static String getTypePresentation(@NotNull Project project, @NotNull PhpType phpType, @Nullable PhpPsiElement scope, @Nullable PhpTypeDeclaration sortBy2) {
        if (project == null) {
            PhpDocUtil.$$$reportNull$$$0(27);
        }
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(28);
        }
        PhpCodeStyleSettings codeStyleSettings = scope == null ? null : (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)scope.getContainingFile(), PhpCodeStyleSettings.class);
        Comparator<String> comparator = PhpDocUtil.docTypesComparator(sortBy2, codeStyleSettings);
        return PhpDocUtil.toQualifiedPresentation(phpType.global(project), scope, codeStyleSettings, comparator);
    }

    public static Comparator<String> docTypesComparator(@Nullable PhpTypeDeclaration sortBy2, @Nullable PhpCodeStyleSettings codeStyleSettings) {
        Comparator<String> nullOrder = codeStyleSettings == null ? null : PhpDocUtil.nullOrderSettingsComparator(codeStyleSettings);
        Comparator<String> originalOrder = sortBy2 == null ? String.CASE_INSENSITIVE_ORDER : PhpDocUtil.typeDeclarationComparator(sortBy2);
        return nullOrder == null ? originalOrder : nullOrder.thenComparing(originalOrder);
    }

    private static Comparator<String> nullOrderSettingsComparator(@NotNull PhpCodeStyleSettings settings) {
        if (settings == null) {
            PhpDocUtil.$$$reportNull$$$0(29);
        }
        if (settings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE) {
            return (a1, a2) -> 0;
        }
        return (o1, o2) -> {
            if ("\\null".equalsIgnoreCase((String)o1)) {
                return settings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING ? -1 : 1;
            }
            if ("\\null".equalsIgnoreCase((String)o2)) {
                return settings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING ? 1 : -1;
            }
            return 0;
        };
    }

    private static Comparator<String> typeDeclarationComparator(@NotNull PhpTypeDeclaration element) {
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(30);
        }
        List references = ContainerUtil.map(element.getClassReferences(), c -> c.getDeclaredType().global(c.getProject()).getTypes().iterator().next());
        return (o1, o2) -> {
            int i2;
            int i1 = references.indexOf(o1);
            if (i1 == (i2 = references.indexOf(o2))) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1, o2);
            }
            if (i1 < 0) {
                return 1;
            }
            if (i2 < 0) {
                return -1;
            }
            return Integer.compare(i1, i2);
        };
    }

    @NotNull
    public static PhpType getReturnType(@NotNull Function function) {
        PhpType type;
        PhpType globalInferredType;
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(31);
        }
        PhpType phpType = (globalInferredType = (type = PhpDocUtil.getDeclaredOrInferredType(function)).global(function.getProject())).filterUnknown().isEmpty() && !type.isEmpty() ? PhpType.MIXED : globalInferredType;
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(32);
        }
        return phpType;
    }

    public static PhpType getParameterType(@NotNull Parameter parameter) {
        if (parameter == null) {
            PhpDocUtil.$$$reportNull$$$0(33);
        }
        PhpType declaredOrInferredType = PhpDocUtil.getDeclaredOrInferredType(parameter).global(parameter.getProject());
        ConstantReference defaultValue = (ConstantReference)ObjectUtils.tryCast((Object)parameter.getDefaultValue(), ConstantReference.class);
        if (defaultValue == null || PhpType.intersects(defaultValue.getType(), declaredOrInferredType)) {
            return declaredOrInferredType;
        }
        return PhpType.or(declaredOrInferredType, defaultValue.getType());
    }

    private static PhpType getDeclaredOrInferredType(@NotNull PhpTypedElement e) {
        PhpType declaredType;
        if (e == null) {
            PhpDocUtil.$$$reportNull$$$0(34);
        }
        if (!(declaredType = e.getDeclaredType()).isEmpty()) {
            return declaredType;
        }
        return e.getInferredType();
    }

    @NotNull
    public static List<PhpDocTag> collectTagsConsideringInheritance(@NotNull Function function, @NotNull String tagName) {
        SmartList tags;
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(35);
        }
        if (tagName == null) {
            PhpDocUtil.$$$reportNull$$$0(36);
        }
        if (PhpDocUtil.processFunction(function, tagName, (List<PhpDocTag>)(tags = new SmartList())) && function instanceof Method) {
            PhpClassHierarchyUtils.processSuperMethods((Method)function, (arg_0, arg_1, arg_2) -> PhpDocUtil.lambda$collectTagsConsideringInheritance$7(tagName, (List)tags, arg_0, arg_1, arg_2));
        }
        SmartList smartList = tags;
        if (smartList == null) {
            PhpDocUtil.$$$reportNull$$$0(37);
        }
        return smartList;
    }

    private static boolean processFunction(@NotNull Function function, @NotNull String name, @NotNull List<PhpDocTag> tags) {
        PhpDocComment comment;
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(38);
        }
        if (name == null) {
            PhpDocUtil.$$$reportNull$$$0(39);
        }
        if (tags == null) {
            PhpDocUtil.$$$reportNull$$$0(40);
        }
        if (!(function instanceof PhpDocMethod) && (comment = function.getDocComment()) != null) {
            tags.addAll(Arrays.asList(comment.getTagElementsByName(name)));
            if (!comment.hasInheritDocTag()) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasOnlyNoInspectionTag(@NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(41);
        }
        return PhpPsiElementImpl.getCachedValueStubBuildOptimized((PsiElement)comment, NO_INSPECTION_TAG_STUB_BUILDING_KEY, () -> CachedValueProvider.Result.createSingleDependency((Object)PhpDocUtil.hasOnlyTagWithName(comment, NOINSPECTION), (Object)comment));
    }

    public static TodoItem[] getToDoItems(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            PhpDocUtil.$$$reportNull$$$0(42);
        }
        if (file == null) {
            PhpDocUtil.$$$reportNull$$$0(43);
        }
        return (TodoItem[])CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.createSingleDependency((Object)PsiTodoSearchHelper.getInstance((Project)project).findTodoItemsLight(file), (Object)file));
    }

    public static boolean hasOnlyTagWithName(@NotNull PhpDocComment comment, String tagName) {
        List tags;
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(44);
        }
        if ((tags = PhpPsiUtil.getChildren((PsiElement)comment, PhpDocTag.INSTANCEOF)).size() != 1) {
            return false;
        }
        PhpDocTag tag = (PhpDocTag)ContainerUtil.getFirstItem(tags);
        if (tag == null || !tagName.equalsIgnoreCase(tag.getName())) {
            return false;
        }
        for (PsiElement child = comment.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiWhiteSpace || child instanceof PhpDocTag || PhpPsiUtil.isOfType(child, ALLOWED_PHP_DOC_TOKENS)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static String toQualifiedPresentation(@NotNull PhpType phpType, @Nullable PhpPsiElement scope, PhpCodeStyleSettings codeStyleSettings, @Nullable Comparator<String> comparator) {
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(45);
        }
        Set<String> types = phpType.getTypesSorted();
        if (comparator != null) {
            TreeSet<String> sortedTypes = new TreeSet<String>(comparator);
            sortedTypes.addAll(types);
            types = sortedTypes;
        }
        StringBuilder typeBuilder = new StringBuilder();
        boolean flag = false;
        for (String type : types) {
            boolean shouldWrap;
            if (type.startsWith("?")) continue;
            if (!flag) {
                flag = true;
            } else {
                typeBuilder.append("|");
            }
            String normalizedType = PhpType.toString(type);
            boolean bl = shouldWrap = PhpType.isIntersectionType(type) && types.size() > 1;
            if (scope != null && !codeStyleSettings.PHPDOC_USE_FQCN && PhpLangUtil.isFqn(normalizedType)) {
                typeBuilder.append(PhpDocUtil.wrapGroupingTypes(PhpCodeInsightUtil.createQualifiedName(scope, normalizedType, true, true), shouldWrap));
                continue;
            }
            typeBuilder.append(PhpDocUtil.wrapGroupingTypes(normalizedType, shouldWrap));
        }
        String string = typeBuilder.toString();
        if (string == null) {
            PhpDocUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    private static String wrapGroupingTypes(String normalizedType, boolean shouldWrap) {
        if (shouldWrap) {
            normalizedType = "(" + (String)normalizedType + ")";
        }
        return normalizedType;
    }

    public static boolean hasDocTagWithName(@NotNull PhpDocComment docComment, @NotNull String tagName) {
        if (docComment == null) {
            PhpDocUtil.$$$reportNull$$$0(47);
        }
        if (tagName == null) {
            PhpDocUtil.$$$reportNull$$$0(48);
        }
        return !PhpDocUtil.getTagsByName(docComment).get((Object)tagName).isEmpty();
    }

    public static void processTagElementsByNames(@NotNull PhpDocComment comment, @NotNull Consumer<? super PhpDocTag> consumer, String ... tagNames) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(49);
        }
        if (consumer == null) {
            PhpDocUtil.$$$reportNull$$$0(50);
        }
        MultiMap<String, PhpDocTag> tagsByName = PhpDocUtil.getTagsByName(comment);
        Stream tagsToProcess = ContainerUtil.exists((Object[])tagNames, t -> t == null) ? tagsByName.values().stream() : Arrays.stream(tagNames).flatMap(t -> tagsByName.get(t).stream());
        tagsToProcess.forEach(consumer);
    }

    private static MultiMap<String, PhpDocTag> getTagsByName(@NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(51);
        }
        return PhpPsiElementImpl.getCachedValueStubBuildOptimized((PsiElement)comment, GET_TAGS_BY_NAME_STUB_BUILDING_KEY, () -> {
            MultiMap res = MultiMap.create();
            PhpDocUtil.processTagElementsByPredicate(comment, t -> res.putValue((Object)t.getName(), t), t -> true);
            return CachedValueProvider.Result.createSingleDependency((Object)res, (Object)comment);
        });
    }

    public static void processTagElementsByPredicate(@NotNull PhpDocComment comment, @NotNull Consumer<? super PhpDocTag> consumer, @NotNull Predicate<? super PhpDocTag> predicate) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(52);
        }
        if (consumer == null) {
            PhpDocUtil.$$$reportNull$$$0(53);
        }
        if (predicate == null) {
            PhpDocUtil.$$$reportNull$$$0(54);
        }
        PhpDocCommentStub stub = comment instanceof PhpDocCommentImpl ? (PhpDocCommentStub)((PhpDocCommentImpl)comment).getGreenStub() : null;
        List value = stub != null ? (List)CachedValuesManager.getCachedValue((PsiElement)comment, () -> CachedValueProvider.Result.createSingleDependency(PhpDocUtil.getDocTagsFromStubs((PhpDocCommentStub)((PhpDocCommentImpl)comment).getGreenStub()), (Object)comment)) : (List)CachedValuesManager.getCachedValue((PsiElement)comment, () -> CachedValueProvider.Result.createSingleDependency(PhpDocUtil.getDocTagsFromAST(comment), (Object)comment));
        for (PhpDocTag tag : value) {
            ProgressManager.checkCanceled();
            if (!predicate.test(tag)) continue;
            consumer.accept(tag);
        }
    }

    private static List<PhpDocTag> getDocTagsFromStubs(@Nullable PhpDocCommentStub stub) {
        ArrayList<PhpDocTag> res = new ArrayList<PhpDocTag>();
        if (stub != null) {
            for (StubElement child : stub.getChildrenStubs()) {
                if (!(child instanceof PhpDocTagStub)) continue;
                res.add((PhpDocTag)((PhpDocTagStub)child).getPsi());
            }
        }
        return res;
    }

    private static List<PhpDocTag> getDocTagsFromAST(PhpDocComment comment) {
        ArrayList<PhpDocTag> res = new ArrayList<PhpDocTag>();
        for (PsiElement child = comment.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PhpDocTag)) continue;
            res.add((PhpDocTag)child);
        }
        return res;
    }

    @Deprecated(forRemoval=true)
    public static boolean processTagElementsByName(@NotNull PhpDocComment comment, @Nullable String tagName, @NotNull Processor<? super PhpDocTag> processor) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(55);
        }
        if (processor == null) {
            PhpDocUtil.$$$reportNull$$$0(56);
        }
        PhpDocUtil.consumeTagElementsByName(comment, tagName, arg_0 -> processor.process(arg_0));
        return true;
    }

    public static void consumeTagElementsByName(@NotNull PhpDocComment comment, @Nullable String tagName, @NotNull Consumer<? super PhpDocTag> processor) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(57);
        }
        if (processor == null) {
            PhpDocUtil.$$$reportNull$$$0(58);
        }
        PhpDocUtil.processTagElementsByNames(comment, processor, tagName);
    }

    @NotNull
    public static Collection<TextRange> getRangesToHighlight(@NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(59);
        }
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new TextRange[]{comment.getFirstChild().getTextRangeInParent(), comment.getLastChild().getTextRangeInParent()});
        if (hashSet == null) {
            PhpDocUtil.$$$reportNull$$$0(60);
        }
        return hashSet;
    }

    public static void replaceFqnsWithImports(@NotNull PsiElement element) {
        PhpPsiElement scope;
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(61);
        }
        if ((scope = PhpCodeInsightUtil.findScopeForUseOperator(element)) == null) {
            return;
        }
        PhpCodeStyleSettings codeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)scope.getContainingFile(), PhpCodeStyleSettings.class);
        if (codeStyleSettings.PHPDOC_USE_FQCN) {
            return;
        }
        for (PhpDocType docType : PsiTreeUtil.findChildrenOfAnyType((PsiElement)element, (boolean)false, (Class[])new Class[]{PhpDocType.class})) {
            String fqn;
            if (StringUtil.isEmpty((String)docType.getName()) || ((PhpDocTypeImpl)docType).getNameIdentifier() == null || !PhpCodeEditUtil.importIfNeeded(docType, fqn = docType.getFQN(), scope)) continue;
            PhpImportClassIntention.replaceClassReference(docType, PhpLangUtil.toShortName(fqn));
        }
    }

    public static String getTagInfo(PhpDocTag tag, boolean isGenerationForRenderedDoc) {
        StringBuilder buf = new StringBuilder();
        PhpType type = tag.getType();
        if (!type.isEmpty()) {
            PhpNamedElementDocSource.appendTypeFromDocTag(buf, tag, isGenerationForRenderedDoc);
            buf.append(HtmlChunk.nbsp());
        }
        String tagValue = PhpDocUtil.getTagValue(tag, isGenerationForRenderedDoc);
        buf.append(PhpDocUtil.convertFromMarkdown(tag.getProject(), tagValue));
        return buf.toString();
    }

    public static TextAttributes getAttributes(TextAttributesKey textAttributesKey) {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(textAttributesKey);
    }

    public static boolean unresolvedLink(@Nullable String linkValue, @Nullable PsiElement context) {
        if (linkValue == null || context == null || DumbService.getInstance((Project)context.getProject()).isDumb()) {
            return true;
        }
        return PhpDocLinkResolver.resolve(linkValue, context).isEmpty();
    }

    public static PhpDocTag getFinalDocTag(PhpNamedElement element) {
        PhpDocComment docComment = element.getDocComment();
        if (docComment == null) {
            return null;
        }
        PhpDocTag tag = (PhpDocTag)ArrayUtil.getFirstElement((Object[])docComment.getTagElementsByName(FINAL_TAG));
        if (tag == null) {
            tag = PhpDocUtil.getFinalTagFromSuperComments(element);
        }
        return tag;
    }

    @Nullable
    private static PhpDocTag getFinalTagFromSuperComments(PhpNamedElement element) {
        Ref finalTag = new Ref(null);
        element.processDocs((Processor<PhpDocComment>)((Processor)docComment -> {
            if (docComment == null) {
                return false;
            }
            PhpDocTag tag = (PhpDocTag)ArrayUtil.getFirstElement((Object[])docComment.getTagElementsByName(FINAL_TAG));
            if (tag == null) {
                return docComment.hasInheritDocTag();
            }
            finalTag.set((Object)tag);
            return false;
        }));
        return (PhpDocTag)finalTag.get();
    }

    @Nullable
    public static InspectionElement tryResolveSuppressedInspection(String shortName, PsiElement context) {
        if (StringUtil.isEmpty((String)shortName)) {
            return null;
        }
        Project project = context.getProject();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        InspectionToolWrapper toolWrapper = profile.getInspectionTool(shortName, project);
        if (toolWrapper == null) {
            return null;
        }
        return new InspectionElement(toolWrapper, PsiManager.getInstance((Project)project));
    }

    private static List<TextRange> getAllToDo(@NotNull PhpDocComment docComment) {
        if (docComment == null) {
            PhpDocUtil.$$$reportNull$$$0(62);
        }
        PsiFile file = docComment.getContainingFile();
        return Arrays.stream(PhpDocUtil.getToDoItems(docComment.getProject(), file)).map(item -> item.getTextRange()).toList();
    }

    private static boolean appendTodo(List<TextRange> todo, PsiElement element, StringBuilder buffer) {
        if (ContainerUtil.exists(todo, r -> r.intersects(element.getTextRange()))) {
            buffer.append(PhpDocUtil.getString(element));
            if (ContainerUtil.exists(todo, r -> r.getEndOffset() == element.getTextRange().getEndOffset())) {
                buffer.append("<br>");
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static String getString(@NotNull PsiElement element) {
        Object text;
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(63);
        }
        if (((String)(text = element.getText())).toLowerCase(Locale.ROOT).equals("todo") || ((String)text).toLowerCase(Locale.ROOT).equals("fixme")) {
            text = ((String)text).toUpperCase(Locale.ROOT) + ": ";
        }
        if (element instanceof PhpDocTag) {
            PhpDocTag phpdocTag = (PhpDocTag)element;
            String tagName = phpdocTag.getName().toLowerCase(Locale.ROOT);
            PsiElement lastChild = phpdocTag.getLastChild();
            if (lastChild != null) {
                if (tagName.equals(TODO_TAG)) {
                    text = "TODO: " + lastChild.getText();
                } else if (tagName.equals("@fixme")) {
                    text = "FIXME: " + lastChild.getText();
                }
            }
        }
        Object object = text;
        if (object == null) {
            PhpDocUtil.$$$reportNull$$$0(64);
        }
        return object;
    }

    private static /* synthetic */ boolean lambda$collectTagsConsideringInheritance$7(String tagName, List tags, Method classMember, PhpClass subClass, PhpClass baseClass) {
        return PhpDocUtil.processFunction(classMember, tagName, tags);
    }

    static {
        Collections.addAll(ALL_TAGS_SET, ALL_TAGS);
        ALLOWED_PHP_DOC_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpDocTokenTypes.DOC_COMMENT_START, PhpDocTokenTypes.DOC_LEADING_ASTERISK, PhpDocTokenTypes.DOC_COMMENT_END});
        NO_INSPECTION_TAG_STUB_BUILDING_KEY = Key.create((String)"php.stub.no.inspection.tag");
        GET_TAGS_BY_NAME_STUB_BUILDING_KEY = Key.create((String)"php.stub.get.tags.by.name");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 61, 62, 63 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outBuf";
                break;
            }
            case 2: 
            case 36: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayCreation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 12: 
            case 25: 
            case 27: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 31: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 22: 
            case 24: 
            case 30: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: 
            case 28: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 41: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 47: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocUtil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawParamTypeStrings";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTagValue";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTagsConsideringInheritance";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "toQualifiedPresentation";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToHighlight";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendInlineTag";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendReference";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendArrayCreation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendBinaryExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInternalAtribute";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertFromMarkdown";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getParamName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRawParamTypeStrings";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getParamType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePhpDocAttributeList";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypePresentation";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "nullOrderSettingsComparator";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "typeDeclarationComparator";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredOrInferredType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectTagsConsideringInheritance";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyNoInspectionTag";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getToDoItems";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyTagWithName";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "toQualifiedPresentation";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasDocTagWithName";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processTagElementsByNames";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getTagsByName";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processTagElementsByPredicate";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processTagElementsByName";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "consumeTagElementsByName";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToHighlight";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "replaceFqnsWithImports";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getAllToDo";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 61, 62, 63 -> new IllegalArgumentException(string);
        };
    }
}

