/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethodTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocCommentStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocCoversTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocDataProviderTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocDependsTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocExpectedExceptionTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocGroupTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLangTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLinkTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocCommentImpl
extends PhpPsiElementImpl<PhpDocCommentStub>
implements PhpDocComment {
    private static final Logger LOG = Logger.getInstance(PhpDocCommentImpl.class);
    private static final Collection<Class<? extends PhpDocTag>> CLASSES_TO_FETCH = Set.of(PhpDocCoversTag.class, PhpDocDataProviderTag.class, PhpDocDependsTag.class, PhpDocExpectedExceptionTag.class, PhpDocGroupTag.class, PhpDocLangTag.class, PhpDocLinkTag.class, PhpDocParamTag.class, PhpDocPropertyTag.class, PhpDocReturnTag.class, PhpDocMethodTag.class, PhpDocThrowsTag.class);

    public PhpDocCommentImpl(PhpDocCommentStub stub) {
        super(stub, PhpDocStubElementTypes.DOC_COMMENT);
    }

    public PhpDocCommentImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public IElementType getTokenType() {
        IStubElementType iStubElementType = this.getElementType();
        if (iStubElementType == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(0);
        }
        return iStubElementType;
    }

    @Override
    @Nullable
    public PhpDocReturnTag getReturnTag() {
        return (PhpDocReturnTag)ArrayUtil.getFirstElement((Object[])this.getTagElementsByName("@return"));
    }

    @Override
    public PhpDocLinkTag @Nullable [] getLinkTags() {
        return this.getDocTagByClass(PhpDocLinkTag.class).toArray(new PhpDocLinkTag[0]);
    }

    @Override
    @NotNull
    public List<PhpDocParamTag> getParamTags() {
        List list = ContainerUtil.filter(this.getDocTagByClass(PhpDocParamTag.class), tag -> {
            String name = tag.getName();
            return "@param".equalsIgnoreCase(name) || "@var".equalsIgnoreCase(name);
        });
        if (list == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    public <T extends PhpDocTag> List<T> getDocTagByClass(Class<T> aClass) {
        if (CLASSES_TO_FETCH.contains(aClass) || aClass.equals(PhpDocTag.class)) {
            return this.getDocTagsByClassCached(aClass);
        }
        LOG.warn(aClass.getName() + " is not present in PhpDocCommentImpl#CLASSES_TO_FETCH, slow path will be used");
        ArrayList tags = new ArrayList();
        PhpDocUtil.processTagElementsByPredicate(this, tag -> tags.add(tag), tag -> aClass.isInstance(tag) && StringUtil.isNotEmpty((String)tag.getName()));
        return tags;
    }

    private <T extends PhpDocTag> List<T> getDocTagsByClassCached(Class<T> aClass) {
        return (List)PhpDocCommentImpl.getTagsByClass(this).get(aClass);
    }

    private static MultiMap<Class<? extends PhpDocTag>, PhpDocTag> getTagsByClass(@NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(2);
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)comment, () -> {
            MultiMap res = MultiMap.create();
            PhpDocUtil.processTagElementsByPredicate(comment, t -> {
                Class clazz = (Class)ContainerUtil.find(CLASSES_TO_FETCH, c -> c.isAssignableFrom(t.getClass()));
                res.putValue((Object)clazz, t);
                res.putValue(PhpDocTag.class, t);
            }, tag -> StringUtil.isNotEmpty((String)tag.getName()));
            return CachedValueProvider.Result.createSingleDependency((Object)res, (Object)comment);
        });
    }

    @Override
    @NotNull
    public List<PhpDocPropertyTag> getPropertyTags() {
        List<PhpDocPropertyTag> list = this.getDocTagByClass(PhpDocPropertyTag.class);
        if (list == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public PhpDocParamTag getVarTag() {
        return (PhpDocParamTag)ContainerUtil.getOnlyItem(this.getVarTags());
    }

    @NotNull
    public Collection<PhpDocParamTag> getVarTags() {
        List list = ContainerUtil.filter(this.getDocTagByClass(PhpDocParamTag.class), PhpDocCommentImpl::isVarTag);
        if (list == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static boolean isVarTag(PhpDocParamTag paramTag) {
        String name = paramTag.getName();
        return "@var".equals(name) || "@type".equals(name);
    }

    @Override
    public PhpDocMethod @NotNull [] getMethods() {
        SmartList result = new SmartList();
        List<PhpDocMethodTag> tags = this.getDocTagByClass(PhpDocMethodTag.class);
        for (PhpDocMethodTag tag : tags) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)((PhpDocMethod)PsiTreeUtil.getStubChildOfType((PsiElement)tag, PhpDocMethod.class)));
        }
        PhpDocMethod[] phpDocMethodArray = result.isEmpty() ? PhpDocMethod.EMPTY_ARRAY : result.toArray(PhpDocMethod.EMPTY_ARRAY);
        if (phpDocMethodArray == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(5);
        }
        return phpDocMethodArray;
    }

    @Override
    public PhpDocTag @NotNull [] getTagElementsByName(String tagName) {
        if (tagName == null) {
            if (PhpDocTag.EMPTY_ARRAY == null) {
                PhpDocCommentImpl.$$$reportNull$$$0(6);
            }
            return PhpDocTag.EMPTY_ARRAY;
        }
        ArrayList tags = new ArrayList();
        PhpDocUtil.consumeTagElementsByName(this, tagName, tags::add);
        PhpDocTag[] phpDocTagArray = tags.toArray(PhpDocTag.EMPTY_ARRAY);
        if (phpDocTagArray == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(7);
        }
        return phpDocTagArray;
    }

    @Override
    public PhpType[] getExceptionClasses() {
        ArrayList<PhpType> exceptionClasses = new ArrayList<PhpType>();
        for (PhpDocTag exceptionTag : this.getTagElementsByName("@throws")) {
            exceptionClasses.add(exceptionTag.getType());
        }
        return exceptionClasses.toArray(new PhpType[0]);
    }

    public PsiElement getOwner() {
        PhpPsiElement next = this.getNextPsiSibling();
        if (next == null) {
            return null;
        }
        PhpPsiElement owner = PhpPsiElementImpl.findNextPhpPsiElement((PsiElement)next);
        if (owner == null) {
            return null;
        }
        IElementType elementType = owner.getNode().getElementType();
        if (elementType == PhpElementTypes.CLASS_FIELDS) {
            owner = PhpPsiUtil.getChildOfType((PsiElement)owner, PhpStubElementTypes.CLASS_FIELD);
        } else if (elementType == PhpElementTypes.CLASS_CONSTANTS) {
            owner = PhpPsiUtil.getChildOfType((PsiElement)owner, PhpStubElementTypes.CLASS_CONST);
        } else if (elementType == PhpElementTypes.CONSTANTS) {
            owner = PhpPsiUtil.getChildOfType((PsiElement)owner, PhpStubElementTypes.CONST);
        } else if (owner instanceof ParameterList) {
            PsiElement parameter = ((ParameterList)owner).getParameter(0);
            if (parameter instanceof PhpPsiElement && PhpPsiUtil.isOfType(parameter, PhpElementTypes.CLOSURE)) {
                owner = ((PhpPsiElement)parameter).getFirstPsiChild();
            } else if (parameter instanceof PhpPromotedFieldParameterImpl) {
                owner = parameter;
            }
        } else if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(elementType)) {
            PsiElement parent = owner.getParent();
            if (PhpPsiUtil.isOfType(parent, PhpStubElementTypes.NAMESPACE)) {
                owner = owner.getFirstChild();
            }
        } else if (!(owner instanceof PhpNamedElement)) {
            Object prevAttribute = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)this, (Condition<? super PsiElement>)((Condition)PhpAttributesList.class::isInstance));
            if (prevAttribute != null) {
                owner = this.getParent();
            }
        }
        return (PsiElement)ObjectUtils.chooseNotNull((Object)PhpDocCommentImpl.tryGetOwnerForClosure((PsiElement)owner), (Object)owner);
    }

    @Nullable
    private static PsiElement tryGetOwnerForClosure(PsiElement owner) {
        PsiElement closureParentDocHolder;
        Function closure;
        if (PhpPsiUtil.isOfType(owner, PhpElementTypes.CLOSURE) && (closure = PhpPsiUtil.getChildOfClass(owner, Function.class)) != null && closure.isClosure()) {
            return closure;
        }
        PsiElement psiElement = closureParentDocHolder = owner instanceof Statement ? owner.getFirstChild() : owner;
        if (closureParentDocHolder instanceof AssignmentExpression) {
            return PhpDocCommentImpl.tryGetOwnerForClosure((PsiElement)((AssignmentExpression)closureParentDocHolder).getValue());
        }
        if (closureParentDocHolder instanceof PhpReturn) {
            return PhpDocCommentImpl.tryGetOwnerForClosure(((PhpReturn)closureParentDocHolder).getArgument());
        }
        if (closureParentDocHolder instanceof ParameterList) {
            return PhpDocCommentImpl.tryGetOwnerForClosure(((ParameterList)closureParentDocHolder).getParameter(0));
        }
        return null;
    }

    @Override
    @Nullable
    public PhpDocParamTag getParamTagByName(String name) {
        for (PhpDocParamTag tag : this.getParamTags()) {
            String tn = tag.getVarName();
            if (tn == null || !tn.equals(name)) continue;
            return tag;
        }
        return null;
    }

    @Override
    public boolean hasInheritDocTag() {
        return PhpDocUtil.hasDocTagWithName(this, "@inheritDoc") || PhpDocUtil.hasDocTagWithName(this, "@inheritdoc");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocCommentImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocCommentImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyTags";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarTags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagElementsByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTagsByClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

