/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocTagParser;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpReferenceBase;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocPsiElementImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTemplateParameter;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTemplateParameterImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocCallbackTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocTagAliasTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocTypeImpl
extends PhpDocPsiElementImpl
implements PhpDocType {
    @NotNull
    private static final TokenSet DOC_IDENTIFIER_TS = TokenSet.create((IElementType[])new IElementType[]{PhpDocTokenTypes.DOC_IDENTIFIER});
    @NotNull
    private static final TokenSet DOC_TEXT_TS = TokenSet.create((IElementType[])new IElementType[]{PhpDocTokenTypes.DOC_TEXT});
    private static final ResolveCache.PolyVariantResolver<PhpDocType> MY_RESOLVER = (expression, incompleteCode) -> {
        ResolveResult[] results = PsiElementResolveResult.createResults((Collection)expression.resolveGlobal(incompleteCode));
        if (results.length > 0) {
            return results;
        }
        return PhpDocTypeImpl.resolveDocTypeAliases(expression);
    };

    public PhpDocTypeImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpDocType(this);
    }

    @NotNull
    public PsiElement getElement() {
        PhpDocTypeImpl phpDocTypeImpl = this;
        if (phpDocTypeImpl == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(1);
        }
        return phpDocTypeImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            PsiElement psi = nameNode.getPsi();
            int startOffset = psi != null ? psi.getStartOffsetInParent() : 0;
            return new TextRange(startOffset, startOffset + nameNode.getTextLength());
        }
        return new TextRange(0, this.getTextLength());
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (!incompleteCode) {
            ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false);
            if (resolveResultArray == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = MY_RESOLVER.resolve((PsiPolyVariantReference)this, true);
        if (resolveResultArray == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ASTNode nameNode;
        if (newElementName == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(5);
        }
        if ((nameNode = this.getNameNode()) != null && !newElementName.equals(nameNode.getText())) {
            String text = "/** " + newElementName + " */";
            PsiElement renamed = PhpPsiElementFactory.createFromText(this.getProject(), nameNode.getElementType(), text);
            nameNode.getTreeParent().replaceChild(nameNode, renamed.getNode());
        }
        return this;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        ASTNode node = this.getNode();
        if (PhpDocTypeImpl.isConditionalType(node) || PhpDocTypeImpl.isNegationType(node.getText())) {
            return null;
        }
        PsiElement child = this.getNameIdentifier();
        if (child == null) {
            child = this.findChildByType(PhpDocTokenTypes.DOC_VARIABLE);
        }
        if (child != null) {
            return child.getNode();
        }
        return null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType(PhpDocTokenTypes.DOC_IDENTIFIER);
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        return PhpDocTypeImpl.resolveLocal(this);
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = PhpCodeInsightUtil.getLocalType(this);
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> resolveLocal(@NotNull PhpReference docType) {
        String text;
        if (docType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(7);
        }
        if ((text = docType.getText()) == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(8);
            }
            return set;
        }
        String name = docType.getName();
        if (name != null && (PhpType.isPrimitiveType(name) || "\\callback".equalsIgnoreCase(PhpLangUtil.toFQN(name))) && !PhpLangUtil.mayBeReferenceToUserDefinedClass(name, docType.getProject())) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<? extends PhpNamedElement> set = ClassReferenceImpl.resolveLocal(docType, name, PhpDocTypeImpl.getNamespaceName(docType, false));
        if (set == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        String text = this.getText();
        if (text == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        String name = this.getName();
        Collection<? extends PhpNamedElement> templates = PhpDocTypeImpl.tryResolveTemplates((PsiElement)this, name);
        if (!templates.isEmpty()) {
            Collection<? extends PhpNamedElement> collection = templates;
            if (collection == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(12);
            }
            return collection;
        }
        String namespaceName = PhpLangUtil.toFQN(name).equals("\\Closure") && this.getImmediateNamespaceName().isEmpty() ? "\\" : PhpDocTypeImpl.getNamespaceName(this, false);
        Collection<? extends PhpNamedElement> collection = ClassReferenceImpl.resolveGlobal(this, name, namespaceName, false);
        if (collection == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    public static boolean isTemplateType(PhpDocType element) {
        String name = element.getName();
        if (name == null) {
            return false;
        }
        Collection<? extends PhpNamedElement> templates = PhpDocTypeImpl.tryResolveTemplates((PsiElement)element, name);
        return !templates.isEmpty();
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> tryResolveTemplates(PsiElement element, String name) {
        PhpDocComment docComment = PhpPsiUtil.getParentOfClass(element, PhpDocComment.class);
        if (docComment != null) {
            PhpDocComment classDocComment;
            PhpDocComment functionDocComment;
            PhpDocTemplateParameter matchedTemplate = PhpDocTypeImpl.findTemplatesWithName(name, docComment);
            if (matchedTemplate != null) {
                List<PhpDocTemplateParameter> list = Collections.singletonList(matchedTemplate);
                if (list == null) {
                    PhpDocTypeImpl.$$$reportNull$$$0(14);
                }
                return list;
            }
            Function function = PhpPsiUtil.getParentOfClass((PsiElement)docComment, Function.class);
            if (function != null && function.getDocComment() != null && (matchedTemplate = PhpDocTypeImpl.findTemplatesWithName(name, functionDocComment = function.getDocComment())) != null) {
                List<PhpDocTemplateParameter> list = Collections.singletonList(matchedTemplate);
                if (list == null) {
                    PhpDocTypeImpl.$$$reportNull$$$0(15);
                }
                return list;
            }
            PhpClass klass = PhpPsiUtil.getParentOfClass((PsiElement)docComment, PhpClass.class);
            if (klass != null && klass.getDocComment() != null && (matchedTemplate = PhpDocTypeImpl.findTemplatesWithName(name, classDocComment = klass.getDocComment())) != null) {
                List<PhpDocTemplateParameter> list = Collections.singletonList(matchedTemplate);
                if (list == null) {
                    PhpDocTypeImpl.$$$reportNull$$$0(16);
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    private static PhpDocTemplateParameter findTemplatesWithName(String name, PhpDocComment docComment) {
        Stream<PsiElement> templates = PhpGenericsTemplatesCustomDocTagValueStubProvider.getTypeNamesPsi(docComment, PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplateNames());
        PsiElement templateWithName = StreamEx.of(templates).findFirst(template -> template.getText().equals(name)).orElse(null);
        if (templateWithName != null) {
            return (PhpDocTemplateParameter)templateWithName.getParent();
        }
        return null;
    }

    private static PsiElementResolveResult[] resolveDocTypeAliases(PhpDocType docType) {
        return (PsiElementResolveResult[])((StreamEx)((StreamEx)StreamEx.of(PhpDocTagAliasTypeProvider.resolveTypeAliases(docType)).map(tag -> PhpDocTagAliasTypeProvider.getAliasIdentifier(tag)).filter(Objects::nonNull)).distinct()).map(PsiElementResolveResult::new).toArray(PsiElementResolveResult.class);
    }

    @Override
    @NotNull
    public Collection<String> getSignatureParts() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    @NotNull
    public String getName() {
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : "";
    }

    @Override
    @NotNull
    public String getNamespaceName() {
        return PhpDocTypeImpl.getNamespaceName(this, true);
    }

    @NotNull
    private static String getNamespaceName(@NotNull PhpReference type, boolean checkPrimitives) {
        if (type == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(19);
        }
        String string = PhpReferenceImpl.findNamespaceName(PhpDocTypeImpl.getImmediateNamespaceName(type, checkPrimitives), (PsiElement)type);
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    @NotNull
    public String getImmediateNamespaceName() {
        String string = PhpDocTypeImpl.getImmediateNamespaceName(this, true);
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static String getImmediateNamespaceName(@NotNull PhpReferenceBase type, boolean checkPrimitives) {
        PhpNamespaceReference reference;
        if (type == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(22);
        }
        if ((reference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)type, PhpNamespaceReference.INSTANCEOF)) != null) {
            return reference.getFullName();
        }
        if (checkPrimitives && (PhpType.isPrimitiveType(type.getName()) || PhpType.isResourceOrNumberType(type.getName()))) {
            return "\\";
        }
        return "";
    }

    @Override
    public boolean isAbsolute() {
        String local = this.getImmediateNamespaceName();
        return StringUtil.startsWithChar((CharSequence)local, (char)'\\');
    }

    @Override
    @NotNull
    public String getFQN() {
        String string = this.getNamespaceName() + this.getName();
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(24);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(25);
        }
        if (element instanceof PhpClass) {
            if (PhpLangUtil.equalsClassNames(this.getFQN(), ((PhpClass)element).getFQN())) {
                return true;
            }
            return ContainerUtil.exists((Object[])this.multiResolve(false), result -> result.isValidResult() && result.getElement() == element);
        }
        if (element instanceof PhpDocTemplateParameterImpl) {
            return this.getName().equals(((PhpDocTemplateParameterImpl)element).getName());
        }
        return false;
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = this.multiResolve(true);
        if (objectArray == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(26);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }

    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType type = PhpTypeInfo.getType((PsiElement)this);
        if (type.getTypesWithParametrisedParts().size() > 1 && this.inferNativeType().getTypesWithParametrisedParts().size() < type.getTypesWithParametrisedParts().size()) {
            PhpType typeFromProviders = PhpTypeInfo.getTypeFromAST((PsiElement)this, new PhpTypeAnalyserVisitor(){

                @Override
                @NotNull
                public PhpType getType() {
                    return new PhpType();
                }
            });
            PhpType phpType = typeFromProviders.pluralise(PhpType.getPluralDimension(this.getText()));
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(27);
            }
            return phpType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(28);
        }
        return phpType;
    }

    @NotNull
    public PhpType inferNativeType() {
        PhpTypeAnalyserVisitor visitor = new PhpTypeAnalyserVisitor();
        this.accept(visitor);
        PhpType phpType = visitor.getType();
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(29);
        }
        return phpType;
    }

    public static boolean isConditionalType(ASTNode node) {
        Object[] identifiers = node.getChildren(DOC_IDENTIFIER_TS);
        Object[] text = node.getChildren(DOC_TEXT_TS);
        return ContainerUtil.exists((Object[])identifiers, e -> "is".equals(e.getText())) && ContainerUtil.exists((Object[])text, e -> "?".equals(e.getText())) && ContainerUtil.exists((Object[])text, e -> ":".equals(e.getText()));
    }

    public static boolean isFloatArrayShapeType(String text) {
        try {
            Float.parseFloat(text);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isNegationType(String fullReferenceText) {
        return fullReferenceText.startsWith("!");
    }

    public static boolean isAdvancedCallable(PhpDocType docType) {
        return ContainerUtil.exists((Object[])docType.getNode().getChildren(DOC_TEXT_TS), e -> e.getText().equals(":"));
    }

    public static boolean isClassStringType(String fullReferenceText) {
        return fullReferenceText.equals("class-string") || fullReferenceText.startsWith("class-string<");
    }

    public static void visitPhpDocTypeConditionalTypesAware(@Nullable PhpDocType type, @NotNull Consumer<PhpDocType> consumer) {
        if (consumer == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(30);
        }
        if (type == null) {
            return;
        }
        if (!PhpDocTypeImpl.isConditionalType(type.getNode())) {
            consumer.accept(type);
            return;
        }
        Object[] children = type.getNode().getChildren(DOC_TEXT_TS);
        ASTNode ifNode = (ASTNode)ContainerUtil.find((Object[])children, c -> c.getText().equals("?"));
        ASTNode elseNode = (ASTNode)ContainerUtil.find((Object[])children, c -> c.getText().equals(":"));
        PhpDocTypeImpl.visitConditionalTypeBranch(ifNode, consumer);
        PhpDocTypeImpl.visitConditionalTypeBranch(elseNode, consumer);
    }

    private static void visitConditionalTypeBranch(@Nullable ASTNode node, Consumer<PhpDocType> consumer) {
        if (node == null) {
            return;
        }
        PsiElement next = PhpPsiUtil.getNextSibling(node.getPsi(), e -> PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_LEADING_ASTERISK) || e instanceof PsiWhiteSpace);
        while (next instanceof PhpDocType || PhpPsiUtil.isOfType(next, PhpDocTokenTypes.DOC_PIPE)) {
            if (next instanceof PhpDocType) {
                PhpDocTypeImpl.visitPhpDocTypeConditionalTypesAware((PhpDocType)next, consumer);
            }
            next = next.getNextSibling();
        }
    }

    @NotNull
    public static PhpType getType(@NotNull PhpReference classReference, @NotNull String fullReferenceText) {
        String pluralisedType;
        PhpClass containingClass;
        PhpDocComment docComment;
        if (classReference == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(31);
        }
        if (fullReferenceText == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(32);
        }
        if (PhpPsiUtil.isOfType(classReference.getFirstChild(), PhpTokenTypes.kwLIST)) {
            PhpType phpType = PhpType.ARRAY;
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(33);
            }
            return phpType;
        }
        if (classReference instanceof PhpDocType && StringUtil.isQuotedString((String)fullReferenceText)) {
            PhpType phpType = PhpType.STRING;
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(34);
            }
            return phpType;
        }
        if (classReference instanceof PhpDocType && PhpDocTypeImpl.isNegationType(fullReferenceText)) {
            PhpType phpType = PhpType.MIXED;
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(35);
            }
            return phpType;
        }
        if (classReference instanceof PhpDocType && PhpDocTypeImpl.isConditionalType(classReference.getNode())) {
            PhpType type = new PhpType();
            PhpDocTypeImpl.visitPhpDocTypeConditionalTypesAware((PhpDocType)classReference, docType -> type.add(docType.getType()));
            PhpType phpType = type;
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(36);
            }
            return phpType;
        }
        if (classReference instanceof PhpDocType && PhpPsiUtil.isOfType(classReference.getFirstChild(), PhpDocTokenTypes.DOC_LPAREN)) {
            PhpType phpType = PhpDocTagImpl.getTypeFromDeclaration(classReference).pluralise(PhpType.getPluralDimension(fullReferenceText));
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(37);
            }
            return phpType;
        }
        int pluralDimension = PhpType.getPluralDimension(fullReferenceText);
        String typeName = PhpType.unpluralize(fullReferenceText, pluralDimension);
        if (classReference instanceof PhpDocType && PhpDocTypeImpl.isClassStringType(typeName) && (docComment = PhpPsiUtil.getParentOfClass((PsiElement)classReference, PhpDocComment.class)) != null) {
            Collection<String> collection;
            PsiElement owner = docComment.getOwner();
            if (owner instanceof PhpNamedElement) {
                PhpNamedElement namedElement = (PhpNamedElement)owner;
                collection = PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(namedElement);
            } else {
                collection = Collections.emptyList();
            }
            List<String> templates = collection;
            List<String> templateFQNs = PhpGenericsTemplatesCustomDocTagValueStubProvider.getTemplateFQNs((PsiElement)classReference, templates, e -> (PhpReference)ObjectUtils.tryCast((Object)e, PhpDocType.class));
            PhpType type = PhpType.from(PhpType.createParametrizedType("\\class-string", templateFQNs));
            PhpType phpType = type.pluralise(pluralDimension);
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(38);
            }
            return phpType;
        }
        String name = classReference.getName();
        if ("int".equals(name)) {
            PsiElement attributes = PhpPsiUtil.getChildOfType((PsiElement)classReference, (IElementType)PhpDocElementTypes.phpDocAttributeList);
            PsiElement openTag = attributes != null ? attributes.getFirstChild() : null;
            Object leftRangeElement = PhpPsiUtil.getNextSiblingByCondition(openTag, (Condition<? super PsiElement>)((Condition)PhpDocTypeImpl::isRangeParameter));
            Object rightRangeElement = PhpPsiUtil.getNextSiblingByCondition(leftRangeElement, (Condition<? super PsiElement>)((Condition)PhpDocTypeImpl::isRangeParameter));
            if (leftRangeElement != null && rightRangeElement != null) {
                String leftRange = leftRangeElement.getText();
                String rightRange = rightRangeElement.getText();
                if (PhpDocTagParser.isIntRangeBound((String)leftRange) && PhpDocTagParser.isIntRangeBound((String)rightRange)) {
                    PhpType phpType = PhpType.createParametrized(name, leftRange, rightRange);
                    if (phpType == null) {
                        PhpDocTypeImpl.$$$reportNull$$$0(39);
                    }
                    return phpType;
                }
            }
        }
        String aClass = PhpDocTypeImpl.getClassReferenceFQN(classReference, name);
        PhpType type = new PhpType();
        if (PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned(aClass) && !fullReferenceText.contains("<") && classReference.getParent() instanceof PhpDocReturnTag && (containingClass = PhpPsiUtil.getParentOfClass((PsiElement)classReference, PhpClass.class)) != null) {
            List templateFQNs = ContainerUtil.map(PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(containingClass), PhpGenericsExtendedTypeProvider.KEY::sign);
            if (!templateFQNs.isEmpty()) {
                String parametrizedType = PhpType.createParametrizedType(aClass, (String[])templateFQNs.toArray(String[]::new));
                String pluralisedType2 = pluralDimension >= 0 ? PhpType.pluralise(parametrizedType, pluralDimension) : parametrizedType;
                type.add(pluralisedType2);
            }
        }
        String string = pluralisedType = pluralDimension >= 0 ? PhpType.pluralise(aClass, pluralDimension) : aClass;
        if (pluralisedType.length() > 1) {
            type.add(pluralisedType);
        }
        if ("callback".equalsIgnoreCase(PhpLangUtil.toShortName(aClass)) && !PhpLangUtil.isFqn(fullReferenceText)) {
            PhpType phpType = type.map(PhpDocCallbackTP::sign);
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(40);
            }
            return phpType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(41);
        }
        return phpType;
    }

    public static String getClassReferenceFQN(@NotNull PhpReference classReference, String name) {
        if (classReference == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(42);
        }
        if ("parent".equals(name)) {
            return "parent";
        }
        Collection<? extends PhpNamedElement> elements = PhpDocTypeImpl.resolveLocal(classReference);
        if (elements.size() > 0) {
            PhpNamedElement element = elements.iterator().next();
            String typeString = element.getType().toString();
            return element instanceof PhpClass && PhpDocTypeImpl.isPolymorphicClassReference(name, (PhpClass)element) ? PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign(typeString) : typeString;
        }
        return PhpDocUtil.getTypeString((PhpLangUtil.isClassNameSpecial(name) ? "" : PhpDocTypeImpl.getNamespaceName(classReference, true)) + name, classReference);
    }

    private static boolean isRangeParameter(PsiElement element) {
        return PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_TEXT, PhpDocTokenTypes.DOC_IDENTIFIER);
    }

    public static boolean isPolymorphicClassReference(@NotNull String name, @Nullable PhpClass containingClass) {
        if (name == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(43);
        }
        return PhpLangUtil.isClassNameSpecial(name) && (!"self".equals(name) || containingClass != null && containingClass.isTrait());
    }

    @NotNull
    public static PhpType getLocalType(@NotNull PhpDocType type) {
        if (type == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(44);
        }
        return PhpDocTypeImpl.getType(type, type.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 23, 26, 27, 28, 29, 33, 34, 35, 36, 37, 38, 39, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
            case 19: 
            case 22: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 31: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullReferenceText";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolveTemplates";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureParts";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateNamespaceName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "inferNativeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateNamespaceName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitPhpDocTypeConditionalTypesAware";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getClassReferenceFQN";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isPolymorphicClassReference";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getLocalType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 23, 26, 27, 28, 29, 33, 34, 35, 36, 37, 38, 39, 40, 41 -> new IllegalStateException(string);
        };
    }
}

