/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.editor.enterHandlers.PhpArrayBracketsEnterHandler;
import com.jetbrains.php.lang.editor.enterHandlers.PhpCommentEnterHandler;
import com.jetbrains.php.lang.editor.enterHandlers.PhpDocEnterHandler;
import com.jetbrains.php.lang.editor.enterHandlers.PhpEndTagEnterHandler;
import com.jetbrains.php.lang.editor.enterHandlers.PhpEnterHandlerBase;
import com.jetbrains.php.lang.editor.enterHandlers.PhpHeredocEnterHandler;
import com.jetbrains.php.lang.editor.enterHandlers.PhpInStringEnterHandler;
import com.jetbrains.php.lang.editor.enterHandlers.PhpStartTagEnterHandler;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpEnterHandlerAdapter
extends EnterHandlerDelegateAdapter
implements PhpTokenTypes {
    private static final PhpEnterHandlerBase[] HANDLERS = new PhpEnterHandlerBase[]{new PhpDocEnterHandler(), new PhpCommentEnterHandler(), new PhpStartTagEnterHandler(), new PhpArrayBracketsEnterHandler(), new PhpInStringEnterHandler(), new PhpHeredocEnterHandler(), new PhpEndTagEnterHandler()};

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            PhpEnterHandlerAdapter.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpEnterHandlerAdapter.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            PhpEnterHandlerAdapter.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            PhpEnterHandlerAdapter.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            PhpEnterHandlerAdapter.$$$reportNull$$$0(4);
        }
        if (!(file instanceof PhpFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null || editor.isViewer() || !editor.getDocument().isWritable()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        int caret = editor.getCaretModel().getOffset();
        if (caret == 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caret);
        PsiElement elementAt = file.findElementAt(caret - 1);
        if (elementAt != null) {
            for (PhpEnterHandlerBase handler : HANDLERS) {
                if (!handler.beforeEnter(file, editor, dataContext, project, document, lineNumber, caret, elementAt)) continue;
                return handler.getNextAction();
            }
        }
        if (PhpEnterHandlerAdapter.handleInsideLineComment(document, caretOffset, caretAdvance, elementAt)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean handleInsideLineComment(@NotNull Document document, Ref<Integer> caretOffset, Ref<Integer> caretAdvance, @Nullable PsiElement element) {
        if (document == null) {
            PhpEnterHandlerAdapter.$$$reportNull$$$0(5);
        }
        if (element == null || !PhpPsiUtil.isOfType(element, PhpTokenTypes.LINE_COMMENT)) {
            return false;
        }
        boolean end = element.getTextRange().getEndOffset() == ((Integer)caretOffset.get()).intValue();
        boolean triple = element.getText().startsWith("///");
        if (end && !triple) {
            return false;
        }
        int spacesBeforeCaret = 0;
        if (!end) {
            CharSequence docChars = document.getCharsSequence();
            for (int i = (Integer)caretOffset.get() - 1; i >= element.getTextRange().getStartOffset() && docChars.charAt(i) == ' '; --i) {
                ++spacesBeforeCaret;
            }
        }
        String prefix = triple ? "/// " : PhpEnterHandlerAdapter.getLineCommentPrefix(element);
        document.insertString((Integer)caretOffset.get() - spacesBeforeCaret, (CharSequence)prefix);
        caretOffset.set((Object)((Integer)caretOffset.get() - spacesBeforeCaret));
        caretAdvance.set((Object)(prefix.length() + spacesBeforeCaret));
        return true;
    }

    private static String getLineCommentPrefix(@NotNull PsiElement lineComment) {
        char firstChar;
        if (lineComment == null) {
            PhpEnterHandlerAdapter.$$$reportNull$$$0(6);
        }
        return (firstChar = lineComment.getNode().getChars().charAt(0)) == '#' ? "#" : "//";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineComment";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/editor/PhpEnterHandlerAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsideLineComment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommentPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

