/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.jetbrains.php.lang.lexer.PhpLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import org.jetbrains.annotations.NotNull;

public class PhpWordsScanner
extends VersionedWordsScanner {
    private static final TokenSet tsCODE = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER, PhpTokenTypes.VARIABLE}), PhpTokenTypes.tsKEYWORDS});

    public void processWords(@NotNull CharSequence fileText, @NotNull Processor<? super WordOccurrence> processor) {
        if (fileText == null) {
            PhpWordsScanner.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PhpWordsScanner.$$$reportNull$$$0(1);
        }
        PhpLexer lexer = new PhpLexer(false);
        int from = -1;
        int to = -1;
        IElementType type = null;
        String text = null;
        try {
            lexer.start(fileText);
            WordOccurrence occurrence = null;
            while (lexer.getTokenType() != null) {
                type = lexer.getTokenType();
                from = lexer.getTokenStart();
                to = lexer.getTokenEnd();
                text = lexer.getTokenText();
                if (to > fileText.length() || from >= to) {
                    throw new RuntimeException("Wrong token range (" + from + "," + to + ") , token " + lexer.getTokenType() + ":'" + text);
                }
                if (tsCODE.contains(type)) {
                    if (type == PhpTokenTypes.VARIABLE && fileText.length() > from + 1 && fileText.charAt(from) == '$') {
                        ++from;
                    }
                    if (occurrence == null) {
                        occurrence = new WordOccurrence(fileText, from, to, WordOccurrence.Kind.CODE);
                    } else {
                        occurrence.init(fileText, from, to, WordOccurrence.Kind.CODE);
                    }
                    if (!processor.process((Object)occurrence)) {
                        return;
                    }
                } else if (PhpElementTypes.tsCOMMENTS.contains(type) ? !PhpWordsScanner.stripWords(processor, fileText, from, to, WordOccurrence.Kind.COMMENTS, occurrence) : (PhpTokenTypes.tsSTRINGS.contains(type) ? !PhpWordsScanner.stripWords(processor, fileText, from, to, WordOccurrence.Kind.LITERALS, occurrence) : (PhpTokenTypes.HTML == type ? !PhpWordsScanner.stripWords(processor, fileText, from, to, WordOccurrence.Kind.FOREIGN_LANGUAGE, occurrence) : type != PhpTokenTypes.WHITE_SPACE && !PhpWordsScanner.stripWords(processor, fileText, from, to, WordOccurrence.Kind.CODE, occurrence)))) {
                    return;
                }
                lexer.advance();
            }
        }
        catch (Exception e) {
            int pos = Math.min(to, fileText.length());
            Error error = new Error(e.getMessage() + " ..occurred @(" + from + "," + to + ") " + type + ":'" + text + "' while scanning file " + fileText.length() + ":<<<" + fileText.subSequence(0, pos) + "[[[PHP_LEXER_TO_POSITION_HERE]]]" + fileText.subSequence(pos, fileText.length()) + ">>>");
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }

    private static boolean stripWords(Processor<? super WordOccurrence> processor, CharSequence tokenText, int from, int to, WordOccurrence.Kind kind, WordOccurrence occurrence) {
        int index = from;
        while (index != to) {
            char c;
            char c2 = tokenText.charAt(index);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || Character.isJavaIdentifierStart(c2) && c2 != '$')) {
                ++index;
                continue;
            }
            int index1 = index;
            while (++index != to && ((c = tokenText.charAt(index)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierPart(c) && c != '$')) {
            }
            if (occurrence == null) {
                occurrence = new WordOccurrence(tokenText, index1, index, kind);
            } else {
                occurrence.init(tokenText, index1, index, kind);
            }
            if (processor.process((Object)occurrence)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fileText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/lang/findUsages/PhpWordsScanner";
        objectArray[2] = "processWords";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

