/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.folding.PhpCodeFoldingConfiguration;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.stubs.PhpFileElementType;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCodeFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(PhpCodeFoldingBuilder.class);
    private static final int MAX_DESCRIPTORS = Registry.intValue((String)"php.folding.max.descriptors");
    private static final com.intellij.util.Function<FoldingDescriptor, Boolean> NON_COMMENT_FOLDING_PREDICATE = foldingDescriptor -> !(foldingDescriptor.getElement() instanceof PsiComment);

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (root instanceof PhpFile) {
            PhpCodeFoldingBuilder.addFoldingDescriptors(descriptors, root, document);
        }
    }

    private static boolean mayHaveAlternateSyntax(PhpPsiElement tag) {
        ASTNode astNode = tag.getNode();
        return tag instanceof For || tag instanceof While || tag instanceof If || tag instanceof ElseIf || tag instanceof Else || tag instanceof ForeachStatement || astNode != null && astNode.getElementType() == PhpElementTypes.SWITCH;
    }

    private static boolean ifOnSameLine(int offset1, int offset2, @NotNull Document document) {
        if (document == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(3);
        }
        return document.getLineNumber(offset1) == document.getLineNumber(offset2);
    }

    private static void addFoldingDescriptors(List<FoldingDescriptor> descriptors, PhpPsiElement tag, @NotNull Document document) {
        int end;
        if (document == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (tag.getTextLength() < 200 && !(tag instanceof PhpUseList) && !tag.getNode().textContains('\n')) {
            return;
        }
        TextRange elementRange = tag.getTextRange();
        int start = elementRange.getStartOffset();
        if (start + 1 < (end = elementRange.getEndOffset())) {
            TextRange range = null;
            boolean canSurvive = true;
            ASTNode astNode = tag.getNode();
            if (astNode == null) {
                return;
            }
            IElementType type = astNode.getElementType();
            if (tag instanceof Function || tag instanceof Try || tag instanceof For || tag instanceof While || tag instanceof DoWhile || tag instanceof If || tag instanceof ElseIf || tag instanceof Else || tag instanceof ForeachStatement || tag instanceof Catch) {
                ASTNode node;
                GroupStatement group = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)tag, GroupStatement.class);
                if (group != null && (node = group.getNode()) != null) {
                    try {
                        range = PhpCodeFoldingBuilder.buildRangeForBraces(node, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("buildRangeForBraces failed for tag '" + tag.getText() + "'", e);
                    }
                }
                if (range == null && PhpCodeFoldingBuilder.mayHaveAlternateSyntax(tag)) {
                    range = PhpCodeFoldingBuilder.buildRangeForAlternateSyntax(tag);
                }
            } else if (tag instanceof FunctionReference) {
                range = PhpCodeFoldingBuilder.buildRangeForBraces(astNode, PhpTokenTypes.chLPAREN, PhpTokenTypes.chRPAREN);
            } else if (tag instanceof PhpClass) {
                range = PhpCodeFoldingBuilder.buildRangeForBraces(astNode, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
            } else if (tag instanceof PhpAttributesList) {
                range = PhpCodeFoldingBuilder.buildRangeForBraces(astNode, PhpTokenTypes.ATTRIBUTE_START, PhpTokenTypes.chRBRACKET);
            } else if (tag instanceof PhpAttribute) {
                range = PhpCodeFoldingBuilder.buildRangeForBraces(astNode, PhpTokenTypes.chLPAREN, PhpTokenTypes.chRPAREN);
            } else if (tag instanceof ArrayCreationExpression) {
                PsiElement firstChild = tag.getFirstChild();
                if (firstChild != null) {
                    IElementType leftBraceType = PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.kwARRAY) ? PhpTokenTypes.chLPAREN : PhpTokenTypes.chLBRACKET;
                    IElementType rightBraceType = leftBraceType == PhpTokenTypes.chLPAREN ? PhpTokenTypes.chRPAREN : PhpTokenTypes.chRBRACKET;
                    range = PhpCodeFoldingBuilder.buildRangeForBraces(astNode, leftBraceType, rightBraceType);
                }
            } else if (PhpCodeFoldingBuilder.isImportStatementWhichCanBeFolded(tag)) {
                PhpPsiElement prevPsiSibling = tag.getPrevPsiSibling();
                if (!PhpCodeFoldingBuilder.isImportStatementWhichCanBeFolded(prevPsiSibling)) {
                    PhpUseList latestUseList = (PhpUseList)tag;
                    PhpPsiElement nextPsiSibling = tag.getNextPsiSibling();
                    while (PhpCodeFoldingBuilder.isImportStatementWhichCanBeFolded(nextPsiSibling)) {
                        latestUseList = (PhpUseList)nextPsiSibling;
                        nextPsiSibling = nextPsiSibling.getNextPsiSibling();
                    }
                    if (latestUseList != tag) {
                        range = PhpCodeFoldingBuilder.buildRange(tag.getTextRange().getStartOffset() + 3, latestUseList.getTextRange().getEndOffset());
                        canSurvive = false;
                    }
                }
            } else if (type == PhpElementTypes.CASE || type == PhpElementTypes.CASE_DEFAULT) {
                ASTNode node;
                ASTNode colon = astNode.findChildByType(PhpTokenTypes.opCOLON);
                GroupStatement group = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)tag, GroupStatement.class);
                if (group != null && colon != null && (node = group.getNode()) != null) {
                    ASTNode lBrace = node.findChildByType(PhpTokenTypes.chLBRACE);
                    ASTNode rBrace = node.findChildByType(PhpTokenTypes.chRBRACE);
                    if (lBrace != null && rBrace != null && PhpCodeFoldingBuilder.ifOnSameLine(lBrace.getStartOffset(), colon.getStartOffset(), document)) {
                        range = PhpCodeFoldingBuilder.buildRange(lBrace.getStartOffset(), rBrace.getStartOffset());
                    } else {
                        TextRange groupTextRange = group.getTextRange();
                        if (groupTextRange.getLength() != 0) {
                            range = PhpCodeFoldingBuilder.buildRange(colon.getStartOffset(), groupTextRange.getEndOffset());
                        }
                    }
                }
            } else if (type == PhpDocStubElementTypes.DOC_COMMENT) {
                int offset = astNode.getStartOffset();
                range = PhpCodeFoldingBuilder.buildRange(offset + "/**".length() - 1, offset + astNode.getTextLength() - "*/".length());
            } else if (type == PhpElementTypes.HEREDOC) {
                ASTNode heredocStart = astNode.findChildByType(PhpTokenTypes.HEREDOC_START);
                ASTNode heredocEnd = astNode.findChildByType(PhpTokenTypes.HEREDOC_END);
                if (heredocStart != null && heredocEnd != null) {
                    int startoffset = heredocStart.getStartOffset() + heredocStart.getTextLength();
                    String heredocStartString = heredocStart.getText();
                    startoffset = heredocStartString.endsWith("\r\n") ? (startoffset -= 2) : --startoffset;
                    int endoffset = heredocEnd.getStartOffset();
                    endoffset = heredocEnd.getText().startsWith("\r\n") ? (endoffset += 2) : ++endoffset;
                    if (startoffset + 1 < endoffset) {
                        range = new TextRange(startoffset, endoffset);
                    }
                }
            } else if (type == PhpElementTypes.SWITCH || type == PhpElementTypes.DO_WHILE) {
                range = PhpCodeFoldingBuilder.buildRangeForBraces(astNode, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
                if (range == null && PhpCodeFoldingBuilder.mayHaveAlternateSyntax(tag)) {
                    range = PhpCodeFoldingBuilder.buildRangeForAlternateSyntax(tag);
                }
            } else if (type == PhpElementTypes.MATCH_EXPRESSION) {
                range = PhpCodeFoldingBuilder.buildRangeForBraces(astNode, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
            } else if (type == PhpElementTypes.PROPERTY_HOOKS) {
                range = PhpCodeFoldingBuilder.buildRangeForBraces(astNode, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
            }
            if (range != null) {
                PhpCodeFoldingBuilder.addDescriptorSmart(descriptors, astNode, range, document, canSurvive);
            }
        }
    }

    private static boolean isImportStatementWhichCanBeFolded(@Nullable PhpPsiElement tag) {
        return tag instanceof PhpUseList && !((PhpUseList)tag).isTraitImport() && !PsiTreeUtil.hasErrorElements((PsiElement)tag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PsiElement collapseConsequentCommentNodes(ASTNode node, List<FoldingDescriptor> descriptors, @NotNull Document document, Deque<PsiElement> queue) {
        int startOffset;
        FoldingDescriptor foldingDescriptor;
        if (document == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(5);
        }
        if ((foldingDescriptor = PhpCodeFoldingBuilder.findPreviousRegionOnSameLineAsRange(descriptors, TextRange.create((int)(startOffset = node.getStartOffset()), (int)startOffset), document, NON_COMMENT_FOLDING_PREDICATE)) != null) {
            PsiElement nextSibling = node.getPsi().getNextSibling();
            if (!(nextSibling instanceof PsiWhiteSpace)) return node.getPsi();
            PsiElement nextSibling1 = nextSibling.getNextSibling();
            if (!PhpPsiUtil.isOfType(nextSibling1, PhpTokenTypes.LINE_COMMENT)) return node.getPsi();
            node = nextSibling1.getNode();
        }
        PsiElement lastEoLComment = node.getPsi();
        PsiElement current = lastEoLComment.getNextSibling();
        int numberOfLines = 1;
        char firstChar = node.getChars().charAt(0);
        boolean containsCustomRegionMarker = PhpCodeFoldingBuilder.isCustomRegionElement((PsiElement)lastEoLComment);
        while (current != null && current instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)current.getText(), (char)'\n') <= 1) {
            if (!PhpPsiUtil.isOfType(current = current.getNextSibling(), PhpTokenTypes.LINE_COMMENT)) continue;
            char currFirstChar = current.getNode().getChars().charAt(0);
            if (currFirstChar != firstChar) break;
            lastEoLComment = current;
            if (queue.peek().equals(current)) {
                queue.remove();
            }
            current = current.getNextSibling();
            ++numberOfLines;
            containsCustomRegionMarker |= PhpCodeFoldingBuilder.isCustomRegionElement((PsiElement)lastEoLComment);
        }
        if (numberOfLines <= 3) {
            return lastEoLComment;
        }
        if (lastEoLComment == node.getPsi()) return node.getPsi();
        if (containsCustomRegionMarker) return lastEoLComment;
        TextRange rangeToFold = new TextRange(node.getStartOffset(), lastEoLComment.getTextOffset() + lastEoLComment.getTextLength());
        PhpCodeFoldingBuilder.addDescriptorSmart(descriptors, node, rangeToFold, document, true);
        return lastEoLComment;
    }

    @Nullable
    static FoldingDescriptor findPreviousRegionOnSameLineAsRange(List<? extends FoldingDescriptor> descriptors, TextRange range, Document document, @Nullable com.intellij.util.Function<? super FoldingDescriptor, Boolean> predicate) {
        for (int i = descriptors.size() - 1; i >= 0; --i) {
            FoldingDescriptor foldingDescriptor = descriptors.get(i);
            if (PhpCodeFoldingBuilder.getNumber(document, range.getEndOffset()) != PhpCodeFoldingBuilder.getNumber(document, foldingDescriptor.getRange().getStartOffset()) && PhpCodeFoldingBuilder.getNumber(document, range.getStartOffset()) != PhpCodeFoldingBuilder.getNumber(document, foldingDescriptor.getRange().getEndOffset())) break;
            if (predicate != null && predicate.fun((Object)foldingDescriptor) != Boolean.TRUE) continue;
            return foldingDescriptor;
        }
        return null;
    }

    private static int getNumber(Document document, int offset) {
        return DocumentUtil.isValidOffset((int)offset, (Document)document) ? document.getLineNumber(offset) : -1;
    }

    private static void addDescriptorSmart(List<FoldingDescriptor> descriptors, ASTNode astNode, TextRange range, @NotNull Document document, boolean canSurvive) {
        if (document == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(6);
        }
        FoldingDescriptor descriptorFromSameGroup = PhpCodeFoldingBuilder.findPreviousRegionOnSameLineAsRange(descriptors, range, document, null);
        FoldingGroup group = null;
        if (descriptorFromSameGroup != null) {
            group = descriptorFromSameGroup.getGroup();
            if (astNode.getPsi() instanceof PsiComment && !(descriptorFromSameGroup.getElement().getPsi() instanceof PsiComment)) {
                return;
            }
        }
        FoldingDescriptor foldingDescriptor = new FoldingDescriptor(astNode, range, group);
        foldingDescriptor.setCanBeRemovedWhenCollapsed(!canSurvive);
        descriptors.add(foldingDescriptor);
    }

    @Nullable
    private static IElementType getClosingForAlternateSyntax(PhpPsiElement element) {
        if (element instanceof If) {
            return PhpTokenTypes.kwENDIF;
        }
        if (element instanceof Else) {
            return null;
        }
        if (element instanceof ElseIf) {
            return null;
        }
        if (element instanceof For) {
            return PhpTokenTypes.kwENDFOR;
        }
        if (element instanceof While) {
            return PhpTokenTypes.kwENDWHILE;
        }
        if (element instanceof ForeachStatement) {
            return PhpTokenTypes.kwENDFOREACH;
        }
        ASTNode node = element.getNode();
        if (node != null && node.getElementType() == PhpElementTypes.SWITCH) {
            return PhpTokenTypes.kwENDSWITCH;
        }
        return null;
    }

    private static TextRange buildRangeForAlternateSyntax(PhpPsiElement element) {
        ASTNode closingNode;
        ASTNode astNode = element.getNode();
        if (astNode == null) {
            return null;
        }
        ASTNode leftBorder = astNode.findChildByType(PhpTokenTypes.opCOLON);
        if (leftBorder == null) {
            return null;
        }
        IElementType closingElementType = PhpCodeFoldingBuilder.getClosingForAlternateSyntax(element);
        int rightBorder = astNode.getLastChildNode().getTextRange().getEndOffset();
        if (closingElementType != null && (closingNode = astNode.findChildByType(closingElementType)) != null) {
            rightBorder = closingNode.getStartOffset();
        }
        return PhpCodeFoldingBuilder.buildRange(leftBorder.getStartOffset(), rightBorder);
    }

    private static void addFoldingDescriptors(List<FoldingDescriptor> descriptors, PsiElement tag, @NotNull Document document) {
        if (document == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(7);
        }
        ArrayDeque<PsiElement> queue = new ArrayDeque<PsiElement>(1000);
        queue.add(tag);
        TreeSet<PsiElement> phpTags = new TreeSet<PsiElement>(Comparator.comparingInt(PsiElement::getTextOffset));
        while (!queue.isEmpty()) {
            PsiElement child = (PsiElement)queue.removeFirst();
            if (child instanceof PhpPsiElement) {
                PhpCodeFoldingBuilder.addFoldingDescriptors(descriptors, (PhpPsiElement)child, document);
                if (child instanceof PhpDocComment || descriptors.size() >= MAX_DESCRIPTORS) continue;
                for (PsiElement candidate = child.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
                    if (candidate instanceof PsiWhiteSpace) continue;
                    queue.add(candidate);
                }
                continue;
            }
            if (child instanceof PsiComment && child.textContains('\n')) {
                ASTNode childNode;
                int endOffset;
                TextRange childRange = child.getTextRange();
                int startOffset = childRange.getStartOffset() + "/*".length();
                if (startOffset + 1 >= (endOffset = childRange.getEndOffset() - "*/".length()) || (childNode = child.getNode()) == null) continue;
                try {
                    PhpCodeFoldingBuilder.addDescriptorSmart(descriptors, childNode, TextRange.create((int)startOffset, (int)endOffset), document, true);
                }
                catch (PsiInvalidElementAccessException e) {
                    PsiFile containingFile = SharedImplUtil.getContainingFile((ASTNode)childNode);
                    LOG.error(e + "\nchildNode.isValid() : " + childNode.getPsi().isValid() + "\ncontaining file: " + (containingFile == null ? "null" : "not null") + "\nchildNode.getText(): " + childNode.getText() + "\nchildNode.getStartOffset(): " + childNode.getStartOffset() + "\nchildNode.getEndOffset(): " + childNode.getTextRange().getEndOffset() + "\nchildNode.getPsi().getContainingFile(): " + childNode.getPsi().getContainingFile().getText() + "\nchildNode.getPsi().getOriginalElement().getContainingFile(): " + childNode.getPsi().getOriginalElement().getContainingFile().getText() + "\nchildNode.getPsi().getContainingFile().getVirtualFile(): " + childNode.getPsi().getContainingFile().getVirtualFile().getCharset());
                }
                continue;
            }
            if (child instanceof PsiComment) {
                ASTNode astNode = child.getNode();
                if (astNode == null || astNode.getElementType() != PhpTokenTypes.LINE_COMMENT) continue;
                PhpCodeFoldingBuilder.collapseConsequentCommentNodes(astNode, descriptors, document, queue);
                continue;
            }
            if (child instanceof LeafPsiElement && PhpPsiUtil.isOfType(child, PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG)) {
                phpTags.add(child);
                continue;
            }
            if (!(child instanceof LeafPsiElement) || !PhpPsiUtil.isOfType(child, PhpTokenTypes.PHP_CLOSING_TAG)) continue;
            phpTags.add(child);
        }
        PsiElement startTag = null;
        for (PsiElement child : phpTags) {
            int length;
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG)) {
                startTag = child;
                continue;
            }
            if (startTag == null || !PhpPsiUtil.isOfType(child, PhpTokenTypes.PHP_CLOSING_TAG)) continue;
            int start = startTag.getTextOffset();
            TextRange range = TextRange.from((int)(start + (length = startTag.getTextLength())), (int)(((LeafPsiElement)child).getStartOffset() - start - length));
            if (range.getLength() > 0 && descriptors.size() < MAX_DESCRIPTORS) {
                FoldingDescriptor foldingDescriptor = new FoldingDescriptor(startTag.getNode(), range, null);
                descriptors.add(foldingDescriptor);
            }
            startTag = null;
        }
    }

    private static TextRange buildRangeForBraces(@NotNull ASTNode astNode, IElementType lbraceType, IElementType rbraceType) {
        if (astNode == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(8);
        }
        ASTNode lBrace = astNode.findChildByType(lbraceType);
        ASTNode rBrace = PhpPsiUtil.getLastChildByType(astNode, rbraceType);
        if (rBrace == null || lBrace == null) {
            return null;
        }
        int startOffset = lBrace.getTextRange().getStartOffset();
        int endOffset = rBrace.getTextRange().getStartOffset();
        if (lbraceType == PhpTokenTypes.chLBRACE) {
            ASTNode parent = lBrace.getTreeParent();
            IElementType parentType = parent != null ? parent.getElementType() : null;
            ASTNode nodeBeforeLineBreak = null;
            if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentType)) {
                nodeBeforeLineBreak = PhpCodeFoldingBuilder.findNodeBeforeLineBreak(parent);
            } else if (parentType == PhpStubElementTypes.CLASS || parentType == PhpElementTypes.SWITCH || parentType == PhpElementTypes.MATCH_EXPRESSION) {
                nodeBeforeLineBreak = PhpCodeFoldingBuilder.findNodeBeforeLineBreak(lBrace);
            }
            if (nodeBeforeLineBreak != null) {
                startOffset = nodeBeforeLineBreak.getTextRange().getEndOffset() - 1;
                endOffset += rBrace.getTextLength();
            }
        } else if (lbraceType == PhpTokenTypes.ATTRIBUTE_START) {
            ++startOffset;
        }
        return PhpCodeFoldingBuilder.buildRange(startOffset, endOffset);
    }

    private static ASTNode findNodeBeforeLineBreak(ASTNode node) {
        ASTNode prev;
        for (prev = node.getTreePrev(); prev != null && prev.getTextLength() == 0; prev = prev.getTreePrev()) {
        }
        if (prev instanceof PsiWhiteSpace && prev.textContains('\n') && (prev = prev.getTreePrev()) != null) {
            return prev;
        }
        return null;
    }

    private static TextRange buildRange(int leftOffset, int rightOffset) {
        int startOffset = leftOffset + 1;
        if (startOffset + 1 < rightOffset) {
            return new TextRange(startOffset, rightOffset);
        }
        return null;
    }

    public String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType type;
        if (node == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (range == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(10);
        }
        if ((type = node.getElementType()) == PhpDocStubElementTypes.DOC_COMMENT) {
            String comment = node.getText();
            String[] strings = comment.split("[\n\r]+");
            if (strings.length >= 2) {
                String commentInfo = strings[1];
                commentInfo = commentInfo.replaceFirst("\\s*[*]*", "");
                return commentInfo + " ...";
            }
        } else if (type == PhpTokenTypes.LINE_COMMENT) {
            return "//...";
        }
        if (PhpCodeFoldingBuilder.usesCompactBraceFolding(node, range)) {
            return "{...}";
        }
        return "...";
    }

    private static boolean usesCompactBraceFolding(ASTNode node, TextRange range) {
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getTextRange().getStartOffset() < range.getStartOffset()) continue;
            if (child instanceof PsiWhiteSpace && (child = child.getTreeNext()) != null) {
                if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(child.getElementType())) {
                    if ((child = child.getFirstChildNode()) != null && child.getElementType() == PhpTokenTypes.chLBRACE) {
                        return true;
                    }
                } else if (node.getElementType() == PhpStubElementTypes.CLASS) {
                    IElementType childType = child.getElementType();
                    if (childType == PhpElementTypes.IMPLEMENTS_LIST || childType == PhpElementTypes.EXTENDS_LIST || childType == PhpTokenTypes.chLBRACE) {
                        return true;
                    }
                } else {
                    if (node.getElementType() == PhpElementTypes.SWITCH) {
                        return child.getElementType() == PhpTokenTypes.chLBRACE;
                    }
                    if (node.getElementType() == PhpElementTypes.MATCH_EXPRESSION) {
                        return child.getElementType() == PhpTokenTypes.chLBRACE;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(11);
        }
        PhpCodeFoldingConfiguration configuration = PhpCodeFoldingConfiguration.getInstance();
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (PhpFormatterUtil.isFileHeader(element)) {
            return CodeFoldingSettings.getInstance().COLLAPSE_FILE_HEADER;
        }
        if (element instanceof Method || element instanceof GroupStatement && element.getParent() instanceof Method) {
            return configuration.isCollapseMethodBody();
        }
        if (element instanceof Function || element instanceof GroupStatement && element.getParent() instanceof Function) {
            return configuration.isCollapseFunctionBody();
        }
        if (element instanceof PhpUseList) {
            return configuration.isCollapseImports();
        }
        if (node.getElementType() == PhpElementTypes.HEREDOC) {
            return configuration.isCollapseHereDocs();
        }
        if (element instanceof PhpDocComment) {
            return configuration.isCollapseDocComments();
        }
        if (element instanceof PhpClass) {
            return configuration.isCollapseClasses();
        }
        if (element instanceof PhpAttribute) {
            return configuration.isCollapseAttribute();
        }
        if (element instanceof PhpAttributesList) {
            return configuration.isCollapseAttributeList();
        }
        if (PhpPsiUtil.isOfType(node, PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG)) {
            return configuration.isCollapsePhpTags();
        }
        return false;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(12);
        }
        return node.getElementType() == PhpTokenTypes.LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            PhpCodeFoldingBuilder.$$$reportNull$$$0(13);
        }
        return (nodeType = node.getElementType()) == PhpFileElementType.FILE || nodeType == PhpStubElementTypes.FUNCTION || nodeType == PhpStubElementTypes.CLASS_METHOD || nodeType == PhpStubElementTypes.CLASS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/folding/PhpCodeFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "ifOnSameLine";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldingDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collapseConsequentCommentNodes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescriptorSmart";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "buildRangeForBraces";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingCandidate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

