/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.jetbrains.php.lang.formatter.PhpBlock;
import com.jetbrains.php.lang.formatter.PhpElseIfBlock;
import com.jetbrains.php.lang.formatter.PhpMultilineStringLiteralBlock;
import com.jetbrains.php.lang.formatter.PhpSyntheticBlock;
import com.jetbrains.php.lang.formatter.PhpXmlBlock;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFormattingModelBuilder
extends AbstractXmlTemplateFormattingModelBuilder {
    protected boolean isTemplateFile(PsiFile file) {
        return file instanceof PhpFile;
    }

    public boolean isOuterLanguageElement(PsiElement element) {
        return PhpPsiUtil.isOfType(element, PhpElementTypes.PHP_OUTER_TYPE);
    }

    public boolean isMarkupLanguageElement(PsiElement element) {
        return PhpPsiUtil.isOfType(element, PhpElementTypes.HTML);
    }

    protected Block createTemplateLanguageBlock(ASTNode node, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        IElementType nodeType = node.getElementType();
        if ((nodeType == PhpTokenTypes.STRING_LITERAL || nodeType == PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE) && node.textContains('\n')) {
            return new PhpMultilineStringLiteralBlock(this, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
        }
        if (nodeType == PhpTokenTypes.kwELSEIF) {
            return new PhpElseIfBlock(this, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
        }
        return new PhpBlock(this, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
    }

    protected List<Block> afterMerge(List<Block> originalBlocks, boolean templateOnly, CodeStyleSettings settings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (xmlFormattingPolicy == null) {
            PhpFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        ArrayList<Block> rearrangedBlocks = new ArrayList<Block>();
        if (templateOnly) {
            if (originalBlocks.size() == 1) {
                return originalBlocks;
            }
            rearrangedBlocks.add(PhpFormattingModelBuilder.createPhpSyntheticBlock(originalBlocks, settings, xmlFormattingPolicy));
            return rearrangedBlocks;
        }
        ArrayList<Block> groupedBlocks = null;
        for (Block block : originalBlocks) {
            if (block instanceof PhpBlock) {
                PhpBlock phpBlock = (PhpBlock)block;
                ASTNode node = phpBlock.getNode();
                if (node.getElementType() == PhpTokenTypes.PHP_OPENING_TAG || node.getElementType() == PhpTokenTypes.PHP_ECHO_OPENING_TAG) {
                    groupedBlocks = new ArrayList<Block>();
                }
                if (groupedBlocks != null) {
                    groupedBlocks.add((Block)phpBlock);
                    if (node.getElementType() != PhpTokenTypes.PHP_CLOSING_TAG || !PhpFormattingModelBuilder.addPhpSyntheticBlock(rearrangedBlocks, groupedBlocks, settings, xmlFormattingPolicy)) continue;
                    groupedBlocks = null;
                    continue;
                }
                rearrangedBlocks.add((Block)phpBlock);
                continue;
            }
            if (PhpFormattingModelBuilder.addPhpSyntheticBlock(rearrangedBlocks, groupedBlocks, settings, xmlFormattingPolicy)) {
                groupedBlocks = null;
            }
            rearrangedBlocks.add(block);
        }
        PhpFormattingModelBuilder.addPhpSyntheticBlock(rearrangedBlocks, groupedBlocks, settings, xmlFormattingPolicy);
        return rearrangedBlocks;
    }

    private static boolean addPhpSyntheticBlock(@NotNull List<Block> rearrangedBlocks, @Nullable List<Block> groupedBlocks, @NotNull CodeStyleSettings settings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (rearrangedBlocks == null) {
            PhpFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PhpFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        if (xmlFormattingPolicy == null) {
            PhpFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        if (groupedBlocks != null) {
            PhpSyntheticBlock syntheticBlock = PhpFormattingModelBuilder.createPhpSyntheticBlock(groupedBlocks, settings, xmlFormattingPolicy);
            rearrangedBlocks.add(syntheticBlock);
            return true;
        }
        return false;
    }

    private static PhpSyntheticBlock createPhpSyntheticBlock(List<Block> originalBlocks, CodeStyleSettings settings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (xmlFormattingPolicy == null) {
            PhpFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        PhpSyntheticBlock syntheticBlock = new PhpSyntheticBlock(originalBlocks, settings, xmlFormattingPolicy);
        for (Block block : originalBlocks) {
            if (!(block instanceof BlockWithParent)) continue;
            ((BlockWithParent)block).setParent((BlockWithParent)syntheticBlock);
        }
        return syntheticBlock;
    }

    protected XmlBlock createXmlBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent, @Nullable TextRange textRange) {
        return new PhpXmlBlock(this, node, wrap, alignment, policy, indent, textRange);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFormattingPolicy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rearrangedBlocks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpFormattingModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "afterMerge";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addPhpSyntheticBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createPhpSyntheticBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

