/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.phpdoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.ui.PhpDocCodeStylePanel;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocFormatPreprocessor
implements PreFormatProcessor {
    private static final Logger LOG = Logger.getInstance(PhpDocFormatPreprocessor.class);

    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement psiElement;
        if (element == null) {
            PhpDocFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PhpDocFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null || !psiElement.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpDocFormatPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (!psiElement.getLanguage().is((Language)PhpLanguage.INSTANCE)) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpDocFormatPreprocessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        TextRange textRange = new PhpDocFormatter(psiElement).process(psiElement, range);
        if (textRange == null) {
            PhpDocFormatPreprocessor.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/phpdoc/PhpDocFormatPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/phpdoc/PhpDocFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class PhpDocFormatter
    extends PhpElementVisitor {
        private final PhpCodeStyleSettings myPhpSettings;
        private final Project myProject;
        private TextRange myOrigRange;
        private TextRange myRange;
        private final Map<Integer, MyChangeInfo> myCollectedChanges;
        private final PhpDocComparator myComparator;

        PhpDocFormatter(@NotNull PsiElement element) {
            if (element == null) {
                PhpDocFormatter.$$$reportNull$$$0(0);
            }
            this.myCollectedChanges = new TreeMap<Integer, MyChangeInfo>();
            this.myProject = element.getProject();
            this.myPhpSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)element.getContainingFile(), PhpCodeStyleSettings.class);
            this.myComparator = new PhpDocComparator(this.myPhpSettings);
        }

        public TextRange process(PsiElement element, TextRange range) {
            Document doc;
            PsiFile file = element.getContainingFile();
            this.myRange = this.myOrigRange = range;
            element.accept((PsiElementVisitor)this);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            Document document = doc = file.isPhysical() ? documentManager.getDocument(file) : file.getViewProvider().getDocument();
            if (doc != null) {
                int delta = this.doReplacements(doc);
                documentManager.commitDocument(doc);
                this.myRange = this.grown(delta);
            }
            return this.myRange;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpDocFormatter.$$$reportNull$$$0(1);
            }
            if (element instanceof PhpDocComment && (this.myOrigRange.contains(element.getTextRange()) || element.getTextRange().contains(this.myOrigRange))) {
                int originalLength = element.getTextRange().getLength();
                PhpDocComment sortedElement = this.myPhpSettings.SORT_PHPDOC_ELEMENTS ? this.sortDocComment((PhpDocComment)element) : null;
                this.processDocComment(sortedElement, (PhpDocComment)element);
                int delta = element.getTextRange().getLength() - originalLength;
                this.myRange = this.grown(delta);
            } else {
                element.acceptChildren((PsiElementVisitor)this);
            }
        }

        @Nullable
        private PhpDocComment sortDocComment(@NotNull PhpDocComment element) {
            PsiElement child;
            if (element == null) {
                PhpDocFormatter.$$$reportNull$$$0(2);
            }
            ArrayList<Pair> blocks = new ArrayList<Pair>();
            String type = null;
            StringBuilder builder2 = new StringBuilder();
            Object startTag = child.getText();
            for (child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!PhpDocFormatter.isSortedBlockStart(child)) {
                    builder2.append(child.getText());
                    continue;
                }
                if (type != null) {
                    String second = builder2.toString();
                    blocks.add(Pair.create(type, (Object)second));
                } else {
                    startTag = child.getText() + builder2;
                }
                type = PhpDocFormatter.getTagName(child);
                builder2 = new StringBuilder(child.getText());
            }
            blocks.add(Pair.create(type, (Object)StringUtil.trimTrailing((String)builder2.toString(), (char)'/')));
            ContainerUtil.sort(blocks, (Comparator)this.myComparator);
            String sortedCommentText = (String)startTag + StringUtil.trimTrailing((String)StringUtil.join((Collection)ContainerUtil.map(blocks, i -> (String)i.second), (String)"")) + "/";
            return PhpPsiElementFactory.createFromText(this.myProject, PhpDocComment.class, sortedCommentText);
        }

        private static String getTagName(@NotNull PsiElement child) {
            if (child == null) {
                PhpDocFormatter.$$$reportNull$$$0(3);
            }
            return child instanceof PhpDocTag ? ((PhpDocTag)child).getName() : "UNKNOWN_TAG";
        }

        private static boolean isSortedBlockStart(@NotNull PsiElement child) {
            if (child == null) {
                PhpDocFormatter.$$$reportNull$$$0(4);
            }
            return child instanceof PhpDocTag && !PhpDocFormatter.isInLineTag((PhpDocTag)child) && PhpDocCodeStylePanel.PhpDocMemberOrderList.PROPERTIES.containsKey(((PhpDocTag)child).getName());
        }

        @NotNull
        private TextRange grown(int delta) {
            TextRange textRange = this.myRange.getLength() + delta > 0 ? this.myRange.grown(delta) : TextRange.from((int)this.myRange.getStartOffset(), (int)0);
            if (textRange == null) {
                PhpDocFormatter.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processDocComment(@Nullable PhpDocComment sortedDocComment, @NotNull PhpDocComment docComment) {
            if (docComment == null) {
                PhpDocFormatter.$$$reportNull$$$0(6);
            }
            StringBuilder newCommentBuf = new StringBuilder();
            PsiElement child = (sortedDocComment == null || docComment.getText().equals(sortedDocComment.getText()) ? docComment : sortedDocComment).getFirstChild();
            boolean beforeFirstTag = true;
            boolean isInParamTags = false;
            boolean blankLineExists = false;
            boolean isAtStart = false;
            while (child != null) {
                block27: {
                    String childText = child.getText();
                    if (PhpDocUtil.isSimpleTag(child)) {
                        if (!PhpDocFormatter.isInLineTag((PhpDocTag)child)) {
                            boolean isBlankLineNeeded = false;
                            if (this.myPhpSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS && beforeFirstTag) {
                                isBlankLineNeeded = true;
                            }
                            if (childText.startsWith("@param")) {
                                if (this.myPhpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS && !isInParamTags) {
                                    isBlankLineNeeded = true;
                                }
                                isInParamTags = true;
                            } else {
                                if (this.myPhpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS && isInParamTags) {
                                    isBlankLineNeeded = true;
                                }
                                isInParamTags = false;
                            }
                            if (isBlankLineNeeded && !blankLineExists && !isAtStart) {
                                Condition whiteSpaceBeforeAsteriskCondition = element -> element instanceof PsiWhiteSpace && PhpPsiUtil.isOfType(element.getNextSibling(), PhpDocTokenTypes.DOC_LEADING_ASTERISK);
                                Object prevSiblingByCondition = PhpPsiUtil.getPrevSiblingByCondition(child, (Condition<? super PsiElement>)whiteSpaceBeforeAsteriskCondition);
                                String whiteSpaceAlligned = prevSiblingByCondition != null ? prevSiblingByCondition.getText() : "\n";
                                int lastIndexOf = newCommentBuf.lastIndexOf("*");
                                if (lastIndexOf == -1) {
                                    newCommentBuf.append(whiteSpaceAlligned);
                                    newCommentBuf.append("*");
                                } else {
                                    newCommentBuf.insert(lastIndexOf, "*");
                                    newCommentBuf.insert(lastIndexOf + 1, whiteSpaceAlligned);
                                }
                            }
                            beforeFirstTag = false;
                            blankLineExists = false;
                        }
                        isAtStart = false;
                        newCommentBuf.append(childText);
                    } else if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_LEADING_ASTERISK)) {
                        PsiElement next = child.getNextSibling();
                        if (next instanceof PsiWhiteSpace && next.getNode().textContains('\n')) {
                            PsiElement afterWhitespace = next.getNextSibling();
                            if (afterWhitespace instanceof PsiWhiteSpace) {
                                afterWhitespace = afterWhitespace.getNextSibling();
                            }
                            boolean isAtEnd = PhpPsiUtil.isOfType(afterWhitespace, PhpDocTokenTypes.DOC_COMMENT_END);
                            if (this.myPhpSettings.PHPDOC_KEEP_BLANK_LINES || isAtStart && isAtEnd) {
                                newCommentBuf.append(childText).append(next.getText());
                                child = next;
                                blankLineExists = true;
                                break block27;
                            } else {
                                child = next.getNextSibling();
                                continue;
                            }
                        }
                        newCommentBuf.append(childText);
                    } else if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IGNORED)) {
                        this.prefixWithStar(newCommentBuf, child);
                    } else {
                        int lineBreaks;
                        if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_COMMENT_START)) {
                            isAtStart = true;
                        } else if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER)) {
                            isAtStart = false;
                            blankLineExists = false;
                        }
                        if (child instanceof PsiWhiteSpace && childText.contains("\n") && (lineBreaks = StringUtil.getLineBreakCount((CharSequence)childText)) > 1) {
                            childText = "\n ";
                        }
                        newCommentBuf.append(childText);
                    }
                }
                child = child.getNextSibling();
            }
            String newCommentText = newCommentBuf.toString();
            PhpDocComment newDocComment = PhpPsiElementFactory.createFromText(this.myProject, PhpDocComment.class, newCommentText);
            assert (newDocComment != null) : "Invalid doc comment: " + newCommentText;
            if (!newDocComment.getText().equals(docComment.getText())) {
                this.myCollectedChanges.put(docComment.getTextOffset(), new MyChangeInfo(docComment.getTextRange(), newCommentText));
            }
        }

        private static boolean isInLineTag(PhpDocTag tag) {
            PsiElement prev = tag.getPrevSibling();
            if (PhpPsiUtil.isOfType(prev, PhpDocTokenTypes.DOC_TEXT)) {
                prev = prev.getPrevSibling();
            }
            return PhpPsiUtil.isOfType(prev, PhpDocTokenTypes.DOC_LBRACE);
        }

        private int doReplacements(Document doc) {
            int delta = 0;
            for (MyChangeInfo info : this.myCollectedChanges.values()) {
                int newDelta = delta + (info.getNewComment().length() - info.getOriginalRange().getLength());
                TextRange replaceRange = info.getOriginalRange().shiftRight(delta);
                doc.replaceString(replaceRange.getStartOffset(), replaceRange.getEndOffset(), (CharSequence)info.getNewComment());
                delta = newDelta;
            }
            return delta;
        }

        private static int lineFeedCount(@NotNull PsiElement element) {
            if (element == null) {
                PhpDocFormatter.$$$reportNull$$$0(7);
            }
            return StringUtil.countChars((CharSequence)element.getNode().getChars(), (char)'\n');
        }

        private void prefixWithStar(StringBuilder builder2, PsiElement currElement) {
            int lineFeeds;
            PsiElement prev = currElement.getPrevSibling();
            if (prev instanceof PsiWhiteSpace && (lineFeeds = PhpDocFormatter.lineFeedCount(prev)) > 0) {
                if (this.myPhpSettings.PHPDOC_KEEP_BLANK_LINES) {
                    builder2.append("*\n".repeat(lineFeeds - 1));
                }
                builder2.append("* ");
            }
            builder2.append(currElement.getNode().getChars());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/formatter/phpdoc/PhpDocFormatPreprocessor$PhpDocFormatter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/formatter/phpdoc/PhpDocFormatPreprocessor$PhpDocFormatter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "grown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "sortDocComment";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTagName";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSortedBlockStart";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processDocComment";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lineFeedCount";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    static final class PhpDocComparator
    implements Comparator<Pair<String, String>> {
        private final PhpCodeStyleSettings mySettings;

        private PhpDocComparator(PhpCodeStyleSettings settings) {
            this.mySettings = settings;
        }

        @Override
        public int compare(Pair<String, String> p1, Pair<String, String> t2) {
            return this.getWeight((String)p1.first) - this.getWeight((String)t2.first);
        }

        private int getWeight(String e) {
            Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>> pair = PhpDocCodeStylePanel.PhpDocMemberOrderList.PROPERTIES.get(e);
            return pair != null ? ((ToIntFunction)pair.getFirst()).applyAsInt(this.mySettings) : this.mySettings.UNKNOWN_TAG_WEIGHT;
        }
    }

    private static final class MyChangeInfo {
        private final TextRange myOriginalRange;
        private final String myNewComment;

        private MyChangeInfo(TextRange originalRange, String newComment) {
            this.myOriginalRange = originalRange;
            this.myNewComment = newComment;
        }

        public TextRange getOriginalRange() {
            return this.myOriginalRange;
        }

        public String getNewComment() {
            return this.myNewComment;
        }
    }
}

