/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

public class PhpConversionCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myMainPanel;
    private JPanel myPreviewPanel;
    private JCheckBox myCaseBooleanCheckBox;
    private JCheckBox myCaseNullCheckBox;
    private JRadioButton myBoolUpperCaseRadioButton;
    private JRadioButton myBoolLowerCaseRadioButton;
    private JRadioButton myNullUpperCaseRadioButton;
    private JRadioButton myNullLowerCaseRadioButton;
    private JCheckBox myElseIfStyleCheckBox;
    private JRadioButton mySeparateElseIfRadioButton;
    private JRadioButton myCombineElseIfRadioButton;
    private JCheckBox myForceShortArrayStyleCheckBox;
    private JPanel myArrayDeclarationStylePanel;
    private JCheckBox myAddCommaAfterLastElementBox;
    private JBScrollPane myScrollPane;
    private JPanel myOptionsPanel;
    private JCheckBox mySortImportsCheckBox;
    private JRadioButton myByStatementLengthRadioButton;
    private JRadioButton myAlphabeticallyRadioButton;
    private JBCheckBox myLowercaseKeywordCheckBox;
    private JBCheckBox myAddCommaAfterLastParameterCheckBox;
    private JRadioButton myAlwaysAddCommaParameterRadioButton;
    private JRadioButton myMultilineAddCommaParameterRadioButton;
    private JCheckBox myAddCommaAfterLastClosureUseVariableCheckBox;
    private JRadioButton myAlwaysAddCommaClosureUseRadioButton;
    private JRadioButton myMultilineAddCommaClosureUseRadioButton;
    private JBCheckBox myAddCommaAfterLastArgumentCheckBox;
    private JRadioButton myAlwaysAddCommaArgumentRadioButton;
    private JRadioButton myMultilineAddCommaArgumentRadioButton;
    private JBCheckBox myAddCommaAfterLastMatchArmCheckBox;

    protected PhpConversionCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PhpConversionCodeStylePanel.this.somethingChanged();
            }
        };
        this.myForceShortArrayStyleCheckBox.addItemListener(listener);
        this.myLowercaseKeywordCheckBox.addItemListener(listener);
        this.myAddCommaAfterLastParameterCheckBox.addItemListener(listener);
        this.myAddCommaAfterLastParameterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PhpConversionCodeStylePanel.this.myAlwaysAddCommaParameterRadioButton.setEnabled(PhpConversionCodeStylePanel.this.myAddCommaAfterLastParameterCheckBox.isSelected());
                PhpConversionCodeStylePanel.this.myMultilineAddCommaParameterRadioButton.setEnabled(PhpConversionCodeStylePanel.this.myAddCommaAfterLastParameterCheckBox.isSelected());
            }
        });
        this.myAddCommaAfterLastClosureUseVariableCheckBox.addItemListener(listener);
        this.myAddCommaAfterLastClosureUseVariableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PhpConversionCodeStylePanel.this.myAlwaysAddCommaClosureUseRadioButton.setEnabled(PhpConversionCodeStylePanel.this.myAddCommaAfterLastClosureUseVariableCheckBox.isSelected());
                PhpConversionCodeStylePanel.this.myMultilineAddCommaClosureUseRadioButton.setEnabled(PhpConversionCodeStylePanel.this.myAddCommaAfterLastClosureUseVariableCheckBox.isSelected());
            }
        });
        this.myAddCommaAfterLastArgumentCheckBox.addItemListener(listener);
        this.myAddCommaAfterLastArgumentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PhpConversionCodeStylePanel.this.myAlwaysAddCommaArgumentRadioButton.setEnabled(PhpConversionCodeStylePanel.this.myAddCommaAfterLastArgumentCheckBox.isSelected());
                PhpConversionCodeStylePanel.this.myMultilineAddCommaArgumentRadioButton.setEnabled(PhpConversionCodeStylePanel.this.myAddCommaAfterLastArgumentCheckBox.isSelected());
            }
        });
        this.myAddCommaAfterLastMatchArmCheckBox.addItemListener(listener);
        this.myCaseBooleanCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PhpConversionCodeStylePanel.this.myCaseBooleanCheckBox.isSelected()) {
                    PhpConversionCodeStylePanel.this.myBoolLowerCaseRadioButton.setEnabled(true);
                    PhpConversionCodeStylePanel.this.myBoolUpperCaseRadioButton.setEnabled(true);
                } else {
                    PhpConversionCodeStylePanel.this.myBoolLowerCaseRadioButton.setEnabled(false);
                    PhpConversionCodeStylePanel.this.myBoolUpperCaseRadioButton.setEnabled(false);
                }
            }
        });
        this.myCaseNullCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PhpConversionCodeStylePanel.this.myCaseNullCheckBox.isSelected()) {
                    PhpConversionCodeStylePanel.this.myNullLowerCaseRadioButton.setEnabled(true);
                    PhpConversionCodeStylePanel.this.myNullUpperCaseRadioButton.setEnabled(true);
                } else {
                    PhpConversionCodeStylePanel.this.myNullLowerCaseRadioButton.setEnabled(false);
                    PhpConversionCodeStylePanel.this.myNullUpperCaseRadioButton.setEnabled(false);
                }
            }
        });
        ButtonGroup boolCaseGroup = new ButtonGroup();
        boolCaseGroup.add(this.myBoolLowerCaseRadioButton);
        boolCaseGroup.add(this.myBoolUpperCaseRadioButton);
        ButtonGroup nullCaseGroup = new ButtonGroup();
        nullCaseGroup.add(this.myNullLowerCaseRadioButton);
        nullCaseGroup.add(this.myNullUpperCaseRadioButton);
        this.myElseIfStyleCheckBox.addActionListener(event -> {
            if (this.myElseIfStyleCheckBox.isSelected()) {
                this.mySeparateElseIfRadioButton.setEnabled(true);
                this.myCombineElseIfRadioButton.setEnabled(true);
            } else {
                this.mySeparateElseIfRadioButton.setEnabled(false);
                this.myCombineElseIfRadioButton.setEnabled(false);
            }
        });
        ButtonGroup elseIfStyleGroup = new ButtonGroup();
        elseIfStyleGroup.add(this.mySeparateElseIfRadioButton);
        elseIfStyleGroup.add(this.myCombineElseIfRadioButton);
        this.myAddCommaAfterLastElementBox.addItemListener(listener);
        this.myArrayDeclarationStylePanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("array.declaration.style", new Object[0])));
        this.mySortImportsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PhpConversionCodeStylePanel.this.myAlphabeticallyRadioButton.setEnabled(PhpConversionCodeStylePanel.this.mySortImportsCheckBox.isSelected());
                PhpConversionCodeStylePanel.this.myByStatementLengthRadioButton.setEnabled(PhpConversionCodeStylePanel.this.mySortImportsCheckBox.isSelected());
            }
        });
        ButtonGroup sortGroup = new ButtonGroup();
        sortGroup.add(this.myAlphabeticallyRadioButton);
        sortGroup.add(this.myByStatementLengthRadioButton);
        ButtonGroup commaParameterGroup = new ButtonGroup();
        commaParameterGroup.add(this.myAlwaysAddCommaParameterRadioButton);
        commaParameterGroup.add(this.myMultilineAddCommaParameterRadioButton);
        ButtonGroup commaArgumentGroup = new ButtonGroup();
        commaArgumentGroup.add(this.myAlwaysAddCommaArgumentRadioButton);
        commaArgumentGroup.add(this.myMultilineAddCommaArgumentRadioButton);
        ButtonGroup commaClosureVarGroup = new ButtonGroup();
        commaClosureVarGroup.add(this.myAlwaysAddCommaClosureUseRadioButton);
        commaClosureVarGroup.add(this.myMultilineAddCommaClosureUseRadioButton);
        this.myScrollPane.setMinimumSize(new Dimension(this.myOptionsPanel.getPreferredSize().width + this.myScrollPane.getVerticalScrollBar().getPreferredSize().width + 5, -1));
        this.myScrollPane.setPreferredSize(this.myScrollPane.getMinimumSize());
    }

    protected int getRightMargin() {
        return 80;
    }

    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            PhpConversionCodeStylePanel.$$$reportNull$$$0(0);
        }
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.php"), scheme, null);
    }

    @NotNull
    protected FileType getFileType() {
        PhpFileType phpFileType = PhpFileType.INSTANCE;
        if (phpFileType == null) {
            PhpConversionCodeStylePanel.$$$reportNull$$$0(1);
        }
        return phpFileType;
    }

    protected String getPreviewText() {
        return "<?php\n\nClass Baz{    public Float $prop;\n    function bar($a, $b, $c) {\n      echo \"Hello!\";\n    }\n    Function foo(Bool $one=Null, \n                 Int $two = 0, \n                 String $three = \"String\"\n): Int\n    {\n        If (True) {\n            $x = Array(\n                0 => \"zero\",\n                123 => \"one two three\",\n                25 => \"two five\"\n            );\n            foo($a, $b, $c);\n            $a = isset(\n                $one, \n                $two, \n                $three\n            );\n            $m = match ($two) {\n                1 => \"one\",\n                2 => \"two\",\n                3 => \"three\"\n            };\n        }\n        ElseIf(Null) {\n            Echo Null;        }\n        Else If (False) {\n            $y = function () use ($a\n            ) {\n                Return $a;\n            };            Return 0;\n            $x = function () use ($a) {\n              echo 0;\n            };\n        }\n        Return 1;\n    }\n}\n?>";
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PhpConversionCodeStylePanel.$$$reportNull$$$0(2);
        }
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpCodeStyleSettings.UPPER_CASE_BOOLEAN_CONST = this.myCaseBooleanCheckBox.isSelected() && this.myBoolUpperCaseRadioButton.isSelected();
        phpCodeStyleSettings.UPPER_CASE_NULL_CONST = this.myCaseNullCheckBox.isSelected() && this.myNullUpperCaseRadioButton.isSelected();
        phpCodeStyleSettings.LOWER_CASE_BOOLEAN_CONST = this.myCaseBooleanCheckBox.isSelected() && this.myBoolLowerCaseRadioButton.isSelected();
        phpCodeStyleSettings.LOWER_CASE_NULL_CONST = this.myCaseNullCheckBox.isSelected() && this.myNullLowerCaseRadioButton.isSelected();
        phpCodeStyleSettings.ELSE_IF_STYLE = this.getElseIfStyle();
        phpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE = this.myForceShortArrayStyleCheckBox.isSelected();
        phpCodeStyleSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT = this.myAddCommaAfterLastElementBox.isSelected();
        phpCodeStyleSettings.IMPORT_SORTING = this.mySortImportsCheckBox.isSelected() ? (this.myByStatementLengthRadioButton.isSelected() ? PhpCodeStyleSettings.ImportSorting.BY_LENGTH : PhpCodeStyleSettings.ImportSorting.ALPHABETIC) : PhpCodeStyleSettings.ImportSorting.DONT_SORT;
        phpCodeStyleSettings.LOWER_CASE_KEYWORDS = this.myLowercaseKeywordCheckBox.isSelected();
        phpCodeStyleSettings.COMMA_AFTER_LAST_PARAMETER = this.myAddCommaAfterLastParameterCheckBox.isSelected();
        phpCodeStyleSettings.COMMA_AFTER_LAST_PARAMETER_STYLE = this.getParameterTrailingCommaStyle();
        phpCodeStyleSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR = this.myAddCommaAfterLastClosureUseVariableCheckBox.isSelected();
        phpCodeStyleSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR_STYLE = this.getClosureVarTrailingCommaStyle();
        phpCodeStyleSettings.COMMA_AFTER_LAST_ARGUMENT = this.myAddCommaAfterLastArgumentCheckBox.isSelected();
        phpCodeStyleSettings.COMMA_AFTER_LAST_ARGUMENT_STYLE = this.getArgumentTrailingCommaStyle();
        phpCodeStyleSettings.COMMA_AFTER_LAST_MATCH_ARM = this.myAddCommaAfterLastMatchArmCheckBox.isSelected();
    }

    private PhpCodeStyleSettings.PhpAddTrailingCommaStyle getParameterTrailingCommaStyle() {
        return this.myAlwaysAddCommaParameterRadioButton.isSelected() ? PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS : PhpCodeStyleSettings.PhpAddTrailingCommaStyle.WHEN_MULTILINE;
    }

    private PhpCodeStyleSettings.PhpAddTrailingCommaStyle getArgumentTrailingCommaStyle() {
        return this.myAlwaysAddCommaArgumentRadioButton.isSelected() ? PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS : PhpCodeStyleSettings.PhpAddTrailingCommaStyle.WHEN_MULTILINE;
    }

    private PhpCodeStyleSettings.PhpAddTrailingCommaStyle getClosureVarTrailingCommaStyle() {
        return this.myAlwaysAddCommaClosureUseRadioButton.isSelected() ? PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS : PhpCodeStyleSettings.PhpAddTrailingCommaStyle.WHEN_MULTILINE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        if (phpCodeStyleSettings.UPPER_CASE_BOOLEAN_CONST != this.myCaseBooleanCheckBox.isSelected()) {
            if (this.myBoolUpperCaseRadioButton.isSelected()) return true;
        }
        if (phpCodeStyleSettings.UPPER_CASE_NULL_CONST != this.myCaseNullCheckBox.isSelected()) {
            if (this.myNullUpperCaseRadioButton.isSelected()) return true;
        }
        if (phpCodeStyleSettings.LOWER_CASE_BOOLEAN_CONST != this.myCaseBooleanCheckBox.isSelected()) {
            if (this.myBoolLowerCaseRadioButton.isSelected()) return true;
        }
        if (phpCodeStyleSettings.LOWER_CASE_NULL_CONST != this.myCaseNullCheckBox.isSelected()) {
            if (this.myNullLowerCaseRadioButton.isSelected()) return true;
        }
        if (phpCodeStyleSettings.ELSE_IF_STYLE != this.getElseIfStyle()) return true;
        if (phpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE != this.myForceShortArrayStyleCheckBox.isSelected()) return true;
        if (phpCodeStyleSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT != this.myAddCommaAfterLastElementBox.isSelected()) return true;
        if (phpCodeStyleSettings.IMPORT_SORTING != (this.mySortImportsCheckBox.isSelected() ? (this.myByStatementLengthRadioButton.isSelected() ? PhpCodeStyleSettings.ImportSorting.BY_LENGTH : PhpCodeStyleSettings.ImportSorting.ALPHABETIC) : PhpCodeStyleSettings.ImportSorting.DONT_SORT)) return true;
        if (phpCodeStyleSettings.LOWER_CASE_KEYWORDS != this.myLowercaseKeywordCheckBox.isSelected()) return true;
        if (phpCodeStyleSettings.COMMA_AFTER_LAST_PARAMETER != this.myAddCommaAfterLastParameterCheckBox.isSelected()) return true;
        if (phpCodeStyleSettings.COMMA_AFTER_LAST_PARAMETER_STYLE != this.getParameterTrailingCommaStyle()) return true;
        if (phpCodeStyleSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR != this.myAddCommaAfterLastClosureUseVariableCheckBox.isSelected()) return true;
        if (phpCodeStyleSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR_STYLE != this.getClosureVarTrailingCommaStyle()) return true;
        if (phpCodeStyleSettings.COMMA_AFTER_LAST_ARGUMENT != this.myAddCommaAfterLastArgumentCheckBox.isSelected()) return true;
        if (phpCodeStyleSettings.COMMA_AFTER_LAST_ARGUMENT_STYLE != this.getArgumentTrailingCommaStyle()) return true;
        if (phpCodeStyleSettings.COMMA_AFTER_LAST_MATCH_ARM == this.myAddCommaAfterLastMatchArmCheckBox.isSelected()) return false;
        return true;
    }

    @NotNull
    private PhpCodeStyleSettings.ElseIfStyle getElseIfStyle() {
        if (this.myElseIfStyleCheckBox.isSelected() && this.mySeparateElseIfRadioButton.isSelected()) {
            PhpCodeStyleSettings.ElseIfStyle elseIfStyle = PhpCodeStyleSettings.ElseIfStyle.SEPARATE;
            if (elseIfStyle == null) {
                PhpConversionCodeStylePanel.$$$reportNull$$$0(3);
            }
            return elseIfStyle;
        }
        if (this.myElseIfStyleCheckBox.isSelected() && this.myCombineElseIfRadioButton.isSelected()) {
            PhpCodeStyleSettings.ElseIfStyle elseIfStyle = PhpCodeStyleSettings.ElseIfStyle.COMBINE;
            if (elseIfStyle == null) {
                PhpConversionCodeStylePanel.$$$reportNull$$$0(4);
            }
            return elseIfStyle;
        }
        PhpCodeStyleSettings.ElseIfStyle elseIfStyle = PhpCodeStyleSettings.ElseIfStyle.AS_IS;
        if (elseIfStyle == null) {
            PhpConversionCodeStylePanel.$$$reportNull$$$0(5);
        }
        return elseIfStyle;
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PhpConversionCodeStylePanel.$$$reportNull$$$0(6);
        }
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        this.myForceShortArrayStyleCheckBox.setSelected(phpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE);
        if (phpCodeStyleSettings.UPPER_CASE_BOOLEAN_CONST) {
            this.enableBooleanCaseRadioButtons(true);
            this.myBoolUpperCaseRadioButton.doClick();
        } else if (phpCodeStyleSettings.LOWER_CASE_BOOLEAN_CONST) {
            this.enableBooleanCaseRadioButtons(true);
            this.myBoolLowerCaseRadioButton.doClick();
        } else {
            this.enableBooleanCaseRadioButtons(false);
        }
        if (phpCodeStyleSettings.UPPER_CASE_NULL_CONST) {
            this.enableNullCaseRadioButtons(true);
            this.myNullUpperCaseRadioButton.doClick();
        } else if (phpCodeStyleSettings.LOWER_CASE_NULL_CONST) {
            this.enableNullCaseRadioButtons(true);
            this.myNullLowerCaseRadioButton.doClick();
        } else {
            this.enableNullCaseRadioButtons(false);
        }
        if (phpCodeStyleSettings.ELSE_IF_STYLE == PhpCodeStyleSettings.ElseIfStyle.SEPARATE) {
            this.enableElseIfStyleRadioButtons(true);
            this.mySeparateElseIfRadioButton.doClick();
        } else if (phpCodeStyleSettings.ELSE_IF_STYLE == PhpCodeStyleSettings.ElseIfStyle.COMBINE) {
            this.enableElseIfStyleRadioButtons(true);
            this.myCombineElseIfRadioButton.doClick();
        } else {
            this.enableElseIfStyleRadioButtons(false);
        }
        this.mySortImportsCheckBox.setSelected(phpCodeStyleSettings.IMPORT_SORTING != PhpCodeStyleSettings.ImportSorting.DONT_SORT);
        this.myByStatementLengthRadioButton.setSelected(phpCodeStyleSettings.IMPORT_SORTING == PhpCodeStyleSettings.ImportSorting.BY_LENGTH);
        this.myAlphabeticallyRadioButton.setSelected(phpCodeStyleSettings.IMPORT_SORTING == PhpCodeStyleSettings.ImportSorting.ALPHABETIC);
        this.myAlphabeticallyRadioButton.setEnabled(this.mySortImportsCheckBox.isSelected());
        this.myByStatementLengthRadioButton.setEnabled(this.mySortImportsCheckBox.isSelected());
        this.myAddCommaAfterLastElementBox.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT);
        this.myLowercaseKeywordCheckBox.setSelected(phpCodeStyleSettings.LOWER_CASE_KEYWORDS);
        this.myAddCommaAfterLastParameterCheckBox.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_PARAMETER);
        this.myAlwaysAddCommaParameterRadioButton.setEnabled(this.myAddCommaAfterLastParameterCheckBox.isSelected());
        this.myMultilineAddCommaParameterRadioButton.setEnabled(this.myAddCommaAfterLastParameterCheckBox.isSelected());
        this.myAlwaysAddCommaParameterRadioButton.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_PARAMETER_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS);
        this.myMultilineAddCommaParameterRadioButton.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_PARAMETER_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.WHEN_MULTILINE);
        this.myAddCommaAfterLastClosureUseVariableCheckBox.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR);
        this.myAlwaysAddCommaClosureUseRadioButton.setEnabled(this.myAddCommaAfterLastClosureUseVariableCheckBox.isSelected());
        this.myMultilineAddCommaClosureUseRadioButton.setEnabled(this.myAddCommaAfterLastClosureUseVariableCheckBox.isSelected());
        this.myAlwaysAddCommaClosureUseRadioButton.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS);
        this.myMultilineAddCommaClosureUseRadioButton.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.WHEN_MULTILINE);
        this.myAddCommaAfterLastArgumentCheckBox.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_ARGUMENT);
        this.myAlwaysAddCommaArgumentRadioButton.setEnabled(this.myAddCommaAfterLastArgumentCheckBox.isSelected());
        this.myMultilineAddCommaArgumentRadioButton.setEnabled(this.myAddCommaAfterLastArgumentCheckBox.isSelected());
        this.myAlwaysAddCommaArgumentRadioButton.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_ARGUMENT_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS);
        this.myMultilineAddCommaArgumentRadioButton.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_ARGUMENT_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.WHEN_MULTILINE);
        this.myAddCommaAfterLastMatchArmCheckBox.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_MATCH_ARM);
    }

    private void enableBooleanCaseRadioButtons(boolean state) {
        this.myCaseBooleanCheckBox.setSelected(state);
        this.myBoolLowerCaseRadioButton.setEnabled(state);
        this.myBoolUpperCaseRadioButton.setEnabled(state);
    }

    private void enableNullCaseRadioButtons(boolean state) {
        this.myCaseNullCheckBox.setSelected(state);
        this.myNullLowerCaseRadioButton.setEnabled(state);
        this.myNullUpperCaseRadioButton.setEnabled(state);
    }

    private void enableElseIfStyleRadioButtons(boolean state) {
        this.myElseIfStyleCheckBox.setSelected(state);
        this.mySeparateElseIfRadioButton.setEnabled(state);
        this.myCombineElseIfRadioButton.setEnabled(state);
    }

    public Language getDefaultLanguage() {
        return PhpLanguage.INSTANCE;
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = PhpBundle.message("php.conversion.code.style.title", new Object[0]);
        if (string == null) {
            PhpConversionCodeStylePanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel2;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel3;
        JBScrollPane jBScrollPane;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(18, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        this.myCaseBooleanCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("phpdoc.code.style.convert.true.false.to"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCaseNullCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("phpdoc.code.style.convert.null.to"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myBoolUpperCaseRadioButton = jRadioButton8 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton8, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("php.code.style.convert.upper.case"));
        jPanel5.add((Component)jRadioButton8, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBoolLowerCaseRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton7, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("php.code.style.convert.lower.case"));
        jPanel5.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNullUpperCaseRadioButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("php.code.style.convert.upper.case"));
        jPanel6.add((Component)jRadioButton6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNullLowerCaseRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("php.code.style.convert.lower.case"));
        jPanel6.add((Component)jRadioButton5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myArrayDeclarationStylePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(16, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("array.declaration.style"), (int)0, (int)0, (Font)this.$$$getFont$$$(null, -1, -1, jPanel2.getFont()), null));
        this.myForceShortArrayStyleCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("checkbox.force.short.declaration.style"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myAddCommaAfterLastElementBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("checkbox.add.a.comma.after.last.element.in.multiline.array"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myElseIfStyleCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("phpdoc.code.style.convert.else.if.to"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCombineElseIfRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("phpdoc.code.style.convert.else.if.combine"));
        jPanel7.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySeparateElseIfRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("phpdoc.code.style.convert.else.if.separate"));
        jPanel7.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel7.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(17, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySortImportsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("php.code.style.sort.use.stmt"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myByStatementLengthRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("php.code.style.sort.by.length"));
        jPanel8.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlphabeticallyRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("php.code.style.sort.alphabetically"));
        jPanel8.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel8.add((Component)spacer6, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLowercaseKeywordCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("php.code.style.convert.keyword.to.lowercase"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.setToolTipText("Always");
        jPanel3.add((Component)jPanel9, new GridConstraints(10, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBRadioButton jBRadioButton = new JBRadioButton();
        this.myMultilineAddCommaParameterRadioButton = jBRadioButton;
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("radio.button.when.multiline.add.coma"));
        jPanel9.add((Component)jBRadioButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JBRadioButton jBRadioButton2 = new JBRadioButton();
        this.myAlwaysAddCommaParameterRadioButton = jBRadioButton2;
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("radio.button.always.add.comma"));
        jPanel9.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel10, new GridConstraints(12, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBRadioButton jBRadioButton3 = new JBRadioButton();
        this.myMultilineAddCommaClosureUseRadioButton = jBRadioButton3;
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("radio.button.when.multiline.add.coma"));
        jPanel10.add((Component)jBRadioButton3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JBRadioButton jBRadioButton4 = new JBRadioButton();
        this.myAlwaysAddCommaClosureUseRadioButton = jBRadioButton4;
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("radio.button.always.add.comma"));
        jPanel10.add((Component)jBRadioButton4, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel11, new GridConstraints(14, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel11.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JBRadioButton jBRadioButton5 = new JBRadioButton();
        this.myMultilineAddCommaArgumentRadioButton = jBRadioButton5;
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("radio.button.when.multiline.add.coma"));
        jPanel11.add((Component)jBRadioButton5, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JBRadioButton jBRadioButton6 = new JBRadioButton();
        this.myAlwaysAddCommaArgumentRadioButton = jBRadioButton6;
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("radio.button.always.add.comma"));
        jPanel11.add((Component)jBRadioButton6, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myAddCommaAfterLastMatchArmCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("checkbox.add.a.comma.after.last.match.arm"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(15, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddCommaAfterLastParameterCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("checkbox.add.a.comma.after.last.parameter"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddCommaAfterLastClosureUseVariableCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("checkbox.add.a.comma.after.last.var.in.closure.use.list"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(11, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myAddCommaAfterLastArgumentCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpConversionCodeStylePanel.class).getString("checkbox.add.a.comma.after.last.argument.in.function.call"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/ui/PhpConversionCodeStylePanel";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/ui/PhpConversionCodeStylePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElseIfStyle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

