/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpPredefinedCodeStyleBase;
import com.jetbrains.php.lang.formatter.ui.PhpSmartIndentOptionsEditor;
import org.jetbrains.annotations.NotNull;

public final class PhpLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final String SPACING_CODE_SAMPLE = "<?php\ndeclare(strict_types=1);\n\nclass Foo\n{\n    function foo($x, $z)\n    {\n        global $k, $s1;\n        $obj->foo(x: 1)->bar();\n        $arr = array(0 => \"zero\", 1 => \"one\");\n  call_func(function() { return 0; });\n  call_func(fn() => 0);\n        for ($i = 0; $i < $x; $i++) {\n            $y += ($y ^ 0x123) << 2;\n        }\n        $k = $x > 15 ? 1 : 2;\n        $k = $x ?: 0;\n        $k = $x ?? $z;\n        $k = $x <=> $z;\n        do {\n            try {\n                if (!0 > $x && !$x < 10) {\n                    while ($x != $y) {\n                        $x = f($x * 3 + 5);\n                    }\n                    $z += 2;\n                } elseif ($x > 20) {\n                    $z = $x << 1;\n                } else {\n                    $z = $x | 2;\n                }\n                $j = (int)$z;\n                switch ($j) {\n                    case 0:\n                        $s1 = 'zero';\n                        break;\n                    case 2:\n                        $s1 = 'two';\n                        break;\n                    default:\n                        $s1 = 'other';\n                }\n            } catch (exception $e) {\n                $t = $one[0];\n                $u = $one['str'];\n                $v = $one[$x[1]];\n                echo $val{foo . $num}[$cell{$a}];\n            } finally {\n                // do something\n            }\n        } while ($x < 0);\n    }\n}\nfunction bar() : Foo\n{\n}\nenum a: int {}\n?><div><?=foo()?></div>";
    private static final String GENERAL_CODE_SAMPLE = "<?php\n#[Attribute] #[Attribute(1,2)] class Foo {\n  var $x;\n  var $y;\n\n  \n/* C-style comment */    var $arr;\n\nfunction foo (#[Attribute(1,2)] $x, $z)\n{\nglobal $k,$s1;\n  for ($i = 0; $i < $x; $i++) { /* Another C-style comment */$y += ($y ^ 0x123) <<   2;   }\n\n\n    \n$k = $x > 15 ? 1 : 2;\n      do   {\n  try {if(0 < $x && $x < 10) {\n         while ($x != $y) {$x = f($x * 3 + 5);\n          }\n          $z += 2;}elseif   (   $x > 20    ) { $z = $x << 1;\n        }else {\n    $z = $x | 2;  }\n     $j = (int) $z;\n        switch($j) {   case 0:\n             $s1 = 'zero';         break;\n           case 2:\n              $s1 = 'two';\n            break;\n           default:\n$s1 = 'other';\n        }\n      }catch (exception $e) {\necho $val{         foo.$num      }[$cell{$a}];\n      }\n    }\n    while(true);\n}}?>";
    private static final String BLANK_LINE_CODE_SAMPLE = "<?php\nnamespace Acme\\Package;\nuse Acme\\Foo;\nuse Acme\\Bar;\nclass Foo {\n    var $x;\n    var $y;\n    function foo() {\n\n    }\n}\nclass Bar {\n    const X = 1;\n    const Y = 2;\n    var $a;\n    var $b;\n    function bar() {\n        $a = \"a\";\n\n\n        $b = \"b\";\n\n        \n    }\nfunction bar_2() {\n return this::$a . this::$b;\n}\n\nfunction bar_3() {\necho \"null\";\n return null;\n}\n\n\n\n}\n\n\nfunction function_declaration() {\n\n}\nregister_function('function_declaration');\nenum Suit: string\n{\n    case Clubs = 'C';\n    case Diamonds = 'D';\n    case Hearts = 'H';\n    case Spades = 'S';\n}\n?>";
    private static final String WRAPPING_CODE_SAMPLE = "<?php\nuse N\\{ClassName,AnotherClassName,OneMoreClassName};\n$instance = new class {};namespace A {\n#[Attribute] #[Attribute(1,2)] function foo() {return 0;}\n\nfunction bar($x,\n$y, int $z=1) {\n$x = 0;\n// $x = 1\ndo { $y += 1; }\nwhile ($y < 10);\nif (true) $x = 10;\nelseif ($y < 10) $x = 5;\nelse if (true) $x = 5;\nfor($i=0;$i<10;$i++) $yy = $x > 2 ?1:2;\nwhile(true) $x = 0;\ndo {$x += 1;} while (true);\nforeach(array(\"a\"=>0,\"b\"=>1,\n\"c\"=>2) as $e1){echo $e1;}\n$count = 10;\n$x = array(\"x\",\"y\",\narray(1=>\"abc\",\n2=>\"def\",3=>\"ghi\"));\n$zz = array(0.1,0.2,\n0.3,0.4);\n$x = array(\n0 => \"zero\",\n123 => \"one two three\",\n25 => \"two five\"\n);bar(0,bar(1,\n\"b\"));\n}\n\nabstract class Foo extends FooBaseClass implements Bar1, Bar2, Bar3 {\n\n  var $numbers = array(\"one\", \"two\", \"three\", \"four\", \"five\", \"six\");\n var $v = 0; // comment \n public $path = \"root\"; // comment\n\nconst FIRST = 'first';\nconst SECOND = 0;const Z = -1;\n\nfunction bar($v,\n$w=\"a\") {\n$y=$w;\n$result = foo(\"arg1\",\n\"arg2\",\n10);\nswitch($v) {\ncase 0:\nreturn 1;\ncase 1:\necho '1';\nbreak;\ncase 2:\nbreak;\ndefault:\n$result = 10;\n}return $result;\n}\n\n  public static function fOne(#[Attribute(1,2)]$argA, $argB, $argC, $argD, $argE, $argF, $argG, $argH) {\n    $x = $argA + $argB + $argC + $argD + $argE + $argF + $argG + $argH;\n    list($field1, $field2, $field3, $filed4, $field5, $field6) = explode(\",\", $x);\n    fTwo($argA, $argB, $argC, fThree($argD, $argE, $argF, $argG, $argH));\n    $z = $argA == \"Some string\" ? \"yes\" : \"no\";\n    $colors = array(\"red\", \"green\", \"blue\", \"black\", \"white\", \"gray\");\n    $count = count($colors);\n    for ($i = 0; $i < $count; $i++)\t{\n      $colorString = $colors[$i];\n    }\n  }\n\n  function fTwo($strA, $strB, $strC, $strD) {\n    if ($strA == \"one\" || $strB == \"two\" || $strC == \"three\") {\n      return $strA + $strB + $strC;\n    }\n    $x = $foo->one(\"a\", \"b\")->two(\"c\", \"d\", \"e\")->three(\"fg\")->four();\n    $y = a()->b()->c();\n    return $strD;\n  }\n\n  function fThree($strA, $strB, $strC, $strD, $strE) {\n    try {\n}catch(Exception $e){\nfoo();\n}\nfinally {\n // do something\n}\n    return $strA + $strB + $strC + $strD + $strE;\n  }\n\n  protected abstract function fFour();\n\n}\n}\nfunction f($a, $ab, $abc) {}\nf(\na: 1,\nab:2,\nabc:3\n);\n$j = 0;\n\nfunction f2(array $arr) {}\nf2([0 => 5,\n    1 => 7,]);\n\necho match($j) {\n0    =>'zero',2 => 'two',\n  42=> 'forty-two',\ndefault=>throw new Exception()\n};\nenum Suit: string\n{\n    case Clubs = 'C';\n    case Diamonds = 'D';\n    case Hearts = 'H';\n    case Spades = 'S';\n}\n$func = fn(\nint $x,\nint $y\n): int =>\n$x + $y;\n$value =\n<<<EOD\n  Example of string\n  spanning multiple lines\n  using heredoc syntax.\n  EOD;\n";
    private static final String INDENT_SAMPLE = "<?php\nfunction foo() {\nif($x>5){\necho \"bar\";\n}\nreturn\n\"string\";\n}\n";

    @NotNull
    public Language getLanguage() {
        PhpLanguage phpLanguage = PhpLanguage.INSTANCE;
        if (phpLanguage == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return phpLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return switch (settingsType) {
            case LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS -> SPACING_CODE_SAMPLE;
            case LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS -> BLANK_LINE_CODE_SAMPLE;
            case LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS -> WRAPPING_CODE_SAMPLE;
            case LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS -> INDENT_SAMPLE;
            default -> GENERAL_CODE_SAMPLE;
        };
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_BEFORE_CATCH_PARENTHESES", "SPACE_BEFORE_SWITCH_PARENTHESES", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_BEFORE_CLASS_LBRACE", "SPACE_BEFORE_METHOD_LBRACE", "SPACE_BEFORE_IF_LBRACE", "SPACE_BEFORE_ELSE_LBRACE", "SPACE_BEFORE_WHILE_LBRACE", "SPACE_BEFORE_FOR_LBRACE", "SPACE_BEFORE_DO_LBRACE", "SPACE_BEFORE_SWITCH_LBRACE", "SPACE_BEFORE_TRY_LBRACE", "SPACE_BEFORE_CATCH_LBRACE", "SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", "SPACE_WITHIN_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_IF_PARENTHESES", "SPACE_WITHIN_WHILE_PARENTHESES", "SPACE_WITHIN_FOR_PARENTHESES", "SPACE_WITHIN_CATCH_PARENTHESES", "SPACE_WITHIN_SWITCH_PARENTHESES", "SPACE_BEFORE_QUEST", "SPACE_AFTER_QUEST", "SPACE_BEFORE_COLON", "SPACE_AFTER_COLON", "SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA", "SPACE_AFTER_SEMICOLON", "SPACE_BEFORE_SEMICOLON", "SPACE_AFTER_TYPE_CAST", "SPACE_AROUND_UNARY_OPERATOR", "SPACE_BEFORE_FINALLY_KEYWORD", "SPACE_BEFORE_FINALLY_LBRACE", "SPACE_BEFORE_ELSE_KEYWORD", "SPACE_BEFORE_WHILE_KEYWORD", "SPACE_BEFORE_CATCH_KEYWORD"});
            consumer.renameStandardOption("SPACE_AROUND_RELATIONAL_OPERATORS", PhpBundle.message("code.style.option.relational.operators", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "CONCAT_SPACES", PhpBundle.message("code.style.option.concatenation", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_AROUND_ARROW", PhpBundle.message("code.style.option.object.access.operator", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_AROUND_NULL_COALESCE_OPERATOR", PhpBundle.message("code.style.option.null.coalescing.operator", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_AROUND_ASSIGNMENT_IN_DECLARE", PhpBundle.message("code.style.option.assignment.in.declare.statement", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_COLON_IN_RETURN_TYPE", PhpBundle.message("code.style.option.before.colon.in.return.type", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_AFTER_COLON_IN_RETURN_TYPE", PhpBundle.message("code.style.option.after.colon.in.return.type", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_AROUND_PIPE_IN_UNION_TYPE", PhpBundle.message("code.style.option.space.around.pipe.in.union.types", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_COLON_IN_NAMED_ARGUMENT", PhpBundle.message("code.style.option.before.colon.in.named.argument", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_AFTER_COLON_IN_NAMED_ARGUMENT", PhpBundle.message("code.style.option.after.colon.in.named.argument", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_COLON_IN_ENUM_BACKED_TYPE", PhpBundle.message("code.style.option.before.colon.in.enum.backed.type", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_AFTER_COLON_IN_ENUM_BACKED_TYPE", PhpBundle.message("code.style.option.after.colon.in.enum.backed.type", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_CALL_PARENTHESES", PhpBundle.message("code.style.option.function.call.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_PARENTHESES", PhpBundle.message("code.style.option.function.declaration.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_CALL_PARENTHESES", PhpBundle.message("code.style.option.function.call.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_PARENTHESES", PhpBundle.message("code.style.option.function.declaration.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_LBRACE", PhpBundle.message("code.style.option.function.left.brace", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", PhpBundle.message("code.style.option.array.initializer.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", PhpBundle.message("code.style.option.array.initializer.parentheses", new Object[0]));
            consumer.moveStandardOption("SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_PARENTHESES);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_UNARY_NOT", PhpBundle.message("code.style.option.before.unary.not", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_AFTER_UNARY_NOT", PhpBundle.message("code.style.option.after.unary.not", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.renameStandardOption("SPACE_AROUND_UNARY_OPERATOR", PhpBundle.message("code.style.option.unary.additive.operators", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BETWEEN_TERNARY_QUEST_AND_COLON", PhpBundle.message("code.style.option.between.and", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TERNARY_OPERATOR, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_AROUND_VAR_WITHIN_BRACKETS", PhpBundle.message("code.style.option.brackets.around.variable.expression", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "SPACE_WITHIN_BRACKETS", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_WITHIN_SHORT_ECHO_TAGS", PhpBundle.message("code.style.option.and", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.renameStandardOption("SPACE_AROUND_SHIFT_OPERATORS", PhpBundle.message("code.style.option.shift.operators", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_CLOSURE_LEFT_PARENTHESIS", PhpBundle.message("code.style.option.anonymous.function.parentheses", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_PARENTHESES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "SPACE_BEFORE_METHOD_CALL_PARENTHESES", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_SHORT_CLOSURE_LEFT_PARENTHESIS", PhpBundle.message("code.style.option.arrow.function.parentheses", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.renameStandardOption("SPACE_AROUND_MULTIPLICATIVE_OPERATORS", PhpBundle.message("code.style.option.multiplicative.operators", new Object[0]));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_BEFORE_METHOD_BODY", "BLANK_LINES_AFTER_CLASS_HEADER", "BLANK_LINES_BEFORE_CLASS_END", "KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_BEFORE_PACKAGE", "BLANK_LINES_AFTER_PACKAGE", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AFTER_IMPORTS"});
            consumer.renameStandardOption("BLANK_LINES_AROUND_FIELD", PhpBundle.message("code.style.option.around.property", new Object[0]));
            consumer.renameStandardOption("BLANK_LINES_BEFORE_PACKAGE", PhpBundle.message("code.style.option.before.namespace", new Object[0]));
            consumer.renameStandardOption("BLANK_LINES_AFTER_PACKAGE", PhpBundle.message("code.style.option.after.namespace", new Object[0]));
            consumer.renameStandardOption("BLANK_LINES_BEFORE_IMPORTS", PhpBundle.message("code.style.option.before.use.statements", new Object[0]));
            consumer.renameStandardOption("BLANK_LINES_AFTER_IMPORTS", PhpBundle.message("code.style.option.after.use.statements", new Object[0]));
            consumer.renameStandardOption("BLANK_LINES_AFTER_CLASS_HEADER", PhpBundle.message("code.style.option.before.class.body", new Object[0]));
            consumer.renameStandardOption("BLANK_LINES_BEFORE_CLASS_END", PhpBundle.message("code.style.option.after.class.body", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_AROUND_CONSTANTS", PhpBundle.message("code.style.option.around.class.constants", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_AROUND_ENUM_CASES", PhpBundle.message("code.style.option.around.enum.cases", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_BETWEEN_IMPORTS", PhpBundle.message("code.style.option.between.group.use.statements", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "BLANK_LINES_BEFORE_IMPORTS", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_AFTER_OPENING_TAG", PhpBundle.message("code.style.option.after.opening.tag", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "BLANK_LINES_BEFORE_PACKAGE", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_AFTER_FUNCTION", PhpBundle.message("code.style.option.after.function", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_BEFORE_RETURN_STATEMENT", PhpBundle.message("code.style.option.before.return.statement", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "BLANK_LINES_BEFORE_METHOD_BODY", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "KEEP_BLANK_LINES_AFTER_LBRACE", PhpBundle.message("code.style.option.after", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "KEEP_BLANK_LINES_BEFORE_RBRACE", new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT", "KEEP_CONTROL_STATEMENT_IN_ONE_LINE", "BRACE_STYLE", "CLASS_BRACE_STYLE", "METHOD_BRACE_STYLE", "LAMBDA_BRACE_STYLE", "EXTENDS_LIST_WRAP", "EXTENDS_KEYWORD_WRAP", "CALL_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "IF_BRACE_FORCE", "DOWHILE_BRACE_FORCE", "WHILE_BRACE_FORCE", "FOR_BRACE_FORCE", "ELSE_ON_NEW_LINE", "WHILE_ON_NEW_LINE", "CATCH_ON_NEW_LINE", "FINALLY_ON_NEW_LINE", "INDENT_CASE_FROM_SWITCH", "ALIGN_MULTILINE_PARAMETERS", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "ALIGN_MULTILINE_FOR", "ALIGN_MULTILINE_BINARY_OPERATION", "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", "ALIGN_MULTILINE_EXTENDS_LIST", "METHOD_CALL_CHAIN_WRAP", "ALIGN_MULTILINE_CHAINED_METHODS", "FOR_STATEMENT_WRAP", "FOR_STATEMENT_LPAREN_ON_NEXT_LINE", "FOR_STATEMENT_RPAREN_ON_NEXT_LINE", "BINARY_OPERATION_WRAP", "BINARY_OPERATION_SIGN_ON_NEXT_LINE", "TERNARY_OPERATION_WRAP", "TERNARY_OPERATION_SIGNS_ON_NEXT_LINE", "ARRAY_INITIALIZER_WRAP", "ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", "ASSIGNMENT_WRAP", "PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE", "PARENTHESES_EXPRESSION_LPAREN_WRAP", "PARENTHESES_EXPRESSION_RPAREN_WRAP", "ALIGN_MULTILINE_TERNARY_OPERATION", "MODIFIER_LIST_WRAP", "KEEP_SIMPLE_METHODS_IN_ONE_LINE", "KEEP_SIMPLE_CLASSES_IN_ONE_LINE", "SPECIAL_ELSE_IF_TREATMENT", "ALIGN_GROUP_FIELD_DECLARATIONS", "INDENT_BREAK_FROM_CASE"});
            consumer.renameStandardOption("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", PhpBundle.message("code.style.option.new.line.after", new Object[0]));
            consumer.renameStandardOption("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", PhpBundle.message("code.style.option.place.on.new.line2", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "IF_LPAREN_ON_NEXT_LINE", PhpBundle.message("code.style.option.new.line.after", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_IF_STATEMENT, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "IF_BRACE_FORCE", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "IF_RPAREN_ON_NEXT_LINE", PhpBundle.message("code.style.option.place.on.new.line2", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_IF_STATEMENT, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "IF_BRACE_FORCE", new Object[0]);
            consumer.renameStandardOption("METHOD_BRACE_STYLE", PhpBundle.message("code.style.option.in.function.declaration", new Object[0]));
            consumer.renameStandardOption("LAMBDA_BRACE_STYLE", PhpBundle.message("code.style.option.in.closure.declaration", new Object[0]));
            consumer.renameStandardOption("METHOD_PARAMETERS_WRAP", PhpBundle.message("code.style.option.function.declaration.parameters", new Object[0]));
            consumer.renameStandardOption("CALL_PARAMETERS_WRAP", PhpBundle.message("code.style.option.function.constructor.call.arguments", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ANONYMOUS_BRACE_STYLE", PhpBundle.message("code.style.option.in.anonymous.class.declaration", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "CLASS_BRACE_STYLE", new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().BRACE_PLACEMENT_OPTIONS, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES});
            consumer.showCustomOption(PhpCodeStyleSettings.class, "FORCE_EMPTY_METHODS_IN_ONE_LINE", PhpBundle.message("code.style.option.force.empty.functions.braces.in.one.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "METHOD_BRACE_STYLE", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "FORCE_EMPTY_CLASSES_IN_ONE_LINE", PhpBundle.message("code.style.option.force.empty.classes.braces.in.one.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "CLASS_BRACE_STYLE", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "PLACE_PARENS_FOR_CONSTRUCTOR", PhpBundle.message("code.style.option.place.for.constructor", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_ARGUMENTS_WRAPPING, new Object[]{new String[]{PhpBundle.message("code.style.option.place.braces.for.constructor.as.is", new Object[0]), PhpBundle.message("code.style.option.place.braces.for.constructor.always", new Object[0]), PhpBundle.message("code.style.option.place.braces.for.constructor.never", new Object[0])}, new int[]{0, 1, 2}});
            consumer.renameStandardOption("FOR_STATEMENT_WRAP", PhpBundle.message("code.style.option.for.foreach.statements", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE", PhpBundle.message("code.style.option.keep.and.on.one.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_PARAMETERS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_ASSIGNMENTS", PhpBundle.message("code.style.option.align.consecutive.assignments", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_ASSIGNMENT, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_CLASS_CONSTANTS", PhpBundle.message("code.style.option.align.constants", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_FIELDS_VARIABLES_GROUPS, new Object[0]);
            consumer.renameStandardOption("ALIGN_GROUP_FIELD_DECLARATIONS", PhpBundle.message("code.style.option.align.properties.in.columns", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_ENUM_CASES", PhpBundle.message("code.style.option.align.enum.cases", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_FIELDS_VARIABLES_GROUPS, new Object[0]);
            consumer.renameStandardOption(CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_FIELDS_VARIABLES_GROUPS, PhpBundle.message("code.style.option.class.field.constant.groups", new Object[0]));
            consumer.showCustomOption(PhpCodeStyleSettings.class, "MULTILINE_CHAINED_CALLS_SEMICOLON_ON_NEW_LINE", PhpBundle.message("code.style.option.place.on.new.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_CALL_CHAIN, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "MULTILINE_CHAINED_CALLS_FIRST_CALL_ON_NEW_LINE", PhpBundle.message("code.style.option.place.first.call.on.new.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_CALL_CHAIN, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_KEY_VALUE_PAIRS", PhpBundle.message("code.style.option.align.key.value.pairs", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_ARRAY_INITIALIZER, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "RETURN_TYPE_ON_NEW_LINE", PhpBundle.message("code.style.option.return.type.on.new.line", new Object[0]), PhpBundle.message("code.style.option.function.return.type", new Object[0]), new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_INLINE_COMMENTS", PhpBundle.message("code.style.option.align.inline.comments", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_COMMENTS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "NEW_LINE_AFTER_PHP_OPENING_TAG", PhpBundle.message("code.style.option.new.line.after.php.tag", new Object[0]), PhpBundle.message("code.style.option.php.opening.tag", new Object[0]), new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_NAMED_ARGUMENTS", PhpBundle.message("label.align.named.arguments", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_ARGUMENTS_WRAPPING, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "TREAT_MULTILINE_ARRAYS_AND_LAMBDAS_MULTILINE", PhpBundle.message("code.style.option.multiline.arrays.lambdas", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_ARGUMENTS_WRAPPING, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_MATCH_ARM_BODIES", PhpBundle.message("code.style.option.match.expression.align.match.arm.bodies", new Object[0]), PhpBundle.message("code.style.option.match.expression", new Object[0]), new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "MULTILINE_CLOSURE_LAMBDA_ON_NEW_LINE", PhpBundle.message("code.style.option.place.lambda.on.new.line", new Object[0]), PhpBundle.message("code.style.option.short.closure", new Object[0]), new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "HEREDOC_ON_SAME_LINE", PhpBundle.message("code.style.place.here.now.doc.on.the.same.line", new Object[0]), PhpBundle.message("code.style.option.here.now.doc", new Object[0]), new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "NAMESPACE_BRACE_STYLE", PhpBundle.message("code.style.option.in.namespace", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "CLASS_BRACE_STYLE", new Object[]{new String[]{ApplicationBundle.message((String)"wrapping.brace.placement.end.of.line", (Object[])new Object[0]), ApplicationBundle.message((String)"wrapping.brace.placement.next.line", (Object[])new Object[0])}, new int[]{1, 2}});
            consumer.showCustomOption(PhpCodeStyleSettings.class, "GROUP_USE_WRAP", PhpBundle.message("code.style.option.group.use", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ATTRIBUTES_WRAP", PhpBundle.message("code.style.option.attributes", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON});
            consumer.showCustomOption(PhpCodeStyleSettings.class, "PARAMETERS_ATTRIBUTES_WRAP", PhpBundle.message("code.style.option.parameter.attributes", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN"});
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_ADD_SPACE"});
        }
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        commonSettings.CLASS_BRACE_STYLE = 2;
        commonSettings.METHOD_BRACE_STYLE = 2;
        commonSettings.SPECIAL_ELSE_IF_TREATMENT = false;
        commonSettings.SPACE_AFTER_TYPE_CAST = false;
        commonSettings.BLANK_LINES_BEFORE_PACKAGE = 1;
        commonSettings.BLANK_LINES_AFTER_PACKAGE = 0;
        commonSettings.BLANK_LINES_AROUND_FIELD = 0;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new PhpSmartIndentOptionsEditor();
    }

    public int getRightMargin(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return 40;
        }
        return super.getRightMargin(settingsType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/ui/PhpLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/ui/PhpLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class PSR1PSR2CodeStyle
    extends PhpPredefinedCodeStyleBase {
        @NlsSafe
        private static final String PSR_1_PSR_2 = "PSR1/PSR2";

        public PSR1PSR2CodeStyle(@NotNull @NlsContexts.ListItem String name) {
            if (name == null) {
                PSR1PSR2CodeStyle.$$$reportNull$$$0(0);
            }
            super(name);
        }

        public PSR1PSR2CodeStyle() {
            super(PSR_1_PSR_2);
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            super.apply(settings);
            CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
            commonSettings.DOWHILE_BRACE_FORCE = 3;
            commonSettings.FOR_BRACE_FORCE = 3;
            commonSettings.IF_BRACE_FORCE = 3;
            commonSettings.WHILE_BRACE_FORCE = 3;
            commonSettings.CLASS_BRACE_STYLE = 2;
            commonSettings.METHOD_BRACE_STYLE = 2;
            commonSettings.BRACE_STYLE = 1;
            commonSettings.BLANK_LINES_AFTER_PACKAGE = 1;
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
            indentOptions.INDENT_SIZE = 4;
            indentOptions.USE_TAB_CHARACTER = false;
            commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_TRY_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
            commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_TRY_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
            commonSettings.SPACE_BEFORE_IF_LBRACE = true;
            commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
            commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
            commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
            commonSettings.SPACE_BEFORE_DO_LBRACE = true;
            commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
            commonSettings.ELSE_ON_NEW_LINE = false;
            commonSettings.SPACE_BEFORE_COMMA = false;
            commonSettings.METHOD_PARAMETERS_WRAP = 5;
            commonSettings.ALIGN_MULTILINE_PARAMETERS = false;
            commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
            commonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
            commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
            commonSettings.SPACE_AFTER_TYPE_CAST = false;
            commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
            commonSettings.SPACE_WITHIN_PARENTHESES = false;
            commonSettings.CALL_PARAMETERS_WRAP = 1;
            commonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
            commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
            commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
            commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
            commonSettings.INDENT_CASE_FROM_SWITCH = true;
            commonSettings.WHILE_ON_NEW_LINE = false;
            commonSettings.CATCH_ON_NEW_LINE = false;
            commonSettings.ARRAY_INITIALIZER_WRAP = 5;
            commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
            commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            phpSettings.UPPER_CASE_BOOLEAN_CONST = false;
            phpSettings.UPPER_CASE_NULL_CONST = false;
            phpSettings.LOWER_CASE_BOOLEAN_CONST = true;
            phpSettings.LOWER_CASE_NULL_CONST = true;
            phpSettings.KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE = true;
            phpSettings.SPACE_BEFORE_CLOSURE_LEFT_PARENTHESIS = true;
            phpSettings.SPACE_BEFORE_SHORT_CLOSURE_LEFT_PARENTHESIS = false;
            phpSettings.ELSE_IF_STYLE = PhpCodeStyleSettings.ElseIfStyle.COMBINE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/lang/formatter/ui/PhpLanguageCodeStyleSettingsProvider$PSR1PSR2CodeStyle", "<init>"));
        }
    }
}

