/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui.predefinedStyle;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.ui.PhpLanguageCodeStyleSettingsProvider;
import com.jetbrains.php.lang.inspections.psr12.PhpCompoundNamespaceDepthInspection;
import com.jetbrains.php.lang.inspections.psr12.PhpLongTypeFormInspection;
import com.jetbrains.php.lang.inspections.psr12.PhpMissingVisibilityInspection;
import com.jetbrains.php.lang.inspections.psr12.PhpModifierOrderInspection;
import com.jetbrains.php.lang.inspections.psr12.PhpNewClassMissingParameterListInspection;
import com.jetbrains.php.lang.inspections.psr12.PhpSeparateElseIfInspection;
import com.jetbrains.php.lang.inspections.psr12.PhpTraitsUseListInspection;
import com.jetbrains.php.lang.inspections.psr12.PhpVarUsageInspection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PSR12CodeStyle
extends PhpLanguageCodeStyleSettingsProvider.PSR1PSR2CodeStyle {
    private static final List<String> PSR12_INSPECTION_NAMES = new SmartList((Object[])new String[]{new PhpCompoundNamespaceDepthInspection().getShortName(), new PhpLongTypeFormInspection().getShortName(), new PhpMissingVisibilityInspection().getShortName(), new PhpModifierOrderInspection().getShortName(), new PhpNewClassMissingParameterListInspection().getShortName(), new PhpSeparateElseIfInspection().getShortName(), new PhpVarUsageInspection().getShortName(), new PhpTraitsUseListInspection().getShortName()});
    public static final String PHP_CODE_STYLE = "PHP Code Style";
    public static final String[] PSR12_GROUP_PATH = new String[]{"PHP", "Code Style", "PSR-12"};
    @NlsSafe
    private static final String PSR_12 = "PSR12";

    public PSR12CodeStyle() {
        super(PSR_12);
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)PhpLanguage.INSTANCE);
        commonSettings.BLANK_LINES_AFTER_PACKAGE = 1;
        commonSettings.ALIGN_MULTILINE_EXTENDS_LIST = true;
        commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
        commonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
        commonSettings.METHOD_PARAMETERS_WRAP = 5;
        commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
        commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
        commonSettings.CALL_PARAMETERS_WRAP = 5;
        commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
        commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
        commonSettings.IF_BRACE_FORCE = 3;
        commonSettings.DOWHILE_BRACE_FORCE = 3;
        commonSettings.WHILE_BRACE_FORCE = 3;
        commonSettings.FOR_BRACE_FORCE = 3;
        commonSettings.EXTENDS_LIST_WRAP = 5;
        commonSettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE = true;
        commonSettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE = true;
        commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = 0;
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpSettings.TREAT_MULTILINE_ARRAYS_AND_LAMBDAS_MULTILINE = false;
        phpSettings.BLANK_LINES_AFTER_OPENING_TAG = 1;
        phpSettings.KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE = true;
        phpSettings.BLANK_LINES_BETWEEN_IMPORTS = 1;
        phpSettings.KEEP_BLANK_LINES_AFTER_LBRACE = 0;
        phpSettings.LOWER_CASE_NULL_CONST = true;
        phpSettings.LOWER_CASE_BOOLEAN_CONST = true;
        phpSettings.UPPER_CASE_NULL_CONST = false;
        phpSettings.UPPER_CASE_BOOLEAN_CONST = false;
        phpSettings.ELSE_IF_STYLE = PhpCodeStyleSettings.ElseIfStyle.COMBINE;
        phpSettings.NEW_LINE_AFTER_PHP_OPENING_TAG = true;
    }

    public static void notifyAboutPSR12Inspections() {
        final Notification notification = new Notification(PHP_CODE_STYLE, PhpBundle.message("php.prefdefined.codestyle.psr12.chosen.title", new Object[0]), PhpBundle.message("php.prefdefined.codestyle.psr12.chosen.message", new Object[0]), NotificationType.INFORMATION);
        notification.setSuggestionType(true);
        notification.addAction(new AnAction(PhpBundle.message("enable", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null) {
                    InspectionProfileManager.getInstance((Project)project).getCurrentProfile().modifyProfile(it -> PSR12_INSPECTION_NAMES.forEach(tool -> it.setToolEnabled(tool, true)));
                    notification.expire();
                    Notifications.Bus.notify((Notification)new Notification(PSR12CodeStyle.PHP_CODE_STYLE, PhpBundle.message("php.prefdefined.codestyle.psr12.chosen.title", new Object[0]), PhpBundle.message("php.prefdefined.codestyle.psr12.enabled.message", new Object[0]), NotificationType.INFORMATION));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/lang/formatter/ui/predefinedStyle/PSR12CodeStyle$1", "actionPerformed"));
            }
        });
        notification.addAction(new AnAction(PhpBundle.message("show.settings", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null) {
                    EditInspectionToolsSettingsAction.editSettings((Project)project, (InspectionProfileImpl)InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile(), c -> c.selectInspectionGroup(PSR12_GROUP_PATH));
                }
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/lang/formatter/ui/predefinedStyle/PSR12CodeStyle$2", "actionPerformed"));
            }
        });
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            InspectionProfileImpl profile;
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project != null && ContainerUtil.all(PSR12_INSPECTION_NAMES, arg_0 -> PSR12CodeStyle.lambda$notifyAboutPSR12Inspections$0(profile = InspectionProfileManager.getInstance((Project)project).getCurrentProfile(), arg_0))) {
                Notifications.Bus.notify((Notification)notification, (Project)project);
            }
        });
    }

    private static /* synthetic */ boolean lambda$notifyAboutPSR12Inspections$0(InspectionProfileImpl profile, String tool) {
        return !profile.isToolEnabled(HighlightDisplayKey.find((String)tool));
    }
}

