/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.highlighter;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.OuterLanguageElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpEditorOptions;
import com.jetbrains.php.lang.highlighter.TemplateLanguageHighlightingExtension;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpTemplateHighlighterFactory
implements DirtyScopeTrackingHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar,
DumbAware {
    private int myPassId;

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        TextAttributesKey backgroundColor;
        TextRange textRange;
        if (file == null) {
            PhpTemplateHighlighterFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpTemplateHighlighterFactory.$$$reportNull$$$0(1);
        }
        if (file.getLanguage() instanceof TemplateLanguage && (textRange = FileStatusMap.getDirtyTextRange((Document)editor.getDocument(), (PsiFile)file, (int)this.getPassId())) != null && (backgroundColor = TemplateLanguageHighlightingExtension.getBackgroundColor((PsiElement)file)) != null) {
            TextAttributes attributes = editor.getColorsScheme().getAttributes(backgroundColor);
            TextAttributes onlyBackground = new TextAttributes();
            onlyBackground.setBackgroundColor(attributes.getBackgroundColor());
            return new PhpTemplateHighlightingPass(file.getProject(), file, editor.getDocument(), onlyBackground);
        }
        return null;
    }

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            PhpTemplateHighlighterFactory.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpTemplateHighlighterFactory.$$$reportNull$$$0(3);
        }
        this.myPassId = registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.FIRST, -1, false, false);
    }

    public int getPassId() {
        return this.myPassId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/highlighter/PhpTemplateHighlighterFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PhpTemplateHighlightingPass
    extends TextEditorHighlightingPass
    implements DumbAware {
        private final List<HighlightInfo> myInfos = new ArrayList<HighlightInfo>();
        private final PsiFile myFile;
        private final TextAttributes myBackgroundColor;

        PhpTemplateHighlightingPass(Project project, PsiFile file, Document document, TextAttributes backgroundColor) {
            super(project, document, false);
            this.myFile = file;
            this.myBackgroundColor = backgroundColor;
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            List allFiles;
            HtmlFileImpl html;
            if (progress == null) {
                PhpTemplateHighlightingPass.$$$reportNull$$$0(0);
            }
            if ((html = (HtmlFileImpl)ContainerUtil.findInstance((Iterable)(allFiles = this.myFile.getViewProvider().getAllFiles()), HtmlFileImpl.class)) == null || html.getFirstChild() == null || html.getFirstChild().getChildren().length == 1 && !PhpEditorOptions.getInstance().ALWAYS_ENABLE_PHP_BACKGROUND_HIGHLIGHTING) {
                BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.myFile, (Document)this.myDocument, (int)0, (int)this.myDocument.getTextLength(), this.myInfos, (int)this.getId());
                return;
            }
            html.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element.getNode().getElementType() instanceof OuterLanguageElementType) {
                        TextRange range = element.getTextRange();
                        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INJECTED_LANGUAGE_BACKGROUND).range(range);
                        builder2.textAttributes(myBackgroundColor);
                        myInfos.add(builder2.createUnconditionally());
                    } else {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/highlighter/PhpTemplateHighlighterFactory$PhpTemplateHighlightingPass$1", "visitElement"));
                }
            });
            BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.myFile, (Document)this.myDocument, (int)0, (int)this.myDocument.getTextLength(), this.myInfos, (int)this.getId());
        }

        public void doApplyInformationToEditor() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/jetbrains/php/lang/highlighter/PhpTemplateHighlighterFactory$PhpTemplateHighlightingPass", "doCollectInformation"));
        }
    }
}

