/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpClassConstantAccessedViaChildClassInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpAccessStaticViaInstanceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAccessStaticViaInstanceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference methodReference) {
                if (methodReference.isStatic()) {
                    this.doCheck(methodReference, (PhpClassMember)ObjectUtils.tryCast((Object)methodReference.resolve(), Method.class));
                }
            }

            @Override
            public void visitPhpFieldReference(FieldReference fieldReference) {
                if (fieldReference.isStatic()) {
                    this.doCheck(fieldReference, (PhpClassMember)ObjectUtils.tryCast((Object)fieldReference.resolve(), Field.class));
                }
            }

            private void doCheck(@NotNull MemberReference memberReference, PhpClassMember classMember) {
                if (memberReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (classMember != null && classMember.getModifier().isStatic()) {
                    PhpExpression phpExpression = PhpAccessStaticViaInstanceInspection.getAccessedInstance(memberReference);
                    PhpClass containingClass = classMember.getContainingClass();
                    if (!(phpExpression == null || containingClass == null || memberReference.getClassReference() == null || 1.isClassMemberAbstract(classMember) || PhpSideEffectDetector.canContainSideEffect((PsiElement)phpExpression) || 1.isClassAmbiguous(classMember))) {
                        holder.registerProblem((PsiElement)memberReference, PhpBundle.message("inspection.static.member.accessed.via.instance.reference", memberReference.getText()), new LocalQuickFix[]{new PhpAccessStaticMethodViaClassQuickFix(containingClass.getFQN(), memberReference.getText().replace(memberReference.getClassReference().getText(), containingClass.getName()))});
                    }
                }
            }

            private static boolean isClassMemberAbstract(PhpClassMember classMember) {
                Method method = (Method)ObjectUtils.tryCast((Object)classMember, Method.class);
                return method != null && method.isAbstract();
            }

            private static boolean isClassAmbiguous(PhpClassMember classMember) {
                PhpClass containingClass = classMember.getContainingClass();
                return containingClass != null && PhpClassHierarchyUtils.subclassExists(containingClass) || classMember.getGlobalType().getTypes().size() > 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberReference", "com/jetbrains/php/lang/inspections/PhpAccessStaticViaInstanceInspection$1", "doCheck"));
            }
        };
    }

    private static PhpExpression getAccessedInstance(MemberReference memberReference) {
        PhpExpression classRef = (PhpExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize((PsiElement)memberReference.getClassReference()), PhpExpression.class);
        return classRef instanceof ClassReference ? null : classRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpAccessStaticViaInstanceInspection", "buildVisitor"));
    }

    private static class PhpAccessStaticMethodViaClassQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myClassFQN;
        private final String myMemberRefReplaceText;

        private PhpAccessStaticMethodViaClassQuickFix(@NotNull @NlsSafe String classFQN, String memberRefReplaceText) {
            if (classFQN == null) {
                PhpAccessStaticMethodViaClassQuickFix.$$$reportNull$$$0(0);
            }
            this.myClassFQN = classFQN;
            this.myMemberRefReplaceText = memberRefReplaceText;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.access.static.via.class.reference", this.myMemberRefReplaceText);
            if (string == null) {
                PhpAccessStaticMethodViaClassQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpExpression classReference;
            if (project == null) {
                PhpAccessStaticMethodViaClassQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpAccessStaticMethodViaClassQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAccessStaticMethodViaClassQuickFix.$$$reportNull$$$0(4);
            }
            if ((classReference = ((MemberReference)element).getClassReference()) != null) {
                PhpClassConstantAccessedViaChildClassInspection.replaceWithClassReference(classReference, this.myClassFQN);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFQN";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpAccessStaticViaInstanceInspection$PhpAccessStaticMethodViaClassQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpAccessStaticViaInstanceInspection$PhpAccessStaticMethodViaClassQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

