/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddAttributeQuickFixBase;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H$J\b\u0010\u0016\u001a\u00020\u0014H$J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a8\u0006!"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpAnnotationToAttributeInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "getHighlightedRange", "Lcom/intellij/openapi/util/TextRange;", "tag", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/tags/PhpDocTag;", "checkToolVersion", "project", "Lcom/intellij/openapi/project/Project;", "getAttributeFqn", "", "attributeName", "getFrameworkName", "getAlias", "createAttributeText", "replaceWithClassString", "attributesList", "Lcom/jetbrains/php/lang/psi/elements/PhpAttributesList;", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "PhpReplaceAnnotationWithAttributeQuickFix", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpAnnotationToAttributeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpAnnotationToAttributeInspection.kt\ncom/jetbrains/php/lang/inspections/PhpAnnotationToAttributeInspection\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,166:1\n1179#2,2:167\n*S KotlinDebug\n*F\n+ 1 PhpAnnotationToAttributeInspection.kt\ncom/jetbrains/php/lang/inspections/PhpAnnotationToAttributeInspection\n*L\n95#1:167,2\n*E\n"})
public abstract class PhpAnnotationToAttributeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpAnnotationToAttributeInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitPhpDocTag(PhpDocTag tag) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!this.this$0.checkToolVersion(project)) {
                    return;
                }
                String string = tag.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (((CharSequence)string).length() == 0) {
                    return;
                }
                String string2 = tag.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                Object object2 = new char[]{'@'};
                object2 = StringsKt.substringAfterLast$default((String)StringsKt.trimStart((String)string2, (char[])object2), (String)"\\", null, (int)2, null);
                if (((CharSequence)object2).length() > 0) {
                    void it22;
                    char c = object2.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 0;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)it22, (Locale)locale));
                    char[] it22 = object2;
                    n = 1;
                    String string3 = it22.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    object = stringBuilder2.append(string3).toString();
                } else {
                    object = object2;
                }
                String string4 = tag.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                object2 = new char[1];
                object2[0] = 64;
                Pair pair = TuplesKt.to((Object)object, (Object)StringsKt.substringBeforeLast((String)StringsKt.trimStart((String)string4, (char[])object2), (String)"\\", (String)""));
                String attributeName = (String)pair.component1();
                String namespace = (String)pair.component2();
                String fqn = this.this$0.getAttributeFqn(attributeName);
                if (!(((CharSequence)namespace).length() == 0 || StringsKt.contains$default((CharSequence)fqn, (CharSequence)namespace, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this.this$0.getAlias(attributeName), (Object)namespace))) {
                    return;
                }
                String attributeText = this.this$0.createAttributeText(tag, attributeName);
                if (attributeText == null) {
                    return;
                }
                PhpAttributesList attributeList = null;
                try {
                    attributeList = PhpPsiElementFactory.createAttributesList(this.$holder.getProject(), fqn + attributeText);
                }
                catch (AssertionError assertionError) {
                    return;
                }
                PsiElement psiElement = (PsiElement)tag;
                Object[] objectArray = new Object[]{this.this$0.getFrameworkName()};
                String string5 = PhpBundle.message("inspection.php.annotation.can.be.replaced.with.attribute", objectArray);
                Project project2 = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                VirtualFile virtualFile = this.$holder.getFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                ProblemHighlightType problemHighlightType = this.this$0.getProblemHighlightType(project2, virtualFile);
                TextRange textRange = this.this$0.getHighlightedRange(tag);
                objectArray = new LocalQuickFix[1];
                Object object3 = this.this$0.replaceWithClassString(attributeList);
                if (object3 == null) {
                    object3 = fqn + attributeText;
                }
                objectArray[0] = new PhpReplaceAnnotationWithAttributeQuickFix((String)object3);
                this.$holder.registerProblem(psiElement, string5, problemHighlightType, textRange, (LocalQuickFix[])objectArray);
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    @Nullable
    public TextRange getHighlightedRange(@NotNull PhpDocTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return null;
    }

    protected abstract boolean checkToolVersion(@NotNull Project var1);

    @NotNull
    protected abstract String getAttributeFqn(@NotNull String var1);

    @NotNull
    protected abstract String getFrameworkName();

    @NotNull
    public String getAlias(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return "";
    }

    @Nullable
    public String createAttributeText(@NotNull PhpDocTag tag, @NotNull String attributeName) {
        String string;
        String tagValue;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        if (PhpPsiUtil.getParentByCondition((PsiElement)tag, PhpDocTag.INSTANCEOF, PhpDocComment.INSTANCEOF) != null) {
            return null;
        }
        PsiElement psiElement = tag.getFirstChild().getNextSibling();
        String string2 = tagValue = psiElement != null ? psiElement.getText() : null;
        if (tagValue == null) {
            return null;
        }
        CharSequence charSequence = tagValue;
        Object object = new Regex("=(.*)::class");
        String string3 = "=\"$1\"";
        tagValue = object.replace(charSequence, string3);
        Regex arrayHashElement = new Regex("(\\{[^@}]*?)=([^>]*?})");
        do {
            String string4 = tagValue;
            Intrinsics.checkNotNull((Object)string4);
            object = string4;
            string3 = "$1=>$2";
            string = tagValue = arrayHashElement.replace((CharSequence)object, string3);
            Intrinsics.checkNotNull((Object)string);
        } while (!Intrinsics.areEqual((Object)tagValue, (Object)arrayHashElement.replace((CharSequence)(object = (CharSequence)string), string3 = "$1=>$2")));
        object = StringsKt.replace$default((String)StringsKt.replace$default((String)tagValue, (String)":", (String)"=>", (boolean)false, (int)4, null), (String)"@", (String)"new ", (boolean)false, (int)4, null);
        string3 = new Regex("[\\s\n]*\\*[\\s\n]*");
        String string5 = " ";
        object = string3.replace((CharSequence)object, string5);
        string3 = new Regex("=([^>])");
        string5 = ":$1";
        tagValue = string3.replace((CharSequence)object, string5);
        int doubleQuote = 0;
        int singleQuote = 0;
        StringBuilder newTagValue = new StringBuilder();
        CharSequence $this$forEach$iv = tagValue;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            int toAppend = c;
            if (doubleQuote % 2 == 0 && singleQuote % 2 == 0) {
                if (c == '{') {
                    toAppend = 91;
                }
                if (c == '}') {
                    toAppend = 93;
                }
            }
            if (c == '\"') {
                ++doubleQuote;
            }
            if (c == '\'') {
                ++singleQuote;
            }
            newTagValue.append((char)toAppend);
        }
        return attributeName + newTagValue;
    }

    @Nullable
    protected String replaceWithClassString(@Nullable PhpAttributesList attributesList) {
        return null;
    }

    @NotNull
    public ProblemHighlightType getProblemHighlightType(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ProblemHighlightType.WEAK_WARNING;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpAnnotationToAttributeInspection$PhpReplaceAnnotationWithAttributeQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "attributeText", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getDocOwner", "comment", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/PhpDocComment;", "isEmptyDocComment", "", "tag", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/tags/PhpDocTag;", "intellij.php.impl"})
    public static final class PhpReplaceAnnotationWithAttributeQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String attributeText;

        public PhpReplaceAnnotationWithAttributeQuickFix(@NotNull String attributeText) {
            Intrinsics.checkNotNullParameter((Object)attributeText, (String)"attributeText");
            this.attributeText = attributeText;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.replace.annotation.with.attribute", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpDocTag tag;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            PhpDocTag phpDocTag = tag = element instanceof PhpDocTag ? (PhpDocTag)element : null;
            if (tag == null) {
                return;
            }
            PhpDocComment comment = (PhpDocComment)PhpPsiUtil.getParentByCondition((PsiElement)tag, PhpDocComment.INSTANCEOF, PhpFile.INSTANCEOF);
            if (comment == null) {
                return;
            }
            PsiElement docOwner = this.getDocOwner(comment);
            if (docOwner == null) {
                return;
            }
            if (this.isEmptyDocComment(tag)) {
                comment.delete();
            } else {
                while (!PhpPsiUtil.isOfType(tag.getPrevSibling(), PhpDocTokenTypes.DOC_LEADING_ASTERISK)) {
                    tag.getPrevSibling().delete();
                }
                tag.getPrevSibling().delete();
                if (Intrinsics.areEqual((Object)tag.getName(), (Object)"@testWith")) {
                    while (!(tag.getNextSibling() instanceof PhpDocTag) && !PhpPsiUtil.isOfType(tag.getNextSibling(), PhpDocTokenTypes.DOC_COMMENT_END)) {
                        PsiElement psiElement = tag.getNextSibling();
                        if (psiElement != null) {
                            psiElement.delete();
                        }
                    }
                }
                tag.delete();
            }
            if (!(docOwner instanceof PhpAttributesOwner)) {
                return;
            }
            PhpAddAttributeQuickFixBase.addAttribute((PhpAttributesOwner)docOwner, this.attributeText);
        }

        private final PsiElement getDocOwner(PhpDocComment comment) {
            PsiElement docOwner = comment.getOwner();
            if (docOwner == null) {
                return null;
            }
            if (docOwner instanceof Field || docOwner instanceof PhpEnumCase || docOwner instanceof Constant) {
                return ((PhpNamedElement)docOwner).getParent();
            }
            return docOwner;
        }

        private final boolean isEmptyDocComment(PhpDocTag tag) {
            Object next = PhpPsiUtil.getNextSiblingByCondition((PsiElement)tag, (Condition<? super PsiElement>)((Condition)arg_0 -> PhpReplaceAnnotationWithAttributeQuickFix.isEmptyDocComment$lambda$0(tag, arg_0)));
            Object prev = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpReplaceAnnotationWithAttributeQuickFix::isEmptyDocComment$lambda$1));
            return PhpPsiUtil.isOfType(prev, PhpDocTokenTypes.DOC_COMMENT_START) && PhpPsiUtil.isOfType(next, PhpDocTokenTypes.DOC_COMMENT_END);
        }

        private static final boolean isEmptyDocComment$lambda$0(PhpDocTag $tag, PsiElement e) {
            return Intrinsics.areEqual((Object)$tag.getName(), (Object)"@testWith") ? e instanceof PhpDocTag || PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_COMMENT_END) : !PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_LEADING_ASTERISK) && !(e instanceof PsiWhiteSpace);
        }

        private static final boolean isEmptyDocComment$lambda$1(PsiElement e) {
            return !PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_LEADING_ASTERISK) && !(e instanceof PsiWhiteSpace);
        }
    }
}

