/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRedundantReadonlyModifierInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassCanBeReadonlyInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClassCanBeReadonlyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpClass(PhpClass clazz) {
                ASTNode nameNode;
                ASTNode aSTNode = nameNode = clazz.isAnonymous() ? clazz.getNode().findChildByType(PhpTokenTypes.kwCLASS) : clazz.getNameNode();
                if (nameNode == null || clazz.isReadonly() || clazz.isTrait() || clazz.isAnonymous() && !PhpLanguageFeature.ANONYMOUS_READONLY_CLASSES.isSupported(clazz.getProject()) || clazz.isInterface()) {
                    return;
                }
                if (clazz.hasTraitUses()) {
                    return;
                }
                if (ContainerUtil.exists(clazz.getSuperClasses(), (Condition)Conditions.not(PhpClass::isReadonly))) {
                    return;
                }
                if (ContainerUtil.exists(PhpClassHierarchyUtils.getDirectSubclasses(clazz), (Condition)Conditions.not(PhpClass::isReadonly))) {
                    return;
                }
                Object[] fields = clazz.getOwnFields(false);
                if (fields.length == 0 || ContainerUtil.exists((Object[])fields, (Condition)Conditions.not(Field::isReadonly))) {
                    return;
                }
                holder.problem(nameNode.getPsi(), PhpBundle.message("inspection.message.class.can.be.readonly", new Object[0])).fix((ModCommandAction)new PhpMakeClassReadonlyQuickFix(clazz)).register();
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP820;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpClassCanBeReadonlyInspection", "buildVisitor"));
    }

    public static class PhpMakeClassReadonlyQuickFix
    extends PsiUpdateModCommandAction<PhpClass> {
        public PhpMakeClassReadonlyQuickFix(@NotNull PhpClass clazz) {
            if (clazz == null) {
                PhpMakeClassReadonlyQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)clazz);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.make.class.readonly", new Object[0]);
            if (string == null) {
                PhpMakeClassReadonlyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpClass clazz, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpMakeClassReadonlyQuickFix.$$$reportNull$$$0(2);
            }
            if (clazz == null) {
                PhpMakeClassReadonlyQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpMakeClassReadonlyQuickFix.$$$reportNull$$$0(4);
            }
            Project project = context.project();
            for (Field field : clazz.getOwnFields()) {
                if (!field.isReadonly()) continue;
                PsiElement readonlyKeyword = PhpHierarchyChecksInspection.getReadonlyKeyword(field);
                assert (readonlyKeyword != null);
                PsiElement visibilityModifier = PhpPsiUtil.getChildOfType(readonlyKeyword.getParent(), PhpTokenTypes.tsVISIBILITY_MODIFIERS);
                PhpRedundantReadonlyModifierInspection.deleteRedundantReadonlyModifier(project, readonlyKeyword, visibilityModifier == null);
            }
            PhpClass newClass = PhpPsiElementFactory.createFromText(project, PhpClass.class, "readonly class A {}");
            PsiElement readonlyKeyword = FieldImpl.getReadonlyKeyword((PsiElement)newClass);
            ASTNode anchorNode = clazz.getNode().findChildByType(PhpTokenTypes.kwCLASS);
            assert (readonlyKeyword != null && anchorNode != null);
            clazz.addRangeBefore(readonlyKeyword, readonlyKeyword.getNextSibling(), anchorNode.getPsi());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpClassCanBeReadonlyInspection$PhpMakeClassReadonlyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpClassCanBeReadonlyInspection$PhpMakeClassReadonlyQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

