/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.optionsPanels.PhpSeverityChoosersKt;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpDeprecatedAssertDeclarationInspection
extends PhpInspection {
    public String PHP73_DEPRECATION_SEVERITY = ProblemHighlightType.WARNING.name();
    public String PHP80_DEPRECATION_SEVERITY = ProblemHighlightType.ERROR.name();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedAssertDeclarationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunction(Function function) {
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null || !"assert".equalsIgnoreCase(function.getName())) {
                    return;
                }
                if (PhpLangUtil.isGlobalNamespaceFQN(function.getNamespaceName())) {
                    holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.message.defining.custom.assert.function.forbidden", new Object[0]), new LocalQuickFix[0]);
                } else {
                    PhpLanguageLevel languageLevel = PhpLanguageLevel.current((Project)function.getProject());
                    if (languageLevel.isAtLeast(PhpLanguageLevel.PHP800)) {
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.message.defining.custom.assert.function.forbidden", new Object[0]), PhpSeverityChoosersKt.getProblemHighlightType(PhpDeprecatedAssertDeclarationInspection.this.PHP80_DEPRECATION_SEVERITY), new LocalQuickFix[0]);
                    } else if (languageLevel.isAtLeast(PhpLanguageLevel.PHP730)) {
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.message.defining.custom.assert.function.deprecated", new Object[0]), PhpSeverityChoosersKt.getProblemHighlightType(PhpDeprecatedAssertDeclarationInspection.this.PHP73_DEPRECATION_SEVERITY), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{PhpSeverityChoosersKt.phpSeverityDropDown("PHP73_DEPRECATION_SEVERITY", PhpBundle.message("inspection.option.label.php73.severity", new Object[0])), PhpSeverityChoosersKt.phpSeverityDropDown("PHP80_DEPRECATION_SEVERITY", PhpBundle.message("inspection.option.label.php8.severity", new Object[0]))});
        if (optPane == null) {
            PhpDeprecatedAssertDeclarationInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedAssertDeclarationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedAssertDeclarationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

