/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeprecatedDollarBraceStringInterpolationInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedDollarBraceStringInterpolationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                if (expression.isSingleQuote()) {
                    return;
                }
                for (Variable variable : PhpPsiUtil.getChildren((PsiElement)expression, (Condition<? super PsiElement>)((Condition)Variable.class::isInstance))) {
                    String name;
                    if (!PhpPsiUtil.isOfType(variable.getFirstChild(), PhpTokenTypes.DOLLAR_LBRACE)) continue;
                    if (PhpDeprecatedDollarBraceStringInterpolationInspection.isSimpleVarNameExpression(variable)) {
                        name = PhpDeprecatedDollarBraceStringInterpolationInspection.getReplaceTextForSimpleVarName(variable);
                        holder.registerProblem((PsiElement)variable, PhpBundle.message("inspection.message.using.in.strings.deprecated.use.instead", variable.getText(), name), new LocalQuickFix[]{new PhpReplaceWithInterpolatedVariableQuickFix(name)});
                        continue;
                    }
                    name = PhpDeprecatedDollarBraceStringInterpolationInspection.getReplaceTextForExpressionVarName(variable);
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("inspection.message.using.variable.variables.in.strings.deprecated.use.instead", variable.getText(), name), new LocalQuickFix[]{new PhpReplaceWithInterpolatedVariableQuickFix(name)});
                }
            }
        };
    }

    private static boolean isSimpleVarNameExpression(Variable variable) {
        PsiElement child = PhpPsiUtil.getNextSiblingIgnoreWhitespace(variable.getFirstChild(), true);
        return child == null || PhpDeprecatedDollarBraceStringInterpolationInspection.isSimpleVarName(child) || child instanceof ArrayAccessExpression && PhpDeprecatedDollarBraceStringInterpolationInspection.isSimpleVarName((PsiElement)((ArrayAccessExpression)child).getValue());
    }

    private static boolean isSimpleVarName(PsiElement child) {
        return PhpPsiUtil.isOfType(child, new IElementType[]{PhpStubElementTypes.VARIABLE, PhpTokenTypes.VARIABLE}) && !child.getText().startsWith("$");
    }

    private static String getReplaceTextForExpressionVarName(Variable variable) {
        return "{" + variable.getText() + "}";
    }

    private static String getReplaceTextForSimpleVarName(Variable variable) {
        return "{$" + variable.getText().substring(2);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP820;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDeprecatedDollarBraceStringInterpolationInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithInterpolatedVariableQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myText;

        private PhpReplaceWithInterpolatedVariableQuickFix(String text) {
            this.myText = text;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.interpolation", new Object[0]);
            if (string == null) {
                PhpReplaceWithInterpolatedVariableQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myText);
            if (string == null) {
                PhpReplaceWithInterpolatedVariableQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithInterpolatedVariableQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceWithInterpolatedVariableQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithInterpolatedVariableQuickFix.$$$reportNull$$$0(4);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, Variable.class, "\"" + this.myText + "\""));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedDollarBraceStringInterpolationInspection$PhpReplaceWithInterpolatedVariableQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedDollarBraceStringInterpolationInspection$PhpReplaceWithInterpolatedVariableQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

