/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeprecatedImplodeUsageInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedImplodeUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                PsiElement[] parameters = reference.getParameters();
                if (parameters.length < 2) {
                    return;
                }
                String functionFqn = PhpDeprecatedImplodeUsageInspection.getFunctionFqn(reference);
                if (functionFqn == null) {
                    return;
                }
                if (("\\implode".equalsIgnoreCase(functionFqn) || "\\join".equalsIgnoreCase(functionFqn)) && PhpDeprecatedImplodeUsageInspection.isObsoleteParametersOrder(parameters)) {
                    holder.problem((PsiElement)reference, PhpBundle.message("inspection.deprecated.implode.usage", PhpLangUtil.toShortName(functionFqn))).highlight(ProblemHighlightType.LIKE_DEPRECATED).fix((ModCommandAction)new PhpFlipArgumentsQuickFix(reference)).register();
                }
            }
        };
    }

    private static boolean isObsoleteParametersOrder(PsiElement[] parameters) {
        ArrayList<PsiElement> resolvedArguments = new ArrayList<PsiElement>(Arrays.asList(null, null));
        for (PsiElement parameter : parameters) {
            int index = PhpWorkaroundUtil.resolveMappedParameterIndex(parameter);
            if (index < 0 || index >= resolvedArguments.size()) continue;
            resolvedArguments.set(index, parameter);
        }
        return PhpType.isArray(PhpDeprecatedImplodeUsageInspection.getParameterType((PsiElement)resolvedArguments.get(0))) && PhpType.STRING.equals(PhpDeprecatedImplodeUsageInspection.getParameterType((PsiElement)resolvedArguments.get(1)));
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static PhpType getParameterType(@Nullable PsiElement parameter) {
        if (parameter == null) {
            return PhpType.EMPTY;
        }
        return new PhpType().add(parameter).global(parameter.getProject()).filterUnknown();
    }

    private static String getFunctionFqn(FunctionReference reference) {
        Set fqns = (Set)StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).map(PhpNamedElement::getFQN).collect(Collectors.toSet());
        return (String)ContainerUtil.getOnlyItem((Collection)fqns);
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.ERROR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDeprecatedImplodeUsageInspection", "buildVisitor"));
    }

    private static final class PhpFlipArgumentsQuickFix
    extends PsiUpdateModCommandAction<FunctionReference> {
        private PhpFlipArgumentsQuickFix(FunctionReference functionReference) {
            super((PsiElement)functionReference);
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull FunctionReference ref) {
            Pair<PsiElement, PsiElement> argumentsToFlip;
            if (context == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(0);
            }
            if (ref == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(1);
            }
            if ((argumentsToFlip = PhpFlipArgumentsQuickFix.getArgumentsToFlip(ref)) == null) {
                Presentation presentation = Presentation.of((String)this.getFamilyName());
                if (presentation == null) {
                    PhpFlipArgumentsQuickFix.$$$reportNull$$$0(2);
                }
                return presentation;
            }
            Presentation presentation = Presentation.of((String)PhpBundle.message("intention.name.flip", ((PsiElement)argumentsToFlip.first).getText(), ((PsiElement)argumentsToFlip.second).getText()));
            if (presentation == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(3);
            }
            return presentation;
        }

        @Nullable
        private static Pair<PsiElement, PsiElement> getArgumentsToFlip(@NotNull FunctionReference ref) {
            PsiElement[] parameters;
            if (ref == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(4);
            }
            if ((parameters = ref.getParameters()).length < 2) {
                return null;
            }
            return Pair.create((Object)parameters[0], (Object)parameters[1]);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull FunctionReference ref, @NotNull ModPsiUpdater updater) {
            Pair<PsiElement, PsiElement> argumentsToFlip;
            if (context == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(5);
            }
            if (ref == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(7);
            }
            if ((argumentsToFlip = PhpFlipArgumentsQuickFix.getArgumentsToFlip(ref)) == null) {
                return;
            }
            PsiElement tmp = ((PsiElement)argumentsToFlip.first).copy();
            ((PsiElement)argumentsToFlip.first).replace((PsiElement)argumentsToFlip.second);
            ((PsiElement)argumentsToFlip.second).replace(tmp);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.flip.arguments.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: 
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedImplodeUsageInspection$PhpFlipArgumentsQuickFix";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedImplodeUsageInspection$PhpFlipArgumentsQuickFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getArgumentsToFlip";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 8 -> new IllegalStateException(string);
            };
        }
    }
}

