/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.google.common.collect.FluentIterable;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpReferenceContributor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpClosureCanBeConvertedToFirstClassCallableInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpReplaceCallableWithFirstClassCallableQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeprecatedPartiallySupportedCallableInspection
extends PhpInspection {
    private static final Set<String> DEPRECATED_CLASS_NAMES = Set.of("static", "self", "parent");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedPartiallySupportedCallableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                if (PhpDeprecatedPartiallySupportedCallableInspection.isPassedToIsCallableFunction(expression)) {
                    return;
                }
                String contents = expression.getContents();
                String deprecated = PhpDeprecatedPartiallySupportedCallableInspection.getDeprecatedClassName(contents);
                if (deprecated != null && PhpDeprecatedPartiallySupportedCallableInspection.isCallable(expression) && PhpDeprecatedPartiallySupportedCallableInspection.isUsedAsCallable(expression)) {
                    StringLiteralExpression highlightExpression = expression.getParent() instanceof ConcatenationExpression ? expression.getParent() : expression;
                    LocalQuickFix[] quickFixes = 1.getFixes(expression).toArray(LocalQuickFix.EMPTY_ARRAY);
                    holder.registerProblem((PsiElement)highlightExpression, PhpBundle.message("use.0.in.callables.is.deprecated", deprecated), ProblemHighlightType.LIKE_DEPRECATED, quickFixes);
                }
            }

            private static List<LocalQuickFix> getFixes(@NotNull PhpExpression expression) {
                String replacement;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
                String functionName = PhpClosureCanBeConvertedToFirstClassCallableInspection.getFunctionName((PsiElement)expression);
                if (functionName != null) {
                    result.add((LocalQuickFix)new PhpReplaceCallableWithFirstClassCallableQuickFix(functionName));
                }
                if ((replacement = PhpReplaceDeprecatedCallablesQuickFix.createNewExpressionContent((PsiElement)expression)) != null) {
                    result.add((LocalQuickFix)new PhpReplaceDeprecatedCallablesQuickFix(replacement));
                }
                return result;
            }

            @Override
            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                String classRef;
                String deprecated;
                if (PhpDeprecatedPartiallySupportedCallableInspection.isPassedToIsCallableFunction(expression)) {
                    return;
                }
                PhpCallbackReferenceBase.PhpClassMemberCallbackReference reference = PhpReferenceContributor.getCallbackRefFromArray(expression);
                if (reference != null && (deprecated = (String)ContainerUtil.find(DEPRECATED_CLASS_NAMES, arg_0 -> 1.lambda$visitPhpArrayCreationExpression$1(classRef = (String)ObjectUtils.doIfCast((Object)reference.getClassRef(), StringLiteralExpression.class, s -> s.getContents()), arg_0))) != null && PhpDeprecatedPartiallySupportedCallableInspection.hasMethodReferences((PsiPolyVariantReference)reference) && PhpDeprecatedPartiallySupportedCallableInspection.isUsedAsCallable(expression)) {
                    LocalQuickFix[] quickFixes = 1.getFixes(expression).toArray(LocalQuickFix.EMPTY_ARRAY);
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("use.0.in.callables.is.deprecated", deprecated), ProblemHighlightType.LIKE_DEPRECATED, quickFixes);
                    return;
                }
                List elements = ContainerUtil.map((Iterable)ArrayCreationExpressionImpl.children(expression).limit(3), PhpPsiElement::getFirstPsiChild);
                if (elements.size() != 2) {
                    return;
                }
                StringLiteralExpression stringExpression = (StringLiteralExpression)ObjectUtils.tryCast(elements.get(1), StringLiteralExpression.class);
                if (stringExpression == null) {
                    return;
                }
                PhpCallbackFunctionUtil.PhpStaticCallback staticCallback = PhpCallbackFunctionUtil.createStaticCallback(stringExpression);
                if (staticCallback == null) {
                    return;
                }
                if (PhpDeprecatedPartiallySupportedCallableInspection.isUsedAsCallable(expression)) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("deprecated.form.of.callables", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ boolean lambda$visitPhpArrayCreationExpression$1(String classRef, String d) {
                return d.equals(classRef);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/php/lang/inspections/PhpDeprecatedPartiallySupportedCallableInspection$1", "getFixes"));
            }
        };
    }

    public static String getDeprecatedClassName(String contents) {
        return (String)ContainerUtil.find(DEPRECATED_CLASS_NAMES, d -> contents.startsWith(d + "::"));
    }

    private static boolean isUsedAsCallable(PhpExpression expression) {
        PhpPsiElement functionRef = (PhpPsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression, FunctionReference.class, (boolean)true, (Class[])new Class[]{Statement.class});
        if (functionRef != null && PhpPsiUtil.unparenthesize(functionRef.getFirstChild()) == expression) {
            return true;
        }
        if (PhpDeprecatedPartiallySupportedCallableInspection.isPassedAsCallable(expression) || PhpReferenceContributor.isReturnedAsCallable((PsiElement)expression)) {
            return true;
        }
        AssignmentExpression assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)expression.getParent(), AssignmentExpression.class);
        if (assignmentExpression == null || assignmentExpression.getValue() != expression) {
            return false;
        }
        final PhpAccessVariableInstruction varInstruction = PhpControlFlowUtil.getAccessInstruction(assignmentExpression.getVariable(), PhpAccessVariableInstruction.class);
        if (varInstruction == null) {
            return false;
        }
        final Ref result = new Ref((Object)false);
        final Ref ambiguous = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(varInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), varInstruction.getVariableName())) {
                    return true;
                }
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access.isWrite() || access.isWriteRef()) {
                    ambiguous.set((Object)true);
                    this.haltTraversal();
                    return false;
                }
                PhpPsiElement anchor = instruction.getAnchor();
                if (PhpReferenceContributor.isReturnedAsCallable((PsiElement)anchor)) {
                    result.set((Object)true);
                    return false;
                }
                PhpExpression parameter = (PhpExpression)ObjectUtils.tryCast((Object)PhpReferenceContributor.findImmediateParentParameter((PsiElement)anchor), PhpExpression.class);
                if (parameter == null) {
                    return true;
                }
                if (PhpDeprecatedPartiallySupportedCallableInspection.isPassedToIsCallableFunction(parameter)) {
                    return true;
                }
                if (PhpDeprecatedPartiallySupportedCallableInspection.isPassedAsCallable(parameter)) {
                    result.set((Object)true);
                    return false;
                }
                if (access.isReadRef()) {
                    ambiguous.set((Object)true);
                    this.haltTraversal();
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }

            @Override
            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                FunctionReference functionReference = instruction.getFunctionReference();
                Variable variable = (Variable)ObjectUtils.tryCast((Object)functionReference.getFirstPsiChild(), Variable.class);
                if (variable != null && PhpLangUtil.equalsVariableNames(variable.getName(), varInstruction.getVariableName())) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            }

            @Override
            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), varInstruction.getVariableName())) {
                    return true;
                }
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access.isWrite() || access.isWriteRef() || access.isReadRef()) {
                    ambiguous.set((Object)true);
                    this.haltTraversal();
                    return false;
                }
                return super.processArrayAccessInstruction(instruction);
            }
        });
        return (Boolean)ambiguous.get() == false && (Boolean)result.get() != false;
    }

    private static boolean isPassedAsCallable(PhpExpression variable) {
        int index = PhpReferenceContributor.findParameterIndex((PsiElement)variable);
        if (index < 0) {
            return false;
        }
        ParameterListOwner parametersOwner = (ParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)variable, ParameterListOwner.class, (boolean)true, (Class[])new Class[]{Statement.class});
        return parametersOwner != null && PhpCallbackFunctionUtil.isCallableParameter(parametersOwner, index);
    }

    private static boolean isPassedToIsCallableFunction(PhpExpression expression) {
        ParameterList parameterList = (ParameterList)ObjectUtils.tryCast((Object)expression.getParent(), ParameterList.class);
        if (parameterList == null) {
            return false;
        }
        if (parameterList.getParameter(0) != expression) {
            return false;
        }
        FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)parameterList.getParent(), FunctionReference.class);
        if (functionReference == null) {
            return false;
        }
        return PhpLangUtil.equalsFunctionNames("is_callable", functionReference.getName());
    }

    private static boolean isCallable(PhpExpression expression) {
        return PhpDeprecatedPartiallySupportedCallableInspection.isPassedAsCallable(expression) || PhpReferenceContributor.isReturnedAsCallable((PsiElement)expression) || StreamEx.of((Object[])expression.getReferences()).select(PhpCallbackReferenceBase.class).anyMatch(r -> PhpDeprecatedPartiallySupportedCallableInspection.hasMethodReferences((PsiPolyVariantReference)r));
    }

    private static boolean hasMethodReferences(PsiPolyVariantReference reference) {
        return ContainerUtil.exists((Object[])reference.multiResolve(false), r -> r.getElement() instanceof Method);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP820;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDeprecatedPartiallySupportedCallableInspection", "buildVisitor"));
    }

    private static class PhpReplaceDeprecatedCallablesQuickFix
    extends PsiUpdateModCommandQuickFix
    implements LowPriorityAction {
        private final String myContent;

        private PhpReplaceDeprecatedCallablesQuickFix(String content) {
            this.myContent = content;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("replace.with.0", "'" + this.myContent + "'");
            if (string == null) {
                PhpReplaceDeprecatedCallablesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.deprecated.from.of.callable", new Object[0]);
            if (string == null) {
                PhpReplaceDeprecatedCallablesQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement psiElement;
            if (project == null) {
                PhpReplaceDeprecatedCallablesQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceDeprecatedCallablesQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceDeprecatedCallablesQuickFix.$$$reportNull$$$0(4);
            }
            if (element instanceof ConcatenationExpression) {
                ConcatenationExpression concat = (ConcatenationExpression)element;
                psiElement = concat.getLeftOperand();
            } else {
                psiElement = element;
            }
            PsiElement expression = psiElement;
            String content = PhpReplaceDeprecatedCallablesQuickFix.createNewExpressionContent(expression);
            if (content != null) {
                PhpExpression newExpression = PhpPsiElementFactory.createFirstFromText(project, PhpExpression.class, content);
                if (newExpression == null) {
                    return;
                }
                expression.replace((PsiElement)newExpression);
            }
        }

        private static String createNewExpressionContent(PsiElement expression) {
            if (expression instanceof StringLiteralExpression) {
                StringLiteralExpression literal = (StringLiteralExpression)expression;
                return PhpReplaceDeprecatedCallablesQuickFix.createNewStringLiteralContent(literal);
            }
            if (expression instanceof ArrayCreationExpression) {
                ArrayCreationExpression array = (ArrayCreationExpression)expression;
                return PhpReplaceDeprecatedCallablesQuickFix.createNewArrayCreationContent(array);
            }
            return null;
        }

        private static String createNewArrayCreationContent(ArrayCreationExpression expression) {
            ArrayCreationExpression copy = (ArrayCreationExpression)expression.copy();
            FluentIterable<PhpPsiElement> children = ArrayCreationExpressionImpl.children(copy);
            if (children.size() != 2) {
                return null;
            }
            StringLiteralExpression stringLiteral = (StringLiteralExpression)ObjectUtils.tryCast((Object)((PhpPsiElement)children.get(0)).getFirstPsiChild(), StringLiteralExpression.class);
            if (stringLiteral == null) {
                return null;
            }
            String deprecated = (String)ContainerUtil.find(DEPRECATED_CLASS_NAMES, d -> d.equals(stringLiteral.getContents()));
            if (deprecated == null) {
                return null;
            }
            String classRefText = deprecated + "::class";
            ClassConstantReference newClassRef = PhpPsiElementFactory.createFirstFromText(expression.getProject(), ClassConstantReference.class, classRefText);
            if (newClassRef == null) {
                return null;
            }
            stringLiteral.replace((PsiElement)newClassRef);
            return copy.getText();
        }

        private static String createNewStringLiteralContent(StringLiteralExpression expression) {
            String contents = expression.getContents();
            String deprecated = PhpDeprecatedPartiallySupportedCallableInspection.getDeprecatedClassName(contents);
            String quote = expression.isSingleQuote() ? "'" : "\"";
            String classRefText = deprecated + "::class";
            String leftover = StringUtil.trimStart((String)contents, (String)(deprecated + "::"));
            return classRefText + " . " + quote + "::" + leftover + quote;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedPartiallySupportedCallableInspection$PhpReplaceDeprecatedCallablesQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedPartiallySupportedCallableInspection$PhpReplaceDeprecatedCallablesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

