/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpReferenceContributor;
import com.jetbrains.php.lang.inspections.PhpDeprecatedPassingNonCallableStringsToXmlHandlerFunctionInspection;
import com.jetbrains.php.lang.inspections.PhpDeprecatedPassingNonCallableStringsToXmlHandlerFunctionInspectionKt;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedCallbackInspection;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpDeprecatedPassingNonCallableStringsToXmlHandlerFunctionInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpDeprecatedPassingNonCallableStringsToXmlHandlerFunctionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                String string = reference.getName();
                if (string == null) {
                    return;
                }
                String name = string;
                if (!PhpDeprecatedPassingNonCallableStringsToXmlHandlerFunctionInspectionKt.access$getXML_SET_HANDLER_FUNCTIONS$p().containsKey(name)) {
                    return;
                }
                Collection collection = reference.multiResolveStrict(Function.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"multiResolveStrict(...)");
                Function function = (Function)CollectionsKt.firstOrNull((Iterable)collection);
                if (function == null) {
                    return;
                }
                Function function2 = function;
                Map map = PhpDeprecatedPassingNonCallableStringsToXmlHandlerFunctionInspectionKt.access$getXML_SET_HANDLER_FUNCTIONS$p();
                String string2 = function2.getFQN();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFQN(...)");
                char[] cArray = new char[]{'\\'};
                if (!map.containsKey(StringsKt.trim((String)string2, (char[])cArray))) {
                    return;
                }
                Map map2 = (Map)PhpDeprecatedPassingNonCallableStringsToXmlHandlerFunctionInspectionKt.access$getXML_SET_HANDLER_FUNCTIONS$p().get(name);
                if (map2 == null) {
                    return;
                }
                Map indexesOfHandlers = map2;
                indexesOfHandlers.forEach((arg_0, arg_1) -> buildVisitor.1.visitPhpFunctionCall$lambda$1((arg_0, arg_1) -> buildVisitor.1.visitPhpFunctionCall$lambda$0(reference, this.$holder, arg_0, arg_1), arg_0, arg_1));
            }

            private static final Unit visitPhpFunctionCall$lambda$0(FunctionReference $reference, ProblemsHolder $holder, String paramName, Integer index) {
                Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                PsiElement psiElement = $reference.getParameter(paramName, index);
                if (psiElement == null) {
                    return Unit.INSTANCE;
                }
                PsiElement handler = psiElement;
                if (handler instanceof ArrayCreationExpression) {
                    if (PhpReferenceContributor.getCallbackRefFromArray((ArrayCreationExpression)handler) == null) {
                        $holder.registerProblem(handler, PhpBundle.message("inspection.php.passing.non.callable.string.is.deprecated", new Object[0]), new LocalQuickFix[0]);
                    }
                    return Unit.INSTANCE;
                }
                if (handler instanceof StringLiteralExpression) {
                    if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(handler)) {
                        $holder.registerProblem(handler, PhpBundle.message("inspection.php.passing.non.callable.string.is.deprecated", new Object[0]), new LocalQuickFix[0]);
                    }
                    return Unit.INSTANCE;
                }
                if (!(handler instanceof PhpTypedElement)) {
                    $holder.registerProblem(handler, PhpBundle.message("inspection.php.passing.non.callable.string.is.deprecated", new Object[0]), new LocalQuickFix[0]);
                } else {
                    PhpType phpType = ((PhpTypedElement)handler).getGlobalType();
                    Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getGlobalType(...)");
                    PhpType type = phpType;
                    if (!(type.isConvertibleFromGlobal(((PhpTypedElement)handler).getProject(), PhpType.CALLABLE) || type.isConvertibleFromGlobal(((PhpTypedElement)handler).getProject(), PhpType.CLOSURE) || type.isConvertibleFromGlobal(((PhpTypedElement)handler).getProject(), PhpType.ARRAY))) {
                        $holder.registerProblem(handler, PhpBundle.message("inspection.php.passing.non.callable.string.is.deprecated", new Object[0]), new LocalQuickFix[0]);
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void visitPhpFunctionCall$lambda$1(Function2 $tmp0, Object p0, Object p1) {
                $tmp0.invoke(p0, p1);
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }
}

