/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParenthesizedExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.UnaryExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\rH\u0002J.\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0012\u0010\u001e\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u001f\u001a\u00020 H\u0014\u00a8\u0006!"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkExpression", "", "left", "Lcom/intellij/psi/PsiElement;", "right", "expression", "Lcom/jetbrains/php/lang/psi/elements/PhpExpression;", "unparenthesize", "element", "isPsiElementIsNegativeInteger", "checkPsiElementForInteger", "mightBePositive", "Lcom/intellij/openapi/util/Ref;", "mightBeNegative", "isNegativeInteger", "value", "isInteger", "isIntegerFromString", "lookingForPositiveInteger", "isPsiElementIsZero", "isZero", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (!Intrinsics.areEqual((Object)expression.getOperationType(), (Object)PhpTokenTypes.opEXP)) {
                    return;
                }
                PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection.access$checkExpression(this.this$0, expression.getLeftOperand(), expression.getRightOperand(), expression, this.$holder);
            }

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (!Intrinsics.areEqual((Object)expression.getOperationType(), (Object)PhpTokenTypes.opEXP_ASGN)) {
                    return;
                }
                PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection.access$checkExpression(this.this$0, (PsiElement)expression.getVariable(), (PsiElement)expression.getValue(), expression, this.$holder);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                String string = reference.getName();
                if (string == null) {
                    return;
                }
                String name = string;
                if (!Intrinsics.areEqual((Object)name, (Object)"pow") && !Intrinsics.areEqual((Object)name, (Object)"fpow")) {
                    return;
                }
                PsiElement lefOperand = reference.getParameter("num", 0);
                PsiElement rightOperant = reference.getParameter("exponent", 1);
                Collection collection = reference.multiResolveStrict(Function.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"multiResolveStrict(...)");
                Function function = (Function)CollectionsKt.firstOrNull((Iterable)collection);
                if (function == null) {
                    return;
                }
                Function function2 = function;
                String string2 = function2.getFQN();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFQN(...)");
                char[] cArray = new char[]{'\\'};
                if (!Intrinsics.areEqual((Object)StringsKt.trim((String)string2, (char[])cArray), (Object)"pow")) {
                    String string3 = function2.getFQN();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFQN(...)");
                    cArray = new char[]{'\\'};
                    if (!Intrinsics.areEqual((Object)StringsKt.trim((String)string3, (char[])cArray), (Object)"fpow")) {
                        return;
                    }
                }
                PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection.access$checkExpression(this.this$0, lefOperand, rightOperant, reference, this.$holder);
            }
        };
    }

    private final void checkExpression(PsiElement left, PsiElement right, PhpExpression expression, ProblemsHolder holder) {
        PsiElement psiElement = this.unparenthesize(left);
        if (psiElement == null) {
            return;
        }
        PsiElement leftOperand = psiElement;
        PsiElement psiElement2 = this.unparenthesize(right);
        if (psiElement2 == null) {
            return;
        }
        PsiElement rightOperand = psiElement2;
        if (this.isPsiElementIsZero(leftOperand) && this.isPsiElementIsNegativeInteger(rightOperand)) {
            holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.php.raising.zero.to.the.power.of.negative.number.is.deprecated", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private final PsiElement unparenthesize(PsiElement element) {
        return element instanceof ParenthesizedExpressionImpl ? (PsiElement)((ParenthesizedExpressionImpl)element).extract() : element;
    }

    private final boolean isPsiElementIsNegativeInteger(PsiElement element) {
        PsiElement value;
        Ref mightBePositive = new Ref((Object)false);
        Ref mightBeNegative = new Ref((Object)false);
        boolean lookingForPositiveInteger = element instanceof UnaryExpressionImpl && PhpPsiUtil.isOfType(((UnaryExpressionImpl)element).getOperation(), PhpTokenTypes.opMINUS);
        PsiElement psiElement = value = lookingForPositiveInteger ? ((UnaryExpressionImpl)element).getLastChild() : element;
        if (!(value instanceof Variable)) {
            this.checkPsiElementForInteger((Ref<Boolean>)mightBePositive, (Ref<Boolean>)mightBeNegative, value);
            return lookingForPositiveInteger && (Boolean)mightBePositive.get() != false || (Boolean)mightBeNegative.get() != false;
        }
        PhpAccessVariableInstruction phpAccessVariableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)value, PhpAccessVariableInstruction.class);
        if (phpAccessVariableInstruction == null) {
            return false;
        }
        PhpAccessVariableInstruction instruction = phpAccessVariableInstruction;
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(this, (Ref<Boolean>)mightBePositive, (Ref<Boolean>)mightBeNegative){
            final /* synthetic */ PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection this$0;
            final /* synthetic */ Ref<Boolean> $mightBePositive;
            final /* synthetic */ Ref<Boolean> $mightBeNegative;
            {
                this.this$0 = $receiver;
                this.$mightBePositive = $mightBePositive;
                this.$mightBeNegative = $mightBeNegative;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                PhpAccessInstruction.Access access = instruction.getAccess();
                Intrinsics.checkNotNullExpressionValue((Object)access, (String)"getAccess(...)");
                PhpAccessInstruction.Access access2 = access;
                if (!access2.isWrite()) {
                    return true;
                }
                AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), AssignmentExpression.class);
                if (assignmentExpression == null) {
                    return true;
                }
                AssignmentExpression assignment = assignmentExpression;
                PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection.access$checkPsiElementForInteger(this.this$0, this.$mightBePositive, this.$mightBeNegative, (PsiElement)assignment.getValue());
                return (Boolean)this.$mightBePositive.get() == false && (Boolean)this.$mightBeNegative.get() == false;
            }
        });
        return lookingForPositiveInteger && (Boolean)mightBePositive.get() != false || (Boolean)mightBeNegative.get() != false;
    }

    private final void checkPsiElementForInteger(Ref<Boolean> mightBePositive, Ref<Boolean> mightBeNegative, PsiElement element) {
        PsiElement psiElement = this.unparenthesize(element);
        if (psiElement == null) {
            return;
        }
        PsiElement value = psiElement;
        if (value instanceof PhpTypedElement && ((PhpTypedElement)value).getGlobalType().getTypes().contains("\\null")) {
            mightBeNegative.set((Object)true);
            return;
        }
        if (this.isNegativeInteger(value)) {
            mightBeNegative.set((Object)true);
            return;
        }
        if (this.isInteger(value)) {
            mightBePositive.set((Object)true);
            return;
        }
        if (value instanceof ConstantReference) {
            if (PhpType.isPrimitiveType(((ConstantReference)value).getText())) {
                return;
            }
            PsiElement psiElement2 = ((ConstantReference)value).resolve();
            Constant constant = psiElement2 instanceof Constant ? (Constant)psiElement2 : null;
            if (constant == null) {
                return;
            }
            Constant resolved = constant;
            this.checkPsiElementForInteger(mightBePositive, mightBeNegative, resolved.getValue());
        } else if (value instanceof ClassConstantReference) {
            PsiElement psiElement3 = ((ClassConstantReference)value).resolve();
            ClassConstImpl classConstImpl = psiElement3 instanceof ClassConstImpl ? (ClassConstImpl)psiElement3 : null;
            if (classConstImpl == null) {
                return;
            }
            ClassConstImpl resolved = classConstImpl;
            this.checkPsiElementForInteger(mightBePositive, mightBeNegative, resolved.getDefaultValue());
        }
    }

    private final boolean isNegativeInteger(PsiElement value) {
        if (value instanceof UnaryExpressionImpl && PhpPsiUtil.isOfType(((UnaryExpressionImpl)value).getOperation(), PhpTokenTypes.opMINUS)) {
            PsiElement psiElement = ((UnaryExpressionImpl)value).getLastChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getLastChild(...)");
            if (this.isInteger(psiElement)) {
                return true;
            }
        }
        return this.isIntegerFromString(value, false);
    }

    private final boolean isInteger(PsiElement value) {
        if (value instanceof PhpExpressionImpl && PhpPsiUtil.isOfType(((PhpExpressionImpl)value).getLastChild(), PhpTokenTypes.tsNUMBERS)) {
            return true;
        }
        return this.isIntegerFromString(value, true);
    }

    private final boolean isIntegerFromString(PsiElement value, boolean lookingForPositiveInteger) {
        String string = value.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{'\"', '\''};
        String text = StringsKt.trim((String)string, (char[])cArray);
        if (!lookingForPositiveInteger && !StringsKt.startsWith$default((String)text, (String)"-", (boolean)false, (int)2, null)) {
            return false;
        }
        if (((CharSequence)text).length() > 0 && StringsKt.first((CharSequence)text) == '+') {
            String string2 = text.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            text = string2;
        }
        try {
            Integer.decode(text);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private final boolean isPsiElementIsZero(PsiElement value) {
        if (!(value instanceof Variable)) {
            return this.isZero(value);
        }
        if (((Variable)value).getGlobalType().getTypes().contains("\\null")) {
            return true;
        }
        PhpAccessVariableInstruction phpAccessVariableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)value, PhpAccessVariableInstruction.class);
        if (phpAccessVariableInstruction == null) {
            return false;
        }
        PhpAccessVariableInstruction instruction = phpAccessVariableInstruction;
        Ref isZero = new Ref((Object)false);
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor((Ref<Boolean>)isZero, this){
            final /* synthetic */ Ref<Boolean> $isZero;
            final /* synthetic */ PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection this$0;
            {
                this.$isZero = $isZero;
                this.this$0 = $receiver;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                PhpAccessInstruction.Access access = instruction.getAccess();
                Intrinsics.checkNotNullExpressionValue((Object)access, (String)"getAccess(...)");
                PhpAccessInstruction.Access access2 = access;
                if (!access2.isWrite()) {
                    return true;
                }
                AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), AssignmentExpression.class);
                if (assignmentExpression == null) {
                    return true;
                }
                AssignmentExpression assignment = assignmentExpression;
                this.$isZero.set((Object)PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection.access$isZero(this.this$0, (PsiElement)assignment.getValue()));
                return (Boolean)this.$isZero.get() == false;
            }
        });
        Object object = isZero.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final boolean isZero(PsiElement element) {
        StubBasedPsiElement<PhpConstantStub> resolved;
        PsiElement psiElement = this.unparenthesize(element);
        if (psiElement == null) {
            return false;
        }
        PsiElement value = psiElement;
        String string = value.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{'\"', '+', '\'', '-'};
        if (Intrinsics.areEqual((Object)StringsKt.trim((String)string, (char[])cArray), (Object)"0")) {
            return true;
        }
        if (value instanceof PhpTypedElement && ((PhpTypedElement)value).getGlobalType().getTypes().contains("\\null")) {
            return true;
        }
        if (value instanceof ConstantReference) {
            PsiElement psiElement2 = ((ConstantReference)value).resolve();
            Constant constant = psiElement2 instanceof Constant ? (Constant)psiElement2 : null;
            if (constant == null) {
                return false;
            }
            resolved = constant;
            return this.isZero(resolved.getValue());
        }
        if (value instanceof ClassConstantReference) {
            PsiElement psiElement3 = ((ClassConstantReference)value).resolve();
            ClassConstImpl classConstImpl = psiElement3 instanceof ClassConstImpl ? (ClassConstImpl)psiElement3 : null;
            if (classConstImpl == null) {
                return false;
            }
            resolved = classConstImpl;
            return this.isZero(resolved.getDefaultValue());
        }
        return false;
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    public static final /* synthetic */ void access$checkExpression(PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection $this, PsiElement left, PsiElement right, PhpExpression expression, ProblemsHolder holder) {
        $this.checkExpression(left, right, expression, holder);
    }

    public static final /* synthetic */ void access$checkPsiElementForInteger(PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection $this, Ref mightBePositive, Ref mightBeNegative, PsiElement element) {
        $this.checkPsiElementForInteger((Ref<Boolean>)mightBePositive, (Ref<Boolean>)mightBeNegative, element);
    }

    public static final /* synthetic */ boolean access$isZero(PhpDeprecatedRaisingZeroToPowerOfNegativeNumberInspection $this, PsiElement element) {
        return $this.isZero(element);
    }
}

