/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeprecatedSerializableUsageInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedSerializableUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpClass(PhpClass clazz) {
                if (clazz.isAbstract()) {
                    return;
                }
                List classReferences = ContainerUtil.concat(clazz.getImplementsList().getReferenceElements(), clazz.getExtendsList().getReferenceElements());
                ClassReference serializableClassReference = (ClassReference)ContainerUtil.find((Iterable)classReferences, r -> PhpDeprecatedSerializableUsageInspection.implementsSerializable(r));
                if (serializableClassReference == null) {
                    return;
                }
                if (PhpDeprecatedSerializableUsageInspection.hasSerializeMagicMethods(clazz)) {
                    return;
                }
                holder.problem((PsiElement)serializableClassReference, PhpBundle.message("class.implements.the.serializable.interface.which.is.deprecated", new Object[0])).fix((ModCommandAction)new PhpAddSerializeMagicMethodsQuickFix(clazz)).register();
            }
        };
    }

    private static boolean implementsSerializable(@NotNull ClassReference classReference) {
        Collection<PhpClass> classes;
        if (classReference == null) {
            PhpDeprecatedSerializableUsageInspection.$$$reportNull$$$0(1);
        }
        return !(classes = classReference.multiResolveStrict(PhpClass.class)).isEmpty() && ContainerUtil.all(classes, c -> PhpDeprecatedSerializableUsageInspection.implementsSerializable(c));
    }

    public static boolean implementsSerializable(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpDeprecatedSerializableUsageInspection.$$$reportNull$$$0(2);
        }
        Ref result = new Ref((Object)false);
        PhpClassHierarchyUtils.processSupers(clazz, true, false, (Processor<? super PhpClass>)((Processor)i -> {
            if (i.isInterface() && StringUtil.equalsIgnoreCase((CharSequence)i.getFQN(), (CharSequence)"\\Serializable")) {
                result.set((Object)true);
            }
            return (Boolean)result.get() == false;
        }));
        return (Boolean)result.get();
    }

    private static boolean hasSerializeMagicMethods(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpDeprecatedSerializableUsageInspection.$$$reportNull$$$0(3);
        }
        Ref hasSerializeMagicMethod = new Ref((Object)false);
        Ref hasUnserializeMagicMethod = new Ref((Object)false);
        PhpClassHierarchyUtils.processMethods(clazz, clazz, (method, subClass, baseClass) -> {
            if (method.isStatic() || !method.getAccess().isPublic()) {
                return true;
            }
            if (PhpLangUtil.equalsFunctionNames("__serialize", method.getName())) {
                hasSerializeMagicMethod.set((Object)true);
            }
            if (PhpLangUtil.equalsFunctionNames("__unserialize", method.getName())) {
                hasUnserializeMagicMethod.set((Object)true);
            }
            return (Boolean)hasSerializeMagicMethod.get() == false || (Boolean)hasUnserializeMagicMethod.get() == false;
        }, false, false);
        return (Boolean)hasSerializeMagicMethod.get() != false && (Boolean)hasUnserializeMagicMethod.get() != false;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    public static List<Method> getSerializeMagicMethods(@NotNull Project project) {
        PhpClass object;
        if (project == null) {
            PhpDeprecatedSerializableUsageInspection.$$$reportNull$$$0(4);
        }
        if ((object = PhpClassHierarchyUtils.getObject(project)) == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.filter(object.getMethods(), m -> PhpLangUtil.equalsFunctionNames("__serialize", m.getName()) || PhpLangUtil.equalsFunctionNames("__unserialize", m.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedSerializableUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "implementsSerializable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSerializeMagicMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSerializeMagicMethods";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class PhpAddSerializeMagicMethodsQuickFix
    extends PsiBasedModCommandAction<PhpClass> {
        private final List<String> myMethodNames;

        PhpAddSerializeMagicMethodsQuickFix(@NotNull PhpClass clazz) {
            if (clazz == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)clazz);
            this.myMethodNames = ContainerUtil.map(PhpAddSerializeMagicMethodsQuickFix.getNotImplementedSerializeMagicMethods(clazz), m -> "'" + m.getName() + "'");
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PhpClass element) {
            if (context == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(2);
            }
            String text = this.myMethodNames.size() > 1 ? PhpBundle.message("add.serialize.magic.methods", String.join((CharSequence)", ", this.myMethodNames)) : (this.myMethodNames.size() == 1 ? PhpBundle.message("add.serialize.magic.method", this.myMethodNames.get(0)) : this.getFamilyName());
            return Presentation.of((String)text);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.serialize.magic.methods", "'__serialize'/'__unserialize'");
            if (string == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        protected ModCommand perform(@NotNull ActionContext context, @NotNull PhpClass clazz) {
            if (context == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(4);
            }
            if (clazz == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(5);
            }
            List<Method> notImplementedSerializableMagicMethods = PhpAddSerializeMagicMethodsQuickFix.getNotImplementedSerializeMagicMethods(clazz);
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)clazz, (writableClass, updater) -> {
                Set insertedMethods = StreamEx.of((Collection)notImplementedSerializableMagicMethods).map(m -> PhpAddMethodStubsQuickFix.addMethodStub(writableClass, m, PhpDocCreationOption.NONE, false)).select(Method.class).toSet();
                Optional<Method> firstInsertedMethod = insertedMethods.stream().min(Comparator.comparing(PhpNamedElement::getName));
                if (firstInsertedMethod.isEmpty()) {
                    return;
                }
                PhpAddSerializeMagicMethodsQuickFix.moveCaretInsideMethod(firstInsertedMethod.get(), updater);
            });
            if (modCommand == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(6);
            }
            return modCommand;
        }

        @NotNull
        private static List<Method> getNotImplementedSerializeMagicMethods(@NotNull PhpClass clazz) {
            List<Method> serializeMagicMethods;
            if (clazz == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(7);
            }
            if ((serializeMagicMethods = PhpDeprecatedSerializableUsageInspection.getSerializeMagicMethods(clazz.getProject())).isEmpty()) {
                List<Method> list = serializeMagicMethods;
                if (list == null) {
                    PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(8);
                }
                return list;
            }
            PhpClassHierarchyUtils.processMethods(clazz, clazz, (method, baseClass, subClass) -> {
                serializeMagicMethods.removeIf(m -> PhpLangUtil.equalsFunctionNames(method.getName(), m.getName()));
                return !serializeMagicMethods.isEmpty();
            }, false, false);
            List<Method> list = serializeMagicMethods;
            if (list == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(9);
            }
            return list;
        }

        private static void moveCaretInsideMethod(@NotNull Method method, @NotNull ModPsiUpdater updater) {
            PsiElement groupStatement;
            if (method == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(10);
            }
            if (updater == null) {
                PhpAddSerializeMagicMethodsQuickFix.$$$reportNull$$$0(11);
            }
            if ((groupStatement = PsiTreeUtil.findChildOfType((PsiElement)method, GroupStatement.class)) == null) {
                return;
            }
            PsiElement body = (PsiElement)ObjectUtils.doIfNotNull((Object)groupStatement.getFirstChild(), f -> PhpPsiUtil.getNextSiblingIgnoreWhitespace(f, true));
            if (body != null) {
                updater.moveCaretTo(body);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedSerializableUsageInspection$PhpAddSerializeMagicMethodsQuickFix";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedSerializableUsageInspection$PhpAddSerializeMagicMethodsQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotImplementedSerializeMagicMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 3: 
                case 6: 
                case 8: 
                case 9: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getNotImplementedSerializeMagicMethods";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "moveCaretInsideMethod";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6, 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

