/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpAnnotationToAttributeInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J\b\u0010\u000f\u001a\u00020\u0006H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpDoctrineAnnotationToAttributeInspection;", "Lcom/jetbrains/php/lang/inspections/PhpAnnotationToAttributeInspection;", "<init>", "()V", "DOCTRINE_ATTRIBUTES", "", "", "ATTRIBUTES_WITH_CLASS_STRING", "", "checkToolVersion", "", "project", "Lcom/intellij/openapi/project/Project;", "getAttributeFqn", "attributeName", "getFrameworkName", "getHighlightedRange", "Lcom/intellij/openapi/util/TextRange;", "tag", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/tags/PhpDocTag;", "replaceWithClassString", "attributesList", "Lcom/jetbrains/php/lang/psi/elements/PhpAttributesList;", "getAlias", "createAttributeText", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpDoctrineAnnotationToAttributeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpDoctrineAnnotationToAttributeInspection.kt\ncom/jetbrains/php/lang/inspections/PhpDoctrineAnnotationToAttributeInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1863#2,2:103\n*S KotlinDebug\n*F\n+ 1 PhpDoctrineAnnotationToAttributeInspection.kt\ncom/jetbrains/php/lang/inspections/PhpDoctrineAnnotationToAttributeInspection\n*L\n82#1:103,2\n*E\n"})
public final class PhpDoctrineAnnotationToAttributeInspection
extends PhpAnnotationToAttributeInspection {
    @NotNull
    private final Set<String> DOCTRINE_ATTRIBUTES;
    @NotNull
    private final Map<String, String> ATTRIBUTES_WITH_CLASS_STRING;

    public PhpDoctrineAnnotationToAttributeInspection() {
        Object[] objectArray = new String[]{"AttributeOverrides", "AttributeOverride", "Column", "Cache", "ChangeTrackingPolicy", "CustomIdGenerator", "DiscriminatorColumn", "DiscriminatorMap", "Embeddable", "Embedded", "Entity", "GeneratedValue", "HasLifecycleCallbacks", "Index", "Id", "InheritanceType", "JoinColumn", "JoinTable", "ManyToOne", "ManyToMany", "MappedSuperclass", "OneToOne", "OneToMany", "OrderBy", "PostLoad", "PostPersist", "PostRemove", "PostUpdate", "PrePersist", "PreRemove", "PreUpdate", "SequenceGenerator", "Table", "UniqueConstraint", "Version"};
        this.DOCTRINE_ATTRIBUTES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"CustomIdGenerator", (Object)"class"), TuplesKt.to((Object)"Embedded", (Object)"class"), TuplesKt.to((Object)"Entity", (Object)"repositoryClass"), TuplesKt.to((Object)"DiscriminatorMap", (Object)"value")};
        this.ATTRIBUTES_WITH_CLASS_STRING = MapsKt.mapOf((Pair[])objectArray);
    }

    @Override
    protected boolean checkToolVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !PhpIndex.getInstance(project).getAnyByFQN("\\Doctrine\\ORM\\Mapping\\MappingAttribute").isEmpty();
    }

    @Override
    @NotNull
    protected String getAttributeFqn(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return "\\Doctrine\\ORM\\Mapping\\";
    }

    @Override
    @NotNull
    protected String getFrameworkName() {
        return "Doctrine";
    }

    @Override
    @NotNull
    public TextRange getHighlightedRange(@NotNull PhpDocTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        TextRange textRange = tag.getFirstChild().getTextRangeInParent();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
        return textRange;
    }

    @Override
    @Nullable
    protected String replaceWithClassString(@Nullable PhpAttributesList attributesList) {
        Collection attributes;
        PhpAttributesList phpAttributesList = attributesList;
        Collection collection = attributes = phpAttributesList != null ? phpAttributesList.getAttributes() : null;
        Intrinsics.checkNotNull((Object)collection);
        if (collection.size() != 1) {
            return null;
        }
        Object object = CollectionsKt.first((Iterable)attributes);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        PhpAttribute attribute = (PhpAttribute)object;
        if (!this.ATTRIBUTES_WITH_CLASS_STRING.containsKey(attribute.getName())) {
            return null;
        }
        if (attribute.getArguments().isEmpty()) {
            return null;
        }
        Pair pair = TuplesKt.to((Object)attribute.getArguments().get(0).getName(), (Object)attribute.getArguments().get(0).getArgument().getValue());
        String name = (String)pair.component1();
        Object object2 = pair.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component2(...)");
        String value = (String)object2;
        Intrinsics.checkNotNull((Object)name);
        if (!(((CharSequence)name).length() == 0) && !Intrinsics.areEqual((Object)name, (Object)this.ATTRIBUTES_WITH_CLASS_STRING.get(attribute.getName()))) {
            return null;
        }
        Object newValue = null;
        newValue = value;
        if (Intrinsics.areEqual((Object)attribute.getName(), (Object)"DiscriminatorMap")) {
            ArrayCreationExpression array = PhpPsiElementFactory.createFromText(attributesList.getProject(), ArrayCreationExpression.class, value);
            if (array == null) {
                return null;
            }
            Iterable<ArrayHashElement> iterable = array.getHashElements();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getHashElements(...)");
            Iterable<ArrayHashElement> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<ArrayHashElement> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                ArrayHashElement element$iv;
                ArrayHashElement it = element$iv = iterator.next();
                boolean bl = false;
                if (it.getValue() == null) continue;
                PhpPsiElement phpPsiElement = it.getValue();
                Intrinsics.checkNotNull((Object)phpPsiElement);
                String string = phpPsiElement.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                PhpPsiElement phpPsiElement2 = it.getValue();
                Intrinsics.checkNotNull((Object)phpPsiElement2);
                String string2 = StringUtil.unquoteString((String)phpPsiElement2.getText());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unquoteString(...)");
                String[] stringArray = new String[]{"\\"};
                newValue = StringsKt.replace$default((String)newValue, (String)string, (String)(CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) + "::class"), (boolean)false, (int)4, null);
            }
        } else {
            String string = StringUtil.unquoteString((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
            String[] stringArray = new String[]{"\\"};
            newValue = CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) + "::class";
            if (!(((CharSequence)name).length() == 0)) {
                String string3 = attribute.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                return StringsKt.replace$default((String)string3, (String)(name + " : " + value), (String)(name + " : " + newValue), (boolean)false, (int)4, null);
            }
        }
        String string = attribute.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.replace$default((String)string, (String)value, (String)newValue, (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public String getAlias(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return "ORM";
    }

    @Override
    @Nullable
    public String createAttributeText(@NotNull PhpDocTag tag, @NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        if (!this.DOCTRINE_ATTRIBUTES.contains(attributeName)) {
            return null;
        }
        return super.createAttributeText(tag, attributeName);
    }
}

