/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class PhpDuplicateCaseInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateCaseInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpSwitch(PhpSwitch switchStatement) {
                HashSet<String> conditions = new HashSet<String>();
                for (PhpCase phpCase : switchStatement.getAllCases()) {
                    String key;
                    PhpPsiElement condition = phpCase.getCondition();
                    if (condition == null || condition.getTextLength() <= 0 || conditions.add(key = PhpDuplicateCaseInspection.convertToString((PsiElement)condition))) continue;
                    holder.registerProblem((PsiElement)condition, isOnTheFly ? PhpBundle.message("inspection.message.duplicate.case.expression.ref", new Object[0]) : PhpBundle.message("inspection.message.duplicate.case.expression", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static String convertToString(@NotNull PsiElement element) {
        String unquotedString;
        if (element == null) {
            PhpDuplicateCaseInspection.$$$reportNull$$$0(1);
        }
        if (element instanceof StringLiteralExpression && (unquotedString = PhpCodeInsightUtil.toString(element)) != null) {
            try {
                Double.parseDouble(unquotedString);
                return unquotedString.trim();
            }
            catch (NumberFormatException e) {
                return "'" + unquotedString + "'";
            }
        }
        return Arrays.stream(PsiEquivalenceUtil.getFilteredChildren((PsiElement)element, null, (boolean)false)).map(PsiElement::getText).collect(Collectors.joining());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDuplicateCaseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

