/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpStaticVsDynamicInspectionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpDynamicAsStaticMethodCallInspection
extends PhpStaticVsDynamicInspectionBase {
    private static final LocalQuickFix MAKE_CALL_DYNAMIC_FIX = new MakeCallDynamicQuickFix();
    public static final String MAKE_CALL_DYNAMIC_FIX_NAME = MAKE_CALL_DYNAMIC_FIX.getName();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDynamicAsStaticMethodCallInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference methodReference) {
                if (PhpPsiUtil.isOfType(methodReference.getParent(), PhpStubElementTypes.TRAIT_USE_RULE)) {
                    return;
                }
                String methodName = methodReference.getName();
                if (methodName == null) {
                    return;
                }
                if (!methodReference.isStatic()) {
                    return;
                }
                Collection resolvedElements = methodReference.multiResolveStrict(Method.class);
                if (resolvedElements.isEmpty() || !ContainerUtil.and((Iterable)resolvedElements, method -> !method.isStatic())) {
                    return;
                }
                Method containingMethod = (Method)PhpPsiUtil.getParentByCondition((PsiElement)methodReference, Method.INSTANCEOF, PhpClass.INSTANCEOF);
                if (containingMethod == null || !containingMethod.isStatic()) {
                    PhpExpression classReference = methodReference.getClassReference();
                    if (classReference == null) {
                        return;
                    }
                    String classReferenceName = classReference.getName();
                    if ("parent".equals(classReferenceName) || "static".equals(classReferenceName) || "self".equals(classReferenceName)) {
                        return;
                    }
                    PhpClass referringClass = PhpPsiUtil.getParentOfClass((PsiElement)methodReference, PhpClass.class);
                    Set declaringClasses = ContainerUtil.map2Set((Collection)resolvedElements, PhpClassMember::getContainingClass);
                    if (referringClass != null && !declaringClasses.contains(null) && (declaringClasses.contains(referringClass) || ContainerUtil.exists((Iterable)declaringClasses, declaringClass -> PhpClassHierarchyUtils.isSuperClass(declaringClass, referringClass, false)))) {
                        return;
                    }
                }
                Project project = methodReference.getProject();
                PhpType type = methodReference.getClassReference().getGlobalType();
                boolean hasMagic = PhpCodeInsightUtil.hasMagicMethod(type, PhpIndex.getInstance(project), "__callStatic");
                if (hasMagic) {
                    if (!PhpDynamicAsStaticMethodCallInspection.this.isShowForMagic()) {
                        return;
                    }
                    holder.registerProblem(methodReference.getNameNode().getPsi(), PhpBundle.message("inspection.dynamic.method.called.as.static.problem.magic", new Object[0]), PhpDynamicAsStaticMethodCallInspection.this.getMagicHighlightType(), new LocalQuickFix[]{MAKE_CALL_DYNAMIC_FIX});
                } else {
                    holder.registerProblem(methodReference.getNameNode().getPsi(), PhpBundle.message("inspection.dynamic.method.called.as.static.problem", new Object[0]), new LocalQuickFix[]{MAKE_CALL_DYNAMIC_FIX});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDynamicAsStaticMethodCallInspection", "buildVisitor"));
    }

    public static class MakeCallDynamicQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("make.call.dynamic.quick.fix.family.name", new Object[0]);
            if (string == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            MemberReference methodReference;
            if (project == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(3);
            }
            if ((methodReference = (MemberReference)PhpPsiUtil.getParentByCondition(element, false, MemberReference.INSTANCEOF, Statement.INSTANCEOF)) == null || !MakeCallDynamicQuickFix.doFix(project, methodReference)) {
                updater.cancel(PhpBundle.message("quickfix.can.not.find.static.method.reference", new Object[0]));
            }
        }

        public static boolean doFix(@NotNull Project project, @NotNull MemberReference methodReference) {
            PhpClass resolve;
            if (project == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(4);
            }
            if (methodReference == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(5);
            }
            PhpExpression classReference = methodReference.getClassReference();
            PsiElement arrow = PhpPsiElementFactory.createArrow(project);
            PsiElement scopeResolution = PhpPsiUtil.getChildOfType((PsiElement)methodReference, PhpTokenTypes.SCOPE_RESOLUTION);
            if (scopeResolution == null) {
                return false;
            }
            scopeResolution.replace(arrow);
            if (classReference instanceof ClassReference && (resolve = (PhpClass)ContainerUtil.getFirstItem(((ClassReference)classReference).multiResolveStrict(PhpClass.class))) != null) {
                String name = new PhpType().add((PsiElement)resolve).toStringRelativized(methodReference.getNamespaceName());
                PhpPsiElement expression = PhpPsiElementFactory.createPhpPsiFromText(project, PhpElementTypes.PARENTHESIZED_EXPRESSION, "(new " + name + ")");
                classReference.replace((PsiElement)expression);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDynamicAsStaticMethodCallInspection$MakeCallDynamicQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDynamicAsStaticMethodCallInspection$MakeCallDynamicQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

