/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRenameWrongReferenceQuickFix;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassVisitorBase;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddAttributeQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDynamicFieldDeclarationInspection
extends PhpInspection {
    public static final String ALLOW_DYNAMIC_PROPERTIES_FQN = "\\AllowDynamicProperties";
    @NotNull
    @NlsSafe
    public static final String ALLOW_DYNAMIC_PROPERTIES_ATTRIBUTE_TEXT = "#[" + PhpLangUtil.toShortName("\\AllowDynamicProperties") + "]";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDynamicFieldDeclarationInspection.$$$reportNull$$$0(0);
        }
        return new PhpUndefinedClassVisitorBase(holder, isOnTheFly, false){

            @Override
            public void visitPhpClass(PhpClass clazz) {
                Field[] fields;
                if (clazz.isReadonly()) {
                    return;
                }
                for (Field field : fields = clazz.getOwnFields()) {
                    Collection<Field> resolvedElements;
                    PsiElement psi;
                    if (!(field instanceof PhpClassImpl.MyRenamableFakePsiElement) || !((psi = field.getNavigationElement()) instanceof FieldReference) || (resolvedElements = ((FieldReference)psi).multiResolveStrict(Field.class)).isEmpty() || !ContainerUtil.all(resolvedElements, r -> r instanceof PhpClassImpl.MyRenamableFakePsiElement) || PhpDynamicFieldDeclarationInspection.classWithAllowDynamicPropertiesAttributeExists(holder.getProject(), PhpType.global(new PsiElement[]{((FieldReference)psi).getClassReference()}))) continue;
                    LocalQuickFix[] fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(clazz.getProject(), psi) ? this.getFixes((FieldReference)psi) : LocalQuickFix.EMPTY_ARRAY;
                    ASTNode node = ((FieldReference)psi).getNameNode();
                    if (node == null || node.getPsi().getContainingFile() != holder.getFile()) continue;
                    holder.registerProblem(node.getPsi(), this.getMessage(), fixes);
                }
            }

            @NotNull
            @Nls
            private String getMessage() {
                String string = this.isDynamicPropertyDeclarationDeprecated() ? PhpBundle.message("inspection.property.declared.dynamically.deprecated", new Object[0]) : PhpBundle.message("inspection.property.declared.dynamically", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected boolean allFieldsDynamicallyInitialized(Collection<PsiElement> elements) {
                if (this.isDynamicPropertyDeclarationDeprecated()) {
                    elements = ContainerUtil.filter(elements, e -> !(e instanceof PhpDocProperty));
                }
                return super.allFieldsDynamicallyInitialized(elements);
            }

            private boolean isDynamicPropertyDeclarationDeprecated() {
                return PhpLanguageLevel.current((Project)holder.getProject()).isAtLeast(PhpLanguageLevel.PHP820);
            }

            @Override
            protected void checkDynamicDeclaration(FieldReference reference, Project project, PsiElement psi, PhpAccessInstruction.Access access, PhpUndefinedMethodInspection.Reachability reachability, PhpType classReferenceType, boolean probablyUndefined) {
                if (reference.getReferenceType() != PhpModifier.State.DYNAMIC) {
                    return;
                }
                if (!this.isDynamicPropertyDeclarationDeprecated() && access.isWrite() && PhpUndefinedFieldInspection.isExplicitlyNotDefined(reference)) {
                    return;
                }
                if (access.isWrite() && !access.isRead()) {
                    LocalQuickFix[] fixes;
                    LocalQuickFix[] localQuickFixArray = fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(project, psi) ? PhpRenameWrongReferenceQuickFix.appendQuickFix(reference, this.getFixes(reference)) : LocalQuickFix.EMPTY_ARRAY;
                    if (psi.getContainingFile() == holder.getFile() && !PhpDynamicFieldDeclarationInspection.classWithAllowDynamicPropertiesAttributeExists(project, classReferenceType) && !PhpAnnotatorVisitor.isReadonlyClass(project, classReferenceType, (PsiElement)reference)) {
                        holder.registerProblem(psi, this.getMessage(), fixes);
                    }
                }
            }

            @Override
            protected LocalQuickFix[] getFixes(FieldReference reference) {
                if (this.isDynamicPropertyDeclarationDeprecated()) {
                    Object[] fixes = new LocalQuickFix[]{PhpAddFieldDeclarationQuickFix.INSTANCE};
                    PhpClass aClass = PhpQuickFixBase.resolveClass(reference, true);
                    return aClass != null ? (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)LocalQuickFix.from((ModCommandAction)new PhpAddAllowDynamicPropertiesAttributeQuickFix(aClass))) : fixes;
                }
                return super.getFixes(reference);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpDynamicFieldDeclarationInspection$1", "getMessage"));
            }
        };
    }

    private static boolean classWithAllowDynamicPropertiesAttributeExists(Project project, PhpType classReferenceType) {
        PhpIndex index = PhpIndex.getInstance(project);
        return classReferenceType.getTypes().stream().flatMap(fqn -> index.getAnyByFQN((String)fqn).stream()).anyMatch(c -> PhpDynamicFieldDeclarationInspection.isClassWithAllowDynamicPropertiesAttribute(c));
    }

    private static boolean isClassWithAllowDynamicPropertiesAttribute(@Nullable PhpClass c) {
        if (c == null) {
            return false;
        }
        if (c.isInterface()) {
            return PhpDynamicFieldDeclarationInspection.childClassWithAllowDynamicPropertiesExists(c);
        }
        return PhpDynamicFieldDeclarationInspection.haveAllowDynamicAttributeInHierarchy(c, new HashSet<PhpClass>());
    }

    private static Boolean childClassWithAllowDynamicPropertiesExists(PhpClass c) {
        HashSet<PhpClass> visited = new HashSet<PhpClass>();
        Ref res = new Ref((Object)false);
        PhpIndex.getInstance(c.getProject()).processAllSubclasses(c.getFQN(), visited, (Processor<? super PhpClass>)((Processor)childClass -> {
            if (PhpDynamicFieldDeclarationInspection.haveAllowDynamicAttributeInHierarchy(childClass, visited)) {
                res.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)res.get();
    }

    private static boolean haveAllowDynamicAttributeInHierarchy(PhpClass c, Set<PhpClass> visited) {
        Ref res = new Ref((Object)false);
        HashSet currentVisited = new HashSet();
        PhpClassHierarchyUtils.processSuperClasses(c, true, true, (Processor<? super PhpClass>)((Processor)superClass -> {
            currentVisited.add(c);
            if (!superClass.getAttributes(ALLOW_DYNAMIC_PROPERTIES_FQN).isEmpty()) {
                res.set((Object)true);
                return false;
            }
            return !visited.contains(superClass);
        }));
        visited.addAll(currentVisited);
        return (Boolean)res.get();
    }

    @Override
    public Map<PhpLanguageLevel, ProblemHighlightType> getCustomSeverities() {
        return Map.of(PhpLanguageLevel.PHP820, ProblemHighlightType.WARNING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDynamicFieldDeclarationInspection", "buildVisitor"));
    }

    private static class PhpAddAllowDynamicPropertiesAttributeQuickFix
    extends PsiUpdateModCommandAction<PhpClass> {
        @NotNull
        @NlsSafe
        private final String myName;

        private PhpAddAllowDynamicPropertiesAttributeQuickFix(@NotNull PhpClass aClass) {
            if (aClass == null) {
                PhpAddAllowDynamicPropertiesAttributeQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)aClass);
            this.myName = aClass.getName();
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.attribute.to", PhpLangUtil.toShortName(PhpDynamicFieldDeclarationInspection.ALLOW_DYNAMIC_PROPERTIES_FQN), this.myName);
            if (string == null) {
                PhpAddAllowDynamicPropertiesAttributeQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpClass phpClass, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddAllowDynamicPropertiesAttributeQuickFix.$$$reportNull$$$0(2);
            }
            if (phpClass == null) {
                PhpAddAllowDynamicPropertiesAttributeQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAddAllowDynamicPropertiesAttributeQuickFix.$$$reportNull$$$0(4);
            }
            PhpAddAttributeQuickFixBase.addAttribute(phpClass, PhpDynamicFieldDeclarationInspection.ALLOW_DYNAMIC_PROPERTIES_FQN);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDynamicFieldDeclarationInspection$PhpAddAllowDynamicPropertiesAttributeQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDynamicFieldDeclarationInspection$PhpAddAllowDynamicPropertiesAttributeQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

