/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpUnitMockMethodReferenceContributor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpInvalidMockingEntityInspectionBase<T extends PhpUnitMockMethodReferenceContributor.PhpMockedMethodReference>
extends PhpInspection {
    protected abstract PhpUnitMockMethodReferenceContributor.PhpMockMethodReferenceProvider<T> getReferenceProvider();

    protected abstract Collection<PhpMockProblemDescriptor> getInvalidForMockingMethodsDescriptors(T var1);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInvalidMockingEntityInspectionBase.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                Set resolvedMockedMethods;
                Collection<PhpMockProblemDescriptor> descriptors;
                Object mockedReference = PhpInvalidMockingEntityInspectionBase.this.getReferenceProvider().getMockReference(expression);
                if (mockedReference != null && !(descriptors = PhpInvalidMockingEntityInspectionBase.this.getInvalidForMockingMethodsDescriptors(mockedReference)).isEmpty() && !(resolvedMockedMethods = (Set)StreamEx.of((Object[])((PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase)((Object)mockedReference)).multiResolve(false)).map(ResolveResult::getElement).select(Method.class).collect(Collectors.toSet())).isEmpty()) {
                    for (PhpMockProblemDescriptor descriptor : descriptors) {
                        if (!resolvedMockedMethods.stream().allMatch(descriptor.getMethodPredicate())) continue;
                        holder.registerProblem((PsiElement)expression, descriptor.getMessage(), descriptor.getFixes());
                        return;
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpInvalidMockingEntityInspectionBase", "buildVisitor"));
    }

    protected static class PhpMethodVisibilityMockProblemDescriptor
    extends PhpMockProblemDescriptor {
        public PhpMethodVisibilityMockProblemDescriptor(@Nls String visibility, Predicate<Method> predicate) {
            super(PhpBundle.message("inspection.message.methods.cannot.be.mocked", visibility), predicate);
        }
    }

    public static class PhpMockProblemDescriptor {
        @Nls
        protected final String myMessage;
        protected final Predicate<Method> myMethodPredicate;

        public PhpMockProblemDescriptor(@Nls String message, Predicate<Method> predicate) {
            this.myMessage = message;
            this.myMethodPredicate = predicate;
        }

        @Nls
        public String getMessage() {
            return this.myMessage;
        }

        public Predicate<Method> getMethodPredicate() {
            return this.myMethodPredicate;
        }

        public LocalQuickFix[] getFixes() {
            return LocalQuickFix.EMPTY_ARRAY;
        }
    }
}

