/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.lang.inspections.PhpApplyingEmptyIndexOperatorOnStringInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpStrFunctionsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInvalidStringOffsetUsageInspection
extends PhpInspection {
    @NotNull
    private static final TokenSet INCREMENT_DECREMENT = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opDECREMENT, PhpTokenTypes.opINCREMENT});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInvalidStringOffsetUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                PhpPsiElement indexValue;
                ArrayIndex index = expression.getIndex();
                PhpPsiElement phpPsiElement = indexValue = index != null ? index.getValue() : null;
                if (indexValue == null) {
                    return;
                }
                @InspectionMessage String invalidStringOffsetUsageMessage = PhpInvalidStringOffsetUsageInspection.getInvalidStringOffsetUsageMessage(expression);
                if (invalidStringOffsetUsageMessage != null && PhpApplyingEmptyIndexOperatorOnStringInspection.isRealValueTypeEqualsString(expression)) {
                    holder.registerProblem((PsiElement)expression, invalidStringOffsetUsageMessage, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                ArrayAccessExpression variable = (ArrayAccessExpression)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), ArrayAccessExpression.class);
                StringLiteralExpression value = (StringLiteralExpression)ObjectUtils.tryCast((Object)assignmentExpression.getValue(), StringLiteralExpression.class);
                if (value == null || variable == null) {
                    return;
                }
                int length = PhpStrFunctionsInspection.countEscapedLength(value);
                if (length != 1 && PhpApplyingEmptyIndexOperatorOnStringInspection.isRealValueTypeEqualsString(variable)) {
                    if (length == 0) {
                        holder.registerProblem((PsiElement)assignmentExpression, PhpBundle.message("inspection.message.cannot.assign.empty.string.to.string.offset", new Object[0]), new LocalQuickFix[0]);
                    } else {
                        holder.registerProblem((PsiElement)value, PhpBundle.message("inspection.message.only.first.byte.will.be.assigned.to.string.offset", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @InspectionMessage
    @Nullable
    private static String getInvalidStringOffsetUsageMessage(ArrayAccessExpression expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof FieldReference && ((FieldReference)parent).getClassReference() == expression && ((FieldReference)parent).isWriteAccess()) {
            return PhpBundle.message("inspection.message.cannot.use.string.offset.as.object", new Object[0]);
        }
        if (parent instanceof ArrayAccessExpression && ((ArrayAccessExpression)parent).getValue() == expression && ((ArrayAccessExpression)parent).isWriteAccess() && PhpInvalidStringOffsetUsageInspection.getInvalidStringOffsetUsageMessage((ArrayAccessExpression)parent) == null) {
            return PhpBundle.message("inspection.message.cannot.use.string.offset.as.array", new Object[0]);
        }
        if (parent instanceof SelfAssignmentExpression && ((AssignmentExpression)parent).getVariable() == expression) {
            return PhpBundle.message("inspection.message.cannot.use.assign.op.operators.with.string.offsets", new Object[0]);
        }
        if (parent instanceof PhpUnset && ArrayUtil.indexOfIdentity((Object[])((PhpUnset)parent).getArguments(), (Object)expression) >= 0) {
            return PhpBundle.message("inspection.message.cannot.unset.string.offsets", new Object[0]);
        }
        if (parent instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)parent).getOperation(), INCREMENT_DECREMENT)) {
            return PhpBundle.message("inspection.message.cannot.increment.decrement.string.offsets", new Object[0]);
        }
        if (PhpCodeInsightUtil.isPassByRefParameter((PsiElement)expression, true)) {
            return PhpBundle.message("inspection.message.only.variables.can.be.passed.by.reference", new Object[0]);
        }
        PhpArrayAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction(expression, PhpArrayAccessInstruction.class);
        if (instruction != null && (instruction.getAccess().isWriteRef() || instruction.getAccess().isReadRef())) {
            return PhpBundle.message("inspection.message.cannot.create.references.to.from.string.offsets", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpInvalidStringOffsetUsageInspection", "buildVisitor"));
    }
}

