/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpArrayEmptinessConditionDfaAnalyzer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.List;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLanguageLevelDfaProcessor
extends PhpDfaBasedAnalyzerProcessor<PhpLanguageLevelState, PhpLanguageLevelVariableState> {
    @NotNull
    private static final String NAME = PhpTypeSignatureKey.CONSTANT.sign("PHP_VERSION");

    public PhpLanguageLevelDfaProcessor(@Nullable CharSequence name, @Nullable PsiElement anchor) {
        super(name, anchor);
    }

    @Override
    @NotNull
    protected PhpLanguageLevelState getUnknown() {
        PhpLanguageLevelState phpLanguageLevelState = PhpLanguageLevelState.UNKNOWN;
        if (phpLanguageLevelState == null) {
            PhpLanguageLevelDfaProcessor.$$$reportNull$$$0(0);
        }
        return phpLanguageLevelState;
    }

    @Override
    public boolean isUnknown(@NotNull PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpLanguageLevelState> state) {
        if (state == null) {
            PhpLanguageLevelDfaProcessor.$$$reportNull$$$0(1);
        }
        return state.getState() == PhpLanguageLevelState.UNKNOWN;
    }

    @Override
    @NotNull
    public PhpConditionDFAnalyzer<PhpLanguageLevelVariableState> createAnalyzer() {
        return new PhpLanguageLevelDfaAnalyzer();
    }

    @Override
    protected PhpLanguageLevelState createAmbiguousState(PhpLanguageLevelState d1, PhpLanguageLevelState d2) {
        return new PhpLanguageLevelState((PhpLanguageLevel)ComparatorUtil.min((Comparable)d1.myLanguageLevel, (Comparable)d2.myLanguageLevel));
    }

    @Override
    @NotNull
    protected PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpLanguageLevelState> getEmpty() {
        return new PhpLanguageLevelVariableState("", PhpLanguageLevelState.EMPTY);
    }

    @Nullable
    public static PhpLanguageLevel getCurrentLanguageLevelFromDFAConditions(@NotNull PsiElement element) {
        PhpScopeHolder scopeHolder;
        if (element == null) {
            PhpLanguageLevelDfaProcessor.$$$reportNull$$$0(2);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder(element.getParent())) == null) {
            return null;
        }
        PhpControlFlow flow = scopeHolder.getControlFlow();
        PhpInstruction instruction = null;
        while (element.getParent() != null && (instruction = flow.getInstruction(element, PhpInstruction.class)) == null) {
            element = element.getParent();
        }
        if (instruction == null) {
            return null;
        }
        PhpLanguageLevelDfaProcessor analyzer = new PhpLanguageLevelDfaProcessor(NAME, element);
        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges(instruction, false, analyzer);
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction state = analyzer.getState();
        return state != null ? ((PhpLanguageLevelState)state.getState()).myLanguageLevel : null;
    }

    private static boolean isMajorVersionConstant(PsiElement left) {
        return left instanceof ConstantReference && PhpLangUtil.equalsConstantNames(((ConstantReference)left).getName(), "PHP_MAJOR_VERSION");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelDfaProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknown";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelDfaProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentLanguageLevelFromDFAConditions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpLanguageLevelState {
        private static final PhpLanguageLevelState UNKNOWN = new PhpLanguageLevelState(PhpLanguageLevel.DEFAULT);
        private static final PhpLanguageLevelState EMPTY = new PhpLanguageLevelState(PhpLanguageLevel.DEFAULT);
        private final PhpLanguageLevel myLanguageLevel;

        private PhpLanguageLevelState(@NotNull PhpLanguageLevel level) {
            if (level == null) {
                PhpLanguageLevelState.$$$reportNull$$$0(0);
            }
            this.myLanguageLevel = level;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/jetbrains/php/lang/inspections/PhpLanguageLevelDfaProcessor$PhpLanguageLevelState", "<init>"));
        }
    }

    private static class PhpLanguageLevelDfaAnalyzer
    extends PhpConditionDFAnalyzer<PhpLanguageLevelVariableState> {
        private PhpLanguageLevelDfaAnalyzer() {
        }

        @Override
        @NotNull
        public PhpLanguageLevelVariableState and(@NotNull PhpLanguageLevelVariableState leftOperand, @NotNull PhpLanguageLevelVariableState rightOperand, boolean conditionResult) {
            if (leftOperand == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(0);
            }
            if (rightOperand == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(1);
            }
            PhpLanguageLevelVariableState phpLanguageLevelVariableState = PhpLanguageLevelDfaAnalyzer.merge(leftOperand, rightOperand, conditionResult);
            if (phpLanguageLevelVariableState == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(2);
            }
            return phpLanguageLevelVariableState;
        }

        @Override
        @NotNull
        public PhpLanguageLevelVariableState or(@NotNull PhpLanguageLevelVariableState leftOperand, @NotNull PhpLanguageLevelVariableState rightOperand, boolean conditionResult) {
            if (leftOperand == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(3);
            }
            if (rightOperand == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(4);
            }
            PhpLanguageLevelVariableState phpLanguageLevelVariableState = PhpLanguageLevelDfaAnalyzer.merge(leftOperand, rightOperand, !conditionResult);
            if (phpLanguageLevelVariableState == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(5);
            }
            return phpLanguageLevelVariableState;
        }

        @Override
        public PhpLanguageLevelVariableState getEmpty() {
            return new PhpLanguageLevelVariableState("", PhpLanguageLevelState.EMPTY);
        }

        private static PhpLanguageLevelVariableState merge(PhpLanguageLevelVariableState left, PhpLanguageLevelVariableState right, boolean result) {
            if (result) {
                return new PhpLanguageLevelVariableState((PhpLanguageLevel)ComparatorUtil.max((Comparable)((PhpLanguageLevelState)left.getState()).myLanguageLevel, (Comparable)((PhpLanguageLevelState)right.getState()).myLanguageLevel));
            }
            return new PhpLanguageLevelVariableState((PhpLanguageLevel)ComparatorUtil.min((Comparable)((PhpLanguageLevelState)left.getState()).myLanguageLevel, (Comparable)((PhpLanguageLevelState)right.getState()).myLanguageLevel));
        }

        @Override
        @NotNull
        public PhpLanguageLevelVariableState performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof BinaryExpression) {
                PsiElement right;
                PsiElement left;
                PhpLanguageLevelVariableState level;
                IElementType operationType = ((BinaryExpression)condition).getOperationType();
                if ((ContainerUtil.exists((Object[])PhpRangeCheckDfaBasedTypeState.Operand.values(), o -> o.myTokenType == operationType) || PhpTokenTypes.tsCOMPARE_EQUALITY_OPS.contains(operationType) && operationType != PhpTokenTypes.kwINSTANCEOF) && (level = PhpLanguageLevelDfaAnalyzer.tryFindLanguageLevel(result, operationType, left = ((BinaryExpression)condition).getLeftOperand(), right = ((BinaryExpression)condition).getRightOperand(), PhpLanguageLevelDfaAnalyzer::isLanguageVersionConstant)) != null) {
                    PhpLanguageLevelVariableState phpLanguageLevelVariableState = level;
                    if (phpLanguageLevelVariableState == null) {
                        PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(6);
                    }
                    return phpLanguageLevelVariableState;
                }
            } else if (condition instanceof FunctionReference && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)condition, "version_compare")) {
                PhpLanguageLevelVariableState level;
                PsiElement version1 = ((FunctionReference)condition).getParameter("version1", 0);
                PsiElement version2 = ((FunctionReference)condition).getParameter("version2", 1);
                PsiElement operator = ((FunctionReference)condition).getParameter("operator", 2);
                IElementType operationType = PhpLanguageLevelDfaAnalyzer.findOperator(operator);
                if (operationType != null && (level = PhpLanguageLevelDfaAnalyzer.tryFindLanguageLevel(result, operationType, version1, version2, PhpLanguageLevelDfaAnalyzer::isPhpVersion)) != null) {
                    PhpLanguageLevelVariableState phpLanguageLevelVariableState = level;
                    if (phpLanguageLevelVariableState == null) {
                        PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(7);
                    }
                    return phpLanguageLevelVariableState;
                }
            }
            PhpLanguageLevelVariableState phpLanguageLevelVariableState = (PhpLanguageLevelVariableState)((Object)super.performDFA(condition, result));
            if (phpLanguageLevelVariableState == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(8);
            }
            return phpLanguageLevelVariableState;
        }

        @Nullable
        private static IElementType findOperator(PsiElement element) {
            if (!(element instanceof StringLiteralExpression)) {
                return null;
            }
            StringLiteralExpression literal = (StringLiteralExpression)element;
            return switch (literal.getContents()) {
                case ">" -> PhpTokenTypes.opGREATER;
                case ">=" -> PhpTokenTypes.opGREATER_OR_EQUAL;
                case "<=" -> PhpTokenTypes.opLESS_OR_EQUAL;
                case "<" -> PhpTokenTypes.opLESS;
                case "==", "=" -> PhpTokenTypes.opEQUAL;
                case "!=" -> PhpTokenTypes.opNOT_EQUAL;
                default -> null;
            };
        }

        private static boolean isPhpVersion(PsiElement element) {
            return element instanceof FunctionReference && ((FunctionReference)element).getParameter(0) == null && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)element, "phpversion") || element instanceof ConstantReference && PhpLangUtil.equalsConstantNames(((ConstantReference)element).getName(), "PHP_VERSION");
        }

        @Nullable
        private static PhpLanguageLevelVariableState tryFindLanguageLevel(boolean result, IElementType operationType, PsiElement left, PsiElement right, Predicate<PsiElement> languageElementPredicate) {
            PhpLanguageLevel level;
            if (languageElementPredicate.test(right)) {
                level = PhpLanguageLevelDfaAnalyzer.findLevel(right, left, PhpPreviousDfaBaseStateConditionDFAnalyzer.invertNonSymmetricOperands(operationType), result);
            } else if (languageElementPredicate.test(left)) {
                level = PhpLanguageLevelDfaAnalyzer.findLevel(left, right, operationType, result);
            } else {
                return null;
            }
            if (level != null) {
                return new PhpLanguageLevelVariableState(level);
            }
            return null;
        }

        @Nullable
        private static PhpLanguageLevel findLevel(PsiElement languageLevelConstant, PsiElement oppositeOperand, IElementType operationType, boolean result) {
            String version = null;
            PhpRangeCheckDfaBasedTypeState.Operand operand = null;
            if (oppositeOperand instanceof StringLiteralExpression) {
                operand = PhpRangeCheckDfaBasedTypeState.normalizeOperand(operationType, result);
                version = StringUtil.replace((String)((StringLiteralExpression)oppositeOperand).getContents(), (String)".", (String)"0");
            } else {
                PhpRangeCheckDfaBasedTypeState delegateState = PhpRangeCheckDfaBasedTypeState.tryToCreate(oppositeOperand, operationType, result, true);
                if (delegateState instanceof PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState) {
                    version = String.valueOf(((PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState)delegateState).getValue());
                    operand = delegateState.getOperand();
                }
            }
            if (version != null) {
                IElementType normalized;
                IElementType iElementType = normalized = !result ? PhpArrayEmptinessConditionDfaAnalyzer.invert(operationType) : operationType;
                if (operand == PhpRangeCheckDfaBasedTypeState.Operand.GREATER || operand == PhpRangeCheckDfaBasedTypeState.Operand.GREATER_EQ || normalized == PhpTokenTypes.opEQUAL || normalized == PhpTokenTypes.opIDENTICAL) {
                    return PhpLanguageLevelDfaAnalyzer.getLevel(version, operand, PhpLanguageLevelDfaProcessor.isMajorVersionConstant(languageLevelConstant));
                }
            }
            return null;
        }

        @Nullable
        private static PhpLanguageLevel getLevel(String version, @Nullable PhpRangeCheckDfaBasedTypeState.Operand operand, boolean isMajorVersionConstant) {
            PhpLanguageLevel level;
            if (version.isEmpty()) {
                return null;
            }
            int majorVersion = Integer.parseInt(version.substring(0, 1));
            int minorVersion = 0;
            if (!isMajorVersionConstant && version.length() >= 3) {
                minorVersion = Integer.parseInt(version.substring(1, 3));
            }
            if ((level = PhpLanguageLevelDfaAnalyzer.findLevel(majorVersion, minorVersion)) == null) {
                return (PhpLanguageLevel)ArrayUtil.getLastElement((Object[])PhpLanguageLevel.values());
            }
            if (operand == PhpRangeCheckDfaBasedTypeState.Operand.GREATER) {
                return isMajorVersionConstant ? PhpLanguageLevelDfaAnalyzer.findLevel(majorVersion + 1, minorVersion) : PhpLanguageLevelDfaAnalyzer.getNextLevel(level);
            }
            return level;
        }

        private static boolean isLanguageVersionConstant(PsiElement left) {
            return left instanceof ConstantReference && PhpLangUtil.equalsConstantNames(((ConstantReference)left).getName(), "PHP_VERSION_ID") || PhpLanguageLevelDfaProcessor.isMajorVersionConstant(left);
        }

        private static PhpLanguageLevel findLevel(int majorVersion, int minorVersion) {
            return (PhpLanguageLevel)ContainerUtil.find((Object[])PhpLanguageLevel.values(), v -> PhpLanguageLevelDfaAnalyzer.atLeastVersionToFind(majorVersion, minorVersion, v));
        }

        private static boolean atLeastVersionToFind(int findMajorVersion, int findMinorVersion, PhpLanguageLevel v) {
            List split = StringUtil.split((String)v.getVersionString(), (String)".");
            int myMajorVersion = Integer.parseInt((String)split.get(0));
            int myMinorVersion = Integer.parseInt((String)split.get(1));
            return myMajorVersion > findMajorVersion || myMajorVersion == findMajorVersion && myMinorVersion >= findMinorVersion;
        }

        private static PhpLanguageLevel getNextLevel(@NotNull PhpLanguageLevel level) {
            if (level == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(9);
            }
            return PhpLanguageLevelDfaAnalyzer.getNextLevel(level, (StreamEx<PhpLanguageLevel>)StreamEx.of((Object[])PhpLanguageLevel.values()));
        }

        private static PhpLanguageLevel getNextLevel(@NotNull PhpLanguageLevel level, StreamEx<PhpLanguageLevel> levels) {
            if (level == null) {
                PhpLanguageLevelDfaAnalyzer.$$$reportNull$$$0(10);
            }
            return levels.findFirst(v -> v.compareTo((Enum)level) > 0).orElse(level);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftOperand";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightOperand";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelDfaProcessor$PhpLanguageLevelDfaAnalyzer";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelDfaProcessor$PhpLanguageLevelDfaAnalyzer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "and";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "or";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performDFA";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "and";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "or";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getNextLevel";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpLanguageLevelVariableState
    extends PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpLanguageLevelState> {
        private String myName;

        public PhpLanguageLevelVariableState(String name, PhpLanguageLevelState state) {
            super(name, state);
            this.myName = name;
        }

        public PhpLanguageLevelVariableState(@NotNull PhpLanguageLevel state) {
            if (state == null) {
                PhpLanguageLevelVariableState.$$$reportNull$$$0(0);
            }
            this(NAME, new PhpLanguageLevelState(state));
        }

        @Override
        public PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpLanguageLevelState> copy(PhpLanguageLevelState state) {
            return new PhpLanguageLevelVariableState(this.myName, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/lang/inspections/PhpLanguageLevelDfaProcessor$PhpLanguageLevelVariableState", "<init>"));
        }
    }
}

