/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureFromUsageQuickFix;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMethodParametersCountMismatchInspection
extends PhpInspection {
    public boolean DISABLE_FOR__PARAMETER = true;
    public boolean DISABLE_FOR_FUNC_ARG = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMethodParametersCountMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference classReference;
                ClassReference classReference2 = classReference = expression != null ? expression.getClassReference() : null;
                if (classReference == null) {
                    PhpClass anonymousClass;
                    PhpClass phpClass = anonymousClass = expression != null ? (PhpClass)ObjectUtils.tryCast((Object)expression.getFirstPsiChild(), PhpClass.class) : null;
                    if (anonymousClass != null) {
                        this.inspect(expression.getParameterList(), Collections.singleton(anonymousClass));
                    }
                    return;
                }
                this.inspect(expression.getClassReference(), expression.getParameterList());
            }

            @Override
            public void visitPhpAttribute(PhpAttribute attribute) {
                this.inspect(attribute.getClassReference(), attribute.getParameterList());
            }

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                if (this.tryCheckPropertyHookCall(reference)) {
                    return;
                }
                this.inspect(reference, reference.getParameterList());
            }

            private boolean tryCheckPropertyHookCall(FunctionReference reference) {
                if (!(reference instanceof MethodReference)) {
                    return false;
                }
                MethodReference methodReference = (MethodReference)reference;
                String name = methodReference.getName();
                if (name == null) {
                    return false;
                }
                if (MethodReferenceImpl.getFieldReferencedFromPropertyHookCall(methodReference.getClassReference()) == null) {
                    return false;
                }
                ParameterList argumentsList = methodReference.getParameterList();
                if (argumentsList == null) {
                    return false;
                }
                PsiElement[] parameters = argumentsList.getParameters();
                int length = argumentsList.getParameters().length;
                if (name.equals("set") && length > 1 || name.equals("get") && length > 0) {
                    PsiElement parameter = argumentsList.getParameter(name.equals("set") ? 1 : 0);
                    if (parameter == null) {
                        return true;
                    }
                    String message = PhpBundle.message("inspection.method.parameters.count.mismatch", length, name.equals("set") ? 1 : 0);
                    TextRange range = TextRange.create((int)parameter.getTextRangeInParent().getStartOffset(), (int)parameters[length - 1].getTextRangeInParent().getEndOffset());
                    holder.registerProblem((PsiElement)argumentsList, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[0]);
                }
                return true;
            }

            private void inspect(@Nullable PhpReference reference, @Nullable ParameterList argumentsList) {
                if (reference == null || argumentsList == null) {
                    return;
                }
                this.inspect(argumentsList, ContainerUtil.map((Object[])reference.multiResolve(false), ResolveResult::getElement));
            }

            private void inspect(@Nullable ParameterList argumentsList, Collection<PsiElement> resolvedElements) {
                if (argumentsList != null && !resolvedElements.isEmpty() && ContainerUtil.all(resolvedElements, e -> this.argumentCountMismatch(argumentsList, (PsiElement)e))) {
                    int parametersCount = resolvedElements.stream().mapToInt(e -> e instanceof Function ? ((Function)e).getParameters().length : 0).min().orElse(-1);
                    PsiElement[] arguments = argumentsList.getParameters();
                    String message = PhpBundle.message("inspection.method.parameters.count.mismatch", arguments.length, parametersCount);
                    LocalQuickFix[] fixes = PhpChangeFunctionSignatureFromUsageQuickFix.getFixes((PsiElement)argumentsList, isOnTheFly);
                    if (arguments.length > parametersCount) {
                        Object first = arguments[parametersCount];
                        Object prevColon = PhpPsiUtil.getPrevSiblingByCondition(first, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opCOLON)));
                        if (prevColon != null) {
                            first = prevColon;
                        }
                        TextRange range = TextRange.create((int)first.getTextRangeInParent().getStartOffset(), (int)arguments[arguments.length - 1].getTextRangeInParent().getEndOffset());
                        holder.registerProblem((PsiElement)argumentsList, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, fixes);
                    }
                }
            }

            private boolean argumentCountMismatch(@NotNull ParameterList argumentsList, @Nullable PsiElement element) {
                if (argumentsList == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PhpClass) {
                    return this.argumentCountMismatch(argumentsList, ((PhpClass)element).getConstructor());
                }
                if (element instanceof Function) {
                    return this.argumentCountMismatch(argumentsList, (Function)element);
                }
                return false;
            }

            private boolean argumentCountMismatch(@NotNull ParameterList argumentsList, @Nullable Function function) {
                Parameter[] parameters;
                int numberOfParametersInDeclaration;
                int numberOfParametersInCall;
                if (argumentsList == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((numberOfParametersInCall = argumentsList.getParameters().length) <= (numberOfParametersInDeclaration = (parameters = function != null ? function.getParameters() : Parameter.EMPTY_ARRAY).length)) {
                    return false;
                }
                if (numberOfParametersInDeclaration > 0) {
                    if (PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR__PARAMETER && parameters[numberOfParametersInDeclaration - 1].getName().equals("_")) {
                        return false;
                    }
                    if (parameters[numberOfParametersInDeclaration - 1].isVariadic()) {
                        return false;
                    }
                }
                return !PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR_FUNC_ARG || function == null || !PhpFuncGetArgUsageProvider.containsGetArgFunctionUsage(function);
            }

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                this.visitPhpFunctionCall(reference);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsList", "com/jetbrains/php/lang/inspections/PhpMethodParametersCountMismatchInspection$1", "argumentCountMismatch"));
            }
        };
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DISABLE_FOR__PARAMETER", (String)PhpBundle.message("inspection.method.parameters.count.mismatch.option.ignore.underscore", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DISABLE_FOR_FUNC_ARG", (String)PhpBundle.message("inspection.method.parameters.count.mismatch.option.ignore.func.get.arg", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpMethodParametersCountMismatchInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpMethodParametersCountMismatchInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpMethodParametersCountMismatchInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

