/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpMissingBreakStatementInspection
extends PhpInspection {
    public static final String[] IGNORE_COMMENTS = new String[]{"no break", "fallthrough"};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingBreakStatementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpSwitch(final PhpSwitch switchStatement) {
                PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)switchStatement);
                if (scopeHolder == null) {
                    return;
                }
                final TextRange switchStatementTextRange = switchStatement.getTextRange();
                for (final PhpCase aCase : switchStatement.getAllCases()) {
                    PhpStatementInstruction firstStatementInstruction;
                    Statement caseGroupStatement = aCase.getStatement();
                    Statement firstStatement = (Statement)PsiTreeUtil.findChildOfType((PsiElement)caseGroupStatement, Statement.class);
                    if (firstStatement == null || (firstStatementInstruction = PhpControlFlowUtil.getStatementInstruction(PhpCustomExitPointRegistry.getControlFlow(scopeHolder), firstStatement)) == null || PhpMissingBreakStatementInspection.containsIgnoreComment(aCase)) continue;
                    PhpControlFlowUtil.processSuccessors(firstStatementInstruction, false, new PhpInstructionProcessor(){

                        @Override
                        public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                            Statement curStatement = instruction.getStatement();
                            if (curStatement == switchStatement) {
                                return false;
                            }
                            TextRange curStatementTextRange = curStatement.getTextRange();
                            if (!aCase.getTextRange().contains(curStatementTextRange)) {
                                if (switchStatementTextRange.contains(curStatementTextRange)) {
                                    holder.registerProblem(aCase.getFirstChild(), PhpMissingBreakStatementInspection.getProblemDescription(), new LocalQuickFix[]{PhpAddBreakStatementQuickFix.INSTANCE});
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }
        };
    }

    private static boolean containsIgnoreComment(PhpCase currentCase) {
        PsiElement sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)currentCase, true);
        if (sibling instanceof PsiComment) {
            return ContainerUtil.exists((Object[])IGNORE_COMMENTS, c -> c.equals(PhpMissingBreakStatementInspection.getCommentContent((PsiComment)sibling)));
        }
        return false;
    }

    private static String getCommentContent(PsiComment comment) {
        return comment.getText().startsWith("#") ? comment.getText().substring(1).trim() : comment.getText().substring(2).trim();
    }

    @InspectionMessage
    public static String getProblemDescription() {
        return PhpBundle.message("inspection.missing.break.statement.problem", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpMissingBreakStatementInspection", "buildVisitor"));
    }

    private static class PhpAddBreakStatementQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpAddBreakStatementQuickFix();

        private PhpAddBreakStatementQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.break.as.last.statement", new Object[0]);
            if (string == null) {
                PhpAddBreakStatementQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpCase aCase;
            Statement statement;
            if (project == null) {
                PhpAddBreakStatementQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddBreakStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddBreakStatementQuickFix.$$$reportNull$$$0(3);
            }
            if ((statement = (aCase = (PhpCase)element.getParent()).getStatement()) == null) {
                return;
            }
            statement.add(PhpPsiElementFactory.createFromText(project, PhpElementTypes.BREAK, "break;"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpMissingBreakStatementInspection$PhpAddBreakStatementQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpMissingBreakStatementInspection$PhpAddBreakStatementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

