/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.inspections.PhpApplyingEmptyIndexOperatorOnStringInspection;
import com.jetbrains.php.lang.inspections.PhpDeprecationInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionProcessor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPassByRefInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpPassByRefInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                this.checkCall(reference, () -> reference.multiResolveStrict(Function.class));
            }

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                this.checkCall(reference, () -> reference.multiResolveStrict(Function.class));
            }

            @Override
            public void visitPhpNewExpression(NewExpression expression) {
                this.checkCall(expression, () -> 1.resolveNewExpression(expression));
            }

            @Override
            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpPsiElement value;
                if (PhpWorkaroundUtil.isAssignByReference(assignmentExpression) && (value = assignmentExpression.getValue()) != null && !PhpPassByRefInspection.canBePassByReference((PsiElement)value)) {
                    holder.registerProblem((PsiElement)value, PhpBundle.message("inspection.message.only.variables.can.be.passed.by.reference", new Object[0]), PhpPassByRefInspection.amendExtractVariableFix(PhpRemoveRefFromAssignmentQuickFix.INSTANCE, isOnTheFly));
                }
            }

            @Override
            public void visitPhpReturn(PhpReturn returnStatement) {
                Function function = PhpPsiUtil.getParentOfClass((PsiElement)returnStatement, Function.class);
                if (function == null) {
                    return;
                }
                this.doCheck(function, returnStatement.getArgument());
            }

            @Override
            public void visitPhpFunction(Function function) {
                if (function.isClosure() && FunctionImpl.isShortArrowFunction(function)) {
                    this.doCheck(function, FunctionImpl.getShortArrowFunctionArgument(function));
                }
            }

            private void doCheck(@NotNull Function function, @Nullable PsiElement argument) {
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (function.isReturningByReference() && argument != null && !PhpPassByRefInspection.canBePassByReference(argument)) {
                    holder.registerProblem(argument, PhpBundle.message("inspection.php.pass.by.ref.description", new Object[0]), PhpPassByRefInspection.amendExtractVariableFix((LocalQuickFix)new PhpRemoveRefFromFunctionDeclarationQuickFix(function.getName()), isOnTheFly));
                }
            }

            @NotNull
            private static Collection<Method> resolveNewExpression(NewExpression expression) {
                ClassReference classReference = expression.getClassReference();
                if (classReference == null) {
                    List<Method> list = Collections.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                Collection collection = Arrays.stream(classReference.multiResolve(false)).map(ResolveResult::getElement).map(resolve -> resolve instanceof Method ? (Method)resolve : (resolve instanceof PhpClass && resolve.isValid() ? ((PhpClass)resolve).getConstructor() : null)).filter(Objects::nonNull).collect(Collectors.toList());
                if (collection == null) {
                    1.$$$reportNull$$$0(2);
                }
                return collection;
            }

            private void checkCall(@NotNull ParameterListOwner reference, @NotNull @NotNull Supplier<@NotNull Collection<? extends Function>> functionSupplier) {
                List<PsiElement> arguments;
                IntSet cantBePassedByReferenceArguments;
                if (reference == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (functionSupplier == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((cantBePassedByReferenceArguments = PhpPassByRefInspection.collectCantBePassedByReferencesArgumentsIndices(arguments = Arrays.asList(reference.getParameters()))).isEmpty()) {
                    return;
                }
                Collection<? extends Function> functions = functionSupplier.get();
                if (!functions.isEmpty() && ContainerUtil.exists(functions, f -> f.getFQN().equals("\\array_multisort") || f.getFQN().equals("\\extract"))) {
                    return;
                }
                List parameters = ContainerUtil.map(functions, function -> Arrays.asList(function.getParameters()));
                cantBePassedByReferenceArguments.forEach(i -> this.doCheckArgumentIndexByRef(arguments, parameters, i));
            }

            private boolean doCheckArgumentIndexByRef(List<PsiElement> arguments, List<List<Parameter>> parameters, int i) {
                List<Parameter> resolvedParameters = PhpPassByRefInspection.resolveParameters(arguments, parameters, i);
                Parameter param = (Parameter)ContainerUtil.getFirstItem(resolvedParameters);
                if (param != null && !resolvedParameters.contains(null) && ContainerUtil.all(resolvedParameters, Parameter::isPassByRef)) {
                    holder.registerProblem(arguments.get(i), PhpBundle.message("inspection.message.only.variables.can.be.passed.by.reference", new Object[0]), PhpPassByRefInspection.amendExtractVariableFix((LocalQuickFix)new PhpRemovePassByRefFromParameterQuickFix(param.getName()), isOnTheFly));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "functionSupplier";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "resolveNewExpression";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doCheck";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "checkCall";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static List<Parameter> resolveParameters(List<PsiElement> arguments, List<List<Parameter>> parameters, int i) {
        List list = ContainerUtil.map(parameters, p -> PhpDeprecationInspection.resolveParameter(arguments, p, i));
        if (list == null) {
            PhpPassByRefInspection.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static LocalQuickFix[] amendExtractVariableFix(LocalQuickFix fix, boolean isOnTheFly) {
        LocalQuickFix[] localQuickFixArray;
        if (isOnTheFly) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
            localQuickFixArray2[0] = fix;
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[1] = PhpExtractVariableQuickFix.INSTANCE;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[0] = fix;
        }
        return localQuickFixArray;
    }

    @NotNull
    private static IntSet collectCantBePassedByReferencesArgumentsIndices(List<PsiElement> arguments) {
        IntOpenHashSet cantBePassedByReferenceArguments = new IntOpenHashSet(arguments.size());
        for (int i = 0; i < arguments.size(); ++i) {
            PsiElement argument = arguments.get(i);
            if (argument instanceof AssignmentExpression && PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)argument) || PhpPassByRefInspection.canBePassByReference(argument)) continue;
            cantBePassedByReferenceArguments.add(i);
        }
        IntOpenHashSet intOpenHashSet = cantBePassedByReferenceArguments;
        if (intOpenHashSet == null) {
            PhpPassByRefInspection.$$$reportNull$$$0(2);
        }
        return intOpenHashSet;
    }

    public static boolean canBePassByReference(@Nullable PsiElement parameter) {
        FieldReference reference;
        if (parameter == null || parameter.getTextLength() <= 0) {
            return true;
        }
        if (PhpPsiUtil.isOfType(parameter.getPrevSibling(), PhpTokenTypes.opVARIADIC)) {
            return true;
        }
        if (parameter instanceof UnaryExpression) {
            PsiElement operation = ((UnaryExpression)parameter).getOperation();
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)operation);
            return elementType == PhpTokenTypes.kwCLONE || elementType == PhpTokenTypes.opSILENCE || (elementType == PhpTokenTypes.opDECREMENT || elementType == PhpTokenTypes.opINCREMENT) && operation == parameter.getFirstChild();
        }
        if (parameter instanceof TernaryExpression) {
            TernaryExpression ternaryExpression = (TernaryExpression)parameter;
            PhpPsiElement trueVariant = ternaryExpression.getTrueVariant();
            PhpPsiElement falseVariant = ternaryExpression.getFalseVariant();
            return PhpPassByRefInspection.canBePassByReference((PsiElement)trueVariant) && PhpPassByRefInspection.canBePassByReference((PsiElement)falseVariant);
        }
        if (parameter instanceof MemberReference && ((MemberReference)parameter).hasNullSafeDereference()) {
            return false;
        }
        if (parameter instanceof FieldReference && (!(reference = (FieldReference)parameter).isConstant() || reference.getReferenceType().isDynamic())) {
            return true;
        }
        if (parameter instanceof FunctionReference) {
            Collection<Function> elements = PhpPassByRefInspection.resolveFunctions(parameter);
            return elements.isEmpty() || ContainerUtil.exists(elements, e -> e.isReturningByReference());
        }
        if (parameter instanceof ArrayAccessExpression && PhpApplyingEmptyIndexOperatorOnStringInspection.isRealValueTypeEqualsString((ArrayAccessExpression)parameter)) {
            return false;
        }
        return parameter instanceof Variable || parameter instanceof ArrayAccessExpression;
    }

    private static Collection<Function> resolveFunctions(PsiElement functionCall) {
        if (functionCall instanceof ParenthesizedExpression) {
            return PhpPassByRefInspection.resolveFunctions((PsiElement)((ParenthesizedExpression)functionCall).getArgument());
        }
        if (functionCall instanceof Function) {
            return Collections.singleton((Function)functionCall);
        }
        if (PhpPsiUtil.isOfType(functionCall, PhpElementTypes.CLOSURE)) {
            return PhpPassByRefInspection.resolveFunctions(functionCall.getFirstChild());
        }
        if (functionCall instanceof MethodReference) {
            if (PhpPassByRefInspection.isMethodCallWithFQN((MethodReference)functionCall, "\\Closure.__invoke") || PhpPassByRefInspection.isMethodCallWithFQN((MethodReference)functionCall, "\\Closure.bindTo")) {
                return PhpPassByRefInspection.resolveFunctions((PsiElement)((MethodReference)functionCall).getClassReference());
            }
            if (PhpPassByRefInspection.isMethodCallWithFQN((MethodReference)functionCall, "\\Closure.bind")) {
                return PhpPassByRefInspection.resolveFunctions(((MethodReference)functionCall).getParameter(0));
            }
        }
        if (functionCall instanceof FunctionReference) {
            Set localFunctions = (Set)StreamEx.of((Collection)((FunctionReference)functionCall).resolveLocal()).select(Function.class).collect(Collectors.toSet());
            return ContainerUtil.union((Collection)((FunctionReference)functionCall).multiResolveStrict(Function.class), (Collection)localFunctions);
        }
        return Collections.emptySet();
    }

    private static boolean isMethodCallWithFQN(MethodReference call, String fqn) {
        String name = fqn.substring(fqn.lastIndexOf(46) + 1);
        if (!name.equals(call.getName())) {
            return false;
        }
        Collection functions = call.multiResolveStrict(Function.class);
        return !functions.isEmpty() && ContainerUtil.all((Collection)functions, f -> f.getFQN().equals(fqn));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCantBePassedByReferencesArgumentsIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpExtractVariableQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpExtractVariableQuickFix();

        private PhpExtractVariableQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = RefactoringBundle.message((String)"introduce.variable.title");
            if (string == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            Editor editor;
            if (project == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(2);
            }
            if ((editor = PsiEditorUtil.findEditor((PsiElement)(element = descriptor.getStartElement()))) == null) {
                return;
            }
            PhpIntroduceVariableHandler handler = new PhpIntroduceVariableHandler();
            try {
                handler.invoke(handler.getIntroduceContext(editor, element));
            }
            catch (PhpIntroduceBaseHandler.RefactoringErrorException refactoringErrorException) {
                // empty catch block
            }
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(3);
            }
            if (previewDescriptor == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(4);
            }
            PsiElement element = previewDescriptor.getStartElement();
            Editor editor = PsiEditorUtil.findEditor((PsiElement)element);
            PhpIntroduceVariableHandler handler = new PhpIntroduceVariableHandler();
            try {
                PhpIntroduceContext context = handler.getIntroduceContext(editor, element);
                handler.doRefactoring(context, PhpInlineFunctionProcessor.getIntroduceVariableSettings(context));
            }
            catch (PhpIntroduceBaseHandler.RefactoringErrorException refactoringErrorException) {
                // empty catch block
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpExtractVariableQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpExtractVariableQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class PhpRemoveRefFromFunctionDeclarationQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myFunctionName;

        private PhpRemoveRefFromFunctionDeclarationQuickFix(String functionName) {
            this.myFunctionName = functionName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = PhpBundle.message("remove.from.function.0.declaration", this.myFunctionName);
            if (string == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.ref.from.function.declaration.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Function function;
            if (project == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(4);
            }
            if ((function = PhpPsiUtil.getParentOfClass(element, Function.class)) == null) {
                return;
            }
            PsiElement passByRefToken = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.opBIT_AND);
            if (passByRefToken != null) {
                passByRefToken.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemoveRefFromFunctionDeclarationQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemoveRefFromFunctionDeclarationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpRemoveRefFromAssignmentQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveRefFromAssignmentQuickFix();

        private PhpRemoveRefFromAssignmentQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.ref.from.assignment.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpRemoveRefFromAssignmentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            AssignmentExpression assignmentExpression;
            PsiElement refAssignment;
            if (project == null) {
                PhpRemoveRefFromAssignmentQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveRefFromAssignmentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveRefFromAssignmentQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement psiElement = refAssignment = (assignmentExpression = PhpPsiUtil.getParentOfClass(element, AssignmentExpression.class)) != null ? PhpPsiUtil.getChildOfType((PsiElement)assignmentExpression, PhpTokenTypes.tsASGN_OPS) : null;
            if (refAssignment != null) {
                PsiElement assignToken = PhpPsiUtil.getChildOfType((PsiElement)PhpPsiElementFactory.createStatement(project, "$a = $b").getFirstPsiChild(), PhpTokenTypes.opASGN);
                assert (assignToken != null);
                refAssignment.replace(assignToken);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemoveRefFromAssignmentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemoveRefFromAssignmentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class PhpRemovePassByRefFromParameterQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myParameterName;

        private PhpRemovePassByRefFromParameterQuickFix(String parameterName) {
            this.myParameterName = parameterName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.pass.by.ref.from.parameter.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = PhpBundle.message("remove.from.the.parameter.0", this.myParameterName);
            if (string == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement passByRefToken;
            ParameterList parameterList;
            if (project == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(4);
            }
            if ((parameterList = PhpPsiUtil.getParentOfClass(element, ParameterList.class)) == null) {
                return;
            }
            int index = PhpWorkaroundUtil.getArgumentIndex(element, parameterList);
            if (index < 0) {
                return;
            }
            FunctionReference reference = (FunctionReference)ObjectUtils.tryCast((Object)parameterList.getParent(), FunctionReference.class);
            if (reference == null) {
                return;
            }
            Function function = (Function)ObjectUtils.tryCast((Object)reference.resolve(), Function.class);
            if (function == null) {
                return;
            }
            Parameter parameter = function.getParameter(index);
            PsiElement psiElement = passByRefToken = parameter != null ? PhpPsiUtil.getChildOfType((PsiElement)parameter, PhpTokenTypes.opBIT_AND) : null;
            if (passByRefToken != null) {
                passByRefToken.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemovePassByRefFromParameterQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemovePassByRefFromParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

